/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Refraction.Uphole.UpholeModel;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Refraction.DelayTime.DelayTimeModelProfileWidget;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayerType;
import java.awt.Color;
import java.awt.Graphics2D;

public class ModelProfileLine
implements Java2D_PaintableInterface {
    public static int PlotProfile = 1000;
    public static int PlotLine = 1001;
    public Color ProfileLineColor = Color.BLACK;
    public boolean Valid = false;
    public int LineIndex = -999;
    public double X1;
    public double Y1;
    public double X2;
    public double Y2;
    public double DX;
    public double DY;
    public double Length;
    public int NumPoints = 500;
    public int NumPointsZ = 500;
    public float[][] Velocity;
    public float[][] Elevation;
    public float[] UpholeSurveyDepths;
    public float[][] UpholeSurveyVelocityAtDepth;
    public float[] MaxVelocity = new float[10];
    public float[] MaxElevation = new float[10];
    public float[] MinVelocity = new float[10];
    public float[] MinElevation = new float[10];
    public float PlotMaxY;
    public float PlotMinY;
    InteractiveModel _model;

    public ModelProfileLine(InteractiveModel model) {
        try {
            this.Velocity = new float[10][this.NumPoints];
            this.Elevation = new float[10][this.NumPoints];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected int checkWaterDepth(Table_Abstract tbl) {
        try {
            int indexDepth = -9999;
            if (!tbl.column_exists("WaterDepth")) {
                return -9999;
            }
            indexDepth = tbl.column_indexOfColumn("WaterDepth");
            int indexDead = tbl.column_indexOfColumn("Killed");
            double maxDepth = 0.0;
            for (int n = 0; n < tbl.row_count(); ++n) {
                if (tbl.getBool(n, indexDead)) continue;
                double depth = tbl.getDouble(n, indexDepth);
                maxDepth = Math.max(depth, maxDepth);
            }
            if (maxDepth <= 1.0) {
                return -9999;
            }
            return indexDepth;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999;
        }
    }

    public void createProfile(InteractiveModel model, double x1, double y1, double x2, double y2, boolean inverseFourth, double radius) {
        try {
            this._model = model;
            this.Valid = false;
            if (this._model == null) {
                return;
            }
            int nLayers = this._model.getLayerCount();
            if (nLayers <= 0) {
                return;
            }
            Table_Abstract recTable = this._model.getReceiverTable();
            Table_Abstract shotTable = this._model.getSourceTable();
            ModelLayer firstLayer = this._model.getLayer(0);
            boolean bHasUpholeSurvey = firstLayer.getLayerType() == ModelLayerType.UpholeSurvey;
            UpholeModel upholeModel = null;
            double dUpholeDepthDigi = 0.0;
            double dMaxUpholeDepth = 0.0;
            if (bHasUpholeSurvey) {
                upholeModel = firstLayer.getUpholeModel();
                if (upholeModel == null) {
                    throw new Exception("missing uphole survey data");
                }
                if (upholeModel.getInterpolationMaxDepth() <= 0.0) {
                    upholeModel.interpolateVelocities(0.5, upholeModel.getMaxDepth());
                }
                dMaxUpholeDepth = upholeModel.getMaxDepth();
                dUpholeDepthDigi = dMaxUpholeDepth / (double)this.NumPointsZ;
                this.UpholeSurveyDepths = new float[this.NumPointsZ];
                this.UpholeSurveyVelocityAtDepth = new float[this.NumPoints][this.NumPointsZ];
                float fDepth = 0.0f;
                for (int iDepth = 0; iDepth < this.NumPointsZ; ++iDepth) {
                    this.UpholeSurveyDepths[iDepth] = fDepth;
                    fDepth = (float)((double)fDepth + dUpholeDepthDigi);
                }
            }
            int[] shotIndexVel = new int[20];
            int[] shotIndexElev = new int[20];
            int shotIndexX = shotTable.column_indexOfColumn("Easting");
            int shotIndexY = shotTable.column_indexOfColumn("Northing");
            int shotIndexDead = shotTable.column_indexOfColumn("Killed");
            shotIndexElev[0] = shotTable.column_indexOfColumn("Elevation");
            shotIndexVel[0] = shotTable.column_indexOfColumn(this._model.getColumnName(0, LayerDataType.Velocity));
            for (int n = 1; n < nLayers; ++n) {
                shotIndexVel[n] = shotTable.column_indexOfColumn(this._model.getColumnName(n, LayerDataType.Velocity));
                shotIndexElev[n] = shotTable.column_indexOfColumn(this._model.getColumnName(n - 1, LayerDataType.Elevation));
            }
            int[] recIndexVel = new int[20];
            int[] recIndexElev = new int[20];
            int recIndexX = recTable.column_indexOfColumn("Easting");
            int recIndexY = recTable.column_indexOfColumn("Northing");
            int recIndexDead = recTable.column_indexOfColumn("Killed");
            recIndexElev[0] = recTable.column_indexOfColumn("Elevation");
            recIndexVel[0] = recTable.column_indexOfColumn(this._model.getColumnName(0, LayerDataType.Velocity));
            for (int n = 1; n < nLayers; ++n) {
                recIndexVel[n] = recTable.column_indexOfColumn(this._model.getColumnName(n, LayerDataType.Velocity));
                recIndexElev[n] = recTable.column_indexOfColumn(this._model.getColumnName(n - 1, LayerDataType.Elevation));
            }
            for (int z = 0; z < nLayers; ++z) {
                this.MaxVelocity[z] = Float.MIN_VALUE;
                this.MinVelocity[z] = Float.MAX_VALUE;
                this.MaxElevation[z] = Float.MIN_VALUE;
                this.MinElevation[z] = Float.MAX_VALUE;
            }
            double radiusSquared = radius * radius;
            double[] sum1z = new double[20];
            double[] sum2z = new double[20];
            double[] sum1v = new double[20];
            double[] sum2v = new double[20];
            this.X1 = x1;
            this.X2 = x2;
            this.Y1 = y1;
            this.Y2 = y2;
            this.DX = this.X2 - this.X1;
            this.DY = this.Y2 - this.Y1;
            this.Length = Math.sqrt(this.DX * this.DX + this.DY * this.DY);
            this.DX /= (double)(this.NumPoints - 1);
            this.DY /= (double)(this.NumPoints - 1);
            for (int n = 0; n < this.NumPoints; ++n) {
                double v;
                double elev;
                int z;
                double w;
                double dsq;
                double dy;
                double dx;
                int t;
                int z2;
                double x = this.X1 + this.DX * (double)n;
                double y = this.Y1 + this.DY * (double)n;
                for (z2 = 0; z2 < nLayers; ++z2) {
                    sum1z[z2] = 0.0;
                    sum2z[z2] = 1.0E-24;
                    sum1v[z2] = 0.0;
                    sum2v[z2] = 1.0E-24;
                }
                for (t = 0; t < recTable.row_count(); ++t) {
                    if (recTable.getBool(t, recIndexDead)) continue;
                    dx = x - recTable.getDouble(t, recIndexX);
                    dy = y - recTable.getDouble(t, recIndexY);
                    dsq = dx * dx + dy * dy;
                    w = 10.0 * radiusSquared / (radiusSquared + dsq);
                    if (inverseFourth) {
                        w *= w;
                    }
                    for (z = 0; z < nLayers; ++z) {
                        elev = recTable.getDouble(t, recIndexElev[z]);
                        v = recTable.getDouble(t, recIndexVel[z]);
                        sum1v[z] = sum1v[z] + w * v;
                        sum2v[z] = sum2v[z] + w;
                        sum1z[z] = sum1z[z] + w * elev;
                        sum2z[z] = sum2z[z] + w;
                    }
                }
                for (t = 0; t < shotTable.row_count(); ++t) {
                    if (shotTable.getBool(t, shotIndexDead)) continue;
                    dx = x - shotTable.getDouble(t, shotIndexX);
                    dy = y - shotTable.getDouble(t, shotIndexY);
                    dsq = dx * dx + dy * dy;
                    w = 10.0 * radiusSquared / (radiusSquared + dsq);
                    if (inverseFourth) {
                        w *= w;
                    }
                    for (z = 0; z < nLayers; ++z) {
                        elev = shotTable.getDouble(t, shotIndexElev[z]);
                        v = shotTable.getDouble(t, shotIndexVel[z]);
                        sum1v[z] = sum1v[z] + w * v;
                        sum2v[z] = sum2v[z] + w;
                        sum1z[z] = sum1z[z] + w * elev;
                        sum2z[z] = sum2z[z] + w;
                    }
                }
                for (z2 = 0; z2 < nLayers; ++z2) {
                    this.Velocity[z2][n] = (float)(sum1v[z2] / sum2v[z2]);
                    this.Elevation[z2][n] = (float)(sum1z[z2] / sum2z[z2]);
                    this.MinElevation[z2] = Math.min(this.MinElevation[z2], this.Elevation[z2][n]);
                    this.MaxElevation[z2] = Math.max(this.MaxElevation[z2], this.Elevation[z2][n]);
                    this.MinVelocity[z2] = Math.min(this.MinVelocity[z2], this.Velocity[z2][n]);
                    this.MaxVelocity[z2] = Math.max(this.MaxVelocity[z2], this.Velocity[z2][n]);
                }
                if (upholeModel == null) continue;
                double dSurfaceElevation = this.Elevation[0][n];
                upholeModel.getInterpolatedVelocity(x, y, dSurfaceElevation, this.UpholeSurveyDepths, this.UpholeSurveyVelocityAtDepth[n]);
                this.MinVelocity[0] = Math.min(this.MinVelocity[0], this.UpholeSurveyVelocityAtDepth[n][0]);
                this.MaxVelocity[0] = Math.max(this.MaxVelocity[0], this.UpholeSurveyVelocityAtDepth[n][0]);
            }
            float plotRange = this.MaxElevation[0] - this.MinElevation[nLayers - 1];
            this.PlotMaxY = this.MaxElevation[0] + 0.1f * plotRange;
            this.PlotMinY = this.MinElevation[nLayers - 1] - 0.1f * plotRange;
            for (int n = 0; n < this.NumPoints; ++n) {
                this.Elevation[nLayers][n] = this.PlotMinY;
            }
            this.Valid = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.Valid = false;
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int n;
            int r;
            if (!this.Valid) {
                return;
            }
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            int nLayers = this._model.getLayerCount();
            UpholeModel upholeModel = null;
            if (nLayers > 0) {
                boolean bHasUpholeSurvey;
                ModelLayer firstLayer = this._model.getLayer(0);
                boolean bl = bHasUpholeSurvey = firstLayer.getLayerType() == ModelLayerType.UpholeSurvey;
                if (bHasUpholeSurvey) {
                    upholeModel = firstLayer.getUpholeModel();
                }
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int nYPixels = transform.sizeY();
            int nXPixels = transform.sizeX();
            if (supplementalData == DelayTimeModelProfileWidget.ProfileLine.PlotLine) {
                g2d.setColor(this.ProfileLineColor);
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
                int x1 = (int)(this.X1 * scaleX + shiftX);
                int y1 = (int)(this.Y1 * scaleY + shiftY);
                int x2 = (int)(this.X2 * scaleX + shiftX);
                int y2 = (int)(this.Y2 * scaleY + shiftY);
                g2d.drawLine(x1, y1, x2, y2);
                return;
            }
            double segLength = this.Length / (double)(this.NumPoints - 1);
            int px = 1 + (int)(scaleX * segLength);
            for (r = 0; r < nLayers; ++r) {
                for (n = 0; n < this.NumPoints; ++n) {
                    double x = (double)n * this.Length / (double)(this.NumPoints - 1);
                    int ix = (int)(x * scaleX + shiftX);
                    int y1 = (int)((double)this.Elevation[r][n] * scaleY + shiftY);
                    int y2 = (int)((double)this.Elevation[r + 1][n] * scaleY + shiftY);
                    if (r == 0 && upholeModel != null) {
                        float fSurfaceElevation = this.Elevation[r][n];
                        float fLayerElevation = this.Elevation[r + 1][n];
                        for (int iDepth = 1; iDepth < this.UpholeSurveyDepths.length; ++iDepth) {
                            float fUpperDepth = this.UpholeSurveyDepths[iDepth - 1];
                            float fLowerDepth = this.UpholeSurveyDepths[iDepth];
                            float fUpperElev = fSurfaceElevation - fUpperDepth;
                            float fLowerElev = fSurfaceElevation - fLowerDepth;
                            if (!(fLowerElev >= fLayerElevation)) continue;
                            float fUpperVel = this.UpholeSurveyVelocityAtDepth[n][iDepth - 1];
                            y1 = (int)((double)fUpperElev * scaleY + shiftY);
                            y2 = (int)((double)fLowerElev * scaleY + shiftY);
                            Color c = colorWrapper.colorUsingValue(fUpperVel);
                            g2d.setColor(c);
                            g2d.fillRect(ix - px / 2, y1, px + 1, y2 - y1);
                        }
                        continue;
                    }
                    if (!colorWrapper.valueOK(this.Velocity[r][n])) continue;
                    Color c = colorWrapper.colorUsingValue(this.Velocity[r][n]);
                    g2d.setColor(c);
                    g2d.fillRect(ix - px / 2, y1, px + 1, y2 - y1);
                }
            }
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            g2d.setColor(Color.BLACK);
            for (r = 0; r < nLayers; ++r) {
                for (n = 1; n < this.NumPoints; ++n) {
                    double x1 = (double)(n - 1) * this.Length / (double)(this.NumPoints - 1);
                    int ix1 = (int)(x1 * scaleX + shiftX);
                    double x2 = (double)n * this.Length / (double)(this.NumPoints - 1);
                    int ix2 = (int)(x2 * scaleX + shiftX);
                    int iy1 = (int)(scaleY * (double)this.Elevation[r][n - 1] + shiftY);
                    int iy2 = (int)(scaleY * (double)this.Elevation[r][n] + shiftY);
                    g2d.drawLine(ix1, iy1, ix2, iy2);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (!this.Valid) {
                return;
            }
            if (supplementalData == DelayTimeModelProfileWidget.ProfileLine.PlotLine) {
                return;
            }
            rangeX.expandRange(0.0 - this.Length * 0.05);
            rangeX.expandRange(this.Length * 1.05);
            rangeY.expandRange(this.PlotMaxY);
            rangeY.expandRange(this.PlotMinY);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            if (!this.Valid) {
                return;
            }
            int nLayers = this._model.getLayerCount();
            if (supplementalData == DelayTimeModelProfileWidget.ProfileLine.PlotLine) {
                return;
            }
            for (int z = 0; z < nLayers; ++z) {
                rangeC.expandRange(this.MinVelocity[z]);
                rangeC.expandRange(this.MaxVelocity[z]);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

