/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Uphole.UpholeModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.IPropertyChangedListener;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelData;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayerType;
import java.util.ArrayList;

public class ModelLayer {
    ModelLayerType _layerType;
    InteractiveModel _parentModel;
    UpholeModel _upholeModel;
    ArrayList<IPropertyChangedListener> _propertyChangedListeners = new ArrayList();
    ModelData[] _modelData = new ModelData[4];
    LayerDataType[] _validDisplayLayerDataTypes;
    LayerDataType[] _validLayerDataTypes;
    LayerDataType[] _validImportLayerDataTypes;
    Boolean _bImportElevationData = false;
    Boolean _bImportVelocityData = true;
    int _iLayerIndex = -1;
    double[] _delayTimeSumShot;
    double[] _delayTimeSumRec;
    double[] _thicknessShot;
    double[] _thicknessRec;
    boolean[] _bLayerVelocityValidShot;
    boolean[] _bLayerVelocityValidRec;
    boolean[] _bLayerElevationValidShot;
    boolean[] _bLayerElevationValidRec;
    boolean[] _bLayerDelayTimeValidShot;
    boolean[] _bLayerDelayTimeValidRec;
    float[] _tmpUpholeModelDepths = null;
    float[] _tmpUpholeModelVels = null;

    public ModelLayer(ModelLayerType layerType, InteractiveModel model) {
        try {
            int i;
            this._layerType = layerType;
            this._parentModel = model;
            if (this._parentModel != null) {
                this.addPropertyChangedListener(this._parentModel);
            }
            this._modelData[0] = new ModelData(LayerDataType.Elevation, this._parentModel, this);
            this._modelData[1] = new ModelData(LayerDataType.Velocity, this._parentModel, this);
            this._modelData[2] = new ModelData(LayerDataType.DelayTime, this._parentModel, this);
            this._modelData[3] = new ModelData(LayerDataType.Thickness, this._parentModel, this);
            this.initializeLayerTypes();
            int nSrc = RefractionStaticsProject.singleton().shotTable().row_count();
            int nRec = RefractionStaticsProject.singleton().receiverTable().row_count();
            this._delayTimeSumShot = new double[nSrc];
            this._delayTimeSumRec = new double[nRec];
            this._thicknessShot = new double[nSrc];
            this._thicknessRec = new double[nRec];
            this._bLayerVelocityValidShot = new boolean[nSrc];
            this._bLayerVelocityValidRec = new boolean[nRec];
            this._bLayerElevationValidShot = new boolean[nSrc];
            this._bLayerElevationValidRec = new boolean[nRec];
            this._bLayerDelayTimeValidShot = new boolean[nSrc];
            this._bLayerDelayTimeValidRec = new boolean[nRec];
            for (i = 0; i < nSrc; ++i) {
                this._bLayerVelocityValidShot[i] = false;
                this._bLayerElevationValidShot[i] = false;
                this._bLayerDelayTimeValidShot[i] = false;
            }
            for (i = 0; i < nRec; ++i) {
                this._bLayerVelocityValidRec[i] = false;
                this._bLayerElevationValidRec[i] = false;
                this._bLayerDelayTimeValidRec[i] = false;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ModelLayer(ModelLayerType layerType, InteractiveModel model, int iLayerIndex) {
        try {
            int i;
            this._iLayerIndex = iLayerIndex;
            this._layerType = layerType;
            this._parentModel = model;
            if (this._parentModel != null) {
                this.addPropertyChangedListener(this._parentModel);
            }
            this._modelData[0] = new ModelData(LayerDataType.Elevation, this._parentModel, this, iLayerIndex);
            this._modelData[1] = new ModelData(LayerDataType.Velocity, this._parentModel, this, iLayerIndex);
            this._modelData[2] = new ModelData(LayerDataType.DelayTime, this._parentModel, this, iLayerIndex);
            this._modelData[3] = new ModelData(LayerDataType.Thickness, this._parentModel, this, iLayerIndex);
            this.initializeLayerTypes();
            int nSrc = model.getSourceCount();
            int nRec = model.getReceiverCount();
            this._delayTimeSumShot = new double[nSrc];
            this._delayTimeSumRec = new double[nRec];
            this._thicknessShot = new double[nSrc];
            this._thicknessRec = new double[nRec];
            this._bLayerVelocityValidShot = new boolean[nSrc];
            this._bLayerVelocityValidRec = new boolean[nRec];
            this._bLayerElevationValidShot = new boolean[nSrc];
            this._bLayerElevationValidRec = new boolean[nRec];
            this._bLayerDelayTimeValidShot = new boolean[nSrc];
            this._bLayerDelayTimeValidRec = new boolean[nRec];
            for (i = 0; i < nSrc; ++i) {
                this._bLayerVelocityValidShot[i] = true;
                this._bLayerElevationValidShot[i] = this._layerType != ModelLayerType.Base;
                this._bLayerDelayTimeValidShot[i] = this._layerType == ModelLayerType.Refracting;
            }
            for (i = 0; i < nRec; ++i) {
                this._bLayerVelocityValidRec[i] = true;
                this._bLayerElevationValidRec[i] = this._layerType != ModelLayerType.Base;
                this._bLayerDelayTimeValidRec[i] = this._layerType == ModelLayerType.Refracting;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearDelayTimeSums() {
        int i;
        if (this._delayTimeSumShot == null) {
            return;
        }
        if (this._delayTimeSumRec == null) {
            return;
        }
        for (i = 0; i < this._delayTimeSumShot.length; ++i) {
            this._delayTimeSumShot[i] = 0.0;
        }
        for (i = 0; i < this._delayTimeSumRec.length; ++i) {
            this._delayTimeSumRec[i] = 0.0;
        }
    }

    public double getDelayTimeSumShot(int iSrc) {
        return this._delayTimeSumShot[iSrc];
    }

    public void setDelayTimeSumShot(int iSrc, double dVal) {
        this._delayTimeSumShot[iSrc] = dVal;
    }

    public double getDelayTimeSumRec(int iRec) {
        return this._delayTimeSumRec[iRec];
    }

    public void setDelayTimeSumRec(int iRec, double dVal) {
        this._delayTimeSumRec[iRec] = dVal;
    }

    public Boolean getLayerDelayTimeValid(int iIndex, Boolean bSrc) throws Exception {
        if (bSrc.booleanValue()) {
            return this.getLayerDelayTimeValidShot(iIndex);
        }
        return this.getLayerDelayTimeValidRec(iIndex);
    }

    public void setLayerDelayTimeValid(int iIndex, Boolean bSrc, Boolean bValid) throws Exception {
        if (bSrc.booleanValue()) {
            this.setLayerDelayTimeValidShot(iIndex, bValid);
        } else {
            this.setLayerDelayTimeValidRec(iIndex, bValid);
        }
    }

    public Boolean getLayerElevationValid(int iIndex, Boolean bSrc) throws Exception {
        if (bSrc.booleanValue()) {
            return this.getLayerElevationValidShot(iIndex);
        }
        return this.getLayerElevationValidRec(iIndex);
    }

    public void setLayerElevationValid(int iIndex, Boolean bSrc, Boolean bValid) throws Exception {
        if (bSrc.booleanValue()) {
            this.setLayerElevationValidShot(iIndex, bValid);
        } else {
            this.setLayerElevationValidRec(iIndex, bValid);
        }
    }

    public Boolean getLayerVelocityValid(int iIndex, Boolean bSrc) throws Exception {
        if (bSrc.booleanValue()) {
            return this.getLayerVelocityValidShot(iIndex);
        }
        return this.getLayerVelocityValidRec(iIndex);
    }

    public void setLayerVelocityValid(int iIndex, Boolean bSrc, Boolean bValid) throws Exception {
        if (bSrc.booleanValue()) {
            this.setLayerVelocityValidShot(iIndex, bValid);
        } else {
            this.setLayerVelocityValidRec(iIndex, bValid);
        }
    }

    public Boolean getLayerDelayTimeValidShot(int iSrc) {
        return this._bLayerDelayTimeValidShot[iSrc];
    }

    public void setLayerDelayTimeValidShot(int iSrc, Boolean dVal) {
        this._bLayerDelayTimeValidShot[iSrc] = dVal;
    }

    public Boolean getLayerDelayTimeValidRec(int iRec) {
        return this._bLayerDelayTimeValidRec[iRec];
    }

    public void setLayerDelayTimeValidRec(int iRec, Boolean dVal) {
        this._bLayerDelayTimeValidRec[iRec] = dVal;
    }

    public Boolean getLayerVelocityValidShot(int iSrc) {
        return this._bLayerVelocityValidShot[iSrc];
    }

    public void setLayerVelocityValidShot(int iSrc, Boolean dVal) {
        this._bLayerVelocityValidShot[iSrc] = dVal;
    }

    public Boolean getLayerVelocityValidRec(int iRec) {
        return this._bLayerVelocityValidRec[iRec];
    }

    public void setLayerVelocityValidRec(int iRec, Boolean dVal) {
        this._bLayerVelocityValidRec[iRec] = dVal;
    }

    public Boolean getLayerElevationValidShot(int iSrc) {
        return this._bLayerElevationValidShot[iSrc];
    }

    public void setLayerElevationValidShot(int iSrc, Boolean dVal) {
        this._bLayerElevationValidShot[iSrc] = dVal;
    }

    public Boolean getLayerElevationValidRec(int iRec) {
        return this._bLayerElevationValidRec[iRec];
    }

    public void setLayerElevationValidRec(int iRec, Boolean dVal) {
        this._bLayerElevationValidRec[iRec] = dVal;
    }

    public double getLowerLayerVelocity(int iIndex, Boolean bSrc) throws Exception {
        int nLayers = this._parentModel.getLayerCount();
        int iLowerLayerIndex = this._iLayerIndex + 1;
        if (this._layerType == ModelLayerType.Base) {
            throw new Exception("invalid lower layer velocity, Base layer");
        }
        if (iLowerLayerIndex >= nLayers) {
            throw new Exception("invalid lower layer velocity, invalid layer index");
        }
        ModelLayer lowerLayer = this._parentModel.getLayer(iLowerLayerIndex);
        double dVel = lowerLayer.getVelocity(iIndex, bSrc);
        return dVel;
    }

    public double getThicknessToSurface(int iIndex, Boolean bSrc) throws Exception {
        double dElevation = this.getElevation(iIndex, bSrc);
        double dSurfaceElevation = this._parentModel.getSurfaceElevation(iIndex, bSrc);
        double dThicknessToSurface = dSurfaceElevation - dElevation;
        return dThicknessToSurface;
    }

    public double getUpperLayerElevation(int iIndex, Boolean bSrc) throws Exception {
        int index = this.getLayerIndex();
        int iUpperLayerIndex = index - 1;
        double dElevation = iUpperLayerIndex < 0 ? this._parentModel.getSurfaceElevation(iIndex, bSrc) : this._parentModel.getLayer(iUpperLayerIndex).getElevation(iIndex, bSrc);
        return dElevation;
    }

    public double getElevation(int iIndex, Boolean bSrc) throws Exception {
        Boolean bElevOk = this.getLayerElevationValid(iIndex, bSrc);
        if (!bElevOk.booleanValue()) {
            throw new Exception("Invalid elevation for index : " + Integer.toString(iIndex) + " src = " + Boolean.toString(bSrc));
        }
        if (bSrc.booleanValue()) {
            return this._modelData[0].getShotValue(iIndex);
        }
        return this._modelData[0].getRecValue(iIndex);
    }

    public double getProvisionalElevation(int iIndex, Boolean bSrc) throws Exception {
        if (bSrc.booleanValue()) {
            return this._modelData[0].getShotValue(iIndex);
        }
        return this._modelData[0].getRecValue(iIndex);
    }

    public void setElevation(int iIndex, Boolean bSrc, double dValue) throws Exception {
        if (bSrc.booleanValue()) {
            this._modelData[0].setShotValue(iIndex, dValue);
        } else {
            this._modelData[0].setRecValue(iIndex, dValue);
        }
        this.setLayerElevationValid(iIndex, bSrc, true);
    }

    public double getVelocity(int iIndex, Boolean bSrc) throws Exception {
        Boolean bVelOk = this.getLayerVelocityValid(iIndex, bSrc);
        if (!bVelOk.booleanValue()) {
            throw new Exception("Invalid velocity for index : " + Integer.toString(iIndex) + " src = " + Boolean.toString(bSrc));
        }
        if (bSrc.booleanValue()) {
            return this._modelData[1].getShotValue(iIndex);
        }
        return this._modelData[1].getRecValue(iIndex);
    }

    public void setVelocity(int iIndex, Boolean bSrc, double dValue) throws Exception {
        if (bSrc.booleanValue()) {
            this._modelData[1].setShotValue(iIndex, dValue);
        } else {
            this._modelData[1].setRecValue(iIndex, dValue);
        }
        this.setLayerVelocityValid(iIndex, bSrc, true);
    }

    public double getDelayTime(int iIndex, Boolean bSrc) throws Exception {
        Boolean bDtOk = this.getLayerDelayTimeValid(iIndex, bSrc);
        if (!bDtOk.booleanValue()) {
            throw new Exception("Invalid delay Time for index : " + Integer.toString(iIndex) + " src = " + Boolean.toString(bSrc));
        }
        if (bSrc.booleanValue()) {
            return this._modelData[2].getShotValue(iIndex);
        }
        return this._modelData[2].getRecValue(iIndex);
    }

    public void setDelayTime(int iIndex, Boolean bSrc, double dValue) throws Exception {
        if (bSrc.booleanValue()) {
            this._modelData[2].setShotValue(iIndex, dValue);
        } else {
            this._modelData[2].setRecValue(iIndex, dValue);
        }
        this.setLayerDelayTimeValid(iIndex, bSrc, true);
    }

    public double getThickness(int iIndex, Boolean bSrc) throws Exception {
        if (bSrc.booleanValue()) {
            return this._modelData[3].getShotValue(iIndex);
        }
        return this._modelData[3].getRecValue(iIndex);
    }

    public void setThickness(int iIndex, Boolean bSrc, double dValue) throws Exception {
        if (bSrc.booleanValue()) {
            this._modelData[3].setShotValue(iIndex, dValue);
        } else {
            this._modelData[3].setRecValue(iIndex, dValue);
        }
    }

    public InteractiveModel getModel() {
        return this._parentModel;
    }

    public Boolean getImportElevationData() {
        if (this._layerType == ModelLayerType.Base) {
            return false;
        }
        if (this._layerType == ModelLayerType.Free || this._layerType == ModelLayerType.UpholeSurvey) {
            return true;
        }
        return this._bImportElevationData;
    }

    public Boolean getImportVelocityData() {
        if (this._layerType == ModelLayerType.Base) {
            return true;
        }
        if (this._layerType == ModelLayerType.Free || this._layerType == ModelLayerType.UpholeSurvey) {
            return true;
        }
        return this._bImportVelocityData;
    }

    public void setImportElevationData(Boolean bImportElevationData) {
        if (this._layerType == ModelLayerType.Base) {
            return;
        }
        if (this._layerType == ModelLayerType.Free || this._layerType == ModelLayerType.UpholeSurvey) {
            return;
        }
        this._bImportElevationData = bImportElevationData;
        this._bImportVelocityData = this._bImportElevationData == false;
        this.sendPropertyChangedEvent("LayerType");
    }

    public void setImportVelocityData(Boolean bImportVelocityData) {
        if (this._layerType == ModelLayerType.Base) {
            return;
        }
        if (this._layerType == ModelLayerType.Free || this._layerType == ModelLayerType.UpholeSurvey) {
            return;
        }
        this._bImportVelocityData = bImportVelocityData;
        this._bImportElevationData = this._bImportVelocityData == false;
        this.sendPropertyChangedEvent("LayerType");
    }

    void initializeLayerTypes() {
        try {
            if (this._layerType == ModelLayerType.Base) {
                this._validLayerDataTypes = new LayerDataType[1];
                this._validDisplayLayerDataTypes = new LayerDataType[1];
                this._validLayerDataTypes[0] = LayerDataType.Velocity;
                this._validDisplayLayerDataTypes[0] = LayerDataType.Velocity;
                this._validImportLayerDataTypes = new LayerDataType[1];
                this._validImportLayerDataTypes[0] = LayerDataType.Velocity;
            }
            if (this._layerType == ModelLayerType.Free || this._layerType == ModelLayerType.UpholeSurvey) {
                this._validLayerDataTypes = new LayerDataType[3];
                this._validLayerDataTypes[0] = LayerDataType.Elevation;
                this._validLayerDataTypes[1] = LayerDataType.Velocity;
                this._validLayerDataTypes[2] = LayerDataType.Thickness;
                this._validImportLayerDataTypes = new LayerDataType[2];
                this._validImportLayerDataTypes[0] = LayerDataType.Elevation;
                this._validImportLayerDataTypes[1] = LayerDataType.Velocity;
                this._validDisplayLayerDataTypes = new LayerDataType[3];
                this._validDisplayLayerDataTypes[0] = LayerDataType.Elevation;
                this._validDisplayLayerDataTypes[1] = LayerDataType.Velocity;
                this._validDisplayLayerDataTypes[2] = LayerDataType.Thickness;
            }
            if (this._layerType == ModelLayerType.Refracting) {
                this._validLayerDataTypes = new LayerDataType[4];
                this._validLayerDataTypes[0] = LayerDataType.Elevation;
                this._validLayerDataTypes[1] = LayerDataType.Velocity;
                this._validLayerDataTypes[2] = LayerDataType.DelayTime;
                this._validLayerDataTypes[3] = LayerDataType.Thickness;
                this._validImportLayerDataTypes = new LayerDataType[3];
                this._validImportLayerDataTypes[0] = LayerDataType.Elevation;
                this._validImportLayerDataTypes[1] = LayerDataType.Velocity;
                this._validImportLayerDataTypes[2] = LayerDataType.DelayTime;
                this._validDisplayLayerDataTypes = new LayerDataType[4];
                this._validDisplayLayerDataTypes[0] = LayerDataType.Elevation;
                this._validDisplayLayerDataTypes[1] = LayerDataType.Velocity;
                this._validDisplayLayerDataTypes[2] = LayerDataType.DelayTime;
                this._validDisplayLayerDataTypes[3] = LayerDataType.Thickness;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public LayerDataType[] getValidLayerDataTypes() {
        return this._validLayerDataTypes;
    }

    public LayerDataType[] getValidImportLayerDataTypes() {
        return this._validImportLayerDataTypes;
    }

    public ModelData getModelData(LayerDataType dataType) {
        ModelData md = null;
        try {
            if (dataType == LayerDataType.Elevation) {
                return this._modelData[0];
            }
            if (dataType == LayerDataType.Velocity) {
                return this._modelData[1];
            }
            if (dataType == LayerDataType.DelayTime) {
                return this._modelData[2];
            }
            if (dataType == LayerDataType.Thickness) {
                return this._modelData[3];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return md;
    }

    public void sendPropertyChangedEvent(String sProperty) {
        try {
            for (int i = 0; i < this._propertyChangedListeners.size(); ++i) {
                this._propertyChangedListeners.get(i).handlePropertyChanged(this, sProperty);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public final void addPropertyChangedListener(IPropertyChangedListener l) {
        this._propertyChangedListeners.add(l);
    }

    public void removePropertyChangedListener(IPropertyChangedListener l) {
        this._propertyChangedListeners.remove(l);
    }

    public Boolean getIsFilled() {
        int nValidImportLayers = this._validImportLayerDataTypes.length;
        Boolean bValid = false;
        if (this._layerType == ModelLayerType.Free || this._layerType == ModelLayerType.UpholeSurvey || this._layerType == ModelLayerType.Base) {
            bValid = true;
            for (int i = 0; i < nValidImportLayers; ++i) {
                LayerDataType dt = this._validImportLayerDataTypes[i];
                ModelData md = this.getModelData(dt);
                if (md.getIsDataLoadDataValid().booleanValue()) continue;
                bValid = false;
            }
        }
        if (this._layerType == ModelLayerType.Refracting) {
            ModelData delayTimeData = this.getModelData(LayerDataType.DelayTime);
            ModelData elevationData = this.getModelData(LayerDataType.Elevation);
            ModelData velocityData = this.getModelData(LayerDataType.Velocity);
            if (delayTimeData.getIsDataLoadDataValid().booleanValue()) {
                bValid = elevationData.getIsDataLoadDataValid() != false || velocityData.getIsDataLoadDataValid() != false;
            } else if (velocityData.getIsDataLoadDataValid().booleanValue()) {
                bValid = elevationData.getIsDataLoadDataValid() != false || delayTimeData.getIsDataLoadDataValid() != false;
            } else if (elevationData.getIsDataLoadDataValid().booleanValue()) {
                bValid = velocityData.getIsDataLoadDataValid() != false || delayTimeData.getIsDataLoadDataValid() != false;
            }
        }
        if (this._layerType == ModelLayerType.UpholeSurvey) {
            ModelData elevationData = this.getModelData(LayerDataType.Elevation);
            ModelData velocityData = this.getModelData(LayerDataType.Velocity);
            bValid = elevationData.getIsDataLoadDataValid() != false && velocityData.getIsDataLoadDataValid() != false;
        }
        return bValid;
    }

    public int getLayerIndex() {
        int iLayerIndex = -1;
        if (this._parentModel != null) {
            iLayerIndex = this._parentModel.getLayerIndex(this);
        }
        return iLayerIndex;
    }

    public String getLayerName() {
        int iLayerIndex = -1;
        if (this._parentModel != null) {
            iLayerIndex = this._parentModel.getLayerIndex(this);
        }
        int iLayer = iLayerIndex + 1;
        String sName = "Layer " + Integer.toString(iLayer);
        return sName;
    }

    public String toString() {
        if (this._iLayerIndex == -1) {
            return "load data : " + this.getLayerName();
        }
        return this.getLayerName() + " : " + this._layerType.toString();
    }

    public ModelLayerType getLayerType() {
        return this._layerType;
    }

    public void setLayerType(ModelLayerType layerType) {
        this._layerType = layerType;
        this.initializeLayerTypes();
        this.sendPropertyChangedEvent("LayerType");
    }

    double getPartialDelayTime(int iIndex, boolean bSrc, double dRefractorVel) throws Exception {
        double dPartialDelayTimeSum = 0.0;
        boolean bContainsInversions = false;
        try {
            double dPartialDelayTime;
            double dThickness;
            int iDepth;
            if (this._layerType != ModelLayerType.UpholeSurvey) {
                throw new Exception("getPartialDelayTime only valid for uphole survey layers");
            }
            if (this._upholeModel == null) {
                throw new Exception("UpholeModel not set");
            }
            double dSurfaceElevation = this._parentModel.getSurfaceElevation(iIndex, bSrc);
            double x = this._parentModel.getGeometryEasting(iIndex, bSrc);
            double y = this._parentModel.getGeometryNorthing(iIndex, bSrc);
            double dMaxUpholeModelDepth = this._upholeModel.getMaxDepth();
            double dDepthDigi = 0.5;
            if (this._upholeModel.getInterpolationMaxDepth() != dMaxUpholeModelDepth || this._upholeModel.getInterpolationMaxDepth() < dMaxUpholeModelDepth) {
                this._upholeModel.interpolateVelocities(dDepthDigi, dMaxUpholeModelDepth);
            }
            if (this._upholeModel.getContainsVelocityInversions()) {
                throw new Exception("uphole survey contains velocity inversion");
            }
            double dMaxDepthAtXY = this._upholeModel.getInterpolatedMaxDepth(x, y);
            double dLayerElevation = this.getElevation(iIndex, bSrc);
            int nDepths = (int)(dMaxUpholeModelDepth / dDepthDigi) + 10;
            if (this._tmpUpholeModelDepths == null || this._tmpUpholeModelVels == null) {
                this._tmpUpholeModelDepths = new float[nDepths];
                this._tmpUpholeModelVels = new float[nDepths];
                float fDepth = 0.0f;
                for (int i = 0; i < nDepths; ++i) {
                    this._tmpUpholeModelDepths[i] = fDepth;
                    fDepth += (float)dDepthDigi;
                }
            }
            this._upholeModel.getInterpolatedVelocity(x, y, dSurfaceElevation, this._tmpUpholeModelDepths, this._tmpUpholeModelVels);
            double dDepth = 0.0;
            float fVelUpper = 0.0f;
            float fVelLower = 0.0f;
            for (iDepth = 0; iDepth < nDepths - 1; ++iDepth) {
                double dTmpElevation;
                dThickness = dDepthDigi;
                fVelLower = this._tmpUpholeModelVels[iDepth];
                fVelUpper = iDepth > 0 ? this._tmpUpholeModelVels[iDepth - 1] : fVelLower;
                if ((double)fVelUpper > dRefractorVel) {
                    bContainsInversions = true;
                }
                if (!((dTmpElevation = dSurfaceElevation - (dDepth += dDepthDigi)) >= dLayerElevation)) break;
                if (bContainsInversions) continue;
                dPartialDelayTime = 1000.0 * dThickness / (double)fVelUpper * Math.cos(Math.asin((double)fVelUpper / dRefractorVel));
                dPartialDelayTimeSum += dPartialDelayTimeSum;
            }
            if (!bContainsInversions) {
                if (iDepth >= 1) {
                    dThickness = dMaxDepthAtXY - dDepth;
                    fVelUpper = this._tmpUpholeModelVels[iDepth - 1];
                    fVelLower = this._tmpUpholeModelVels[iDepth];
                    if (dThickness > 0.0 && (double)fVelUpper < dRefractorVel) {
                        dPartialDelayTime = 1000.0 * dThickness / (double)fVelUpper * Math.cos(Math.asin((double)fVelUpper / dRefractorVel));
                        dPartialDelayTimeSum += dPartialDelayTimeSum;
                    }
                }
            } else {
                fVelUpper = this._tmpUpholeModelVels[0];
                fVelLower = this._tmpUpholeModelVels[iDepth];
                dThickness = dMaxDepthAtXY;
                if ((double)fVelUpper <= dRefractorVel) {
                    dPartialDelayTime = 1000.0 * dThickness / (double)fVelUpper * Math.cos(Math.asin((double)fVelUpper / dRefractorVel));
                    dPartialDelayTimeSum += dPartialDelayTimeSum;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
        if (bContainsInversions) {
            return -99999.0;
        }
        return dPartialDelayTimeSum;
    }

    public void setUpholeModel(UpholeModel upholeModel) {
        this._upholeModel = upholeModel;
    }

    public UpholeModel getUpholeModel() {
        return this._upholeModel;
    }
}

