/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelDataSource;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelDataViewModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;

public class ModelData {
    LayerDataType _dt;
    ModelDataSource _dataSource = new ModelDataSource();
    ModelLayer _layer;
    double[] _dataLoadSourceValues;
    double[] _dataLoadReceiverValues;
    Boolean _bIsDataValid = false;
    int _iLayerIndex = -1;
    Table_Abstract _recTable;
    Table_Abstract _shotTable;
    String _sColumnName;
    int _iSrcColumnIndex = -1;
    int _iRecColumnIndex = -1;
    int _iSrcColumnShotIndex = -1;
    int _iRecColumnRecIndex = -1;
    Boolean _bDataModified = false;
    InteractiveModel _model;
    ModelDataViewModel _defaultView;

    public ModelData(LayerDataType dt, InteractiveModel model, ModelLayer layer) {
        try {
            this._dt = dt;
            this._layer = layer;
            this._model = model;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Table_Abstract recTable = project.receiverTable();
            Table_Abstract shotTable = project.shotTable();
            if (shotTable != null && recTable != null) {
                int nSrc = shotTable.row_count();
                this._dataLoadSourceValues = new double[nSrc];
                int nRec = recTable.row_count();
                this._dataLoadReceiverValues = new double[nRec];
            }
            this._defaultView = new ModelDataViewModel(this, this._model);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ModelData(LayerDataType dt, InteractiveModel model, ModelLayer layer, int iLayerIndex) {
        try {
            this._iLayerIndex = iLayerIndex;
            this._dt = dt;
            this._layer = layer;
            this._model = model;
            this._recTable = model.getReceiverTable();
            this._shotTable = model.getSourceTable();
            this._sColumnName = model.getColumnName(this._iLayerIndex, this._dt);
            if (this._shotTable.column_exists(this._sColumnName)) {
                this._iSrcColumnIndex = this._shotTable.column_indexOfColumn(this._sColumnName);
            }
            if (this._recTable.column_exists(this._sColumnName)) {
                this._iRecColumnIndex = this._recTable.column_indexOfColumn(this._sColumnName);
            }
            if (this._shotTable.column_exists("ShotID")) {
                this._iSrcColumnShotIndex = this._shotTable.column_indexOfColumn("ShotID");
            }
            if (this._recTable.column_exists("ReceiverID")) {
                this._iRecColumnRecIndex = this._recTable.column_indexOfColumn("ReceiverID");
            }
            if (this._shotTable != null && this._recTable != null) {
                int nSrc = this._shotTable.row_count();
                this._dataLoadSourceValues = new double[nSrc];
                int nRec = this._recTable.row_count();
                this._dataLoadReceiverValues = new double[nRec];
                String sColumnName = model.getColumnName(this._iLayerIndex, this._dt);
                if (this._shotTable.column_exists(sColumnName) && this._recTable.column_exists(sColumnName)) {
                    double dVal;
                    int i;
                    int iShotColumn = this._shotTable.column_indexOfColumn(sColumnName);
                    int iRecColumn = this._recTable.column_indexOfColumn(sColumnName);
                    for (i = 0; i < nSrc; ++i) {
                        this._dataLoadSourceValues[i] = dVal = this._shotTable.getDouble(i, iShotColumn);
                    }
                    for (i = 0; i < nRec; ++i) {
                        this._dataLoadReceiverValues[i] = dVal = this._recTable.getDouble(i, iRecColumn);
                    }
                }
            }
            this._defaultView = new ModelDataViewModel(this, this._model);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ModelDataViewModel getDefaultView() {
        return this._defaultView;
    }

    public String getColumnName() {
        return this._sColumnName;
    }

    public Range_Double getRange() throws Exception {
        double dVal;
        Range_Double r = new Range_Double();
        int nSrc = this._model.getSourceCount();
        int nRec = this._model.getReceiverCount();
        for (int iSrc = 0; iSrc < nSrc; ++iSrc) {
            dVal = this.getShotValue(iSrc);
            r.expandRange(dVal);
        }
        for (int iRec = 0; iRec < nRec; ++iRec) {
            dVal = this.getRecValue(iRec);
            r.expandRange(dVal);
        }
        return r;
    }

    public int getShotID(int iShotIndex) throws Exception {
        int iVal = this._iSrcColumnIndex < 0 ? iShotIndex : this._shotTable.getInt(iShotIndex, this._iSrcColumnShotIndex);
        return iVal;
    }

    public double getShotValue(int iShotIndex) throws Exception {
        double dVal = 0.0;
        dVal = this._iSrcColumnIndex < 0 ? this._dataLoadSourceValues[iShotIndex] : this._shotTable.getDouble(iShotIndex, this._iSrcColumnIndex);
        return dVal;
    }

    public int getRecID(int iRecIndex) throws Exception {
        int iVal = this._iSrcColumnIndex < 0 ? iRecIndex : this._recTable.getInt(iRecIndex, this._iRecColumnRecIndex);
        return iVal;
    }

    public double getRecValue(int iRecIndex) throws Exception {
        double dVal = 0.0;
        dVal = this._iRecColumnIndex < 0 ? this._dataLoadReceiverValues[iRecIndex] : this._recTable.getDouble(iRecIndex, this._iRecColumnIndex);
        return dVal;
    }

    public void setShotValue(int iShotIndex, double dVal) throws Exception {
        if (this._iSrcColumnIndex >= 0) {
            this._shotTable.putDouble(iShotIndex, this._iSrcColumnIndex, dVal);
        }
        if (this._dataLoadSourceValues != null) {
            this._dataLoadSourceValues[iShotIndex] = dVal;
        }
        this._bDataModified = true;
    }

    public void setRecValue(int iRecIndex, double dVal) throws Exception {
        if (this._iRecColumnIndex >= 0) {
            this._recTable.putDouble(iRecIndex, this._iRecColumnIndex, dVal);
        }
        if (this._dataLoadReceiverValues != null) {
            this._dataLoadReceiverValues[iRecIndex] = dVal;
        }
        this._bDataModified = true;
    }

    public Boolean getDataModified() {
        return this._bDataModified;
    }

    public void setDataModified(Boolean bDataModified) {
        this._bDataModified = bDataModified;
    }

    public ModelLayer getLayer() {
        return this._layer;
    }

    public String toString() {
        return this._dt.toString();
    }

    public Boolean getIsDataLoadDataValid() {
        return this._bIsDataValid;
    }

    public void setIsDataLoadDataValid(Boolean bDataIsValid) {
        this._bIsDataValid = bDataIsValid;
    }

    public double[] getDataLoadSourceValues() {
        return this._dataLoadSourceValues;
    }

    public double[] getDataLoadReceiverValues() {
        return this._dataLoadReceiverValues;
    }

    public ModelDataSource getModelDataSource() {
        return this._dataSource;
    }

    public void setModelDataSource(ModelDataSource src) {
        this._dataSource = src;
    }

    public LayerDataType getLayerDataType() {
        return this._dt;
    }
}

