/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ButtonEditor;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ButtonRenderer;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayerType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;

public class ModelBuilderDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    JTable _table;
    InteractiveModel _model;
    ModelTableModel _tableModel;
    JButton _btnOk;
    JButton _btnCancel;
    JTextField _txtModelName;
    LinearLayoutWidget _topWidget;
    LinearLayoutWidget _bottomWidget;
    Boolean _bDialogResult = false;

    public ModelBuilderDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.setSize(850, 600);
            this.setLocationRelativeTo(null);
            this.setTitle("Model Builder");
            this._model = InteractiveModel.createNewInMemoryModel();
            this._model.addModelLayer(new ModelLayer(ModelLayerType.Free, this._model));
            this._model.addModelLayer(new ModelLayer(ModelLayerType.Refracting, this._model));
            this._model.addModelLayer(new ModelLayer(ModelLayerType.Base, this._model));
            this._tableModel = new ModelTableModel(this._model);
            this._table = new JTable(this._tableModel);
            TableColumn typeColumn = this._table.getColumnModel().getColumn(1);
            JComboBox<ModelLayerType> comboBox = new JComboBox<ModelLayerType>();
            ModelLayerType[] types = ModelLayerType.values();
            for (int i = 0; i < types.length; ++i) {
                comboBox.addItem(types[i]);
            }
            typeColumn.setCellEditor(new DefaultCellEditor(comboBox));
            this._table.getColumn(ModelTableModel.LoadDataColumn).setCellRenderer(new ButtonRenderer());
            this._table.getColumn(ModelTableModel.LoadDataColumn).setCellEditor(new ButtonEditor(new JCheckBox()));
            this._table.getColumnModel().getColumn(0).setPreferredWidth(30);
            this._table.getColumnModel().getColumn(1).setPreferredWidth(20);
            this._table.getColumnModel().getColumn(2).setPreferredWidth(20);
            this._table.getColumnModel().getColumn(3).setPreferredWidth(20);
            this._table.getColumnModel().getColumn(4).setPreferredWidth(20);
            this._table.getColumnModel().getColumn(5).setPreferredWidth(20);
            this._table.getColumnModel().getColumn(6).setPreferredWidth(200);
            JScrollPane scroll = new JScrollPane(this._table);
            this.getContentPane().add((Component)scroll, "Center");
            this._bottomWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            this._btnOk = this._bottomWidget.createButton("Ok", this, 3);
            this._btnCancel = this._bottomWidget.createButton("Cancel", this, 3);
            this._topWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            this._topWidget.createLabel("Model Name", 0, 3);
            this._txtModelName = this._topWidget.createTextField("newModel", this, 3);
            this.getContentPane().add((Component)this._bottomWidget, "South");
            this.getContentPane().add((Component)this._topWidget, "North");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public double getMinThickness() {
        double dMinThickness = 0.0;
        return dMinThickness;
    }

    public void showDialog() {
        try {
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Boolean getDialogResult() {
        return this._bDialogResult;
    }

    Boolean checkModelName() {
        try {
            String sModelName = this._txtModelName.getText();
            if (sModelName == null) {
                JOptionPane.showMessageDialog(null, "Model name must have at least three characters", "", 0);
                return false;
            }
            if (sModelName.length() < 3) {
                JOptionPane.showMessageDialog(null, "Model name must have at least three characters", "", 0);
                return false;
            }
            if (!Tools_Strings.isAlphaNumeric(sModelName, true, false)) {
                JOptionPane.showMessageDialog(null, "Spaces and special characters not allowed", "", 0);
                return false;
            }
            if (Tools_Strings.startsWithNumber(sModelName)) {
                JOptionPane.showMessageDialog(null, "Model Name cannot start with a number", "", 0);
                return false;
            }
            if (InteractiveModel.doesModelExist(sModelName).booleanValue()) {
                JOptionPane.showMessageDialog(null, "Model already exists", "", 0);
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public String getModelName() {
        return this._txtModelName.getText();
    }

    Boolean checkAllDataFilled() {
        try {
            int nLayers = this._model.getLayerCount();
            Boolean bAllLayersFilled = true;
            int iMissingLayer = -1;
            for (int iLayer = 0; iLayer < nLayers; ++iLayer) {
                if (this._model.getLayer(iLayer).getIsFilled().booleanValue()) continue;
                bAllLayersFilled = false;
                iMissingLayer = iLayer;
            }
            if (!bAllLayersFilled.booleanValue()) {
                int iLayerNumber = iMissingLayer + 1;
                JOptionPane.showMessageDialog(null, "Layer data is missing, please load data for layer" + Integer.toString(iLayerNumber), "", 0);
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this._btnOk) {
                String sModelName = this._txtModelName.getText();
                if (!this.checkModelName().booleanValue()) {
                    return;
                }
                if (!this.checkAllDataFilled().booleanValue()) {
                    return;
                }
                try {
                    double dMinimumThickness = this.getMinThickness();
                    this._model.buildModel(dMinimumThickness);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "error calculating model layers:" + ex.getMessage(), "", 0);
                    return;
                }
                this._model.writeModelToDatabase(sModelName, false);
                this._bDialogResult = true;
                this.dispose();
            }
            if (e.getSource() == this._btnCancel) {
                this._bDialogResult = false;
                this.dispose();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }
}

