/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.PolygonUsage;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel_StaticsInfo;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Uphole.UpholeModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelData;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayerType;

public class InteractiveModel_StaticsInfo {
    public String ColumnName = "";
    public DelayTimeModel_StaticsInfo.WeatheringVelocityEnum WeatheringVelocity = DelayTimeModel_StaticsInfo.WeatheringVelocityEnum.Normal;
    public Table_Abstract ElevationTable = new Table_Memory();
    public Table_Abstract VelocityTable = new Table_Memory();
    public IMB_IntermediateDatumEnum IntermediateDatum = IMB_IntermediateDatumEnum.FixedElevation;
    public double Intermediate_FixedElevation = 0.0;
    public double Intermediate_FixedDepth = 0.0;
    public int Intermediate_RefractorNumber = 0;
    public boolean Intermediate_SmoothRefractor = false;
    public double Intermediate_SmoothRadius = 2000.0;
    public double Intermediate_DownwardDistance = 0.0;
    public double Intermediate_SurfaceSmoothRadius = 2000.0;
    public double Intermediate_SurfaceDownwardDistance = 1000.0;
    public IMB_FinalDatumEnum FinalDatum = IMB_FinalDatumEnum.FixedElevation;
    public double Final_FixedElevation = 0.0;
    public double Final_FixedDepth = 0.0;
    public double Final_FixedDepthSmoothRadius = 0.0;
    public double Final_ReplacementVelocity = 1000.0;
    public DelayTimeModel_StaticsInfo.FinalShiftMethod ShiftMethod = DelayTimeModel_StaticsInfo.FinalShiftMethod.None;
    public String TieStaticsColumn = "";
    public double m_sumStatic = 0.0;
    public double m_sumValid = 1.0E-20;
    public double m_averageStatic = 0.0;
    protected int m_indexEasting;
    protected int m_indexNorthing;
    protected int[] m_indexZ = new int[20];
    protected int[] m_indexV = new int[20];
    protected int m_indexDepth;
    protected int m_indexWaterDepth;
    protected int m_indexStatic;
    protected int m_indexDatumIntermediate;
    protected int m_indexDatumFinal;
    protected double m_easting;
    protected double m_northing;
    protected double[] m_elevation = new double[20];
    protected double[] m_velocity = new double[20];
    protected float[] m_upholeSurveyDepths;
    protected float[] m_upholeSurveyVels;
    protected double m_depth;
    protected double m_waterDepth;
    protected double m_waterVel;
    protected double m_startZ;
    protected double m_datumIntermediate;
    protected double m_datumFinal;
    protected int m_finalLayer;
    protected int m_startLayer;
    InteractiveModel _model;
    UpholeModel _upholeModel;
    float m_fUpholeDepthDigi = 0.5f;

    public String getIntermediateDatumDescription() {
        try {
            String s = this.IntermediateDatum.Description;
            if (this.IntermediateDatum == IMB_IntermediateDatumEnum.FixedElevation) {
                return s + ": " + Double.toString(this.Intermediate_FixedElevation);
            }
            if (this.IntermediateDatum == IMB_IntermediateDatumEnum.FixedDepth) {
                return s + ": " + Double.toString(this.Intermediate_FixedDepth);
            }
            if (this.IntermediateDatum == IMB_IntermediateDatumEnum.LayerSurface) {
                if (this.Intermediate_SmoothRefractor) {
                    return String.format("%s: Refractor # %d, Smooth radius %f, Pushed down %f: ", this.IntermediateDatum.Description, this.Intermediate_RefractorNumber, Float.valueOf((float)this.Intermediate_SmoothRadius), Float.valueOf((float)this.Intermediate_DownwardDistance));
                }
                return String.format("%s: Refractor # %d, refractor surface not smoothed", this.IntermediateDatum.Description, this.Intermediate_RefractorNumber);
            }
            if (this.IntermediateDatum == IMB_IntermediateDatumEnum.Surface) {
                return String.format("%s: Smooth radius %f, Pushed down %f: ", this.IntermediateDatum.Description, Float.valueOf((float)this.Intermediate_SurfaceSmoothRadius), Float.valueOf((float)this.Intermediate_SurfaceDownwardDistance));
            }
            return s;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "ERROR getIntermediateDatumDescription";
        }
    }

    public String getReplacementVelocityDescription() {
        try {
            return String.format("Replacement velocity %f", Float.valueOf((float)this.Final_ReplacementVelocity));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "ERROR getReplacementVelocityDescription";
        }
    }

    public String getFinalDatumDescription() {
        try {
            String s = this.FinalDatum.Description;
            if (this.FinalDatum == IMB_FinalDatumEnum.FixedElevation) {
                return s + ": " + Double.toString(this.Final_FixedElevation);
            }
            if (this.FinalDatum == IMB_FinalDatumEnum.FixedDepth) {
                if (this.Final_FixedDepthSmoothRadius < 5.0) {
                    return s + ": " + Double.toString(this.Final_FixedDepth) + " (unsmoothed)";
                }
                return s + ": " + Double.toString(this.Final_FixedDepth) + ", smooth radius = " + Double.toString(this.Final_FixedDepthSmoothRadius);
            }
            return s;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "ERROR getFinalDatumDescription";
        }
    }

    public InteractiveModel_StaticsInfo(InteractiveModel model) {
        try {
            this._model = model;
            int indexName = this.ElevationTable.column_append("Surface name", DataType.Text);
            int indexMin = this.ElevationTable.column_append("Minimum elevation", DataType.Double);
            int indexMax = this.ElevationTable.column_append("Maximum elevation", DataType.Double);
            this.VelocityTable.column_append("Layer", DataType.Text);
            this.VelocityTable.column_append("Minimum velocity", DataType.Double);
            this.VelocityTable.column_append("Maximum velocity", DataType.Double);
            this.reloadElevationTable();
            this.reloadVelocityTable();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public InteractiveModel getModel() {
        return this._model;
    }

    public void reloadVelocityTable() {
        try {
            int nLayers = this._model.getLayerCount();
            int indexName = this.VelocityTable.column_indexOfColumn("Layer");
            int indexMin = this.VelocityTable.column_indexOfColumn("Minimum velocity");
            int indexMax = this.VelocityTable.column_indexOfColumn("Maximum velocity");
            this.VelocityTable.row_clear(true);
            for (int b = 0; b < nLayers; ++b) {
                int row = this.VelocityTable.row_increment();
                ModelLayer layer = this._model.getLayer(b);
                String sLayerName = layer.getLayerName();
                this.VelocityTable.putString(row, indexName, sLayerName);
                Range_Double range = layer.getModelData(LayerDataType.Velocity).getRange();
                if (!range.rangeValid()) continue;
                this.VelocityTable.putDouble(row, indexMin, range.rangeMin());
                this.VelocityTable.putDouble(row, indexMax, range.rangeMax());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void reloadElevationTable() {
        try {
            int nLayers = this._model.getLayerCount();
            int indexName = this.ElevationTable.column_indexOfColumn("Surface name");
            int indexMin = this.ElevationTable.column_indexOfColumn("Minimum elevation");
            int indexMax = this.ElevationTable.column_indexOfColumn("Maximum elevation");
            this.ElevationTable.row_clear(true);
            for (int iLayer = -1; iLayer < nLayers - 1; ++iLayer) {
                int row = this.ElevationTable.row_increment();
                Range_Double range = null;
                if (iLayer == -1) {
                    this.ElevationTable.putString(row, indexName, "Surface elevation");
                    range = this._model.getSurfaceElevationRange();
                } else {
                    ModelLayer layer = this._model.getLayer(iLayer);
                    String sLayerName = layer.getLayerName();
                    this.ElevationTable.putString(row, indexName, sLayerName);
                    ModelData elevData = layer.getModelData(LayerDataType.Elevation);
                    range = elevData.getRange();
                }
                this.ElevationTable.putDouble(row, indexMin, range.rangeMin());
                this.ElevationTable.putDouble(row, indexMax, range.rangeMax());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepIndices(Table_Abstract table) throws Exception {
        try {
            ModelLayer layer;
            int nLayers = this._model.getLayerCount();
            if (nLayers > 0 && (layer = this._model.getLayer(0)).getLayerType() == ModelLayerType.UpholeSurvey) {
                this._upholeModel = layer.getUpholeModel();
                if (this._upholeModel == null) {
                    throw new Exception("null uphole model");
                }
                double dMaxUpholeDepth = this._upholeModel.getMaxDepth();
                if (this._upholeModel.getInterpolationMaxDepth() <= 0.0) {
                    this._upholeModel.interpolateVelocities(0.5, dMaxUpholeDepth);
                }
                int nSamples = (int)(dMaxUpholeDepth / (double)this.m_fUpholeDepthDigi) + 1;
                if (this.m_upholeSurveyDepths == null || this.m_upholeSurveyVels == null) {
                    this.m_upholeSurveyDepths = new float[nSamples];
                    this.m_upholeSurveyVels = new float[nSamples];
                }
                if (this.m_upholeSurveyDepths.length != nSamples || this.m_upholeSurveyVels.length != nSamples) {
                    this.m_upholeSurveyDepths = new float[nSamples];
                    this.m_upholeSurveyVels = new float[nSamples];
                }
                float fDepth = 0.0f;
                for (int iDepthSample = 0; iDepthSample < nSamples; ++iDepthSample) {
                    this.m_upholeSurveyDepths[iDepthSample] = fDepth;
                    fDepth += this.m_fUpholeDepthDigi;
                }
            }
            this.m_indexEasting = table.column_indexOfColumn("Easting");
            this.m_indexNorthing = table.column_indexOfColumn("Northing");
            this.m_indexStatic = table.column_indexOfColumn(this.ColumnName);
            this.m_indexDatumIntermediate = table.column_indexOfColumn("Datum_Intermediate");
            this.m_indexDatumFinal = table.column_indexOfColumn("Datum_Final");
            this.m_indexWaterDepth = -9999;
            if (table.column_exists("WaterDepth")) {
                this.m_indexWaterDepth = table.column_indexOfColumn("WaterDepth");
            }
            this.m_indexWaterDepth = -9999;
            if (table.column_exists("WaterDepth")) {
                this.m_indexWaterDepth = table.column_indexOfColumn("WaterDepth");
            }
            this.m_indexDepth = -9999;
            if (table.column_exists("PointDepth")) {
                this.m_indexDepth = table.column_indexOfColumn("PointDepth");
            }
            for (int iLayer = 0; iLayer < nLayers; ++iLayer) {
                String sElevationColumn = iLayer == 0 ? "Elevation" : this._model.getColumnName(iLayer - 1, LayerDataType.Elevation);
                String sVelocityColumn = this._model.getColumnName(iLayer, LayerDataType.Velocity);
                this.m_indexZ[iLayer] = table.column_indexOfColumn(sElevationColumn);
                this.m_indexV[iLayer] = table.column_indexOfColumn(sVelocityColumn);
            }
            if (this.WeatheringVelocity == DelayTimeModel_StaticsInfo.WeatheringVelocityEnum.AnisotropicFast && table.column_exists("DTA_AnisFastV0")) {
                this.m_indexV[0] = table.column_indexOfColumn("DTA_AnisFastV0");
            }
            if (this.WeatheringVelocity == DelayTimeModel_StaticsInfo.WeatheringVelocityEnum.AnisotropicSlow && table.column_exists("DTA_AnisSlowV0")) {
                this.m_indexV[0] = table.column_indexOfColumn("DTA_AnisSlowV0");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void prepValues(Table_Abstract table, int row) throws Exception {
        try {
            int nLayers = this._model.getLayerCount();
            this.m_easting = table.getDouble(row, this.m_indexEasting);
            this.m_northing = table.getDouble(row, this.m_indexNorthing);
            for (int iLayer = 0; iLayer < nLayers; ++iLayer) {
                this.m_elevation[iLayer] = table.getDouble(row, this.m_indexZ[iLayer]);
                this.m_velocity[iLayer] = table.getDouble(row, this.m_indexV[iLayer]);
            }
            this.m_datumIntermediate = table.getDouble(row, this.m_indexDatumIntermediate);
            this.m_datumFinal = table.getDouble(row, this.m_indexDatumFinal);
            this.m_waterDepth = 0.0;
            if (this.m_indexWaterDepth >= 0) {
                this.m_waterDepth = table.getDouble(row, this.m_indexWaterDepth);
            }
            this.m_waterDepth = Math.max(this.m_waterDepth, 0.0);
            this.m_depth = 0.0;
            if (this.m_indexDepth >= 0) {
                this.m_depth = table.getDouble(row, this.m_indexDepth);
            }
            this.m_depth = Math.max(this.m_depth, 0.0);
            this.m_waterDepth = 0.0;
            if (this.m_indexWaterDepth >= 0) {
                this.m_waterDepth = table.getDouble(row, this.m_indexWaterDepth);
            }
            this.m_waterDepth = Math.max(this.m_waterDepth, 0.0);
            this.m_startZ = this.m_elevation[0] - this.m_depth;
            if (this._upholeModel != null) {
                this._upholeModel.getInterpolatedVelocity(this.m_easting, this.m_northing, this.m_elevation[0], this.m_upholeSurveyDepths, this.m_upholeSurveyVels);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected int findLayer(double z) throws Exception {
        try {
            int nLayers = this._model.getLayerCount();
            int iMaxLayer = nLayers - 1;
            if (z >= this.m_elevation[1]) {
                return 0;
            }
            if (z <= this.m_elevation[iMaxLayer]) {
                return iMaxLayer;
            }
            for (int iLayer = 1; iLayer < nLayers; ++iLayer) {
                if (!(z >= this.m_elevation[iLayer])) continue;
                return iLayer - 1;
            }
            return iMaxLayer;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected float computeTimeFromStartToIntermediate_New(double intermediateDatum) throws Exception {
        try {
            double waterBottomZ;
            int nLayers = this._model.getLayerCount();
            int iMaxLayer = nLayers - 1;
            if (this.m_startZ <= this.m_elevation[iMaxLayer]) {
                return (float)(1000.0 * (intermediateDatum - this.m_startZ) / this.m_velocity[iMaxLayer]);
            }
            double currentZ = this.m_startZ;
            float timeToWaterBottom = 0.0f;
            if (this.m_waterDepth >= 1.0 && currentZ > (waterBottomZ = this.m_elevation[0] - this.m_waterDepth)) {
                timeToWaterBottom = (float)(1000.0 * (currentZ - waterBottomZ) / this.m_waterVel);
                currentZ = waterBottomZ;
            }
            double timeToLowestRefractor = 0.0;
            for (int currentBranch = 1; currentBranch <= iMaxLayer; ++currentBranch) {
                if (this._upholeModel != null && currentBranch == 1) {
                    int iLastValidDepth = -1;
                    if (currentZ > this.m_elevation[currentBranch]) {
                        for (int i = 0; i < this.m_upholeSurveyDepths.length; ++i) {
                            double elev = this.m_elevation[0] - (double)this.m_upholeSurveyDepths[i];
                            double vel = this.m_upholeSurveyVels[i];
                            if (!(currentZ > elev) || !(elev > this.m_elevation[currentBranch])) continue;
                            double time = 1000.0 * (currentZ - elev) / vel;
                            timeToLowestRefractor += time;
                            currentZ = elev;
                            iLastValidDepth = i;
                        }
                    }
                    if (!(currentZ > this.m_elevation[currentBranch]) || iLastValidDepth < 0) continue;
                    double vel = this.m_upholeSurveyVels[iLastValidDepth];
                    double time = 1000.0 * (currentZ - this.m_elevation[currentBranch]) / vel;
                    timeToLowestRefractor += time;
                    currentZ = this.m_elevation[currentBranch];
                    continue;
                }
                if (!(currentZ > this.m_elevation[currentBranch])) continue;
                double time = 1000.0 * (currentZ - this.m_elevation[currentBranch]) / this.m_velocity[currentBranch - 1];
                timeToLowestRefractor += time;
                currentZ = this.m_elevation[currentBranch];
            }
            double timeToDatum = 1000.0 * (this.m_elevation[iMaxLayer] - intermediateDatum) / this.m_velocity[iMaxLayer];
            double totalTime = (double)timeToWaterBottom + timeToLowestRefractor + timeToDatum;
            return -((float)totalTime);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected float computeTimeFromStartToIntermediate_Old(double finalZ) throws Exception {
        try {
            int finalLayer;
            int startLayer;
            float timeToWaterBottom = 0.0f;
            if (this.m_waterDepth >= 1.0) {
                double waterBottomZ = this.m_elevation[0] - this.m_waterDepth;
                timeToWaterBottom = this.m_startZ > waterBottomZ ? (float)(1000.0 * (this.m_startZ - waterBottomZ) / this.m_waterVel) : (float)(1000.0 * (this.m_startZ - waterBottomZ) / this.m_velocity[0]);
                this.m_startZ = waterBottomZ;
            }
            if ((startLayer = this.findLayer(this.m_startZ)) == (finalLayer = this.findLayer(finalZ))) {
                return (float)(1000.0 * (finalZ - this.m_startZ) / this.m_velocity[finalLayer]);
            }
            if (startLayer > finalLayer) {
                float timeStart = (float)(1000.0 * (this.m_elevation[startLayer] - this.m_startZ) / this.m_velocity[startLayer]);
                float timeFinal = (float)(1000.0 * (finalZ - this.m_elevation[finalLayer + 1]) / this.m_velocity[finalLayer]);
                float timeMiddle = 0.0f;
                for (int layer = finalLayer + 1; layer < startLayer; ++layer) {
                    float time = (float)(1000.0 * (this.m_elevation[layer] - this.m_elevation[layer + 1]) / this.m_velocity[layer]);
                    timeMiddle += time;
                }
                return timeMiddle + timeStart + timeFinal;
            }
            float timeFinal = (float)(1000.0 * (this.m_elevation[finalLayer] - finalZ) / this.m_velocity[finalLayer]);
            float timeStart = (float)(1000.0 * (this.m_startZ - this.m_elevation[startLayer + 1]) / this.m_velocity[startLayer]);
            float timeMiddle = 0.0f;
            for (int layer = startLayer + 1; layer < finalLayer; ++layer) {
                float time = (float)(1000.0 * (this.m_elevation[layer] - this.m_elevation[layer + 1]) / this.m_velocity[layer]);
                timeMiddle += time;
            }
            return -(timeMiddle + timeStart + timeFinal + timeToWaterBottom);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeStatics() throws Exception {
        try {
            RefractionStaticsProject refractionProject = RefractionStaticsProject.singleton();
            this.m_waterVel = refractionProject.getWaterVelocity();
            this._model.setColumnValue_Double("Datum_Final", -999999.0);
            this._model.setColumnValue_Double("Datum_Intermediate", -999999.0);
            this.setStaticToZero(this._model.getReceiverTable());
            this.setStaticToZero(this._model.getSourceTable());
            if (this.IntermediateDatum == IMB_IntermediateDatumEnum.FixedDepth) {
                this.computeIntermediateDatum_FixedDepth(this._model.getReceiverTable());
                this.computeIntermediateDatum_FixedDepth(this._model.getSourceTable());
            } else if (this.IntermediateDatum == IMB_IntermediateDatumEnum.Surface) {
                this.computeIntermediateDatum_SmoothedSurface();
            } else if (this.IntermediateDatum == IMB_IntermediateDatumEnum.LayerSurface) {
                if (!this.Intermediate_SmoothRefractor) {
                    this.computeIntermediateDatum_RefractorSurface(this._model.getReceiverTable());
                    this.computeIntermediateDatum_RefractorSurface(this._model.getSourceTable());
                } else {
                    this.computeIntermediateDatum_SmoothedRefractorSurface();
                }
            } else {
                this._model.setColumnValue_Double("Datum_Intermediate", this.Intermediate_FixedElevation);
            }
            this._model.geometryDatabase().writeColumnContentsToDatabase(this._model.getSourceTable(), "Datum_Intermediate");
            this._model.geometryDatabase().writeColumnContentsToDatabase(this._model.getReceiverTable(), "Datum_Intermediate");
            this.computeIntermediateStatics(this._model.getSourceTable());
            this.computeIntermediateStatics(this._model.getReceiverTable());
            this.m_sumStatic = 0.0;
            this.m_sumValid = 1.0E-40;
            if (this.FinalDatum == IMB_FinalDatumEnum.FixedElevation) {
                this.computeFinalDatum_FixedElevation(this._model.getReceiverTable());
                this.computeFinalDatum_FixedElevation(this._model.getSourceTable());
            } else {
                this.computeFinalDatum_FixedDepth(this._model.getReceiverTable());
                this.computeFinalDatum_FixedDepth(this._model.getSourceTable());
                if (this.Final_FixedDepthSmoothRadius > 3.0) {
                    this._model.smoothColumn("Datum_Final", -9.9999999E7, this.Final_FixedDepthSmoothRadius, PolygonUsage.NotUsed);
                }
            }
            this._model.geometryDatabase().writeColumnContentsToDatabase(this._model.getSourceTable(), "Datum_Final");
            this._model.geometryDatabase().writeColumnContentsToDatabase(this._model.getReceiverTable(), "Datum_Final");
            this.computeFinalStatics_FromIntermediateDatum(this._model.getReceiverTable());
            this.computeFinalStatics_FromIntermediateDatum(this._model.getSourceTable());
            this.m_averageStatic = this.m_sumStatic / this.m_sumValid;
            if (this.ShiftMethod == DelayTimeModel_StaticsInfo.FinalShiftMethod.ZeroMean) {
                this.subtractAverage(this._model.getReceiverTable());
                this.subtractAverage(this._model.getSourceTable());
            }
            if (this.ShiftMethod == DelayTimeModel_StaticsInfo.FinalShiftMethod.TieToAnother && this._model.getSourceTable().column_exists(this.TieStaticsColumn)) {
                double avg = this._model.computeAverage(this.TieStaticsColumn, -1.0E20, 1.0E20);
                double shift = avg - this.m_averageStatic;
                this.addShift(this._model.getSourceTable(), (float)shift);
                this.addShift(this._model.getReceiverTable(), (float)shift);
            }
            this._model.geometryDatabase().writeColumnContentsToDatabase(this._model.getReceiverTable(), this.ColumnName);
            this._model.geometryDatabase().writeColumnContentsToDatabase(this._model.getSourceTable(), this.ColumnName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void computeEffectiveRepVel(Table_Abstract table) {
        try {
            int indexTI = table.column_indexOfColumn("Time_Intermediate");
            int indexS = table.column_indexOfColumn(this.ColumnName);
            int indexID = table.column_indexOfColumn("Datum_Intermediate");
            int indexFD = table.column_indexOfColumn("Datum_Final");
            int indexEV = table.column_append("EffectiveRepVel", DataType.Float);
            for (int row = 0; row < table.row_count(); ++row) {
                float timeInt = table.getFloat(row, indexTI);
                float stat = table.getFloat(row, indexS);
                float id = table.getFloat(row, indexID);
                float fd = table.getFloat(row, indexFD);
                float t = Math.abs(stat + timeInt);
                float v = 1000.0f * Math.abs(id - fd) / t;
                table.putFloat(row, indexEV, v);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeFinalDatum_FixedElevation(Table_Abstract table) throws Exception {
        try {
            this.prepIndices(table);
            for (int row = 0; row < table.row_count(); ++row) {
                table.putDouble(row, this.m_indexDatumFinal, this.Final_FixedElevation);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeFinalDatum_FixedDepth(Table_Abstract table) throws Exception {
        try {
            this.prepIndices(table);
            for (int row = 0; row < table.row_count(); ++row) {
                this.prepValues(table, row);
                double surface = table.getDouble(row, this.m_indexZ[0]);
                this.m_datumFinal = surface - this.Final_FixedDepth;
                table.putDouble(row, this.m_indexDatumFinal, this.m_datumFinal);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeFinalStatics_FromIntermediateDatum(Table_Abstract table) throws Exception {
        try {
            this.prepIndices(table);
            float maxStatic = -1000000.0f;
            float minStatic = 1000000.0f;
            int numHuge = 0;
            int indexKilled = table.column_indexOfColumn("Killed");
            for (int row = 0; row < table.row_count(); ++row) {
                this.prepValues(table, row);
                double shift = 1000.0 * (this.m_datumFinal - this.m_datumIntermediate) / this.Final_ReplacementVelocity;
                float currentStatic = table.getFloat(row, this.m_indexStatic);
                float totalStatic = currentStatic + (float)shift;
                if (!table.getBool(row, indexKilled)) {
                    this.m_sumStatic += (double)totalStatic;
                    this.m_sumValid += 1.0;
                }
                table.putFloat(row, this.m_indexStatic, totalStatic);
            }
            String s = String.format("computeFinalStatics_FromIntermediateDatum %f  to %f   %d", Float.valueOf(minStatic), Float.valueOf(maxStatic), numHuge);
            System.out.println(s);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void addShift(Table_Abstract table, float shift) throws Exception {
        try {
            this.prepIndices(table);
            for (int row = 0; row < table.row_count(); ++row) {
                float stat = table.getFloat(row, this.m_indexStatic);
                table.putFloat(row, this.m_indexStatic, stat += shift);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void subtractAverage(Table_Abstract table) throws Exception {
        try {
            this.prepIndices(table);
            for (int row = 0; row < table.row_count(); ++row) {
                float stat = table.getFloat(row, this.m_indexStatic);
                table.putFloat(row, this.m_indexStatic, stat -= (float)this.m_averageStatic);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeIntermediateDatum_SmoothedRefractorSurface() throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.computeIntermediateDatum_RefractorSurface(this._model.getReceiverTable());
            this.computeIntermediateDatum_RefractorSurface(this._model.getSourceTable());
            double smoothRadius = this.Intermediate_SmoothRadius;
            smoothRadius = Math.max(smoothRadius, 1.0);
            this._model.smoothColumn("Datum_Intermediate", -9.9999999E7, smoothRadius, PolygonUsage.NotUsed);
            double downShift = this.Intermediate_DownwardDistance;
            this._model.shiftColumnValue_Double("Datum_Intermediate", -downShift);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeIntermediateDatum_SmoothedSurface() throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.computeIntermediateDatum_Surface(this._model.getReceiverTable());
            this.computeIntermediateDatum_Surface(this._model.getSourceTable());
            double smoothRadius = this.Intermediate_SurfaceSmoothRadius;
            smoothRadius = Math.max(smoothRadius, 1.0);
            this._model.smoothColumn("Datum_Intermediate", -9.9999999E7, smoothRadius, PolygonUsage.NotUsed);
            double downShift = this.Intermediate_SurfaceDownwardDistance;
            this._model.shiftColumnValue_Double("Datum_Intermediate", -downShift);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeIntermediateDatum_Surface(Table_Abstract table) throws Exception {
        try {
            int indexDatum = table.column_indexOfColumn("Datum_Intermediate");
            int indexSurface = table.column_indexOfColumn("Elevation");
            for (int row = 0; row < table.row_count(); ++row) {
                double surface = table.getDouble(row, indexSurface);
                table.putDouble(row, indexDatum, surface);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeIntermediateDatum_RefractorSurface(Table_Abstract table) throws Exception {
        try {
            int indexDatum = table.column_indexOfColumn("Datum_Intermediate");
            int iLayer = this.Intermediate_RefractorNumber - 1;
            String sColumn = this._model.getColumnName(iLayer, LayerDataType.Elevation);
            int indexSurface = table.column_indexOfColumn(sColumn);
            for (int row = 0; row < table.row_count(); ++row) {
                double surface = table.getDouble(row, indexSurface);
                table.putDouble(row, indexDatum, surface);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeIntermediateStatics(Table_Abstract table) throws Exception {
        try {
            this.prepIndices(table);
            for (int row = 0; row < table.row_count(); ++row) {
                this.prepValues(table, row);
                float time = this.computeTimeFromStartToIntermediate_New(this.m_datumIntermediate);
                table.putFloat(row, this.m_indexStatic, time);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeIntermediateDatum_FixedDepth(Table_Abstract table) throws Exception {
        try {
            this.prepIndices(table);
            int indexDatum = table.column_indexOfColumn("Datum_Intermediate");
            int indexSurface = table.column_indexOfColumn(Pecos.getColNameElev(0));
            for (int row = 0; row < table.row_count(); ++row) {
                double surface = table.getDouble(row, indexSurface);
                double intermediateDepth = surface - this.Intermediate_FixedDepth;
                table.putDouble(row, indexDatum, intermediateDepth);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void setStaticToZero(Table_Abstract table) throws Exception {
        try {
            int indexStatic = table.column_append(this.ColumnName, DataType.Float);
            for (int row = 0; row < table.row_count(); ++row) {
                table.putFloat(row, indexStatic, 0.0f);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static enum IMB_IntermediateDatumEnum {
        FixedElevation("Intermediate datum at a constant elevation"),
        FixedDepth("Intermediate datum at a fixed depth below the surface"),
        LayerSurface("Intermediate datum at a layer surface"),
        Surface("Intermediate datum at surface (smoothed and shifted down!)");

        public final String Description;

        private IMB_IntermediateDatumEnum(String s) {
            this.Description = s;
        }
    }

    public static enum IMB_FinalDatumEnum {
        FixedElevation("Final datum at a constant elevation"),
        FixedDepth("Final datum at a fixed depth below the (smoothed) surface");

        public final String Description;

        private IMB_FinalDatumEnum(String s) {
            this.Description = s;
        }
    }

    public static enum FinalShiftMethod {
        None,
        ZeroMean,
        TieToAnother;

    }

    public static enum WeatheringVelocityEnum {
        Normal,
        AnisotropicFast,
        AnisotropicSlow;

    }
}

