/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_DelayTimeAnisotropy_Grid;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_DelayTimeUpdate;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_GeometryError;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_PointVelocity;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_SimpleVelocityAnalysis;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_VelocityGradient;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.DelayTime.AdvancedDelayTimeOptionsDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.RefractorVelocityAssignmentDialog;
import com.PecosLibrary.Windows.Shared.MultiTextDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class Menu_DelayTimeAnalysis
implements ActionListener {
    protected JMenu m_menuAnalysis = new JMenu("Analysis");
    protected JMenuItem m_menuItem_DefaultAnalysisSequence;
    protected JMenuItem m_menuItem_GriddedAnalysisSequence;
    protected JMenuItem m_menuItem_Dt_Analysis_NoAnis;
    protected JMenuItem m_menuItem_Dt_Analysis_WithAnis;
    protected JMenuItem m_menuItem_Dt_Anisotropy;
    protected JMenuItem m_menuItem_Dt_AnisotropyClear;
    protected JMenuItem m_menuItem_ComputeV0;
    protected JMenuItem m_menuItem_Vel_InterpolateFromBranch;
    protected JMenuItem m_menuItem_Vel_Update;
    protected JMenuItem m_menuItem_Vel_Slope;
    protected JMenuItem m_menuItem_Vel_Const;
    protected AdvancedDelayTimeOptionsDialog m_dtOptionsDlg;
    protected AdvancedDelayTimeOptionsDialog m_velOptionsDlg;
    protected MultiTextDialog m_dlgAnis;

    public Menu_DelayTimeAnalysis(JMenu menu) {
        try {
            menu.add(this.m_menuAnalysis);
            this.m_menuItem_DefaultAnalysisSequence = this.addMenuItem(this.m_menuAnalysis, "Default analysis sequence");
            this.m_menuItem_GriddedAnalysisSequence = this.addMenuItem(this.m_menuAnalysis, "Gridded velocity analysis sequence");
            this.m_menuAnalysis.addSeparator();
            this.m_menuItem_Vel_InterpolateFromBranch = this.addMenuItem(this.m_menuAnalysis, "Velocity update: Linear least-squares fit, CMP based (Ignores delay times)");
            this.m_menuItem_Vel_Update = this.addMenuItem(this.m_menuAnalysis, "Velocity update: Use delay times");
            this.m_menuItem_Vel_Slope = this.addMenuItem(this.m_menuAnalysis, "Velocity update: Error gradient analysis");
            this.m_menuItem_Vel_Const = this.addMenuItem(this.m_menuAnalysis, "Velocity update: Set to constant");
            this.m_menuAnalysis.addSeparator();
            this.m_menuItem_Dt_Analysis_NoAnis = this.addMenuItem(this.m_menuAnalysis, "Delay time analysis - Do not use anisotropy");
            this.m_menuItem_Dt_Analysis_WithAnis = this.addMenuItem(this.m_menuAnalysis, "Delay time analysis - use anisotropy");
            this.m_menuAnalysis.addSeparator();
            this.m_menuItem_Dt_Anisotropy = this.addMenuItem(this.m_menuAnalysis, "Delay time anisotropy - perform analysis");
            this.m_menuItem_Dt_AnisotropyClear = this.addMenuItem(this.m_menuAnalysis, "Delay time anisotropy - clear results");
            this.m_menuAnalysis.addSeparator();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JMenuItem addMenuItem(JMenu menu, String text) {
        try {
            JMenuItem mi = new JMenuItem(text);
            menu.add(mi);
            mi.addActionListener(this);
            return mi;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            boolean dtUseAnis;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_menuItem_DefaultAnalysisSequence) {
                DelayTimeModel.singleton().launchStandardSequence();
                return;
            }
            if (e.getSource() == this.m_menuItem_GriddedAnalysisSequence) {
                DelayTimeModel.singleton().launchGriddedSequence();
                return;
            }
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            BranchAssignment ba = project.delayTimeData().branchAssignment();
            int maxbranch = ba.maxBranch();
            if (maxbranch < 1) {
                JOptionPane.showMessageDialog(null, "Must assign branches first", "Cannot perform analysis", 0);
                return;
            }
            if (e.getSource() == this.m_menuItem_Vel_Const) {
                RefractorVelocityAssignmentDialog dlg = new RefractorVelocityAssignmentDialog();
                return;
            }
            Action_Sequence sequence = project.actionSequence();
            sequence.clear();
            boolean needErrorStep = false;
            if (this.m_menuItem_Dt_AnisotropyClear == e.getSource()) {
                project.delayTimeData().clearDelayTimeAnisotropy();
                return;
            }
            if (e.getSource() == this.m_menuItem_Vel_InterpolateFromBranch) {
                for (b = 1; b <= maxbranch; ++b) {
                    action = new Action_DelayTime_SimpleVelocityAnalysis();
                    action.Hasher.int_put("Branch", b);
                    action.Hasher.string_put("PickVersion", "FBP_User");
                    sequence.addAction(action);
                }
            } else {
                for (b = 1; b <= maxbranch; ++b) {
                    String colName = Pecos.getColNameVel(b);
                    if (project.shotTable().column_exists(colName)) continue;
                    action = new Action_DelayTime_SimpleVelocityAnalysis();
                    action.Hasher.int_put("Branch", b);
                    action.Hasher.string_put("PickVersion", "FBP_User");
                    sequence.addAction(action);
                }
            }
            if (e.getSource() == this.m_menuItem_Dt_Anisotropy) {
                if (this.m_dlgAnis == null) {
                    this.m_dlgAnis = new MultiTextDialog(null, "Anisotropy options", "Maximum allowed anisotropy (ms)", "Analysis grid size (ft/m)");
                    this.m_dlgAnis.setText(0, "20");
                    this.m_dlgAnis.setText(1, "1000");
                }
                this.m_dlgAnis.showDialog("OK");
                if (!this.m_dlgAnis.OK) {
                    return;
                }
                double maxAnis = this.m_dlgAnis.getDouble(0, 12.0, 0.0, 100.0);
                double gridSize = this.m_dlgAnis.getDouble(1, 600.0, 100.0, 100000.0);
                for (int b = 1; b <= maxbranch; ++b) {
                    Action_DelayTime_DelayTimeAnisotropy_Grid action = new Action_DelayTime_DelayTimeAnisotropy_Grid();
                    action.Hasher.double_put("MaxAnis", maxAnis);
                    action.Hasher.double_put("GridSize", gridSize);
                    action.Hasher.int_put("Branch", b);
                    action.Hasher.string_put("PickVersion", "FBP_User");
                    action.Hasher.int_put("IterationCount", 12);
                    action.Hasher.bool_put("ResetDelayTimes", false);
                    sequence.addAction(action);
                }
                needErrorStep = true;
            }
            boolean dtNoAnis = e.getSource() == this.m_menuItem_Dt_Analysis_NoAnis;
            boolean bl = dtUseAnis = e.getSource() == this.m_menuItem_Dt_Analysis_WithAnis;
            if (dtNoAnis || dtUseAnis) {
                this.m_dtOptionsDlg = new AdvancedDelayTimeOptionsDialog(true, false, false);
                this.m_dtOptionsDlg.showDialog();
                if (!this.m_dtOptionsDlg.OK) {
                    return;
                }
                boolean ensureNoBias = this.m_dtOptionsDlg.ensureNoBias();
                boolean interpolateUsingInverseSquare = this.m_dtOptionsDlg.interpolateUsingInverseSquare();
                boolean forceSame = this.m_dtOptionsDlg.forceTheSame();
                double sameDist = this.m_dtOptionsDlg.nearbyDistance();
                Action_DelayTime_DelayTimeUpdate action = new Action_DelayTime_DelayTimeUpdate();
                action.Hasher.string_put("PickVersion", "FBP_User");
                action.Hasher.int_put("IterationCount", 12);
                action.Hasher.bool_put("ResetDelayTimes", false);
                action.Hasher.bool_put("UseAnisotropy", dtUseAnis);
                action.Hasher.bool_put("EnsureNoDCBias", ensureNoBias);
                action.InterpolateUsingInverseSquare = interpolateUsingInverseSquare;
                action.ForceNearbyToBeTheSame = forceSame;
                action.NearbyDistance = sameDist;
                sequence.addAction(action);
                needErrorStep = true;
            }
            if (e.getSource() == this.m_menuItem_Vel_Slope) {
                this.m_velOptionsDlg = new AdvancedDelayTimeOptionsDialog(false, true, false);
                this.m_velOptionsDlg.showDialog();
                if (!this.m_velOptionsDlg.OK) {
                    return;
                }
                Action_DelayTime_VelocityGradient actionVelSlope = new Action_DelayTime_VelocityGradient();
                actionVelSlope.Hasher.string_put("PickVersion", "FBP_User");
                sequence.addAction(actionVelSlope);
                actionVelSlope.ComputeSmoothRadius = false;
                actionVelSlope.SmoothRadiusWorld = this.m_velOptionsDlg.velSmoothRadius();
                needErrorStep = true;
            }
            if (e.getSource() == this.m_menuItem_Vel_Update) {
                this.m_velOptionsDlg = new AdvancedDelayTimeOptionsDialog(false, true, false);
                this.m_velOptionsDlg.showDialog();
                if (!this.m_velOptionsDlg.OK) {
                    return;
                }
                Action_DelayTime_PointVelocity actionVelPoint = new Action_DelayTime_PointVelocity();
                actionVelPoint.Hasher.string_put("PickVersion", "FBP_User");
                actionVelPoint.MaxPercentVariation = (float)this.m_velOptionsDlg.velMaxPercentVariation();
                actionVelPoint.ComputeSmoothRadius = false;
                actionVelPoint.SmoothRadiusWorld = this.m_velOptionsDlg.velSmoothRadius();
                sequence.addAction(actionVelPoint);
                needErrorStep = true;
            }
            if (needErrorStep) {
                Action_DelayTime_GeometryError action = new Action_DelayTime_GeometryError();
                sequence.addAction(action);
            }
            if (sequence.size() >= 1) {
                project.executeActionSequence();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

