/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosLibrary.Refraction.DelayTime.Tools_DelayTime;
import com.PecosLibrary.Windows.Refraction.DelayTime.BranchAssignmentDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.BranchAssignmentWidget;
import com.PecosLibrary.Windows.Refraction.DelayTime.DelayTimeModelProfileWidget;
import com.PecosLibrary.Windows.Refraction.DelayTime.DelayTimeModelWidget;
import com.PecosLibrary.Windows.Refraction.DelayTime.ImportOtherProjectDelayTimeDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.LayerModelWidget;
import com.PecosLibrary.Windows.Refraction.DelayTime.Menu_DelayTimeAnalysis;
import com.PecosLibrary.Windows.Refraction.DelayTime.PickHistogramWidget;
import com.PecosLibrary.Windows.Refraction.DelayTime.SolutionStacksWidget_DelayTime;
import com.PecosLibrary.Windows.Refraction.DelayTime.UpholeCorrectionDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.WaterBottomCorrectionDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.WeatherVelocity_DefineUsingSliceWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class Menu_DelayTime
implements ActionListener {
    protected JMenu m_menu = new JMenu("DelayTime");
    protected JMenuItem m_menuItem_UpholeMethod;
    protected JMenuItem m_menuItem_WaterBottomMethod;
    protected JMenuItem m_menuItem_Branch_Picks;
    protected JMenuItem m_menuItem_Branch_Traces;
    protected JMenu m_menu_BranchShortcuts = new JMenu("Branch assignment shortcuts");
    protected JMenuItem m_menuItem_Branch_AssignTwoToOne;
    protected JMenuItem m_menuItem_PickHistogram;
    protected JMenuItem m_menuItem_ImportOtherProject;
    protected JMenuItem m_menuItem_StacksWindow;
    protected JMenuItem m_menuItem_ModelWindow;
    protected JMenuItem m_menuItem_ModelProfileWindow;
    protected JMenuItem m_menuItem_WeatheringWindow;
    protected JMenuItem m_menuItem_InteractiveModelWindow;
    protected JCheckBoxMenuItem m_menuItem_ShowOptions;
    protected Menu_DelayTimeAnalysis m_menuAnalysis;
    protected ImportOtherProjectDelayTimeDialog m_importDialog = null;

    public Menu_DelayTime(JMenuBar menuBar) {
        try {
            menuBar.add(this.m_menu);
            this.m_menuItem_Branch_Picks = this.addMenuItem(this.m_menu, "Branch assignment - use picks");
            this.m_menuItem_Branch_Traces = this.addMenuItem(this.m_menu, "Branch assignment - use traces");
            this.m_menu.addSeparator();
            this.m_menuItem_ImportOtherProject = this.addMenuItem(this.m_menu, "Import delay time data from another project");
            this.m_menu.addSeparator();
            this.m_menuItem_UpholeMethod = this.addMenuItem(this.m_menu, "Select uphole correction method");
            this.m_menuItem_WaterBottomMethod = this.addMenuItem(this.m_menu, "Select water bottom correction method");
            this.m_menu.addSeparator();
            this.m_menu.add(this.m_menu_BranchShortcuts);
            this.m_menuItem_Branch_AssignTwoToOne = this.addMenuItem(this.m_menu_BranchShortcuts, "Clear first branch, assign second to first");
            this.m_menu.addSeparator();
            this.m_menuItem_StacksWindow = this.addMenuItem(this.m_menu, "Shot/receiver stack picker");
            this.m_menuItem_PickHistogram = this.addMenuItem(this.m_menu, "Pick error histogram display");
            this.m_menu.addSeparator();
            this.m_menuItem_ShowOptions = this.addCheckMenuItem(this.m_menu, "Show advanced options for analysis (currently OFF)");
            this.m_menuAnalysis = new Menu_DelayTimeAnalysis(this.m_menu);
            this.m_menu.addSeparator();
            this.m_menuItem_ModelWindow = this.addMenuItem(this.m_menu, "Model building window");
            this.m_menuItem_InteractiveModelWindow = this.addMenuItem(this.m_menu, "Imported layer model building window");
            this.m_menuItem_ModelProfileWindow = this.addMenuItem(this.m_menu, "Model profile display window");
            this.m_menuItem_WeatheringWindow = this.addMenuItem(this.m_menu, "Define weathering velocity");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JCheckBoxMenuItem addCheckMenuItem(JMenu menu, String text) {
        try {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(text);
            menu.add(mi);
            mi.addActionListener(this);
            return mi;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JMenuItem addMenuItem(JMenu menu, String text) {
        try {
            JMenuItem mi = new JMenuItem(text);
            menu.add(mi);
            mi.addActionListener(this);
            return mi;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            if (e.getSource() == this.m_menuItem_ImportOtherProject) {
                if (this.m_importDialog == null) {
                    this.m_importDialog = new ImportOtherProjectDelayTimeDialog(false);
                }
                this.m_importDialog.showDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_InteractiveModelWindow) {
                cm.showComponent(LayerModelWidget.class.getName(), "IMBW", "IMBW", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_WaterBottomMethod) {
                WaterBottomCorrectionDialog dlg = new WaterBottomCorrectionDialog();
                dlg.showDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_UpholeMethod) {
                UpholeCorrectionDialog dlg = new UpholeCorrectionDialog();
                dlg.showDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_ShowOptions) {
                SharedApplicationData.ExpertMode = !SharedApplicationData.ExpertMode;
                this.m_menuItem_ShowOptions.setState(SharedApplicationData.ExpertMode);
                if (SharedApplicationData.ExpertMode) {
                    this.m_menuItem_ShowOptions.setText("Show advanced options for analysis (currently ON)");
                } else {
                    this.m_menuItem_ShowOptions.setText("Show advanced options for analysis (currently OFF)");
                }
                return;
            }
            if (e.getSource() == this.m_menuItem_PickHistogram) {
                cm.showComponent(PickHistogramWidget.class.getName(), "Pick histogram", "Pick error histogram", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_Branch_AssignTwoToOne) {
                Tools_DelayTime.singleton().copyBranchData(2, 1);
                return;
            }
            if (e.getSource() == this.m_menuItem_StacksWindow) {
                cm.showComponent(SolutionStacksWidget_DelayTime.class.getName(), "DT Shot/rec stacks", "Delay time picker", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_Branch_Traces) {
                BranchAssignmentDialog dlg = new BranchAssignmentDialog(BranchAssignmentWidget.PlotType.Traces, false);
                return;
            }
            if (e.getSource() == this.m_menuItem_Branch_Picks) {
                BranchAssignmentDialog dlg = new BranchAssignmentDialog(BranchAssignmentWidget.PlotType.Picks, false);
                return;
            }
            if (e.getSource() == this.m_menuItem_ModelProfileWindow) {
                cm.showComponent(DelayTimeModelProfileWidget.class.getName(), "DT model profiles", "Delay time model profiles", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_ModelWindow) {
                cm.showComponent(DelayTimeModelWidget.class.getName(), "Model", "Delay time model", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_WeatheringWindow) {
                cm.showComponent(WeatherVelocity_DefineUsingSliceWidget.class.getName(), "V0", "Define weathering velocity", true);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

