/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_AxisLines;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class DelayTimeModelProfileWidget
extends JSplitPane
implements GenericObjectListener.Listener,
ActionListener,
ItemListener,
ISaveableFrame {
    protected JRadioButton m_blackRadio = new JRadioButton("No colors");
    protected JRadioButton m_tableRadio = new JRadioButton("Use database value");
    protected ButtonGroup m_plotGroup = new ButtonGroup();
    protected ComboStringListWrapper m_columnCombo = new ComboStringListWrapper();
    protected JButton m_reloadComboButton;
    protected JButton m_reloadPlotButton;
    protected Java2D_SimpleComposite m_widgetBasemap;
    protected StackedComposites m_stackedComposites;
    protected Java2D_UserEventConsumer_Line m_profileLineUEC = new Java2D_UserEventConsumer_Line();
    protected JRadioButton m_squareRadio = new JRadioButton("Inverse square");
    protected JRadioButton m_fourthRadio = new JRadioButton("Inverse fourth");
    protected ButtonGroup m_interpGroup = new ButtonGroup();
    protected JTextField m_interpRadiusText = new JTextField("100");
    protected int m_maxVisible = 4;
    protected int m_nextIndex = 0;
    protected JComboBox<String> m_cmbNumVisible = new JComboBox();
    protected JCheckBox m_chkHorzLines = new JCheckBox("Show horizontal grid lines");

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.DelayTime.DelayTimeModelProfileWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "DT model profiles";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Delay time model profiles";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public DelayTimeModelProfileWidget() {
        super(1);
        try {
            this.setLeftComponent(this.createLeft());
            this.m_stackedComposites = new StackedComposites(this.m_maxVisible);
            this.setRightComponent(this.m_stackedComposites);
            this.m_stackedComposites.setNumVisible(this.m_cmbNumVisible.getSelectedIndex() + 1);
            this.reloadCombo();
            this.reloadMap();
            this.m_profileLineUEC.SymmetricLine = false;
            this.m_profileLineUEC.addListener(this);
            this.m_widgetBasemap.mainWidget().addEventConsumer(this.m_profileLineUEC);
            this.m_widgetBasemap.mainWidget().addZoomer();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeft() {
        try {
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            for (int n = 1; n <= this.m_maxVisible; ++n) {
                String s = Integer.toString(n) + " plots visible";
                this.m_cmbNumVisible.addItem(s);
            }
            this.m_cmbNumVisible.setSelectedIndex(2);
            this.m_cmbNumVisible.addItemListener(this);
            w.addComponent(this.m_cmbNumVisible, 0);
            w.addComponent(this.m_chkHorzLines, 0);
            this.m_chkHorzLines.setSelected(true);
            this.m_chkHorzLines.addActionListener(this);
            GridLayoutWidget grid = w.createGridLayoutWidget(3, "Interpolation options", 0);
            int row = 0;
            grid.addSimple(row++, this.m_squareRadio, this.m_fourthRadio);
            grid.addSimple(row++, new JLabel("Interpolation radius"), this.m_interpRadiusText);
            this.m_interpGroup.add(this.m_squareRadio);
            this.m_interpGroup.add(this.m_fourthRadio);
            this.m_fourthRadio.setSelected(true);
            LinearLayoutWidget sub = w.createVertical(0, "Plot options", 0);
            sub.addComponent(this.m_blackRadio, 0);
            sub.addComponent(this.m_tableRadio, 0);
            sub.addComponent(this.m_columnCombo, 0);
            this.m_reloadComboButton = sub.createButton("Reload database column list", this, 0);
            this.m_reloadPlotButton = sub.createButton("Reload the plot", this, 0);
            this.m_columnCombo.setPreferredSelected("Elevation");
            this.m_columnCombo.setEnabled(false);
            this.m_columnCombo.listener().addListener(this);
            this.m_plotGroup.add(this.m_blackRadio);
            this.m_plotGroup.add(this.m_tableRadio);
            this.m_blackRadio.setSelected(true);
            this.m_blackRadio.addActionListener(this);
            this.m_tableRadio.addActionListener(this);
            Tools_FontChanger.changeSizeOfFont(w, -2, null, true);
            this.m_widgetBasemap = new Java2D_SimpleComposite(true);
            this.m_widgetBasemap.setAxesVisible(false, false);
            w.addComponent(this.m_widgetBasemap, 10);
            return w;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadMap() {
        try {
            Java2D_Paintable_Table po;
            System.out.println("reloadMap()");
            Java2D_Widget w = this.m_widgetBasemap.mainWidget();
            this.m_widgetBasemap.setColorTitle("");
            w.clearPaintableList();
            if (this.m_blackRadio.isSelected()) {
                po = Tools_RefractionStaticsProject.loadGeomPO("Shot");
                po.Symbol = Java2D_PointSymbol.FilledSquare;
                w.addPaintable(po, -9999);
                po = Tools_RefractionStaticsProject.loadGeomPO("Receiver");
                po.Symbol = Java2D_PointSymbol.FilledSquare;
                w.addPaintable(po, -9999);
            }
            if (this.m_tableRadio.isSelected()) {
                String col = this.m_columnCombo.getSelectedString();
                this.m_widgetBasemap.setColorTitle(col);
                po = Tools_RefractionStaticsProject.loadGeomPO("Shot", col);
                w.addPaintable(po, -9999);
                po = Tools_RefractionStaticsProject.loadGeomPO("Receiver", col);
                w.addPaintable(po, -9999);
            }
            for (int n = 0; n <= this.m_cmbNumVisible.getSelectedIndex(); ++n) {
                ProfileLine profile = this.m_stackedComposites.ProfileList.get(n);
                w.addPaintable(profile, ProfileLine.PlotLine);
            }
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadCombo() {
        try {
            ArrayList<String> cols = Tools_RefractionStaticsProject.getColumnList_Intersection();
            this.m_columnCombo.setStringArray(cols);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_cmbNumVisible) {
                this.m_nextIndex = 0;
                this.m_stackedComposites.setNumVisible(this.m_cmbNumVisible.getSelectedIndex() + 1);
                this.reloadMap();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_chkHorzLines) {
                this.m_stackedComposites.setLinesVisible(this.m_chkHorzLines.isSelected());
            }
            if (e.getSource() == this.m_reloadComboButton) {
                this.reloadCombo();
                return;
            }
            if (this.m_blackRadio == e.getSource() || this.m_tableRadio == e.getSource() || this.m_reloadPlotButton == e.getSource()) {
                this.m_columnCombo.setEnabled(this.m_tableRadio.isSelected());
                this.reloadMap();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadMapProfile() {
        try {
            while (this.m_nextIndex < 0) {
                ++this.m_nextIndex;
            }
            if (this.m_nextIndex > this.m_cmbNumVisible.getSelectedIndex()) {
                this.m_nextIndex = 0;
            }
            ProfileLine pl = this.m_stackedComposites.ProfileList.get(this.m_nextIndex);
            double radius = Tools_Widget.extractDouble(this.m_interpRadiusText, 100.0, 1.0, 10000.0);
            pl.createProfile(this.m_profileLineUEC.StartWorldX, this.m_profileLineUEC.StartWorldY, this.m_profileLineUEC.EndWorldX, this.m_profileLineUEC.EndWorldY, this.m_fourthRadio.isSelected(), radius);
            this.m_stackedComposites.PlotList.get(this.m_nextIndex).mainWidget().mooz();
            this.reloadMap();
            ++this.m_nextIndex;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_profileLineUEC) {
                if (this.m_profileLineUEC.Dragging) {
                    return;
                }
                if (this.m_profileLineUEC.TinyLine) {
                    return;
                }
                this.loadMapProfile();
            }
            if (sender == this.m_columnCombo) {
                this.reloadMap();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static class StackedComposites
    extends JPanel
    implements ComponentListener {
        public int m_numVisible = 1;
        public ArrayList<ProfileLine> ProfileList = new ArrayList();
        public ArrayList<Java2D_SimpleComposite> PlotList = new ArrayList();
        public ArrayList<Java2D_Paintable_AxisLines> LineList = new ArrayList();

        public StackedComposites(int max) {
            try {
                this.setLayout(null);
                for (int n = 0; n < max; ++n) {
                    ProfileLine pl = new ProfileLine();
                    pl.LineIndex = n;
                    Java2D_SimpleComposite w = new Java2D_SimpleComposite(false);
                    this.LineList.add(new Java2D_Paintable_AxisLines());
                    w.mainWidget().addPaintable(pl, ProfileLine.PlotProfile);
                    w.mainWidget().addPaintable(this.LineList.get(n), -9999);
                    Color c = Color.BLACK;
                    if (n == 0) {
                        c = Color.RED;
                    }
                    if (n == 1) {
                        c = Color.BLUE;
                    }
                    if (n == 2) {
                        c = Color.MAGENTA;
                    }
                    if (n == 3) {
                        c = Color.YELLOW;
                    }
                    if (n == 4) {
                        c = Color.CYAN;
                    }
                    pl.ProfileLineColor = c;
                    Color axisColor = Tools_GraphicalObjectLibrary.lighten(c);
                    w.setVerticalAxisColor(axisColor);
                    this.PlotList.add(w);
                    this.ProfileList.add(pl);
                    this.add(w);
                }
                this.addComponentListener(this);
                this.placeWidgets();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void setLinesVisible(boolean vis) {
            try {
                for (int n = 0; n < this.LineList.size(); ++n) {
                    this.LineList.get((int)n).DrawHorizontalLines = vis;
                    this.PlotList.get(n).mainWidget().mooz();
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            try {
                this.placeWidgets();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        public void placeWidgets() {
            try {
                int width = this.getSize().width;
                int height = this.getSize().height;
                this.m_numVisible = Math.max(1, this.m_numVisible);
                this.m_numVisible = Math.min(this.m_numVisible, this.PlotList.size());
                int pixPer = height / this.m_numVisible;
                for (int n = 0; n < this.PlotList.size(); ++n) {
                    this.PlotList.get(n).setVisible(n < this.m_numVisible);
                }
                int top = 0;
                for (int n = 0; n < this.m_numVisible; ++n) {
                    this.PlotList.get(n).setBounds(0, top, width, pixPer);
                    top += pixPer;
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void setNumVisible(int num) {
            try {
                this.m_numVisible = num;
                this.placeWidgets();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }

    public static class ProfileLine
    implements Java2D_PaintableInterface {
        public static int PlotProfile = 1000;
        public static int PlotLine = 1001;
        public Color ProfileLineColor = Color.BLACK;
        public boolean Valid = false;
        public int LineIndex = -999;
        public double X1;
        public double Y1;
        public double X2;
        public double Y2;
        public double DX;
        public double DY;
        public double Length;
        public int NumPoints = 500;
        public float[][] Velocity;
        public float[][] Elevation;
        public float[] MaxVelocity = new float[10];
        public float[] MaxElevation = new float[10];
        public float[] MinVelocity = new float[10];
        public float[] MinElevation = new float[10];
        public float PlotMaxY;
        public float PlotMinY;
        public int NumRefractors = 0;

        public ProfileLine() {
            try {
                this.Velocity = new float[10][this.NumPoints];
                this.Elevation = new float[10][this.NumPoints];
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        protected int checkWaterDepth(Table_Abstract tbl) {
            try {
                int indexDepth = -9999;
                if (!tbl.column_exists("WaterDepth")) {
                    return -9999;
                }
                indexDepth = tbl.column_indexOfColumn("WaterDepth");
                int indexDead = tbl.column_indexOfColumn("Killed");
                double maxDepth = 0.0;
                for (int n = 0; n < tbl.row_count(); ++n) {
                    if (tbl.getBool(n, indexDead)) continue;
                    double depth = tbl.getDouble(n, indexDepth);
                    maxDepth = Math.max(depth, maxDepth);
                }
                if (maxDepth <= 1.0) {
                    return -9999;
                }
                return indexDepth;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                return -9999;
            }
        }

        public void createProfile(double x1, double y1, double x2, double y2, boolean inverseFourth, double radius) {
            try {
                this.Valid = false;
                RefractionStaticsProject.singleton();
                this.NumRefractors = RefractionStaticsProject.delayTimeData().branchAssignment().maxBranch();
                if (this.NumRefractors < 1) {
                    return;
                }
                Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
                Table_Abstract recTable = RefractionStaticsProject.singleton().receiverTable();
                if (!shotTable.column_exists(Pecos.getColNameVel(0))) {
                    return;
                }
                int shotIndexWaterDepth = this.checkWaterDepth(shotTable);
                int recIndexWaterDepth = this.checkWaterDepth(recTable);
                if (shotIndexWaterDepth >= 0 && recIndexWaterDepth >= 0) {
                    this.createProfileWithWater(x1, y1, x2, y2, inverseFourth, radius);
                    return;
                }
                int[] shotIndexVel = new int[20];
                int[] shotIndexElev = new int[20];
                int shotIndexX = shotTable.column_indexOfColumn("Easting");
                int shotIndexY = shotTable.column_indexOfColumn("Northing");
                int shotIndexDead = shotTable.column_indexOfColumn("Killed");
                shotIndexElev[0] = shotTable.column_indexOfColumn("Elevation");
                shotIndexVel[0] = shotTable.column_indexOfColumn(Pecos.getColNameVel(0));
                for (int n = 1; n <= this.NumRefractors; ++n) {
                    shotIndexVel[n] = shotTable.column_indexOfColumn(Pecos.getColNameVel(n));
                    shotIndexElev[n] = shotTable.column_indexOfColumn(Pecos.getColNameElev(n));
                }
                int[] recIndexVel = new int[20];
                int[] recIndexElev = new int[20];
                int recIndexX = recTable.column_indexOfColumn("Easting");
                int recIndexY = recTable.column_indexOfColumn("Northing");
                int recIndexDead = recTable.column_indexOfColumn("Killed");
                recIndexElev[0] = recTable.column_indexOfColumn("Elevation");
                recIndexVel[0] = recTable.column_indexOfColumn(Pecos.getColNameVel(0));
                for (int n = 1; n <= this.NumRefractors; ++n) {
                    recIndexVel[n] = recTable.column_indexOfColumn(Pecos.getColNameVel(n));
                    recIndexElev[n] = recTable.column_indexOfColumn(Pecos.getColNameElev(n));
                }
                double radiusSquared = radius * radius;
                for (int z = 0; z <= this.NumRefractors; ++z) {
                    this.MaxVelocity[z] = Float.MIN_VALUE;
                    this.MinVelocity[z] = Float.MAX_VALUE;
                    this.MaxElevation[z] = Float.MIN_VALUE;
                    this.MinElevation[z] = Float.MAX_VALUE;
                }
                double[] sum1z = new double[20];
                double[] sum2z = new double[20];
                double[] sum1v = new double[20];
                double[] sum2v = new double[20];
                this.X1 = x1;
                this.X2 = x2;
                this.Y1 = y1;
                this.Y2 = y2;
                this.DX = this.X2 - this.X1;
                this.DY = this.Y2 - this.Y1;
                this.Length = Math.sqrt(this.DX * this.DX + this.DY * this.DY);
                this.DX /= (double)(this.NumPoints - 1);
                this.DY /= (double)(this.NumPoints - 1);
                for (int n = 0; n < this.NumPoints; ++n) {
                    double v;
                    double elev;
                    int z;
                    double w;
                    double dsq;
                    double dy;
                    double dx;
                    int t;
                    int z2;
                    double x = this.X1 + this.DX * (double)n;
                    double y = this.Y1 + this.DY * (double)n;
                    for (z2 = 0; z2 <= this.NumRefractors; ++z2) {
                        sum1z[z2] = 0.0;
                        sum2z[z2] = 1.0E-24;
                        sum1v[z2] = 0.0;
                        sum2v[z2] = 1.0E-24;
                    }
                    for (t = 0; t < recTable.row_count(); ++t) {
                        if (recTable.getBool(t, recIndexDead)) continue;
                        dx = x - recTable.getDouble(t, recIndexX);
                        dy = y - recTable.getDouble(t, recIndexY);
                        dsq = dx * dx + dy * dy;
                        w = 10.0 * radiusSquared / (radiusSquared + dsq);
                        if (inverseFourth) {
                            w *= w;
                        }
                        for (z = 0; z <= this.NumRefractors; ++z) {
                            elev = recTable.getDouble(t, recIndexElev[z]);
                            v = recTable.getDouble(t, recIndexVel[z]);
                            sum1v[z] = sum1v[z] + w * v;
                            sum2v[z] = sum2v[z] + w;
                            sum1z[z] = sum1z[z] + w * elev;
                            sum2z[z] = sum2z[z] + w;
                        }
                    }
                    for (t = 0; t < shotTable.row_count(); ++t) {
                        if (shotTable.getBool(t, shotIndexDead)) continue;
                        dx = x - shotTable.getDouble(t, shotIndexX);
                        dy = y - shotTable.getDouble(t, shotIndexY);
                        dsq = dx * dx + dy * dy;
                        w = 10.0 * radiusSquared / (radiusSquared + dsq);
                        if (inverseFourth) {
                            w *= w;
                        }
                        for (z = 0; z <= this.NumRefractors; ++z) {
                            elev = shotTable.getDouble(t, shotIndexElev[z]);
                            v = shotTable.getDouble(t, shotIndexVel[z]);
                            sum1v[z] = sum1v[z] + w * v;
                            sum2v[z] = sum2v[z] + w;
                            sum1z[z] = sum1z[z] + w * elev;
                            sum2z[z] = sum2z[z] + w;
                        }
                    }
                    for (z2 = 0; z2 <= this.NumRefractors; ++z2) {
                        this.Velocity[z2][n] = (float)(sum1v[z2] / sum2v[z2]);
                        this.Elevation[z2][n] = (float)(sum1z[z2] / sum2z[z2]);
                        this.MinElevation[z2] = Math.min(this.MinElevation[z2], this.Elevation[z2][n]);
                        this.MaxElevation[z2] = Math.max(this.MaxElevation[z2], this.Elevation[z2][n]);
                        this.MinVelocity[z2] = Math.min(this.MinVelocity[z2], this.Velocity[z2][n]);
                        this.MaxVelocity[z2] = Math.max(this.MaxVelocity[z2], this.Velocity[z2][n]);
                    }
                }
                float plotRange = this.MaxElevation[0] - this.MinElevation[this.NumRefractors];
                this.PlotMaxY = this.MaxElevation[0] + 0.1f * plotRange;
                this.PlotMinY = this.MinElevation[this.NumRefractors] - 0.1f * plotRange;
                for (int n = 0; n < this.NumPoints; ++n) {
                    this.Elevation[this.NumRefractors + 1][n] = this.PlotMinY;
                }
                this.Valid = true;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                this.Valid = false;
            }
        }

        protected void createProfileWithWater(double x1, double y1, double x2, double y2, boolean inverseFourth, double radius) {
            try {
                this.Valid = false;
                RefractionStaticsProject.singleton();
                this.NumRefractors = RefractionStaticsProject.delayTimeData().branchAssignment().maxBranch();
                if (this.NumRefractors < 1) {
                    return;
                }
                Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
                Table_Abstract recTable = RefractionStaticsProject.singleton().receiverTable();
                if (!shotTable.column_exists(Pecos.getColNameVel(0))) {
                    return;
                }
                int shotIndexWaterDepth = this.checkWaterDepth(shotTable);
                int recIndexWaterDepth = this.checkWaterDepth(recTable);
                double waterVel = RefractionStaticsProject.singleton().getWaterVelocity();
                int[] shotIndexVel = new int[20];
                int[] shotIndexElev = new int[20];
                int shotIndexX = shotTable.column_indexOfColumn("Easting");
                int shotIndexY = shotTable.column_indexOfColumn("Northing");
                int shotIndexDead = shotTable.column_indexOfColumn("Killed");
                shotIndexElev[0] = shotTable.column_indexOfColumn("Elevation");
                shotIndexVel[0] = shotTable.column_indexOfColumn(Pecos.getColNameVel(0));
                for (int n = 1; n <= this.NumRefractors; ++n) {
                    shotIndexVel[n] = shotTable.column_indexOfColumn(Pecos.getColNameVel(n));
                    shotIndexElev[n] = shotTable.column_indexOfColumn(Pecos.getColNameElev(n));
                }
                int[] recIndexVel = new int[20];
                int[] recIndexElev = new int[20];
                int recIndexX = recTable.column_indexOfColumn("Easting");
                int recIndexY = recTable.column_indexOfColumn("Northing");
                int recIndexDead = recTable.column_indexOfColumn("Killed");
                recIndexElev[0] = recTable.column_indexOfColumn("Elevation");
                recIndexVel[0] = recTable.column_indexOfColumn(Pecos.getColNameVel(0));
                for (int n = 1; n <= this.NumRefractors; ++n) {
                    recIndexVel[n] = recTable.column_indexOfColumn(Pecos.getColNameVel(n));
                    recIndexElev[n] = recTable.column_indexOfColumn(Pecos.getColNameElev(n));
                }
                double radiusSquared = radius * radius;
                for (int z = 0; z <= this.NumRefractors + 1; ++z) {
                    this.MaxVelocity[z] = Float.MIN_VALUE;
                    this.MinVelocity[z] = Float.MAX_VALUE;
                    this.MaxElevation[z] = Float.MIN_VALUE;
                    this.MinElevation[z] = Float.MAX_VALUE;
                }
                double[] sum1z = new double[20];
                double[] sum2z = new double[20];
                double[] sum1v = new double[20];
                double[] sum2v = new double[20];
                this.X1 = x1;
                this.X2 = x2;
                this.Y1 = y1;
                this.Y2 = y2;
                this.DX = this.X2 - this.X1;
                this.DY = this.Y2 - this.Y1;
                this.Length = Math.sqrt(this.DX * this.DX + this.DY * this.DY);
                this.DX /= (double)(this.NumPoints - 1);
                this.DY /= (double)(this.NumPoints - 1);
                for (int n = 0; n < this.NumPoints; ++n) {
                    int z;
                    double v;
                    double elev;
                    int z2;
                    double waterDepth;
                    double w;
                    double dsq;
                    double dy;
                    double dx;
                    int t;
                    double x = this.X1 + this.DX * (double)n;
                    double y = this.Y1 + this.DY * (double)n;
                    for (int z3 = 0; z3 <= this.NumRefractors; ++z3) {
                        sum1z[z3] = 0.0;
                        sum2z[z3] = 1.0E-24;
                        sum1v[z3] = 0.0;
                        sum2v[z3] = 1.0E-24;
                    }
                    double sum1wd = 0.0;
                    double sum2wd = 1.0E-24;
                    for (t = 0; t < recTable.row_count(); ++t) {
                        if (recTable.getBool(t, recIndexDead)) continue;
                        dx = x - recTable.getDouble(t, recIndexX);
                        dy = y - recTable.getDouble(t, recIndexY);
                        dsq = dx * dx + dy * dy;
                        w = 10.0 * radiusSquared / (radiusSquared + dsq);
                        if (inverseFourth) {
                            w *= w;
                        }
                        waterDepth = recTable.getDouble(t, recIndexWaterDepth);
                        waterDepth = Math.max(waterDepth, 0.0);
                        sum1wd += waterDepth * w;
                        sum2wd += w;
                        for (z2 = 0; z2 <= this.NumRefractors; ++z2) {
                            elev = recTable.getDouble(t, recIndexElev[z2]);
                            v = recTable.getDouble(t, recIndexVel[z2]);
                            sum1v[z2] = sum1v[z2] + w * v;
                            sum2v[z2] = sum2v[z2] + w;
                            sum1z[z2] = sum1z[z2] + w * elev;
                            sum2z[z2] = sum2z[z2] + w;
                        }
                    }
                    for (t = 0; t < shotTable.row_count(); ++t) {
                        if (shotTable.getBool(t, shotIndexDead)) continue;
                        dx = x - shotTable.getDouble(t, shotIndexX);
                        dy = y - shotTable.getDouble(t, shotIndexY);
                        dsq = dx * dx + dy * dy;
                        w = 10.0 * radiusSquared / (radiusSquared + dsq);
                        if (inverseFourth) {
                            w *= w;
                        }
                        waterDepth = shotTable.getDouble(t, shotIndexWaterDepth);
                        waterDepth = Math.max(waterDepth, 0.0);
                        sum1wd += waterDepth * w;
                        sum2wd += w;
                        for (z2 = 0; z2 <= this.NumRefractors; ++z2) {
                            elev = shotTable.getDouble(t, shotIndexElev[z2]);
                            v = shotTable.getDouble(t, shotIndexVel[z2]);
                            sum1v[z2] = sum1v[z2] + w * v;
                            sum2v[z2] = sum2v[z2] + w;
                            sum1z[z2] = sum1z[z2] + w * elev;
                            sum2z[z2] = sum2z[z2] + w;
                        }
                    }
                    double waterDepth2 = sum1wd / sum2wd;
                    this.Velocity[0][n] = (float)waterVel;
                    this.Elevation[0][n] = (float)(sum1z[0] / sum2z[0]);
                    for (z = 0; z <= this.NumRefractors; ++z) {
                        this.Velocity[z + 1][n] = (float)(sum1v[z] / sum2v[z]);
                    }
                    this.Elevation[1][n] = this.Elevation[0][n] - (float)waterDepth2;
                    for (z = 1; z <= this.NumRefractors; ++z) {
                        this.Elevation[z + 1][n] = (float)(sum1z[z] / sum2z[z]);
                    }
                    for (z = 0; z <= this.NumRefractors + 1; ++z) {
                        this.MinElevation[z] = Math.min(this.MinElevation[z], this.Elevation[z][n]);
                        this.MaxElevation[z] = Math.max(this.MaxElevation[z], this.Elevation[z][n]);
                        this.MinVelocity[z] = Math.min(this.MinVelocity[z], this.Velocity[z][n]);
                        this.MaxVelocity[z] = Math.max(this.MaxVelocity[z], this.Velocity[z][n]);
                    }
                }
                ++this.NumRefractors;
                float plotRange = this.MaxElevation[0] - this.MinElevation[this.NumRefractors];
                this.PlotMaxY = this.MaxElevation[0] + 0.1f * plotRange;
                this.PlotMinY = this.MinElevation[this.NumRefractors] - 0.1f * plotRange;
                for (int n = 0; n < this.NumPoints; ++n) {
                    this.Elevation[this.NumRefractors + 1][n] = this.PlotMinY;
                }
                this.Valid = true;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                this.Valid = false;
            }
        }

        @Override
        public boolean Java2D_ImageContentsDirty(int supplementalData) {
            return false;
        }

        @Override
        public int Java2D_MaximumPaintLevel(int supplementalData) {
            return 0;
        }

        @Override
        public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
            try {
                int n;
                int r;
                if (!this.Valid) {
                    return;
                }
                if (paintParameter.PaintLevel != 0) {
                    return;
                }
                Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
                Java2D_Transform transform = paintParameter.Transform;
                Graphics2D g2d = paintParameter.G2D;
                double scaleX = transform.scaleX();
                double shiftX = transform.shiftX();
                double scaleY = transform.scaleY();
                double shiftY = transform.shiftY();
                if (supplementalData == PlotLine) {
                    g2d.setColor(this.ProfileLineColor);
                    g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
                    int x1 = (int)(this.X1 * scaleX + shiftX);
                    int y1 = (int)(this.Y1 * scaleY + shiftY);
                    int x2 = (int)(this.X2 * scaleX + shiftX);
                    int y2 = (int)(this.Y2 * scaleY + shiftY);
                    g2d.drawLine(x1, y1, x2, y2);
                    return;
                }
                double segLength = this.Length / (double)(this.NumPoints - 1);
                int px = 1 + (int)(scaleX * segLength);
                for (r = 0; r <= this.NumRefractors; ++r) {
                    for (n = 0; n < this.NumPoints; ++n) {
                        double x = (double)n * this.Length / (double)(this.NumPoints - 1);
                        int ix = (int)(x * scaleX + shiftX);
                        int y1 = (int)((double)this.Elevation[r][n] * scaleY + shiftY);
                        int y2 = (int)((double)this.Elevation[r + 1][n] * scaleY + shiftY);
                        if (!colorWrapper.valueOK(this.Velocity[r][n])) continue;
                        Color c = colorWrapper.colorUsingValue(this.Velocity[r][n]);
                        g2d.setColor(c);
                        g2d.fillRect(ix - px / 2, y1, px + 1, y2 - y1);
                    }
                }
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
                g2d.setColor(Color.BLACK);
                for (r = 0; r <= this.NumRefractors; ++r) {
                    for (n = 1; n < this.NumPoints; ++n) {
                        double x1 = (double)(n - 1) * this.Length / (double)(this.NumPoints - 1);
                        int ix1 = (int)(x1 * scaleX + shiftX);
                        double x2 = (double)n * this.Length / (double)(this.NumPoints - 1);
                        int ix2 = (int)(x2 * scaleX + shiftX);
                        int iy1 = (int)(scaleY * (double)this.Elevation[r][n - 1] + shiftY);
                        int iy2 = (int)(scaleY * (double)this.Elevation[r][n] + shiftY);
                        g2d.drawLine(ix1, iy1, ix2, iy2);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
            try {
                if (!this.Valid) {
                    return;
                }
                if (supplementalData == PlotLine) {
                    return;
                }
                rangeX.expandRange(0.0 - this.Length * 0.05);
                rangeX.expandRange(this.Length * 1.05);
                rangeY.expandRange(this.PlotMaxY);
                rangeY.expandRange(this.PlotMinY);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
            try {
                if (!this.Valid) {
                    return;
                }
                if (supplementalData == PlotLine) {
                    return;
                }
                for (int z = 0; z <= this.NumRefractors; ++z) {
                    rangeC.expandRange(this.MinVelocity[z]);
                    rangeC.expandRange(this.MaxVelocity[z]);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
        }
    }
}

