/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.DefineGridWidget;
import com.PecosLibrary.Windows.Shared.MultiTextDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DefineGridThreeCornerDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener,
DocumentListener {
    protected JButton m_btnOK = new JButton("Apply changes");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JButton m_btnComputeXY2 = new JButton("Compute corner #2 (X,Y)");
    protected JButton m_btnExportCSV = new JButton("Export to CSV");
    public boolean OK = false;
    protected int m_timerCount = 0;
    protected JTextField[] m_txtInline = new JTextField[4];
    protected JTextField[] m_txtCrossline = new JTextField[4];
    protected JTextField[] m_txtX = new JTextField[4];
    protected JTextField[] m_txtY = new JTextField[4];
    public double[] X = new double[4];
    public double[] Y = new double[4];
    public int[] Inline = new int[4];
    public int[] Crossline = new int[4];
    public double InlineSize = 1.0;
    public double CrosslineSize = 1.0;
    public double Angle = 1.0;
    protected JLabel m_lblStatus = new JLabel(" ");
    protected JLabel m_lblSizeInline = new JLabel(" ");
    protected JLabel m_lblSizeCrossline = new JLabel(" ");
    protected Grid3D_Conversion m_grid;
    String m_fileName;
    protected ParameterTree m_tree = new ParameterTree();
    protected boolean m_requireRightHand = true;
    protected boolean m_ignoreChanges = false;

    public DefineGridThreeCornerDialog(Grid3D_Conversion grid3D, boolean requireRightHand) {
        try {
            this.m_requireRightHand = requireRightHand;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String path = project.projectPath();
            this.m_fileName = path + File.pathSeparator + "threecorner.xml";
            this.m_tree.read(this.m_fileName);
            this.m_grid = grid3D;
            LinearLayoutWidget main = LinearLayoutWidget.vert(4, null);
            GridLayoutWidget grid = new GridLayoutWidget(3, "Corners");
            main.addComponent(grid, 0);
            int row = 0;
            grid.addSimple(row++, new JLabel(" "), new JLabel("Inline"), new JLabel("Crossline"), new JLabel("X"), new JLabel("Y"), 0, 1, 1, 1, 1);
            JLabel lbl = null;
            for (int n = 0; n < 4; ++n) {
                this.m_txtInline[n] = new JTextField("1");
                this.m_txtCrossline[n] = new JTextField("1");
                this.m_txtX[n] = new JTextField("0");
                this.m_txtY[n] = new JTextField("0");
                if (n == 0) {
                    lbl = new JLabel("Corner 1");
                }
                if (n == 1) {
                    lbl = new JLabel("Corner 2, constant inline");
                }
                if (n == 2) {
                    lbl = new JLabel("Corner 3, constant crossline");
                }
                if (n == 3) {
                    lbl = new JLabel("Corner 4, computed from above");
                }
                grid.addSimple(row++, lbl, this.m_txtInline[n], this.m_txtCrossline[n], this.m_txtX[n], this.m_txtY[n], 0, 1, 1, 1, 1);
                if (n >= 3) continue;
                if (n != 1) {
                    this.m_txtInline[n].getDocument().addDocumentListener(this);
                }
                if (n != 2) {
                    this.m_txtCrossline[n].getDocument().addDocumentListener(this);
                }
                this.m_txtX[n].getDocument().addDocumentListener(this);
                this.m_txtY[n].getDocument().addDocumentListener(this);
            }
            this.m_txtY[0].setText(this.m_tree.string_get("Y1", "0"));
            this.m_txtY[1].setText(this.m_tree.string_get("Y2", "0"));
            this.m_txtY[2].setText(this.m_tree.string_get("Y3", "0"));
            this.m_txtX[0].setText(this.m_tree.string_get("X1", "0"));
            this.m_txtX[1].setText(this.m_tree.string_get("X2", "0"));
            this.m_txtX[2].setText(this.m_tree.string_get("X3", "0"));
            this.m_txtInline[0].setText(this.m_tree.string_get("I1", "1"));
            this.m_txtInline[1].setText(this.m_tree.string_get("I2", "1"));
            this.m_txtInline[2].setText(this.m_tree.string_get("I3", "1"));
            this.m_txtCrossline[0].setText(this.m_tree.string_get("C1", "1"));
            this.m_txtCrossline[1].setText(this.m_tree.string_get("C2", "1"));
            this.m_txtCrossline[2].setText(this.m_tree.string_get("C3", "1"));
            this.m_txtInline[1].setEnabled(false);
            this.m_txtCrossline[2].setEnabled(false);
            main.addComponent(this.m_lblStatus, 0);
            main.addComponent(this.m_lblSizeInline, 0);
            main.addComponent(this.m_lblSizeCrossline, 0);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.m_btnOK.setEnabled(false);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnComputeXY2, 0);
            this.m_btnComputeXY2.addActionListener(this);
            bottom.addComponent(this.m_btnExportCSV, 0);
            this.m_btnExportCSV.addActionListener(this);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(this.getSize().width + 300, this.getSize().height);
            this.setTitle("Define the grid using three corners");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    protected void computeXY2() {
        try {
            MultiTextDialog dlg = new MultiTextDialog(null, "Crossline bin size", "Crossline bin size");
            dlg.setText(0, Double.toString(this.InlineSize));
            dlg.showDialog("OK");
            if (!dlg.OK) {
                return;
            }
            this.CrosslineSize = dlg.getDouble(0, this.InlineSize, 0.1 * this.InlineSize, 10.0 * this.InlineSize);
            double angle = this.Angle + 1.5707963267948966;
            int crosslineInc = this.Crossline[1] - this.Crossline[0];
            double len = (double)crosslineInc * this.CrosslineSize;
            double x = this.X[0] + len * Math.cos(angle);
            double y = this.Y[0] + len * Math.sin(angle);
            this.m_ignoreChanges = true;
            this.m_txtX[1].setText(Tools_Strings.doubleToString(x, 20.0));
            this.m_txtY[1].setText(Tools_Strings.doubleToString(y, 20.0));
            this.m_ignoreChanges = false;
            this.handleDoc();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.m_ignoreChanges = false;
        }
        this.m_ignoreChanges = false;
    }

    protected void handleDoc() {
        try {
            int n;
            if (this.m_ignoreChanges) {
                return;
            }
            this.m_txtInline[3].setEnabled(false);
            this.m_txtCrossline[3].setEnabled(false);
            this.m_txtX[3].setEnabled(false);
            this.m_txtY[3].setEnabled(false);
            this.m_txtInline[3].setText("");
            this.m_txtCrossline[3].setText("");
            this.m_txtX[3].setText("");
            this.m_txtY[3].setText("");
            this.m_btnOK.setEnabled(false);
            this.m_btnComputeXY2.setEnabled(false);
            this.m_lblStatus.setForeground(Color.red);
            this.m_lblSizeCrossline.setText(" ");
            this.m_lblSizeInline.setText(" ");
            boolean valid = true;
            for (n = 0; n < 3; ++n) {
                valid = valid && this.m_txtInline[n].getText().length() > 0;
                valid = valid && this.m_txtCrossline[n].getText().length() > 0;
                valid = valid && this.m_txtX[n].getText().length() > 0;
                valid = valid && this.m_txtY[n].getText().length() > 0;
            }
            if (!valid) {
                this.m_lblStatus.setText("Please enter valid numbers");
                return;
            }
            for (n = 0; n < 3; ++n) {
                this.Inline[n] = Tools_Widget.extractInteger(this.m_txtInline[n], 1, -999999999, 999999999);
                this.Crossline[n] = Tools_Widget.extractInteger(this.m_txtCrossline[n], 1, -999999999, 999999999);
                this.X[n] = Tools_Widget.extractDouble(this.m_txtX[n], 1.0, -1.0E20, 1.0E20);
                this.Y[n] = Tools_Widget.extractDouble(this.m_txtY[n], 1.0, -1.0E20, 1.0E20);
                if (n != 0) continue;
                this.m_txtInline[1].setText(this.m_txtInline[0].getText());
                this.m_txtCrossline[2].setText(this.m_txtCrossline[0].getText());
            }
            this.m_txtInline[3].setText(this.m_txtInline[2].getText());
            this.m_txtCrossline[3].setText(this.m_txtCrossline[1].getText());
            int inlineInc = this.Inline[2] - this.Inline[0];
            if (inlineInc <= 1) {
                this.m_lblStatus.setText("Must have corner 3 inline  greater than corner 1 inline");
                return;
            }
            double dxi = this.X[2] - this.X[0];
            double dyi = this.Y[2] - this.Y[0];
            double disti = Math.sqrt(1.0E-40 + dxi * dxi + dyi * dyi);
            this.InlineSize = disti / (double)inlineInc;
            this.m_lblSizeInline.setText("Inline bin size = " + Double.toString(this.InlineSize));
            if (this.InlineSize < 0.1) {
                this.m_lblStatus.setText("Inline bin size too small");
                return;
            }
            this.Angle = Math.atan2(dyi, dxi);
            int crosslineInc = this.Crossline[1] - this.Crossline[0];
            if (crosslineInc <= 1) {
                this.m_lblStatus.setText("Must have corner 2 crossline  greater than corner 1 crossline");
                return;
            }
            this.m_btnComputeXY2.setEnabled(true);
            double dxc = this.X[1] - this.X[0];
            double dyc = this.Y[1] - this.Y[0];
            double distc = Math.sqrt(1.0E-40 + dxc * dxc + dyc * dyc);
            this.CrosslineSize = distc / (double)crosslineInc;
            this.m_lblSizeCrossline.setText("Crossline bin size = " + Double.toString(this.CrosslineSize));
            if (this.CrosslineSize < 0.1) {
                this.m_lblStatus.setText("CrosslineSize bin size too small");
                return;
            }
            this.m_txtX[3].setText(Double.toString(this.X[0] + dxi + dxc));
            this.m_txtY[3].setText(Double.toString(this.Y[0] + dyi + dyc));
            double dot = (dxi /= disti) * (dxc /= distc) + (dyi /= disti) * (dyc /= distc);
            if (Math.abs(dot) > 1.0E-4) {
                this.m_lblStatus.setText("Inline, crossline directions not perpendicular");
                return;
            }
            double cross = dxi * dyc - dxc * dyi;
            if (this.m_requireRightHand) {
                if (cross < 0.999) {
                    this.m_lblStatus.setText("Corner #2 needs to be counter-clockwise from corner #3");
                    return;
                }
            } else if (Math.abs(cross) < 0.9999) {
                this.m_lblStatus.setText("Axes not perpendicular");
                return;
            }
            this.m_btnOK.setEnabled(false);
            this.m_lblStatus.setForeground(Color.blue);
            this.m_lblStatus.setText("Grid definition OK");
            this.m_btnOK.setEnabled(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            this.handleDoc();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            this.handleDoc();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            this.handleDoc();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void handleCancel(DefineGridWidget sender) {
        try {
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleDone(DefineGridWidget sender) {
        try {
            System.out.println("handleDone");
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void exportCSV() {
        try {
            String fileName = Tools_Chooser.getSaveFileName("csv");
            if (fileName == null) {
                return;
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            for (int k = 0; k < 4; ++k) {
                int n = k;
                if (k == 1) {
                    n = 2;
                }
                if (k == 2) {
                    n = 1;
                }
                writer.write(this.m_txtInline[n].getText());
                writer.write(", ");
                writer.write(this.m_txtCrossline[n].getText());
                writer.write(", ");
                writer.write(this.m_txtX[n].getText());
                writer.write(", ");
                writer.write(this.m_txtY[n].getText());
                writer.newLine();
            }
            writer.flush();
            writer.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                this.m_grid.setInlineAtOrigin(this.Inline[0]);
                this.m_grid.setCrosslineAtOrigin(this.Crossline[0]);
                this.m_grid.setInlineAngle(this.Angle);
                this.m_grid.setOrigin(this.X[0], this.Y[0]);
                this.m_grid.setBinSize(this.InlineSize, this.CrosslineSize);
                this.OK = true;
                this.m_tree.string_put("C1", this.m_txtCrossline[0].getText());
                this.m_tree.string_put("C2", this.m_txtCrossline[1].getText());
                this.m_tree.string_put("C3", this.m_txtCrossline[2].getText());
                this.m_tree.string_put("I1", this.m_txtInline[0].getText());
                this.m_tree.string_put("I2", this.m_txtInline[1].getText());
                this.m_tree.string_put("I3", this.m_txtInline[2].getText());
                this.m_tree.string_put("X1", this.m_txtX[0].getText());
                this.m_tree.string_put("X2", this.m_txtX[1].getText());
                this.m_tree.string_put("X3", this.m_txtX[2].getText());
                this.m_tree.string_put("Y1", this.m_txtY[0].getText());
                this.m_tree.string_put("Y2", this.m_txtY[1].getText());
                this.m_tree.string_put("Y3", this.m_txtY[2].getText());
                this.m_tree.save(this.m_fileName);
                this.dispose();
            }
            if (e.getSource() == this.m_btnExportCSV) {
                this.exportCSV();
            }
            if (e.getSource() == this.m_btnComputeXY2) {
                this.computeXY2();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.OK = false;
                this.dispose();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

