/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Database;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.PlanarFit;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ThreePointDialog
extends JDialog
implements GenericObjectListener.Listener,
ActionListener {
    protected RefractionStaticsProject m_project;
    protected JButton m_btnCancel = new JButton("Close");
    protected JButton m_btnInterpolate = new JButton("Update column");
    protected ComboStringListWrapper m_combo = new ComboStringListWrapper();
    protected ArrayList<JTextField> m_list_x = new ArrayList();
    protected ArrayList<JTextField> m_list_y = new ArrayList();
    protected ArrayList<JTextField> m_list_v = new ArrayList();

    public ThreePointDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            ParameterTree t = this.m_project.information().ParameterTree_get("ThreePoint");
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Modify which column", 0);
            sub.addComponent(this.m_combo, 0);
            this.m_combo.listener().addListener(this);
            GridLayoutWidget grid = main.createGridLayoutWidget(3, 0);
            boolean row = false;
            for (int n = 0; n < 3; ++n) {
                String s = "Point # " + String.valueOf(n + 1);
                JTextField tx = new JTextField("0");
                JTextField ty = new JTextField("0");
                JTextField tv = new JTextField("0");
                grid.addSimple(n, new JLabel(s), tx, ty, tv);
                this.m_list_x.add(tx);
                this.m_list_y.add(ty);
                this.m_list_v.add(tv);
                tx.setText(t.string_get("tx" + String.valueOf(n), "0"));
                ty.setText(t.string_get("ty" + String.valueOf(n), "0"));
                tv.setText(t.string_get("tv" + String.valueOf(n), "0"));
            }
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnInterpolate, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnInterpolate.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.reloadColumns();
            this.setTitle("Smooth database value");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadColumns() {
        try {
            boolean rec = true;
            boolean shot = true;
            ArrayList<String> colList = null;
            if (shot && !rec) {
                colList = this.database().listOfColumnNames("Shot");
            }
            if (!shot && rec) {
                colList = this.database().listOfColumnNames("Receiver");
            }
            if (shot && rec) {
                colList = this.database().listOfColumnNames("Receiver", "Shot");
            }
            this.m_combo.setEnabled(colList != null);
            ArrayList<String> col1 = new ArrayList<String>();
            col1.add("Easting");
            col1.add("Northing");
            col1.add("Elevation");
            col1.add("LineNumber");
            col1.add("PointNumber");
            col1.add("PointIndex");
            col1.add("FFID");
            col1.add("ShotID");
            col1.add("ReceiverID");
            if (colList != null) {
                for (String s : col1) {
                    if (!colList.contains(s)) continue;
                    colList.remove(s);
                }
                this.m_combo.setStringArray(colList);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void save_current() {
        try {
            ParameterTree t = this.m_project.information().ParameterTree_get("ThreePoint");
            for (int n = 0; n < 3; ++n) {
                t.string_put("tx" + String.valueOf(n), this.m_list_x.get(n).getText());
                t.string_put("ty" + String.valueOf(n), this.m_list_y.get(n).getText());
                t.string_put("tv" + String.valueOf(n), this.m_list_v.get(n).getText());
            }
            this.m_project.saveInformation();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean modify() {
        try {
            PlanarFit plane = new PlanarFit();
            for (int n = 0; n < 3; ++n) {
                double x = Double.valueOf(this.m_list_x.get(n).getText());
                double y = Double.valueOf(this.m_list_y.get(n).getText());
                double v = Double.valueOf(this.m_list_v.get(n).getText());
                plane.add(x, y, v);
            }
            plane.leastSquaredFit();
            String col = this.m_combo.getSelectedString();
            for (int iter = 0; iter <= 1; ++iter) {
                Table_Abstract t = this.m_project.shotTable();
                if (iter == 1) {
                    t = this.m_project.receiverTable();
                }
                int colx = t.column_indexOfColumn("Easting");
                int coly = t.column_indexOfColumn("Northing");
                int colv = t.column_indexOfColumn(col);
                for (int r = 0; r < t.row_count(); ++r) {
                    double x = t.getDouble(r, colx);
                    double y = t.getDouble(r, coly);
                    double v = plane.A * x + plane.B * y + plane.C;
                    t.putDouble(r, colv, v);
                }
            }
            IDatabaseConnection db = this.m_project.geometryDatabase();
            db.writeColumnContentsToDatabase(this.m_project.shotTable(), col);
            db.writeColumnContentsToDatabase(this.m_project.receiverTable(), col);
            this.m_project.reloadAllData();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            try {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (Exception error2) {
                ExceptionMonitor.add(error2);
            }
            return false;
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnInterpolate) {
                this.save_current();
                if (!this.modify()) {
                    return;
                }
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.save_current();
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

