/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Database;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class SeismicFileManagerDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected RefractionStaticsProject m_project;
    protected JButton m_pathButton;
    protected JButton m_pathSelectedButton;
    protected JButton m_cancelButton;
    protected JButton m_saveButton;
    protected JTable m_table = new JTable();
    protected Table_Abstract m_fileTable;

    public SeismicFileManagerDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            this.m_fileTable = Table_Memory.readTable(this.m_project.projectPath(), "FileList");
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget top = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            this.m_pathButton = top.createButton("Choose path for all files", this, 0);
            this.m_pathSelectedButton = top.createButton("Choose path for selected files", this, 0);
            top.addStretch(10);
            main.addComponent(new JScrollPane(this.m_table), 10);
            this.m_table.setGridColor(Color.LIGHT_GRAY);
            this.m_table.setShowGrid(true);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            this.m_saveButton = bottom.createButton("Save changes and close", this, 0);
            this.m_cancelButton = bottom.createButton("Cancel", this, 0);
            bottom.addStretch(10);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            if (this.m_fileTable == null) {
                this.dispose();
            }
            this.reloadTable();
            this.setSize(750, 450);
            this.setTitle("Seismic file manager");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadTable() {
        try {
            int indexID = this.m_fileTable.column_indexOfColumn("FileID");
            int indexName = this.m_fileTable.column_indexOfColumn("Name");
            int indexPath = this.m_fileTable.column_indexOfColumn("Directory");
            int indexOK = this.m_fileTable.column_append("Status", DataType.Text);
            for (int n = 0; n < this.m_fileTable.row_count(); ++n) {
                String name = this.m_fileTable.getString(n, indexName);
                String path = this.m_fileTable.getString(n, indexPath);
                String baseName = "";
                if (name.endsWith(".xtref")) {
                    int endChar = name.length() - ".xtref".length();
                    baseName = name.substring(0, endChar);
                } else {
                    baseName = name;
                }
                String fullPath = path + "/" + baseName;
                String fullPathwcf = fullPath + "_wcf";
                if (Tools_FileSystem.exists_file(fullPath)) {
                    this.m_fileTable.putString(n, indexOK, "Okay");
                    continue;
                }
                if (Tools_FileSystem.exists_file(fullPathwcf)) {
                    this.m_fileTable.putString(n, indexOK, "Okay, compressed");
                    continue;
                }
                this.m_fileTable.putString(n, indexOK, "Not found");
            }
            this.m_table.setModel(new Table_SimpleModel(this.m_fileTable));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_pathSelectedButton) {
                int[] rows = this.m_table.getSelectedRows();
                if (rows == null) {
                    return;
                }
                if (rows.length < 1) {
                    return;
                }
                String path = Tools_Chooser.getDirectory("Select path for selected files");
                if (path == null) {
                    return;
                }
                int indexPath = this.m_fileTable.column_indexOfColumn("Directory");
                for (int r = 0; r < rows.length; ++r) {
                    int n = rows[r];
                    this.m_fileTable.putString(n, indexPath, path);
                }
                this.reloadTable();
            }
            if (e.getSource() == this.m_pathButton) {
                String path = Tools_Chooser.getDirectory("Select path for all files");
                if (path == null) {
                    return;
                }
                int indexPath = this.m_fileTable.column_indexOfColumn("Directory");
                for (int n = 0; n < this.m_fileTable.row_count(); ++n) {
                    this.m_fileTable.putString(n, indexPath, path);
                }
                this.reloadTable();
            }
            if (e.getSource() == this.m_saveButton) {
                Table_Abstract projectTable = Table_Memory.readTable(this.m_project.projectPath(), "FileList");
                int indexProject = projectTable.column_indexOfColumn("Directory");
                int indexLocal = this.m_fileTable.column_indexOfColumn("Directory");
                for (int n = 0; n < this.m_fileTable.row_count(); ++n) {
                    String path = this.m_fileTable.getString(n, indexLocal);
                    projectTable.putString(n, indexProject, path);
                }
                projectTable.saveToPath(this.m_project.projectPath());
                this.m_project.reloadFileInfo(false);
                this.dispose();
            }
            if (e.getSource() == this.m_cancelButton) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

