/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Database;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.Database.DraggerWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class DraggerDialog
extends JDialog
implements GenericObjectListener.Listener,
ActionListener {
    protected DraggerWidget m_draggerWidget;
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JButton m_btnAccept = new JButton("Move to new location");
    protected JLabel m_label = new JLabel("ll");

    public DraggerDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.m_draggerWidget = new DraggerWidget();
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnAccept, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnAccept.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)this.m_draggerWidget, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.setSize(1050, 850);
            this.setTitle("Drag to new location");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void dragShot(int shotID) {
        try {
            Table_Abstract table = RefractionStaticsProject.singleton().shotTable();
            HashMap_Integer map = RefractionStaticsProject.singleton().shotMap();
            if (!map.containsKey(shotID)) {
                JOptionPane.showMessageDialog(null, "Selected shot ID does not exist", "Cannot open drag dialog", 0);
                return;
            }
            this.m_draggerWidget.dragShot(shotID);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnAccept) {
                this.m_draggerWidget.acceptMove();
                this.setVisible(false);
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.setVisible(false);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

