/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Import.Action_AddSegyFilesToProject;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.FileWidget;
import com.PecosLibrary.Windows.Shared.MultipleFileSelectionWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class AddSegyFilesDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected RefractionStaticsProject m_project;
    protected FileWidget m_dictWidget;
    protected MultipleFileSelectionWidget m_segyWidget;
    protected JButton m_btnOK = new JButton("Okay");
    protected JButton m_btnCancel = new JButton("Cancel");
    public boolean OK = false;

    public AddSegyFilesDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_dictWidget = new FileWidget(false, false, 3, "Select SEG-Y dictionary", this);
            main.addComponent(this.m_dictWidget, 0);
            this.m_segyWidget = new MultipleFileSelectionWidget("Select SEGY files");
            main.addComponent(this.m_segyWidget, 10);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setTitle("Add SEG-Y files to an existing project");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ArrayList<String> getFileList() {
        return this.m_segyWidget.fileList();
    }

    public String getDictFileName() {
        return this.m_dictWidget.getText();
    }

    public void showDialog() {
        try {
            this.OK = false;
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    protected boolean launchMerge() {
        try {
            Action_AddSegyFilesToProject action = new Action_AddSegyFilesToProject();
            String dictFileName = this.m_dictWidget.getText();
            ArrayList<String> files = this.getFileList();
            action.Hasher.string_put("DictionaryFile", dictFileName);
            ArrayList<String> list = new ArrayList<String>();
            for (String fileName : files) {
                boolean exists = false;
                String fileListPath = RefractionStaticsProject.singleton().projectPath() + "/";
                Table_Abstract fileTable = Table_Memory.readTable(fileListPath, "FileList");
                int indexName = fileTable.column_indexOfColumn("Name");
                int indexPath = fileTable.column_indexOfColumn("Directory");
                for (int r = 0; r < fileTable.row_count(); ++r) {
                    String fullPath = fileTable.getString(r, indexPath) + "/" + fileTable.getString(r, indexName);
                    if (!fullPath.equalsIgnoreCase(fileName)) continue;
                    exists = true;
                }
                Segy segy = new Segy();
                segy.setFileName(fileName, true);
                if (!segy.isFileOK() || exists) continue;
                list.add(fileName);
            }
            if (list.size() < 1) {
                JOptionPane.showMessageDialog(null, "No valid SEGY files selected", "No valid SEGY files selected", 0);
                return false;
            }
            action.Hasher.stringList_put("FileList", list);
            this.m_project.executeSingleAction(action);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                this.OK = true;
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

