/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.MDI;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.MDI.MDIDesktopPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MDIViewMenu
extends JMenu
implements ActionListener,
MenuListener {
    private MDIDesktopPane m_desktop;
    private JMenuItem m_cascade = new JMenuItem("Cascade");
    private JMenuItem m_tile = new JMenuItem("Tile");

    public MDIViewMenu(MDIDesktopPane desktop) {
        try {
            this.m_desktop = desktop;
            this.setText("MDI");
            this.m_cascade.addActionListener(this);
            this.m_tile.addActionListener(this);
            this.addMenuListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
        this.removeAll();
    }

    @Override
    public void menuSelected(MenuEvent e) {
        try {
            this.buildChildMenus();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_cascade) {
                this.m_desktop.cascadeFrames();
                return;
            }
            if (e.getSource() == this.m_tile) {
                this.m_desktop.tileFrames();
                return;
            }
            if (e.getSource() instanceof ChildMenuItem) {
                ChildMenuItem cm = (ChildMenuItem)e.getSource();
                cm.frame.moveToFront();
                cm.frame.setSelected(true);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    private void buildChildMenus() {
        try {
            this.removeAll();
            JInternalFrame[] array = this.m_desktop.getAllFrames();
            this.add(this.m_cascade);
            this.add(this.m_tile);
            if (array.length > 0) {
                this.addSeparator();
            }
            this.m_cascade.setEnabled(array.length > 0);
            this.m_tile.setEnabled(array.length > 0);
            for (int i = 0; i < array.length; ++i) {
                ChildMenuItem menu = new ChildMenuItem(array[i]);
                menu.setState(i == 0);
                menu.addActionListener(this);
                this.add(menu);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    class ChildMenuItem
    extends JCheckBoxMenuItem {
        private JInternalFrame frame;

        public ChildMenuItem(JInternalFrame frame) {
            super(frame.getTitle());
            this.frame = frame;
        }

        public JInternalFrame getFrame() {
            return this.frame;
        }
    }
}

