/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.LWRS;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Seismic.SeismicProfile;
import com.PecosLibrary.Stack.SemblanceProfileVolume;
import com.PecosLibrary.Stack.StackGizmo;
import com.PecosLibrary.Stack.VelocityLocation;
import com.PecosLibrary.Windows.Java2D.ColorWidgets.Java2D_HorizontalColorCompositeWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Java2D_XAxisWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_YAxisWidget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Ensemble_Wiggles;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_MoveoutOverlay;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseMove;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LwrsSemblanceWidget
extends LinearLayoutWidget
implements ComponentListener,
ActionListener,
ItemListener,
ChangeListener,
Java2D_Widget.Listener,
Java2D_HorizontalColorCompositeWidget.Listener,
GenericObjectListener.Listener,
Messenger.Listener {
    protected Java2D_YAxisWidget m_timeAxis;
    protected Java2D_Widget m_semblanceWidget;
    protected Java2D_XAxisWidget m_semblanceAxis;
    protected Java2D_Widget m_gatherWidget;
    protected Java2D_XAxisWidget m_gatherAxis;
    protected Java2D_HorizontalColorCompositeWidget m_horizontalColorWidget = null;
    protected JPanel m_mainPanel = new JPanel();
    protected JCheckBox m_chkShowGather = new JCheckBox("Show gather");
    protected JComboBox<String> m_comboBin = new JComboBox();
    protected JButton m_btnPrev;
    protected JComboBox<String> m_comboStep = new JComboBox();
    protected JButton m_btnNext;
    protected JLabel m_lblCount = new JLabel("");
    protected JSlider m_slider = new JSlider();
    protected boolean m_ignoreNav = true;
    protected JLabel m_lblPick = new JLabel("", 4);
    protected JButton m_btnClearAllPicks;
    protected JButton m_btnMoveRightAndPick;
    protected JButton m_btnMoveLeftAndPick;
    protected JButton m_btnMoveRightAndPickMultiple;
    protected JButton m_btnMoveLeftAndPickMultiple;
    protected SeismicProfile m_profile;
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected Ensemble m_ensemble;
    protected Java2D_Paintable_Ensemble_Wiggles m_wigglePainter = new Java2D_Paintable_Ensemble_Wiggles();
    protected Java2D_Paintable_MoveoutOverlay m_moveoutOverlay = new Java2D_Paintable_MoveoutOverlay();
    protected Range_Double m_rangeOffset = new Range_Double();
    protected Range_Double m_rangeTime = new Range_Double();
    protected Range_Double m_rangeVelocity = new Range_Double();
    protected Java2D_UserEventConsumer_MouseMove m_mouseMoveUEC = new Java2D_UserEventConsumer_MouseMove();
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
    protected StackGizmo m_stackGizmo = new StackGizmo();
    protected int m_selectedBin = 0;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public StackGizmo getStackGizmo() {
        return this.m_stackGizmo;
    }

    public LwrsSemblanceWidget(GenericObjectListener.Listener listener) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_listener.addListener(listener);
            Messenger.singleton().addListener(this);
            this.m_lblCount.setPreferredSize(new Dimension(120, 18));
            this.m_lblCount.setMinimumSize(new Dimension(80, 18));
            LinearLayoutWidget top = this.createHorizontal(3, "Bin navigation", 0);
            for (int n = 1; n <= 10; ++n) {
                this.m_comboStep.addItem(String.format("%d", n));
            }
            this.m_comboStep.setSelectedIndex(0);
            top.addComponent(new JLabel("Bin:"), 0);
            top.addComponent(this.m_comboBin, 2);
            this.m_btnPrev = top.createButton("<<", this, 0);
            this.m_btnNext = top.createButton(">>", this, 0);
            top.addComponent(new JLabel("Skip:"), 0);
            top.addComponent(this.m_comboStep, 0);
            top.addComponent(this.m_slider, 10);
            top.addComponent(this.m_lblCount, 2);
            this.m_chkShowGather.addActionListener(this);
            this.m_comboBin.addItemListener(this);
            this.m_slider.addChangeListener(this);
            top = this.createHorizontal(3, "Automated picks", 0);
            this.m_btnMoveLeftAndPick = top.createButton("Move left and pick", this, 0);
            this.m_btnMoveRightAndPick = top.createButton("Move right and pick", this, 0);
            this.m_btnClearAllPicks = top.createButton("Remove all picks", this, 0);
            top.addComponent(this.m_lblPick, 20);
            this.addComponent(this.m_mainPanel, 10);
            this.m_mainPanel.setLayout(null);
            this.m_horizontalColorWidget = new Java2D_HorizontalColorCompositeWidget(this);
            Java2D_ColorArrayWrapper colorWrapper = this.m_horizontalColorWidget.getColorArrayWrapper();
            int numColors = colorWrapper.colorCount();
            int third = numColors / 3;
            colorWrapper.setColor(0, Color.black);
            colorWrapper.setColor(third, Color.blue);
            colorWrapper.setColor(2 * third, Color.red);
            colorWrapper.setColor(numColors - 1, Color.yellow);
            colorWrapper.interpolateColors(0, third);
            colorWrapper.interpolateColors(third, 2 * third);
            colorWrapper.interpolateColors(2 * third, numColors - 1);
            this.m_timeAxis = new Java2D_YAxisWidget();
            this.m_semblanceAxis = new Java2D_XAxisWidget();
            this.m_semblanceAxis.setTitle("Velocity");
            this.m_gatherAxis = new Java2D_XAxisWidget();
            this.m_gatherAxis.setTitle("Offset");
            this.m_semblanceWidget = new Java2D_Widget(colorWrapper);
            this.m_gatherWidget = new Java2D_Widget(colorWrapper);
            this.m_semblanceWidget.addListener(this);
            this.m_gatherWidget.addListener(this);
            this.m_mainPanel.addComponentListener(this);
            this.m_mainPanel.add(this.m_horizontalColorWidget);
            this.m_mainPanel.add(this.m_timeAxis);
            this.m_mainPanel.add(this.m_semblanceAxis);
            this.m_mainPanel.add(this.m_gatherAxis);
            this.m_mainPanel.add(this.m_semblanceWidget);
            this.m_mainPanel.add(this.m_gatherWidget);
            this.m_mouseMoveUEC.addListener(this);
            this.m_leftClickUEC.addListener(this);
            this.loadSemblanceUEC();
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void loadProfile() {
        try {
            this.m_ignoreNav = true;
            if (this.m_profile == null) {
                return;
            }
            if (!this.m_profile.semblanceProfileVolume().valid()) {
                return;
            }
            this.m_selectedBin = 0;
            this.m_slider.setMaximum(this.m_profile.binCount());
            this.m_slider.setMinimum(1);
            this.m_slider.setValue(1);
            this.reloadCombo();
            this.m_ignoreNav = false;
            this.loadCurrentBin();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setSeismicProfile(SeismicProfile profile) {
        try {
            this.m_profile = profile;
            this.loadProfile();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.ProfileSemblanceRecomputed) {
                this.loadProfile();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected VelocityLocation getVelocityLocation() {
        try {
            return this.getVelocityLocation(this.m_selectedBin);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected VelocityLocation getVelocityLocation(int bin) {
        try {
            return this.m_profile.semblanceProfileVelocityCollection().getVelocityLocation(bin);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected boolean moveRightAndPick() {
        try {
            this.m_lblPick.setText("");
            if (this.m_selectedBin >= this.m_profile.binCount() - 1) {
                return false;
            }
            SemblanceProfileVolume spv = this.m_profile.semblanceProfileVolume();
            VelocityLocation currentLoc = this.getVelocityLocation(this.m_selectedBin);
            VelocityLocation nextLoc = this.getVelocityLocation(this.m_selectedBin + 1);
            if (currentLoc.numPicks() < 1) {
                this.m_lblPick.setText("Current location not picked");
                this.m_lblPick.setForeground(Color.red);
                return false;
            }
            if (nextLoc.numPicks() >= 1) {
                this.m_lblPick.setText("Next location already picked");
                this.m_lblPick.setForeground(Color.red);
                return true;
            }
            int numPicksMade = 0;
            for (int n = 0; n < currentLoc.numPicks(); ++n) {
                VelocityLocation.Pick currentPick = currentLoc.pick(n);
                boolean ok = spv.tryToMakePick(currentPick.Time, currentPick.Velocity, this.m_selectedBin + 1);
                if (!ok) continue;
                ++numPicksMade;
                nextLoc.addPickFromAuto(spv.PickedTime, spv.PickedVel);
            }
            if (numPicksMade < 1) {
                this.m_lblPick.setText("Failed to make picks at new location");
            } else {
                this.m_profile.semblanceProfileVelocityCollection().save();
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected void loadCurrentBin() {
        try {
            this.m_lblCount.setText("");
            this.m_semblanceWidget.clearPaintableList();
            this.m_gatherWidget.clearPaintableList();
            if (this.m_profile == null) {
                this.m_gatherWidget.repaint();
                this.m_semblanceWidget.repaint();
                return;
            }
            this.m_selectedBin = this.m_comboBin.getSelectedIndex();
            SemblanceProfileVolume spv = this.m_profile.semblanceProfileVolume();
            VelocityLocation loc = this.getVelocityLocation();
            this.m_semblanceWidget.addPaintable(spv, spv.PlotBin + this.m_selectedBin);
            if (loc != null) {
                this.m_semblanceWidget.addPaintable(loc, VelocityLocation.PlotType.Semblance.ordinal());
            }
            this.m_semblanceWidget.transform().setTechnique(Java2D_Transform.Technique.Inverted);
            this.m_semblanceWidget.transform().setDesiredWorldX(spv.minimumVelocity(), spv.maximumVelocity());
            this.m_semblanceWidget.transform().setDesiredWorldY(spv.minimumTime(), spv.maximumTime());
            this.m_semblanceWidget.transform().computeTransform();
            this.m_semblanceWidget.repaint();
            try {
                int count = this.m_profile.bin((int)this.m_selectedBin).Count;
                this.m_lblCount.setText(count + " traces in the current bin");
            }
            catch (Exception exception) {}
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadCombo() {
        try {
            this.m_ignoreNav = true;
            this.m_comboBin.removeAllItems();
            if (this.m_profile == null) {
                return;
            }
            for (int n = 0; n < this.m_profile.binCount(); ++n) {
                this.m_comboBin.addItem(Integer.toString(n + 1));
            }
            this.m_comboBin.setSelectedIndex(this.m_selectedBin);
            this.m_ignoreNav = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (!this.m_ignoreNav && e.getSource() == this.m_comboBin) {
                this.m_ignoreNav = true;
                this.m_selectedBin = this.m_comboBin.getSelectedIndex();
                this.m_slider.setValue(this.m_selectedBin + 1);
                this.m_ignoreNav = false;
                this.loadCurrentBin();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setCurrentBin(int bin) {
        try {
            bin = Math.max(0, bin);
            bin = Math.min(bin, this.m_profile.binCount() - 1);
            this.m_ignoreNav = true;
            this.m_selectedBin = bin;
            this.m_slider.setValue(this.m_selectedBin + 1);
            this.m_comboBin.setSelectedIndex(this.m_selectedBin);
            this.m_ignoreNav = false;
            this.loadCurrentBin();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            if (!this.m_ignoreNav && e.getSource() == this.m_slider) {
                this.m_ignoreNav = true;
                this.m_selectedBin = this.m_slider.getValue() - 1;
                this.m_comboBin.setSelectedIndex(this.m_selectedBin);
                this.m_ignoreNav = false;
                this.loadCurrentBin();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void gotoNextBin() {
        try {
            int step = 1 + this.m_comboStep.getSelectedIndex();
            this.m_selectedBin += step;
            this.m_selectedBin = Math.min(this.m_selectedBin, this.m_profile.binCount() - 1);
            this.m_ignoreNav = true;
            this.m_comboBin.setSelectedIndex(this.m_selectedBin);
            this.m_slider.setValue(this.m_selectedBin + 1);
            this.m_ignoreNav = false;
            this.loadCurrentBin();
            return;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return;
        }
    }

    protected void gotoPrevBin() {
        try {
            int step = 1 + this.m_comboStep.getSelectedIndex();
            this.m_selectedBin -= step;
            this.m_selectedBin = Math.max(this.m_selectedBin, 0);
            this.m_ignoreNav = true;
            this.m_comboBin.setSelectedIndex(this.m_selectedBin);
            this.m_slider.setValue(this.m_selectedBin + 1);
            this.m_ignoreNav = false;
            this.loadCurrentBin();
            return;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.m_btnClearAllPicks == e.getSource()) {
                for (int b = 0; b < this.m_profile.binCount(); ++b) {
                    VelocityLocation loc = this.getVelocityLocation(b);
                    loc.removeAllPicks();
                    this.m_profile.semblanceProfileVelocityCollection().save();
                }
                this.loadCurrentBin();
            }
            if (this.m_profile.binCount() >= 1 && e.getSource() == this.m_btnMoveRightAndPick) {
                if (this.moveRightAndPick()) {
                    this.gotoNextBin();
                }
                return;
            }
            if (this.m_profile.binCount() >= 1 && e.getSource() == this.m_btnPrev) {
                this.gotoPrevBin();
            }
            if (this.m_profile.binCount() >= 1 && e.getSource() == this.m_btnNext) {
                this.gotoNextBin();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadSemblanceUEC() {
        try {
            this.m_semblanceWidget.clearEventConsumerList();
            this.m_semblanceWidget.addEventConsumer(this.m_mouseMoveUEC);
            this.m_semblanceWidget.addEventConsumer(this.m_leftClickUEC);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearAndLoadPaintables() {
        try {
            this.m_semblanceWidget.clearPaintableList();
            this.m_gatherWidget.clearPaintableList();
            if (this.m_wigglePainter.ensemble() != null) {
                this.m_gatherWidget.addPaintable(this.m_wigglePainter, -9999);
                this.m_gatherWidget.addPaintable(this.m_moveoutOverlay, -9999);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void unzoom() {
    }

    public void setEnsemble(Ensemble e) {
        try {
            this.m_ensemble = e;
            if (this.m_ensemble == null) {
                this.m_semblanceWidget.clearPaintableList();
                this.m_gatherWidget.clearPaintableList();
                this.m_semblanceWidget.forceImageRepaint();
                this.m_gatherWidget.forceImageRepaint();
                this.m_semblanceWidget.repaint();
                this.m_gatherWidget.repaint();
                return;
            }
            if (this.m_ensemble != null) {
                this.m_stackGizmo.insertEnsemble(this.m_ensemble, false);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_leftClickUEC) {
                VelocityLocation loc = this.getVelocityLocation();
                if (loc == null) {
                    return;
                }
                if (this.m_leftClickUEC.ControlDown) {
                    loc.deletePick_SemblancePlot(this.m_leftClickUEC.PixelY);
                } else {
                    loc.addPick_SemblancePlot(this.m_leftClickUEC.PixelX, this.m_leftClickUEC.PixelY);
                }
                this.m_semblanceWidget.repaint();
                this.m_profile.semblanceProfileVelocityCollection().save();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void horizontalColorMapCompositeChanged(Object sender) {
        try {
            this.m_semblanceWidget.forceImageRepaint();
            this.m_semblanceWidget.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleJava2DWidgetPaintEvent(Java2D_Widget widget, boolean imagePainted) {
        try {
            if (widget == this.m_semblanceWidget) {
                this.m_semblanceAxis.setRange(this.m_semblanceWidget.transform().actualLeft(), this.m_semblanceWidget.transform().actualRight());
                this.m_timeAxis.setRange(this.m_semblanceWidget.transform().actualTop(), this.m_semblanceWidget.transform().actualBottom());
                this.m_horizontalColorWidget.repaint();
                return;
            }
            if (widget == this.m_gatherWidget) {
                this.m_gatherAxis.setRange(this.m_gatherWidget.transform().actualLeft(), this.m_gatherWidget.transform().actualRight());
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void placeWidgets() {
        try {
            int width = this.m_mainPanel.getSize().width;
            int height = this.m_mainPanel.getSize().height;
            int horzAxisHeight = 34;
            int vertAxisWidth = 54;
            int scrollWidth = 18;
            int scrollHeight = 18;
            int horzColorHeight = 80;
            int weightSemb = 2;
            int weightGather = 0;
            if (this.m_chkShowGather.isSelected()) {
                weightGather = 3;
            }
            int totalWeight = weightGather + weightSemb;
            int buffer = 8;
            int totalPixels = width - vertAxisWidth - 2 * buffer;
            if (totalPixels < 100) {
                return;
            }
            int mainHeight = height - horzAxisHeight - horzColorHeight;
            if (mainHeight < 10) {
                return;
            }
            int left = 0;
            this.m_timeAxis.setBounds(left, horzAxisHeight, vertAxisWidth, mainHeight);
            int pixForSemb = (int)((double)totalPixels * (double)weightSemb / (double)totalWeight);
            this.m_semblanceAxis.setBounds(left += vertAxisWidth, 0, pixForSemb, horzAxisHeight);
            this.m_semblanceWidget.setBounds(left, horzAxisHeight, pixForSemb, mainHeight);
            this.m_horizontalColorWidget.setBounds(left, height - horzColorHeight, pixForSemb, horzColorHeight);
            left = left + pixForSemb + buffer;
            int pixForGather = (int)((double)totalPixels * (double)weightGather / (double)totalWeight);
            this.m_gatherAxis.setVisible(this.m_chkShowGather.isSelected());
            this.m_gatherWidget.setVisible(this.m_chkShowGather.isSelected());
            if (this.m_chkShowGather.isSelected()) {
                this.m_gatherAxis.setBounds(left, 0, pixForGather, horzAxisHeight);
                this.m_gatherWidget.setBounds(left, horzAxisHeight, pixForGather, mainHeight);
                left = left + pixForGather + buffer;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        try {
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

