/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.LWRS;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.QC.Action_ComputeProfileSemblance;
import com.PecosLibrary.Math.RectangularGrid;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Seismic.SeismicProfile;
import com.PecosLibrary.Tools.Tools_Math;
import com.PecosLibrary.Windows.Java2D.Java2D_VerticalStackWidget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_PaintablePointArray;
import com.PecosLibrary.Windows.LWRS.LwrsWidget;
import com.PecosLibrary.Windows.Shared.MultiTextDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class LwrsHvaWidget
extends LinearLayoutWidget
implements ActionListener,
Messenger.Listener {
    protected LwrsWidget.SharedData m_sharedData;
    protected JButton m_btnRecompute;
    protected JProgressBar m_progress = new JProgressBar();
    protected JLabel m_label = new JLabel("");
    protected SeismicProfile m_profile;
    protected EnsembleWorker_Sequence m_sequence;
    protected Java2D_VerticalStackWidget m_widget;
    protected Action_ComputeProfileSemblance m_action = new Action_ComputeProfileSemblance();
    protected boolean m_timeValid = false;
    protected double[] m_pickTime;
    protected boolean m_velValid = false;
    protected double[] m_pickVel;
    protected MultiTextDialog m_dlg;

    public LwrsHvaWidget(LwrsWidget.SharedData sharedData, GenericObjectListener.Listener listener, EnsembleWorker_Sequence sequence) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_sharedData = sharedData;
            this.m_sequence = sequence;
            LinearLayoutWidget top = this.createHorizontal(3, null, 0);
            this.m_btnRecompute = top.createButton("Compute", this, 0);
            top.addComponent(this.m_progress, 10);
            top.addComponent(this.m_label, 10);
            this.m_widget = new Java2D_VerticalStackWidget(3);
            this.m_widget.setColorVisible(0, false);
            this.m_widget.setColorVisible(1, false);
            this.m_widget.setSectionWeight(2, 2.0);
            this.addComponent(this.m_widget, 10);
            Messenger.singleton().addListener(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.HvaComputed && sender == this.m_action) {
                float[][] hva = this.m_action.hva();
                double minVel = this.m_action.m_semblance.minVel();
                double maxVel = this.m_action.m_semblance.maxVel();
                int numVel = this.m_action.m_semblance.numVels();
                double dv = (maxVel - minVel) / (double)(numVel - 1);
                int numBins = hva.length;
                RectangularGrid grid = new RectangularGrid(hva);
                grid.setOrigin(0.0, minVel);
                grid.setSize(1.0, dv);
                this.m_widget.mainWidget(2).addPaintable(grid, 1000);
                this.m_widget.unzoom();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setSeismicProfile(SeismicProfile profile) {
        try {
            this.m_profile = profile;
            this.m_widget.clear();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepTime() {
        try {
            this.m_timeValid = false;
            this.m_velValid = false;
            if (this.m_profile == null) {
                return;
            }
            Ensemble e = this.m_sharedData.StackEnsemble;
            if (e == null) {
                return;
            }
            int minValidIndex = Integer.MAX_VALUE;
            int maxValidIndex = Integer.MIN_VALUE;
            this.m_pickTime = new double[e.traceCount()];
            int indexPick = e.dictionary().getEntryIndex("Trace", "FBP_User");
            for (int n = 0; n < e.traceCount(); ++n) {
                this.m_pickTime[n] = e.trace(n).header().getFloat(indexPick);
            }
            if (!Tools_Math.singleton().interpolateArray(this.m_pickTime, 0.0, 200000.0)) {
                return;
            }
            this.m_timeValid = true;
            Java2D_PaintablePointArray pa = new Java2D_PaintablePointArray();
            pa.setLength(this.m_pickTime.length);
            for (int n = 0; n < e.traceCount(); ++n) {
                pa.setX(n, n);
                pa.setY(n, this.m_pickTime[n]);
            }
            pa.UseColorScale = false;
            this.m_widget.mainWidget(0).addPaintable(pa, 1000);
            this.m_widget.unzoom();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void compute() {
        try {
            this.m_widget.clear();
            this.prepTime();
            if (!this.m_timeValid) {
                return;
            }
            if (this.m_dlg == null) {
                this.m_dlg = new MultiTextDialog(null, "HVA parameters", "Min velocity", "Max velocity", "Min offset", "Max offset", "Stretch mute");
                this.m_dlg.setText(0, "3000");
                this.m_dlg.setText(1, "9000");
                this.m_dlg.setText(2, "0");
                this.m_dlg.setText(3, "20000");
                this.m_dlg.setText(4, "25");
            }
            this.m_dlg.showDialog();
            if (!this.m_dlg.OK) {
                return;
            }
            double minv = this.m_dlg.getDouble(0, 3000.0, 500.0, 15000.0);
            double maxv = this.m_dlg.getDouble(1, minv + 1000.0, minv + 10.0, minv + 20000.0);
            double minoff = this.m_dlg.getDouble(2, 0.0, 0.0, 15000.0);
            double maxoff = this.m_dlg.getDouble(3, minoff + 1000.0, minoff + 10.0, minoff + 20000.0);
            double mute = this.m_dlg.getDouble(4, 25.0, 5.0, 50.0);
            this.m_action.m_semblance.ExtraWaveletShaping = false;
            this.m_action.ExtractHVA = true;
            this.m_action.SaveInProfileVolume = false;
            this.m_action.m_profile = this.m_profile;
            this.m_action.HvaTimes = this.m_pickTime;
            this.m_action.m_semblance.setOffsetRange(minoff, maxoff);
            this.m_action.m_semblance.setVelocityRange(minv, maxv);
            this.m_action.m_semblance.setNumVelocities(100);
            this.m_action.m_semblance.setTimeRange(0.0, 3000.0);
            this.m_action.m_semblance.setDigi(8.0);
            this.m_action.m_semblance.setStretchMutePercent(mute);
            this.m_sequence.getParametersFromWidgets();
            this.m_action.m_sequence = this.m_sequence;
            RefractionStaticsProject.singleton().executeSingleAction(this.m_action);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnRecompute) {
                this.compute();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

