/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JavaSeis;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Seismic.JavaSeis.JavaSeisWrapper;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Shared.FileWidget;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.javaseis.grid.GridDefinition;
import org.javaseis.io.Seisio;
import org.javaseis.properties.AxisDefinition;
import org.javaseis.properties.DataDefinition;
import org.javaseis.properties.PropertyDescription;
import org.javaseis.properties.TraceProperties;

public class JavaSeisViewerWidget
extends JTabbedPane
implements ItemListener,
GenericObjectListener.Listener,
ISaveableFrame {
    protected FileWidget m_fileWidget;
    protected JTable m_tracePropsTable = new JTable();
    protected JTable m_gridTable = new JTable();
    protected JTable m_gridAxisTable = new JTable();
    protected JTable m_headerTable = new JTable();
    protected JLabel m_lblHyperCube = new JLabel("HC", 4);
    protected JLabel m_lblVolume = new JLabel("HC", 4);
    protected JLabel m_lblFrame = new JLabel("HC", 4);
    protected JComboBox<String> m_cmbHyperCube = new JComboBox();
    protected JComboBox<String> m_cmbVolume = new JComboBox();
    protected JComboBox<String> m_cmbFrame = new JComboBox();
    protected JavaSeisWrapper m_wrapper = new JavaSeisWrapper();
    protected boolean m_ignoreCombo = true;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.JavaSeis.JavaSeisViewerWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "JavaSeis";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "JavaSeis";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public JavaSeisViewerWidget() {
        try {
            this.addTab("File selection", this.createFileWidget());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createFileWidget() {
        try {
            JSplitPane topSplitter = new JSplitPane(1);
            LinearLayoutWidget left = LinearLayoutWidget.vert(0, null);
            topSplitter.setLeftComponent(left);
            this.m_fileWidget = new FileWidget(true, false, 0, "Select JavaSeis path", this);
            left.addComponent(this.m_fileWidget, 0);
            JTabbedPane tabs = new JTabbedPane();
            left.addComponent(tabs, 10);
            tabs.addTab("Grid, data definition", this.createGridDefWidget());
            tabs.addTab("Trace properties", new JScrollPane(this.m_tracePropsTable));
            topSplitter.setRightComponent(this.createHeaderWidget());
            return topSplitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createHeaderWidget() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(5, null);
            LinearLayoutWidget top = main.createHorizontal(3, null, 0);
            LinearLayoutWidget sub = top.createHorizontal(3, "Hypercube", 10);
            sub.addComponent(this.m_lblHyperCube, 0);
            sub.addComponent(this.m_cmbHyperCube, 4);
            sub = top.createHorizontal(3, "Volume", 10);
            sub.addComponent(this.m_lblVolume, 0);
            sub.addComponent(this.m_cmbVolume, 4);
            sub = top.createHorizontal(3, "Frame", 10);
            sub.addComponent(this.m_lblFrame, 0);
            sub.addComponent(this.m_cmbFrame, 4);
            this.m_cmbHyperCube.addItemListener(this);
            this.m_cmbVolume.addItemListener(this);
            this.m_cmbFrame.addItemListener(this);
            main.addComponent(new JScrollPane(this.m_headerTable), 10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createGridDefWidget() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(5, null);
            main.addComponent(new JScrollPane(this.m_gridTable), 10);
            main.addComponent(new JScrollPane(this.m_gridAxisTable), 10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void handleNewFile() {
        try {
            String s;
            double physical;
            long logical;
            long n;
            int n2;
            int row;
            this.clearAll();
            if (!Seisio.isJavaSeis(this.m_fileWidget.getText())) {
                return;
            }
            Seisio sio = new Seisio(this.m_fileWidget.getText());
            sio.open("r");
            GridDefinition gridDef = sio.getGridDefinition();
            DataDefinition dataDef = sio.getDataDefinition();
            long numDim = gridDef.getNumDimensions();
            Table_Memory table = new Table_Memory();
            int index1 = ((Table_Abstract)table).column_append("Variable", DataType.Text);
            int index2 = ((Table_Abstract)table).column_append("Value", DataType.Text);
            if (numDim >= 4L) {
                row = ((Table_Abstract)table).row_increment();
                ((Table_Abstract)table).putString(row, index1, "NumVolumesPerHypercube");
                ((Table_Abstract)table).putString(row, index2, Long.toString(gridDef.getNumVolumesPerHypercube()));
            }
            row = ((Table_Abstract)table).row_increment();
            ((Table_Abstract)table).putString(row, index1, "NumFramesPerVolume");
            ((Table_Abstract)table).putString(row, index2, Long.toString(gridDef.getNumFramesPerVolume()));
            row = ((Table_Abstract)table).row_increment();
            ((Table_Abstract)table).putString(row, index1, "NumTracesPerFrame");
            ((Table_Abstract)table).putString(row, index2, Long.toString(gridDef.getNumTracesPerFrame()));
            row = ((Table_Abstract)table).row_increment();
            ((Table_Abstract)table).putString(row, index1, "NumSamplesPerTrace");
            ((Table_Abstract)table).putString(row, index2, Long.toString(gridDef.getNumSamplesPerTrace()));
            row = ((Table_Abstract)table).row_increment();
            ((Table_Abstract)table).putString(row, index1, "NumDimensions");
            ((Table_Abstract)table).putString(row, index2, Long.toString(gridDef.getNumDimensions()));
            row = ((Table_Abstract)table).row_increment();
            ((Table_Abstract)table).putString(row, index1, "ByteOrder");
            ((Table_Abstract)table).putString(row, index2, dataDef.getByteOrderString());
            row = ((Table_Abstract)table).row_increment();
            ((Table_Abstract)table).putString(row, index1, "DataType");
            ((Table_Abstract)table).putString(row, index2, dataDef.getDataTypeString());
            row = ((Table_Abstract)table).row_increment();
            ((Table_Abstract)table).putString(row, index1, "TraceFormat");
            ((Table_Abstract)table).putString(row, index2, dataDef.getTraceFormatString());
            this.m_gridTable.setModel(new Table_SimpleModel(table));
            table = new Table_Memory();
            index1 = ((Table_Abstract)table).column_append("Variable", DataType.Text);
            int[] indexAxis = new int[(int)numDim];
            for (n2 = 0; n2 < (int)numDim; ++n2) {
                indexAxis[n2] = ((Table_Abstract)table).column_append("Axis " + Integer.toString(n2), DataType.Text);
            }
            row = ((Table_Abstract)table).row_increment();
            ((Table_Abstract)table).putString(row, index1, "AxisDomain");
            for (n2 = 0; n2 < (int)numDim; ++n2) {
                ((Table_Abstract)table).putString(row, indexAxis[n2], gridDef.getAxisDomainString(n2));
            }
            row = ((Table_Abstract)table).row_increment();
            ((Table_Abstract)table).putString(row, index1, "AxisLabel");
            for (n2 = 0; n2 < (int)numDim; ++n2) {
                ((Table_Abstract)table).putString(row, indexAxis[n2], gridDef.getAxisLabelString(n2));
            }
            row = ((Table_Abstract)table).row_increment();
            ((Table_Abstract)table).putString(row, index1, "AxisUnits");
            for (n2 = 0; n2 < (int)numDim; ++n2) {
                ((Table_Abstract)table).putString(row, indexAxis[n2], gridDef.getAxisUnitsString(n2));
            }
            row = ((Table_Abstract)table).row_increment();
            ((Table_Abstract)table).putString(row, index1, "AxisLength");
            for (n2 = 0; n2 < (int)numDim; ++n2) {
                ((Table_Abstract)table).putString(row, indexAxis[n2], Long.toString(gridDef.getAxisLength(n2)));
            }
            row = ((Table_Abstract)table).row_increment();
            ((Table_Abstract)table).putString(row, index1, "LogicalDelta");
            for (n2 = 0; n2 < (int)numDim; ++n2) {
                ((Table_Abstract)table).putString(row, indexAxis[n2], Long.toString(gridDef.getAxisLogicalDelta(n2)));
            }
            row = ((Table_Abstract)table).row_increment();
            ((Table_Abstract)table).putString(row, index1, "LogicalOrigin");
            for (n2 = 0; n2 < (int)numDim; ++n2) {
                ((Table_Abstract)table).putString(row, indexAxis[n2], Long.toString(gridDef.getAxisLogicalOrigin(n2)));
            }
            row = ((Table_Abstract)table).row_increment();
            ((Table_Abstract)table).putString(row, index1, "PhysicalDelta");
            for (n2 = 0; n2 < (int)numDim; ++n2) {
                ((Table_Abstract)table).putString(row, indexAxis[n2], Double.toString(gridDef.getAxisPhysicalDelta(n2)));
            }
            row = ((Table_Abstract)table).row_increment();
            ((Table_Abstract)table).putString(row, index1, "PhysicalOrigin");
            for (n2 = 0; n2 < (int)numDim; ++n2) {
                ((Table_Abstract)table).putString(row, indexAxis[n2], Double.toString(gridDef.getAxisPhysicalOrigin(n2)));
            }
            this.m_gridAxisTable.setModel(new Table_SimpleModel(table));
            this.m_ignoreCombo = true;
            this.m_cmbHyperCube.removeAllItems();
            this.m_cmbVolume.removeAllItems();
            this.m_cmbFrame.removeAllItems();
            if (numDim < 5L) {
                this.m_lblHyperCube.setText("Not valid!");
                this.m_cmbHyperCube.setEnabled(false);
            } else {
                AxisDefinition axis = gridDef.getAxis(4);
                for (n = 0L; n < axis.getLength(); ++n) {
                    logical = axis.getLogicalOrigin() + n * axis.getLogicalDelta();
                    physical = axis.getPhysicalOrigin() + (double)n * axis.getPhysicalDelta();
                    s = String.format("%d (%.2f)", (int)logical, Float.valueOf((float)physical));
                    this.m_cmbHyperCube.addItem(s);
                }
                this.m_cmbHyperCube.setSelectedIndex(0);
                this.m_lblHyperCube.setText(gridDef.getAxisLabelString(4));
                this.m_cmbHyperCube.setEnabled(true);
            }
            if (numDim < 4L) {
                this.m_lblVolume.setText("Not valid!");
                this.m_cmbVolume.setEnabled(false);
            } else {
                AxisDefinition axis = gridDef.getAxis(3);
                for (n = 0L; n < axis.getLength(); ++n) {
                    logical = axis.getLogicalOrigin() + n * axis.getLogicalDelta();
                    physical = axis.getPhysicalOrigin() + (double)n * axis.getPhysicalDelta();
                    s = String.format("%d (%.2f)", (int)logical, Float.valueOf((float)physical));
                    this.m_cmbVolume.addItem(s);
                }
                this.m_cmbVolume.setSelectedIndex(0);
                this.m_lblVolume.setText(gridDef.getAxisLabelString(3));
                this.m_cmbVolume.setEnabled(true);
            }
            if (numDim < 3L) {
                this.m_lblFrame.setText("Not valid!");
                this.m_cmbFrame.setEnabled(false);
            } else {
                AxisDefinition axis = gridDef.getAxis(2);
                for (n = 0L; n < axis.getLength(); ++n) {
                    logical = axis.getLogicalOrigin() + n * axis.getLogicalDelta();
                    physical = axis.getPhysicalOrigin() + (double)n * axis.getPhysicalDelta();
                    s = String.format("%d (%.2f)", (int)logical, Float.valueOf((float)physical));
                    this.m_cmbFrame.addItem(s);
                }
                this.m_cmbFrame.setSelectedIndex(0);
                this.m_lblFrame.setText(gridDef.getAxisLabelString(2));
                this.m_cmbFrame.setEnabled(true);
            }
            this.m_ignoreCombo = false;
            TraceProperties tp = sio.getTraceProperties();
            PropertyDescription[] pd = tp.getTraceProperties();
            table = new Table_Memory();
            index1 = ((Table_Abstract)table).column_append("Count", DataType.Text);
            index2 = ((Table_Abstract)table).column_append("Description", DataType.Text);
            int index3 = ((Table_Abstract)table).column_append("Format", DataType.Text);
            int index4 = ((Table_Abstract)table).column_append("Label", DataType.Text);
            int index5 = ((Table_Abstract)table).column_append("Offset", DataType.Text);
            for (int n3 = 0; n3 < pd.length; ++n3) {
                row = ((Table_Abstract)table).row_increment();
                ((Table_Abstract)table).putInt(row, index1, pd[n3].getCount());
                ((Table_Abstract)table).putString(row, index2, pd[n3].getDescription());
                ((Table_Abstract)table).putString(row, index3, pd[n3].getFormatString());
                ((Table_Abstract)table).putString(row, index4, pd[n3].getLabel());
                ((Table_Abstract)table).putInt(row, index5, pd[n3].getOffset());
            }
            this.m_tracePropsTable.setModel(new Table_SimpleModel(table));
            sio.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadRawHeaders() {
        try {
            this.m_headerTable.setModel(new DefaultTableModel());
            this.m_wrapper.setJavaSeisPath(this.m_fileWidget.getText());
            if (!this.m_wrapper.valid()) {
                return;
            }
            if (this.m_wrapper.numDimensions() == 5) {
                int cube = this.m_cmbHyperCube.getSelectedIndex();
                int vol = this.m_cmbVolume.getSelectedIndex();
                int frame = this.m_cmbFrame.getSelectedIndex();
                this.m_wrapper.load_Cube_Volume_Frame(cube, vol, frame);
                this.m_headerTable.setModel(new Table_SimpleModel(this.m_wrapper.rawHeaderTable()));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (this.m_ignoreCombo) {
                return;
            }
            this.loadRawHeaders();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void clearAll() {
        try {
            this.m_gridTable.setModel(new DefaultTableModel());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_fileWidget) {
                this.handleNewFile();
                this.loadRawHeaders();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

