/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.UserEventHandler;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumerBase;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventDataWrapper;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventOrigin;
import com.PecosLibrary.Windows.Refraction.DelayTime.BranchColors;
import java.awt.Graphics2D;

public class Java2D_UserEventConsumer_Picker
extends Java2D_UserEventConsumerBase {
    public boolean ApplyLMO = false;
    public double VelLMO = 100.0;
    public int Refractor = 1;
    public boolean Dragging = false;
    public boolean BroadcastWhenDragging = true;
    public int MouseButton = 1;
    public int StartPixelX;
    public int StartPixelY;
    public int EndPixelX;
    public int EndPixelY;
    public double StartWorldX;
    public double StartWorldY;
    public double EndWorldX;
    public double EndWorldY;
    public double MinOff;
    public double MaxOff;
    public double MinTime;
    public double MaxTime;
    public boolean StuffOK = false;
    public double Velocity = 0.0;
    public double DelayTime = 0.0;

    protected void computeStuff() {
        try {
            this.StuffOK = false;
            if (this.StartPixelX <= this.EndPixelX) {
                this.MinOff = this.StartWorldX;
                this.MaxOff = this.EndWorldX;
                this.MinTime = this.StartWorldY;
                this.MaxTime = this.EndWorldY;
            } else {
                this.MaxOff = this.StartWorldX;
                this.MinOff = this.EndWorldX;
                this.MaxTime = this.StartWorldY;
                this.MinTime = this.EndWorldY;
            }
            if (this.ApplyLMO) {
                this.MinTime += 1000.0 * this.MinOff / this.VelLMO;
                this.MaxTime += 1000.0 * this.MaxOff / this.VelLMO;
            }
            if (Math.abs(this.EndPixelX - this.StartPixelX) < 4) {
                return;
            }
            if (Math.abs(this.MaxTime - this.MinTime) < 1.0E-6) {
                return;
            }
            this.Velocity = 1000.0 * (this.MaxOff - this.MinOff) / (this.MaxTime - this.MinTime);
            this.DelayTime = 0.5 * (this.MinTime - 1000.0 * this.MinOff / this.Velocity);
            this.StuffOK = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.StuffOK = false;
        }
    }

    @Override
    public void handleUserEvent(Java2D_UserEventDataWrapper eventData) {
        try {
            if (!this.Dragging) {
                this.NeedsToBePainted = false;
                if (eventData.UserEventOrigin != Java2D_UserEventOrigin.MousePressed) {
                    return;
                }
                if (eventData.InputMouseEvent.getButton() != this.MouseButton) {
                    return;
                }
                this.StartPixelX = eventData.PixelX;
                this.StartPixelY = eventData.PixelY;
                this.StartWorldX = eventData.Transform.getWorldFromPixel_X(this.StartPixelX);
                this.StartWorldY = eventData.Transform.getWorldFromPixel_Y(this.StartPixelY);
                this.EndPixelY = eventData.PixelY;
                this.EndPixelX = eventData.PixelX;
                this.EndWorldX = eventData.Transform.getWorldFromPixel_X(this.EndPixelX);
                this.EndWorldY = eventData.Transform.getWorldFromPixel_Y(this.EndPixelY);
                this.Dragging = true;
                this.computeStuff();
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseDragged) {
                this.NeedsToBePainted = true;
                this.EndPixelY = eventData.PixelY;
                this.EndPixelX = eventData.PixelX;
                this.EndWorldX = eventData.Transform.getWorldFromPixel_X(this.EndPixelX);
                this.EndWorldY = eventData.Transform.getWorldFromPixel_Y(this.EndPixelY);
                this.computeStuff();
                if (this.BroadcastWhenDragging) {
                    this.broadcast(this, null);
                }
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseReleased) {
                this.NeedsToBePainted = false;
                this.Dragging = false;
                this.EndPixelY = eventData.PixelY;
                this.EndPixelX = eventData.PixelX;
                this.EndWorldX = eventData.Transform.getWorldFromPixel_X(this.EndPixelX);
                this.EndWorldY = eventData.Transform.getWorldFromPixel_Y(this.EndPixelY);
                this.computeStuff();
                this.broadcast(this, null);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void paint(Java2D_PaintParameter paintParameter) {
        try {
            if (!this.Dragging) {
                return;
            }
            this.computeStuff();
            Graphics2D g2d = paintParameter.G2D;
            g2d.setColor(BranchColors.solidColor(this.Refractor));
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            g2d.drawLine(this.EndPixelX, this.EndPixelY, this.StartPixelX, this.StartPixelY);
            if (this.StuffOK) {
                int midX = 40 + (this.EndPixelX + this.StartPixelX) / 2;
                int midY = -40 + (this.EndPixelY + this.StartPixelY) / 2;
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
                String s = String.format("V=%d  DT=%d", (int)this.Velocity, (int)(0.5 + this.DelayTime));
                g2d.drawString(s, midX, midY);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleImageJustPainted() {
        try {
            this.Dragging = false;
            this.NeedsToBePainted = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

