/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.UserEventHandler;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumerBase;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventDataWrapper;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventOrigin;

public class Java2D_UserEventConsumer_KeyPressed
extends Java2D_UserEventConsumerBase {
    public int PixelX;
    public int PixelY;
    public double WorldX;
    public double WorldY;
    public boolean ShiftDown;
    public boolean AltDown;
    public boolean ControlDown;
    public boolean EscapePressed;
    public char KeyChar;
    public int KeyCode;
    protected PickerMode m_pickerMode;

    @Override
    public void handleUserEvent(Java2D_UserEventDataWrapper eventData) {
        try {
            this.ShiftDown = eventData.IsShiftDown;
            this.AltDown = eventData.IsAltDown;
            this.ControlDown = eventData.IsControlDown;
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseMoved) {
                this.PixelX = eventData.PixelX;
                this.PixelY = eventData.PixelY;
                this.WorldX = eventData.Transform.getWorldFromPixel_X(this.PixelX);
                this.WorldY = eventData.Transform.getWorldFromPixel_Y(this.PixelY);
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.KeyPressed) {
                this.KeyChar = eventData.InputKeyEvent.getKeyChar();
                this.KeyCode = eventData.InputKeyEvent.getKeyCode();
                this.EscapePressed = this.KeyCode == 27;
                this.broadcast(this, null);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void paint(Java2D_PaintParameter paintParameter) {
    }

    @Override
    public void handleImageJustPainted() {
    }

    public boolean pickerModeIsStack() {
        return this.m_pickerMode == PickerMode.Stack;
    }

    public boolean pickerModeIsTrace() {
        return this.m_pickerMode == PickerMode.Trace;
    }

    public static enum PickerMode {
        Trace,
        Stack;

    }
}

