/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.UserEventHandler;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Refraction.GLI.GliInteractiveModel_SingleLocation;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumerBase;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventDataWrapper;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventOrigin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class Java2D_UserEventConsumer_GliInteractiveModel
extends Java2D_UserEventConsumerBase {
    public boolean IsMouseMoveEvent = false;
    public boolean IsFinalClickEvent = false;
    public boolean ApplyLMO = false;
    public boolean DrawRectangle = false;
    public double VelocityLMO = 5000.0;
    public Color LineColorOK = Color.BLUE;
    public Color LineColorBad = Color.RED;
    public Stroke LineStroke = new BasicStroke(4.0f);
    protected double[] m_offset = new double[200];
    protected double[] m_time = new double[200];
    protected double[] m_velocity = new double[200];
    protected double m_currentOffset = 0.0;
    protected double m_currentTime = 0.0;
    protected double m_currentVelocity = 0.0;
    protected boolean m_currentValid = false;
    protected String m_reasonNotValid = "";
    protected int m_pointCount = 0;

    public double currentVelocity() {
        return this.m_currentVelocity;
    }

    public boolean currentValid() {
        return this.m_currentValid;
    }

    public String reasonNotValid() {
        return this.m_reasonNotValid;
    }

    public int pointCount() {
        return this.m_pointCount;
    }

    public void prepGliModel(GliInteractiveModel_SingleLocation model, boolean addCurrent) {
        try {
            model.clearPicks();
            for (int n = 0; n < this.m_pointCount; ++n) {
                model.addPick(this.m_offset[n], this.m_time[n]);
            }
            if (addCurrent) {
                model.addPick(this.m_currentOffset, this.m_currentTime);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleMouseMove() {
        try {
            this.m_currentValid = false;
            if (this.m_pointCount == 0) {
                if (this.m_currentTime < 1.0 || this.m_currentOffset < 1.0) {
                    this.m_reasonNotValid = "Time and offset must be greater than zero";
                    return;
                }
                this.m_currentVelocity = 1000.0 * (this.m_currentOffset / this.m_currentTime);
                this.m_currentValid = true;
                return;
            }
            double doffset = this.m_currentOffset - this.m_offset[this.m_pointCount - 1];
            double dtime = this.m_currentTime - this.m_time[this.m_pointCount - 1];
            if (doffset < 1.0 || dtime < 1.0) {
                this.m_reasonNotValid = "Offset and time must increase";
                return;
            }
            this.m_currentVelocity = 1000.0 * (this.m_currentOffset / this.m_currentTime);
            if (this.m_currentVelocity <= (double)1.001f * this.m_velocity[this.m_pointCount - 1]) {
                this.m_reasonNotValid = "Velocity must increase";
                return;
            }
            this.m_currentValid = true;
            this.m_offset[this.m_pointCount] = this.m_currentOffset;
            this.m_time[this.m_pointCount] = this.m_currentTime;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void paintLine(Java2D_PaintParameter paintParameter, double startOffset, double startTime, double endOffset, double endTime, boolean extrapolate) {
        try {
            Graphics2D g2d = paintParameter.G2D;
            Java2D_Transform transform = paintParameter.Transform;
            double scaleX = transform.scaleX();
            double scaleY = transform.scaleY();
            double shiftX = transform.shiftX();
            double shiftY = transform.shiftY();
            if (this.ApplyLMO) {
                startTime -= 1000.0 * (startOffset / this.VelocityLMO);
                endTime -= 1000.0 * (endOffset / this.VelocityLMO);
            }
            int pixelStartX = (int)(startOffset * scaleX + shiftX);
            int pixelStartY = (int)(startTime * scaleY + shiftY);
            int pixelEndX = (int)(endOffset * scaleX + shiftX);
            int pixelEndY = (int)(endTime * scaleY + shiftY);
            if (!extrapolate) {
                g2d.drawLine(pixelStartX, pixelStartY, pixelEndX, pixelEndY);
                return;
            }
            double dx = pixelEndX - pixelStartX;
            double dy = pixelEndY - pixelStartY;
            if (Math.abs(dx) < 4.0 && Math.abs(dy) < 4.0) {
                return;
            }
            double scalar = 300.0;
            pixelEndX = pixelStartX + (int)(scalar * dx);
            pixelEndY = pixelStartY + (int)(scalar * dy);
            g2d.drawLine(pixelStartX, pixelStartY, pixelEndX, pixelEndY);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleImageJustPainted() {
        try {
            this.NeedsToBePainted = false;
            this.m_pointCount = 0;
            System.out.println("Current Time: " + this.m_currentTime);
            System.out.println("Current Offset: " + this.m_currentOffset);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void paint(Java2D_PaintParameter paintParameter) {
        try {
            Graphics2D g2d = paintParameter.G2D;
            if (this.m_currentValid) {
                g2d.setColor(this.LineColorOK);
            } else {
                g2d.setColor(this.LineColorBad);
            }
            g2d.setStroke(this.LineStroke);
            if (this.m_pointCount < 1) {
                this.paintLine(paintParameter, 0.0, 0.0, this.m_currentOffset, this.m_currentTime, false);
                return;
            }
            this.paintLine(paintParameter, 0.0, 0.0, this.m_offset[0], this.m_time[0], false);
            for (int n = 1; n < this.m_pointCount; ++n) {
                this.paintLine(paintParameter, this.m_offset[n - 1], this.m_time[n - 1], this.m_offset[n], this.m_time[n], false);
            }
            this.paintLine(paintParameter, this.m_offset[this.m_pointCount - 1], this.m_time[this.m_pointCount - 1], this.m_currentOffset, this.m_currentTime, false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleUserEvent(Java2D_UserEventDataWrapper eventData) {
        try {
            this.IsMouseMoveEvent = false;
            this.IsFinalClickEvent = false;
            double time = eventData.WorldY;
            double offset = eventData.WorldX;
            if (this.ApplyLMO) {
                time += 1000.0 * (offset / this.VelocityLMO);
            }
            this.NeedsToBePainted = false;
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseMoved) {
                this.m_currentOffset = offset;
                this.m_currentTime = time;
                this.handleMouseMove();
                this.NeedsToBePainted = true;
                this.IsMouseMoveEvent = true;
                this.broadcast(this, null);
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MousePressed) {
                if (this.m_currentValid) {
                    this.m_currentOffset = offset;
                    this.m_currentTime = time;
                    this.m_offset[this.m_pointCount] = offset;
                    this.m_time[this.m_pointCount] = time;
                    ++this.m_pointCount;
                    double doffset = this.m_offset[this.m_pointCount - 1];
                    double dtime = this.m_time[this.m_pointCount - 1];
                    if (this.m_pointCount >= 2) {
                        doffset = this.m_offset[this.m_pointCount - 1] - this.m_offset[this.m_pointCount - 2];
                        dtime = this.m_time[this.m_pointCount - 1] - this.m_time[this.m_pointCount - 2];
                    }
                    this.m_velocity[this.m_pointCount - 1] = 1000.0 * (doffset / dtime);
                    if (this.m_pointCount == RefractionStaticsProject.singleton().gliNewModelLayerCount() + 1) {
                        this.IsFinalClickEvent = true;
                        this.broadcast(this, null);
                        this.m_pointCount = 0;
                    }
                    this.NeedsToBePainted = true;
                }
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

