/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.UserEventHandler;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumerBase;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventDataWrapper;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventOrigin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class Java2D_UserEventConsumer_DragFixedLine
extends Java2D_UserEventConsumerBase {
    public boolean DrawRectangle = false;
    public Color LineColor = Color.BLUE;
    public Stroke LineStroke = new BasicStroke(3.0f);
    public boolean Dragging = false;
    public boolean JustReleased = false;
    public boolean BroadcastWhenDragging = true;
    public int MouseButton = 1;
    public double StartWorldX;
    public double StartWorldY;
    public double EndWorldX;
    public double EndWorldY;
    public boolean Valid = true;

    public void setEnsemble(Ensemble ensemble, String table) {
        try {
            this.Valid = false;
            this.Dragging = false;
            this.JustReleased = false;
            if (ensemble == null) {
                return;
            }
            if (ensemble.traceCount() < 1) {
                return;
            }
            int indexX = ensemble.dictionary().getEntryIndex_ReturnInvalid(table, "Easting");
            int indexY = ensemble.dictionary().getEntryIndex_ReturnInvalid(table, "Northing");
            if (indexX < 0 || indexY < 0) {
                return;
            }
            this.StartWorldX = ensemble.trace(0).header().getDouble(indexX);
            this.StartWorldY = ensemble.trace(0).header().getDouble(indexY);
            this.Valid = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleUserEvent(Java2D_UserEventDataWrapper eventData) {
        try {
            if (!this.Valid) {
                return;
            }
            if (!this.Dragging) {
                this.JustReleased = false;
                this.NeedsToBePainted = false;
                if (eventData.UserEventOrigin != Java2D_UserEventOrigin.MousePressed) {
                    return;
                }
                if (eventData.InputMouseEvent.getButton() != this.MouseButton) {
                    return;
                }
                this.EndWorldX = eventData.WorldX;
                this.EndWorldY = eventData.WorldY;
                this.Dragging = true;
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseDragged) {
                this.NeedsToBePainted = true;
                this.EndWorldX = eventData.WorldX;
                this.EndWorldY = eventData.WorldY;
                if (this.BroadcastWhenDragging) {
                    this.broadcast(this, null);
                }
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseReleased) {
                this.JustReleased = true;
                this.NeedsToBePainted = false;
                this.Dragging = false;
                this.EndWorldX = eventData.WorldX;
                this.EndWorldY = eventData.WorldY;
                this.broadcast(this, null);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void paint(Java2D_PaintParameter paintParameter) {
        try {
            if (!this.Dragging) {
                return;
            }
            double scaleX = paintParameter.Transform.scaleX();
            double shiftX = paintParameter.Transform.shiftX();
            double scaleY = paintParameter.Transform.scaleY();
            double shiftY = paintParameter.Transform.shiftY();
            Graphics2D g2d = paintParameter.G2D;
            g2d.setColor(this.LineColor);
            g2d.setStroke(this.LineStroke);
            int x1 = (int)(scaleX * this.StartWorldX + shiftX);
            int y1 = (int)(scaleY * this.StartWorldY + shiftY);
            int x2 = (int)(scaleX * this.EndWorldX + shiftX);
            int y2 = (int)(scaleY * this.EndWorldY + shiftY);
            g2d.drawLine(x1, y1, x2, y2);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleImageJustPainted() {
        try {
            this.Dragging = false;
            this.NeedsToBePainted = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

