/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;

public class Java2D_Paintable_MoveoutOverlay
implements Java2D_PaintableInterface {
    public double Time0 = 0.0;
    public double Velocity;
    public double StretchMutePercent = 25.0;

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 1;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 1) {
                return;
            }
            if (this.Velocity < 10.0) {
                return;
            }
            if (this.Time0 < 10.0) {
                return;
            }
            if (this.StretchMutePercent < 1.0) {
                return;
            }
            double s = 1.0 + 0.01 * this.StretchMutePercent;
            double maxOff = 0.001 * this.Time0 * this.Velocity * Math.sqrt(s * s - 1.0);
            int numOff = 100;
            double deltaOff = maxOff / (double)(numOff - 1);
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            g2d.setColor(Color.green);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            for (int n = 1; n < numOff; ++n) {
                double x1 = (double)(n - 1) * deltaOff;
                double x2 = (double)n * deltaOff;
                double temp1 = 1000.0 * x1 / this.Velocity;
                double temp2 = 1000.0 * x2 / this.Velocity;
                double t1 = Math.sqrt(this.Time0 * this.Time0 + temp1 * temp1);
                double t2 = Math.sqrt(this.Time0 * this.Time0 + temp2 * temp2);
                int ix1 = (int)(scaleX * x1 + shiftX);
                int iy1 = (int)(scaleY * t1 + shiftY);
                int ix2 = (int)(scaleX * x2 + shiftX);
                int iy2 = (int)(scaleY * t2 + shiftY);
                g2d.drawLine(ix1, iy1, ix2, iy2);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

