/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class Java2D_Paintable_Lines
implements Java2D_PaintableInterface {
    protected ArrayList<Line> m_list = new ArrayList();
    public Color LineColor = new Color(255, 0, 0, 128);
    public BasicStroke LineStroke = new BasicStroke(6.0f);

    public void addLine(double x1, double y1, double x2, double y2) {
        try {
            this.m_list.add(new Line(x1, y1, x2, y2));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearLines() {
        this.m_list.clear();
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(this.LineStroke);
            g2d.setColor(this.LineColor);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            for (Line line : this.m_list) {
                int ix1 = (int)(scaleX * line.X1 + shiftX);
                int iy1 = (int)(scaleY * line.Y1 + shiftY);
                int ix2 = (int)(scaleX * line.X2 + shiftX);
                int iy2 = (int)(scaleY * line.Y2 + shiftY);
                g2d.drawLine(ix1, iy1, ix2, iy2);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            for (Line line : this.m_list) {
                rangeX.expandRange(line.X1);
                rangeX.expandRange(line.X2);
                rangeY.expandRange(line.Y1);
                rangeY.expandRange(line.Y2);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    protected class Line {
        public double X1;
        public double Y1;
        public double X2;
        public double Y2;

        public Line(double x1, double y1, double x2, double y2) {
            this.X1 = x1;
            this.Y1 = y1;
            this.X2 = x2;
            this.Y2 = y2;
        }
    }
}

