/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;

public class Java2D_Paintable_LineSegment
implements Java2D_PaintableInterface {
    public double X1 = -9999999.0;
    public double Y1;
    public double X2;
    public double Y2;
    public boolean Valid = false;
    public boolean Dirty = true;
    public Java2D_PointSymbol Symbol1 = Java2D_PointSymbol.X;
    public Color Color1 = Color.BLUE;
    public int Size1 = 11;
    public Java2D_PointSymbol Symbol2 = Java2D_PointSymbol.HollowOval;
    public Color Color2 = Color.GREEN;
    public int Size2 = 11;
    public boolean DrawSymbols = true;
    public int PaintLevel = 0;
    public Color LineColor = Color.YELLOW;

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        if (!this.Valid) {
            return false;
        }
        return this.Dirty;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return this.PaintLevel;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (!this.Valid) {
                return;
            }
            if (paintParameter.PaintLevel != this.PaintLevel) {
                return;
            }
            System.out.println("Java2D_Paintable_LineSegment Java2D_Paint");
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            int x1 = (int)(this.X1 * scaleX + shiftX);
            int y1 = (int)(this.Y1 * scaleY + shiftY);
            g2d.setColor(this.Color1);
            if (this.DrawSymbols) {
                this.drawSymbol(g2d, this.Symbol1, x1, y1, this.Size1);
            }
            int x2 = (int)(this.X2 * scaleX + shiftX);
            int y2 = (int)(this.Y2 * scaleY + shiftY);
            g2d.setColor(this.Color2);
            if (this.DrawSymbols) {
                this.drawSymbol(g2d, this.Symbol2, x2, y2, this.Size2);
            }
            g2d.setColor(this.LineColor);
            g2d.drawLine(x1, y1, x2, y2);
            this.Dirty = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void drawSymbol(Graphics2D g2d, Java2D_PointSymbol sym, int x, int y, int size) {
        try {
            int w = size / 2;
            if (sym == Java2D_PointSymbol.X) {
                g2d.drawLine(x - w, y - w, x + w, y + w);
                g2d.drawLine(x - w, y + w, x + w, y - w);
            } else if (sym == Java2D_PointSymbol.HollowOval) {
                g2d.drawOval(x - w, y - w, size, size);
            } else {
                g2d.fillRect(x - w, y - w, size, size);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (!this.Valid) {
                return;
            }
            rangeX.expandRange(this.X1);
            rangeY.expandRange(this.Y1);
            rangeX.expandRange(this.X2);
            rangeY.expandRange(this.Y2);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

