/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleFirstBreakPickPlotData;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Refraction.DelayTime.BranchColors;
import java.awt.Color;
import java.awt.Graphics2D;

public class Java2D_Paintable_Ensemble_Wiggles
implements Java2D_PaintableInterface {
    protected Ensemble m_ensemble = null;
    public int NumberOfTracesPainted = 0;
    public boolean ImageContentsDirty = true;
    public int MaxOverlayLevel = 1;
    protected Java2D_EnsembleAxisEnum m_axisType = Java2D_EnsembleAxisEnum.UniformSpacing;
    protected String m_table = "";
    protected String m_column = "";
    public boolean PlotBackgroundColor = false;
    public String BackgroundColorKey = "";
    public double ScaleX;
    public double ShiftX;
    public double ScaleY;
    public double ShiftY;
    public double Left;
    public double Right;
    public double Top;
    public double Bottom;
    public int Height;
    protected Graphics2D m_g2d = null;
    public boolean DrawKilledTraces = false;
    public float WiggleOverlap = 1.1f;
    public float WiggleClipping = 1.1f;
    public boolean ApplyClipping = false;
    public boolean IndividualTraceAmplitudeScaling = true;
    public boolean DisplayBranch = true;
    public boolean DrawOverlappingTraces = true;
    public int PixelOverlapLimit = 5;
    protected byte[] m_pixelUsed = new byte[2000];
    public boolean FillPositiveWiggle = true;
    public Color PositiveColor = Color.BLACK;
    public boolean FillNegativeWiggle = false;
    public Color NegativeColor = Color.RED;
    public boolean DrawReceiverLineColor = true;
    public Color ReceiverLineColor = Color.YELLOW;
    public int MaximumStickLength;
    public int MinimumStickLength;
    protected float[] m_data = new float[3];
    protected double TempScalar;
    protected int MidPixel;
    protected double SampleScaleY;
    protected double SampleShiftY;
    protected double InverseSampleScaleY;
    protected double InverseSampleShiftY;
    public Color[] BackColorArray;
    public boolean DrawMuteZone = false;
    public Color MuteColor = new Color(255, 255, 128, 100);
    protected int[] MuteX = new int[4];
    protected int[] MuteY = new int[4];

    public Java2D_Paintable_Ensemble_Wiggles() {
        try {
            this.BackColorArray = new Color[20];
            for (int n = 0; n < this.BackColorArray.length; ++n) {
                this.BackColorArray[n] = new Color(255, 255, 255);
            }
            this.BackColorArray[0] = new Color(128, 255, 128, 64);
            this.BackColorArray[1] = new Color(255, 128, 255, 192);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setAxisTableColumn(String table, String column) {
        try {
            this.m_table = table;
            this.m_column = column;
            this.clearTracePlotData();
            this.ImageContentsDirty = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setAxisType(Java2D_EnsembleAxisEnum axisType) {
        try {
            this.m_axisType = axisType;
            this.clearTracePlotData();
            this.ImageContentsDirty = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Java2D_EnsembleAxisEnum axisType() {
        return this.m_axisType;
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.ImageContentsDirty;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return this.MaxOverlayLevel;
    }

    protected void paintOverlays(Java2D_PaintParameter paintParameter, Object supplementalData) {
        try {
            EnsembleFirstBreakPickPlotData pickPlotData = this.m_ensemble.pickPlotData();
            this.m_g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            for (int k = 0; k < pickPlotData.size(); ++k) {
                EnsembleFirstBreakPickPlotData.Entry entry = pickPlotData.getEntry(k);
                if (!this.m_ensemble.dictionary().containsEntry("Trace", entry.Column)) continue;
                this.m_g2d.setColor(entry.PickColor);
                int w = entry.SymbolSize;
                int w2 = w / 2;
                int index = this.m_ensemble.dictionary().getEntryIndex("Trace", entry.Column);
                for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = this.m_ensemble.trace(n);
                    float pick = trace.header().getFloat(index);
                    if (!trace.PlotData.Visible || !(pick > -980.0f)) continue;
                    float shift = trace.data().getTotalFirstSampleShifts();
                    float shifted = pick + shift;
                    int py = (int)(this.ScaleY * (double)shifted + this.ShiftY);
                    int px = trace.PlotData.PixelX;
                    if (entry.Symbol == Java2D_PointSymbol.FilledSquare) {
                        this.m_g2d.fillRect(px - w2, py - w2, w, w);
                    }
                    if (entry.Symbol == Java2D_PointSymbol.FilledOval) {
                        this.m_g2d.fillOval(px - w2, py - w2, w, w);
                    }
                    if (entry.Symbol == Java2D_PointSymbol.HollowSquare) {
                        this.m_g2d.drawRect(px - w2, py - w2, w, w);
                    }
                    if (entry.Symbol == Java2D_PointSymbol.HollowOval) {
                        this.m_g2d.drawOval(px - w2, py - w2, w, w);
                    }
                    if (entry.Symbol == Java2D_PointSymbol.X) {
                        this.m_g2d.drawLine(px - w2, py - w2, px + w2, py + w2);
                        this.m_g2d.drawLine(px + w2, py - w2, px - w2, py + w2);
                    }
                    if (entry.Symbol != Java2D_PointSymbol.Plus) continue;
                    this.m_g2d.drawLine(px - w2, py, px + w2, py);
                    this.m_g2d.drawLine(px, py - w2, px, py + w2);
                }
            }
            this.m_g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Ensemble ensemble() {
        return this.m_ensemble;
    }

    public void setEnsemble(Ensemble ensemble) {
        try {
            this.m_ensemble = ensemble;
            this.clearTracePlotData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void clearTracePlotData() {
        try {
            if (this.m_ensemble == null) {
                return;
            }
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_ensemble.trace(n);
                trace.PlotData.Visible = false;
                trace.PlotData.DataOK = trace.data().absoluteMax() > 1.0E-10f;
                trace.PlotData.PixelX = -999999;
                trace.PlotData.WorldX = -999999.0;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void Java2D_PaintBackground(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int pixPerTrace = (int)(1.0 + this.ScaleX);
            Java2D_ColorArrayWrapper colorArray = paintParameter.ColorArrayWrapper;
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                FloatArrayWrapper data;
                EnsembleTrace trace = this.m_ensemble.trace(n);
                if (!trace.PlotData.Visible || !trace.hasSupplementalData(this.BackgroundColorKey) || (data = trace.getSupplementalData(this.BackgroundColorKey)).length() <= 3) continue;
                int left = trace.PlotData.PixelX - pixPerTrace / 2;
                if (this.m_data.length != data.length()) {
                    this.m_data = new float[data.length()];
                }
                data.copyToArray(this.m_data);
                double digi = data.getSampleInterval();
                double time = (double)data.getFirstSampleCoord_WithShifts() - 0.5 * digi;
                double pixelY = this.ScaleY * time + this.ShiftY;
                double pixPerSample = this.ScaleY * digi;
                int pixHeight = 1 + (int)(0.5 + pixPerSample);
                for (int s = 0; s < this.m_data.length; ++s) {
                    Color c = colorArray.colorUsingValue(this.m_data[s]);
                    if (colorArray.valueOK(this.m_data[s])) {
                        this.m_g2d.setColor(colorArray.colorUsingValue(this.m_data[s]));
                        this.m_g2d.fillRect(left, (int)pixelY, pixPerTrace, pixHeight);
                    }
                    pixelY += pixPerSample;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void plotBackColors(int supplementalData) {
        try {
            EnsembleTrace trace;
            if (this.m_ensemble == null) {
                return;
            }
            int numVisible = 0;
            int firstIndex = 10000000;
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                trace = this.m_ensemble.trace(n);
                if (!trace.PlotData.Visible) continue;
                ++numVisible;
                firstIndex = Math.min(firstIndex, n);
            }
            this.m_g2d.setColor(this.m_ensemble.BackColor);
            if (numVisible < 2) {
                return;
            }
            if (!this.m_ensemble.dictionary().containsEntry(this.m_ensemble.BackColorTable, this.m_ensemble.BackColorColumn)) {
                return;
            }
            int index = this.m_ensemble.dictionary().getEntryIndex(this.m_ensemble.BackColorTable, this.m_ensemble.BackColorColumn);
            trace = this.m_ensemble.trace(firstIndex);
            int curr = trace.header().getInt(index);
            boolean draw = false;
            int w = this.MaximumStickLength / 2;
            w = Math.max(2, w);
            w = Math.min(12, w);
            for (int n = firstIndex + 1; n < this.m_ensemble.traceCount(); ++n) {
                trace = this.m_ensemble.trace(n);
                if (!trace.PlotData.Visible) continue;
                int val = trace.header().getInt(index);
                if (val != curr) {
                    curr = val;
                    boolean bl = draw = !draw;
                }
                if (!draw) continue;
                int ix = trace.PlotData.PixelX;
                this.m_g2d.fillRect(ix - w, 0, 2 * w + 1, this.Height + 2);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void plotBackColorsUsingIndex(int supplementalData) {
        try {
            EnsembleTrace trace;
            if (this.m_ensemble == null) {
                return;
            }
            int numVisible = 0;
            int firstIndex = 10000000;
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                trace = this.m_ensemble.trace(n);
                if (!trace.PlotData.Visible) continue;
                ++numVisible;
                firstIndex = Math.min(firstIndex, n);
            }
            if (numVisible < 2) {
                return;
            }
            int index = this.m_ensemble.dictionary().getEntryIndex("Trace", "BackColorIndex");
            int w = this.MaximumStickLength / 2;
            w = Math.max(2, w);
            w = Math.min(12, w);
            for (int n = firstIndex + 1; n < this.m_ensemble.traceCount(); ++n) {
                int val;
                trace = this.m_ensemble.trace(n);
                if (!trace.PlotData.Visible || (val = trace.header().getInt(index)) < 0 || val >= this.BackColorArray.length) continue;
                this.m_g2d.setColor(this.BackColorArray[val]);
                int ix = trace.PlotData.PixelX;
                this.m_g2d.fillRect(ix - w, 0, 2 * w + 1, this.Height + 2);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int n;
            if (this.m_ensemble == null) {
                return;
            }
            if (!this.DrawOverlappingTraces) {
                int numPixels = Math.min(7000, paintParameter.Transform.sizeX());
                if (this.m_pixelUsed.length < numPixels) {
                    this.m_pixelUsed = new byte[numPixels];
                }
                for (int p = 0; p < this.m_pixelUsed.length; ++p) {
                    this.m_pixelUsed[p] = 0;
                }
                this.PixelOverlapLimit = Math.max(2, this.PixelOverlapLimit);
                this.PixelOverlapLimit = Math.min(20, this.PixelOverlapLimit);
            }
            this.ScaleX = paintParameter.Transform.scaleX();
            this.ShiftX = paintParameter.Transform.shiftX();
            this.ScaleY = paintParameter.Transform.scaleY();
            this.ShiftY = paintParameter.Transform.shiftY();
            this.Left = paintParameter.Transform.actualLeft();
            this.Right = paintParameter.Transform.actualRight();
            this.Top = paintParameter.Transform.actualTop();
            this.Bottom = paintParameter.Transform.actualBottom();
            this.Height = paintParameter.Transform.sizeY();
            this.m_g2d = paintParameter.G2D;
            if (paintParameter.PaintLevel >= 1) {
                this.paintOverlays(paintParameter, supplementalData);
                this.m_g2d = null;
                return;
            }
            this.clearTracePlotData();
            this.NumberOfTracesPainted = 0;
            double nextWorldCoord = 0.0;
            if (this.m_axisType == Java2D_EnsembleAxisEnum.UniformSpacing) {
                for (n = 0; n < this.m_ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = this.m_ensemble.trace(n);
                    if (!trace.PlotData.ShowTrace) continue;
                    trace.PlotData.WorldX = nextWorldCoord;
                    nextWorldCoord += 1.0;
                    trace.PlotData.InsideViewport = trace.PlotData.WorldX >= this.Left && trace.PlotData.WorldX <= this.Right;
                }
            }
            if (this.m_axisType == Java2D_EnsembleAxisEnum.TraceHeader) {
                if (!this.m_ensemble.dictionary().containsEntry(this.m_table, this.m_column)) {
                    this.m_g2d = null;
                    return;
                }
                this.m_ensemble.sortDouble(0, this.m_table, this.m_column);
                int headerIndex = this.m_ensemble.dictionary().getEntryIndex(this.m_table, this.m_column);
                for (int n2 = 0; n2 < this.m_ensemble.traceCount(); ++n2) {
                    EnsembleTrace trace = this.m_ensemble.trace(n2);
                    trace.PlotData.WorldX = trace.header().getDouble(headerIndex);
                    trace.PlotData.InsideViewport = trace.PlotData.WorldX >= this.Left && trace.PlotData.WorldX <= this.Right;
                }
            }
            for (n = 0; n < this.m_ensemble.traceCount(); ++n) {
                boolean traceOkay;
                EnsembleTrace trace = this.m_ensemble.trace(n);
                trace.PlotData.PixelX = (int)(this.ScaleX * trace.PlotData.WorldX + this.ShiftX);
                boolean bl = traceOkay = trace.traceOkay() || this.DrawKilledTraces;
                if (!this.DrawOverlappingTraces) {
                    int left = trace.PlotData.PixelX - this.PixelOverlapLimit;
                    left = Math.max(left, 0);
                    int right = trace.PlotData.PixelX + this.PixelOverlapLimit;
                    right = Math.min(right, this.m_pixelUsed.length - 1);
                    for (int p = left; p <= right; ++p) {
                        if (this.m_pixelUsed[p] == 0) continue;
                        traceOkay = false;
                    }
                }
                if (!(trace.PlotData.WorldX >= this.Left) || !(trace.PlotData.WorldX <= this.Right) || !trace.PlotData.ShowTrace || !traceOkay) continue;
                trace.PlotData.Visible = true;
                ++this.NumberOfTracesPainted;
                if (trace.PlotData.PixelX < 0 || trace.PlotData.PixelX >= this.m_pixelUsed.length) continue;
                this.m_pixelUsed[trace.PlotData.PixelX] = 1;
            }
            if (this.NumberOfTracesPainted < 1) {
                this.m_g2d = null;
                return;
            }
            if (this.PlotBackgroundColor) {
                this.Java2D_PaintBackground(paintParameter, supplementalData);
            }
            double pixelsPerTrace = (double)paintParameter.Transform.sizeX() / (double)this.NumberOfTracesPainted;
            double maxStickLength = 0.5 + (double)this.WiggleOverlap * pixelsPerTrace;
            if (this.ApplyClipping && this.WiggleClipping < this.WiggleOverlap) {
                maxStickLength = 0.5 + (double)this.WiggleClipping * pixelsPerTrace;
            }
            this.MaximumStickLength = (int)(0.5 + maxStickLength);
            this.MaximumStickLength = Math.max(this.MaximumStickLength, 2);
            this.MaximumStickLength = Math.min(this.MaximumStickLength, 300);
            this.MinimumStickLength = -this.MaximumStickLength;
            if (this.IndividualTraceAmplitudeScaling) {
                for (int n3 = 0; n3 < this.m_ensemble.traceCount(); ++n3) {
                    EnsembleTrace trace = this.m_ensemble.trace(n3);
                    if (!trace.PlotData.Visible) continue;
                    float max = Math.max(1.0E-20f, trace.data().absoluteMax());
                    trace.PlotData.WiggleScalar = (float)(pixelsPerTrace * (double)this.WiggleOverlap / (double)max);
                }
            } else {
                EnsembleTrace trace;
                int n4;
                float ensembleMaximum = 1.0E-20f;
                for (n4 = 0; n4 < this.m_ensemble.traceCount(); ++n4) {
                    trace = this.m_ensemble.trace(n4);
                    if (!trace.PlotData.Visible) continue;
                    float max = Math.max(1.0E-20f, trace.data().absoluteMax());
                    ensembleMaximum = Math.max(ensembleMaximum, max);
                }
                for (n4 = 0; n4 < this.m_ensemble.traceCount(); ++n4) {
                    trace = this.m_ensemble.trace(n4);
                    if (!trace.PlotData.Visible) continue;
                    trace.PlotData.WiggleScalar = (float)(pixelsPerTrace * (double)this.WiggleOverlap / (double)ensembleMaximum);
                }
            }
            boolean backgroundPlotted = false;
            if (this.m_ensemble.ColorBackground) {
                this.plotBackColors(supplementalData);
                backgroundPlotted = true;
            }
            if (!backgroundPlotted && this.m_ensemble.dictionary().containsEntry("Trace", "BackColorIndex")) {
                this.plotBackColorsUsingIndex(supplementalData);
                backgroundPlotted = true;
            }
            for (int n5 = 0; n5 < this.m_ensemble.traceCount(); ++n5) {
                EnsembleTrace trace = this.m_ensemble.trace(n5);
                if (!trace.PlotData.Visible || !trace.hasData()) continue;
                double time0 = trace.data().getFirstSampleCoord_WithShifts();
                double digi = trace.data().getSampleInterval();
                trace.PlotData.ShiftY = this.ShiftY + this.ScaleY * time0;
                trace.PlotData.ScaleY = digi * this.ScaleY;
                trace.PlotData.InverseScaleY = 1.0 / trace.PlotData.ScaleY;
                trace.PlotData.InverseShiftY = -trace.PlotData.ShiftY / trace.PlotData.ScaleY;
            }
            this.m_g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
            int branchIndex = -999;
            if (this.m_ensemble.dictionary().containsEntry("Trace", "Branch_DelayTime")) {
                branchIndex = this.m_ensemble.dictionary().getEntryIndex("Trace", "Branch_DelayTime");
            }
            for (int n6 = 0; n6 < this.m_ensemble.traceCount(); ++n6) {
                int branch;
                EnsembleTrace trace = this.m_ensemble.trace(n6);
                if (!trace.PlotData.Visible || !trace.hasData()) continue;
                Color posColor = this.PositiveColor;
                Color negColor = this.NegativeColor;
                if (trace.PlotData.ShowBranch && branchIndex >= 0 && (branch = trace.header().getInt(branchIndex)) >= 1) {
                    posColor = BranchColors.solidColor(branch);
                    negColor = BranchColors.solidColor(branch);
                }
                if (this.m_data.length != trace.data().length()) {
                    this.m_data = new float[trace.data().length()];
                }
                trace.data().copyToArray(this.m_data);
                double time0 = trace.data().getFirstSampleCoord_WithShifts();
                double digi = trace.data().getSampleInterval();
                this.SampleShiftY = trace.PlotData.ShiftY;
                this.SampleScaleY = trace.PlotData.ScaleY;
                this.InverseSampleScaleY = trace.PlotData.InverseScaleY;
                this.InverseSampleShiftY = trace.PlotData.InverseShiftY;
                this.TempScalar = trace.PlotData.WiggleScalar;
                this.MidPixel = trace.PlotData.PixelX;
                if (trace.PlotData.ColorOverride && trace.PlotData.OverrideColor != null) {
                    posColor = trace.PlotData.OverrideColor;
                    negColor = trace.PlotData.OverrideColor;
                }
                if (this.FillNegativeWiggle) {
                    this.m_g2d.setColor(negColor);
                    if (this.SampleScaleY <= 1.0) {
                        this.negative_Case1(trace);
                    } else {
                        this.negative_Case2(trace);
                    }
                }
                if (this.FillPositiveWiggle) {
                    this.m_g2d.setColor(posColor);
                    if (this.SampleScaleY <= 1.0) {
                        this.positive_Case1(trace);
                    } else {
                        this.positive_Case2(trace);
                    }
                }
                if (!this.FillPositiveWiggle || !this.FillNegativeWiggle) {
                    this.m_g2d.setColor(posColor);
                    this.wiggle(trace);
                    continue;
                }
                this.m_g2d.setColor(posColor);
                this.m_g2d.drawLine(this.MidPixel, 0, this.MidPixel, this.Height);
            }
            if (this.DrawMuteZone) {
                if (this.MuteX.length < this.m_ensemble.traceCount() + 5) {
                    this.MuteX = new int[this.m_ensemble.traceCount() + 5];
                    this.MuteY = new int[this.m_ensemble.traceCount() + 5];
                }
                this.m_g2d.setColor(this.MuteColor);
                int numMute = 0;
                int lastX = 0;
                for (int n7 = 0; n7 < this.m_ensemble.traceCount(); ++n7) {
                    EnsembleTrace trace = this.m_ensemble.trace(n7);
                    if (!trace.PlotData.Visible || !trace.hasData()) continue;
                    if (numMute == 0) {
                        this.MuteX[numMute] = trace.PlotData.PixelX;
                        this.MuteY[numMute] = 0;
                        ++numMute;
                    }
                    this.MuteX[numMute] = trace.PlotData.PixelX;
                    this.MuteY[numMute] = (int)(this.ScaleY * (double)trace.StretchMuteTime + this.ShiftY);
                    lastX = trace.PlotData.PixelX;
                    ++numMute;
                }
                this.MuteX[numMute] = lastX;
                this.MuteY[numMute] = 0;
                if (++numMute >= 3) {
                    this.m_g2d.fillPolygon(this.MuteX, this.MuteY, numMute);
                }
            }
            this.m_g2d = null;
            this.ImageContentsDirty = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        this.m_g2d = null;
    }

    protected void negative_Case2(EnsembleTrace trace) {
        try {
            int pixelY = 0;
            double floatIndex = (double)pixelY * this.InverseSampleScaleY + this.InverseSampleShiftY;
            int lowIndex = (int)floatIndex;
            while (floatIndex < 0.0) {
                floatIndex = (double)(++pixelY) * this.InverseSampleScaleY + this.InverseSampleShiftY;
                lowIndex = (int)floatIndex;
            }
            while (pixelY < this.Height && lowIndex < this.m_data.length - 1) {
                double w;
                double interp;
                if ((this.m_data[lowIndex] < 0.0f || this.m_data[lowIndex + 1] < 0.0f) && (interp = (1.0 - (w = floatIndex - (double)lowIndex)) * (double)this.m_data[lowIndex] + w * (double)this.m_data[lowIndex + 1]) < 0.0) {
                    int stick = (int)(0.5 - (double)((float)this.TempScalar) * interp);
                    if ((stick = Math.min(stick, this.MaximumStickLength)) != 0) {
                        this.m_g2d.drawLine(this.MidPixel - stick, pixelY, this.MidPixel, pixelY);
                    }
                }
                floatIndex = (double)(++pixelY) * this.InverseSampleScaleY + this.InverseSampleShiftY;
                lowIndex = (int)floatIndex;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void positive_Case2(EnsembleTrace trace) {
        try {
            int pixelY = 0;
            double floatIndex = (double)pixelY * this.InverseSampleScaleY + this.InverseSampleShiftY;
            int lowIndex = (int)floatIndex;
            while (floatIndex < 0.0) {
                floatIndex = (double)(++pixelY) * this.InverseSampleScaleY + this.InverseSampleShiftY;
                lowIndex = (int)floatIndex;
            }
            while (pixelY < this.Height && lowIndex < this.m_data.length - 1) {
                double w;
                double interp;
                if ((this.m_data[lowIndex] > 0.0f || this.m_data[lowIndex + 1] > 0.0f) && (interp = (1.0 - (w = floatIndex - (double)lowIndex)) * (double)this.m_data[lowIndex] + w * (double)this.m_data[lowIndex + 1]) > 0.0) {
                    int stick = (int)(0.5 + (double)((float)this.TempScalar) * interp);
                    if ((stick = Math.min(stick, this.MaximumStickLength)) != 0) {
                        this.m_g2d.drawLine(this.MidPixel + stick, pixelY, this.MidPixel, pixelY);
                    }
                }
                floatIndex = (double)(++pixelY) * this.InverseSampleScaleY + this.InverseSampleShiftY;
                lowIndex = (int)floatIndex;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void wiggle(EnsembleTrace trace) {
        try {
            int xold = this.MidPixel;
            int yold = (int)(this.SampleShiftY + 0.0 * this.SampleScaleY);
            this.m_g2d.drawLine(xold, yold, xold, 0);
            for (int s = 0; s < this.m_data.length; ++s) {
                int x = this.MidPixel;
                if (this.m_data[s] > 0.0f) {
                    stick = (int)(0.5f + (float)this.TempScalar * this.m_data[s]);
                    stick = Math.min(stick, this.MaximumStickLength);
                    x = this.MidPixel + stick;
                } else {
                    stick = (int)(0.5f - (float)this.TempScalar * this.m_data[s]);
                    stick = Math.min(stick, this.MaximumStickLength);
                    x = this.MidPixel - stick;
                }
                int y = (int)(this.SampleShiftY + (double)s * this.SampleScaleY);
                this.m_g2d.drawLine(xold, yold, x, y);
                xold = x;
                yold = y;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void positive_Case1(EnsembleTrace trace) {
        try {
            for (int s = 0; s < this.m_data.length; ++s) {
                if (!(this.m_data[s] > 0.0f)) continue;
                int stick = (int)(0.5f + (float)this.TempScalar * this.m_data[s]);
                if ((stick = Math.min(stick, this.MaximumStickLength)) == 0) continue;
                int y = (int)(this.SampleShiftY + (double)s * this.SampleScaleY);
                this.m_g2d.drawLine(this.MidPixel + stick, y, this.MidPixel, y);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void negative_Case1(EnsembleTrace trace) {
        try {
            for (int s = 0; s < this.m_data.length; ++s) {
                if (!(this.m_data[s] < 0.0f)) continue;
                int stick = (int)(0.5f - (float)this.TempScalar * this.m_data[s]);
                if ((stick = Math.min(stick, this.MaximumStickLength)) == 0) continue;
                int y = (int)(this.SampleShiftY + (double)s * this.SampleScaleY);
                this.m_g2d.drawLine(this.MidPixel - stick, y, this.MidPixel, y);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            int n;
            if (this.m_ensemble == null) {
                return;
            }
            if (this.m_ensemble.traceCount() < 1) {
                return;
            }
            this.m_ensemble.expandTimeRange(rangeY);
            if (this.m_axisType == Java2D_EnsembleAxisEnum.UniformSpacing) {
                rangeX.expandRange(0.0);
                int num = 0;
                for (n = 0; n < this.m_ensemble.traceCount(); ++n) {
                    if (!this.m_ensemble.trace((int)n).PlotData.ShowTrace) continue;
                    ++num;
                }
                rangeX.expandRange(num);
            }
            if (this.m_axisType == Java2D_EnsembleAxisEnum.TraceHeader) {
                if (!this.m_ensemble.dictionary().containsEntry(this.m_table, this.m_column)) {
                    return;
                }
                int headerIndex = this.m_ensemble.dictionary().getEntryIndex(this.m_table, this.m_column);
                for (n = 0; n < this.m_ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = this.m_ensemble.trace(n);
                    if (!trace.PlotData.ShowTrace) continue;
                    rangeX.expandRange(trace.header().getDouble(headerIndex));
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            if (!this.PlotBackgroundColor) {
                return;
            }
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                FloatArrayWrapper wrapper;
                Range_Double range;
                EnsembleTrace trace = this.m_ensemble.trace(n);
                if (!trace.hasSupplementalData(this.BackgroundColorKey) || !(range = (wrapper = trace.getSupplementalData(this.BackgroundColorKey)).totalRange()).rangeValid()) continue;
                rangeC.expandRange(range);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

