/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Uphole.UpholeSimple;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;

public class Java2D_PaintableDatabaseProfile
implements Java2D_PaintableInterface {
    public double[] X;
    public double[] Y;
    public double[] V;
    public double[] W;
    public double Length;
    protected int[] m_id;
    protected boolean m_bContentsChangedSinceLastPaint = true;
    protected Java2D_PointSymbol m_symbol = Java2D_PointSymbol.FilledOval;
    public Color SymbolColor = Color.BLACK;
    public int SymbolSize = 5;
    public boolean UseColorScale = true;
    protected boolean m_isSparse = false;
    public String Column;
    public int NumZ = 0;
    public int NumX = 0;
    public double DeltaDepth;
    public double[][] Velocity;
    public double[][] Time;
    public Range_Double RangeZ = new Range_Double();

    public Java2D_PaintableDatabaseProfile(String column, double x1, double y1, double x2, double y2, int num) {
        try {
            int n;
            num = Math.max(num, 10);
            this.Column = column;
            this.X = new double[num];
            this.Y = new double[num];
            this.V = new double[num];
            this.W = new double[num];
            double dx = x2 - x1;
            double dy = y2 - y1;
            this.Length = Math.sqrt(dx * dx + dy * dy);
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            double scalar = 30.0;
            if (!p.units_feet()) {
                scalar = 10.0;
            }
            double alpha = -Math.log(0.5) / (scalar * scalar);
            int numw = 1000;
            double[] weight = new double[numw];
            double max_dist = 10.0 * scalar;
            double maxoff2 = max_dist * max_dist;
            double delta = maxoff2 / (double)(numw - 1);
            for (n = 0; n < numw; ++n) {
                double off2 = (double)n * maxoff2 / (double)(numw - 1);
                weight[n] = Math.exp(-alpha * off2);
                weight[n] = Math.max(weight[n], 1.0E-7);
            }
            for (n = 0; n < num; ++n) {
                this.X[n] = x1 + (x2 - x1) * (double)n / (double)(num - 1);
                this.Y[n] = y1 + (y2 - y1) * (double)n / (double)(num - 1);
                this.V[n] = 0.0;
                this.W[n] = 0.0;
            }
            for (int iter = 0; iter <= 1; ++iter) {
                Table_Abstract t = p.shotTable();
                if (iter == 1) {
                    t = p.receiverTable();
                }
                int ix = t.column_indexOfColumn("Easting");
                int iy = t.column_indexOfColumn("Northing");
                int iv = t.column_indexOfColumn(column);
                int ik = t.column_indexOfColumn("Killed");
                for (int r = 0; r < t.row_count(); ++r) {
                    if (t.getBool(r, ik)) continue;
                    double x = t.getDouble(r, ix);
                    double y = t.getDouble(r, iy);
                    double v = t.getDouble(r, iv);
                    int n2 = 0;
                    while (n2 < num) {
                        dx = x - this.X[n2];
                        dy = y - this.Y[n2];
                        double off2 = dx * dx + dy * dy;
                        int index_w = (int)(off2 / maxoff2);
                        index_w = Math.min(index_w, numw - 1);
                        double w = weight[index_w];
                        int n3 = n2;
                        this.V[n3] = this.V[n3] + w * v;
                        int n4 = n2++;
                        this.W[n4] = this.W[n4] + w;
                    }
                }
            }
            for (n = 0; n < num; ++n) {
                this.V[n] = this.V[n] / this.W[n];
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void prep_uphole_arrays(UpholeSimple uphole) {
        try {
            this.NumZ = uphole.Time.length;
            this.NumX = this.X.length;
            this.Velocity = new double[this.NumX][this.NumZ];
            this.Time = new double[this.NumX][this.NumZ];
            this.RangeZ.clearRange();
            this.DeltaDepth = uphole.DeltaDepth;
            for (int n = 0; n < this.NumX; ++n) {
                uphole.interpolate_arrays(this.X[n], this.Y[n]);
                for (int z = 0; z < this.NumZ; ++z) {
                    this.Velocity[n][z] = uphole.Velocity[z];
                    this.Time[n][z] = uphole.Time[z];
                }
                this.RangeZ.expandRange(this.V[n]);
                this.RangeZ.expandRange(this.V[n] - this.DeltaDepth * (double)this.NumZ);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.m_bContentsChangedSinceLastPaint;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 1;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            g2d.setColor(this.SymbolColor);
            g2d.setStroke(new BasicStroke(3.0f));
            if (supplementalData == 2000 || supplementalData == 2001) {
                double deltaX = this.Length / (double)this.X.length;
                int sx = 1 + (int)Math.abs(scaleX * deltaX);
                int sy = 1 + (int)Math.abs(scaleY * this.DeltaDepth);
                double[][] array = this.Time;
                if (supplementalData == 2001) {
                    array = this.Velocity;
                }
                for (int n = 0; n < this.X.length; ++n) {
                    double x = this.Length * (double)n / (double)(this.V.length - 1);
                    for (int iz = 0; iz < this.NumZ; ++iz) {
                        double z = this.V[n] - (double)iz * this.DeltaDepth;
                        int ix1 = (int)(scaleX * x + shiftX);
                        int iy1 = (int)(scaleY * z + shiftY);
                        Color c = colorWrapper.colorUsingValue(array[n][iz]);
                        g2d.setColor(c);
                        g2d.fillRect(ix1 - sx / 2, iy1 - sy / 2, sx, sy);
                    }
                }
            }
            if (supplementalData == 1000) {
                for (int n = 1; n < this.V.length; ++n) {
                    double x1 = this.Length * (double)(n - 1) / (double)(this.V.length - 1);
                    double x2 = this.Length * (double)n / (double)(this.V.length - 1);
                    int ix1 = (int)(scaleX * x1 + shiftX);
                    int iy1 = (int)(scaleY * this.V[n - 1] + shiftY);
                    int ix2 = (int)(scaleX * x2 + shiftX);
                    int iy2 = (int)(scaleY * this.V[n] + shiftY);
                    g2d.drawLine(ix1, iy1, ix2, iy2);
                }
            }
            this.m_bContentsChangedSinceLastPaint = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (supplementalData == 2000 || supplementalData == 2001) {
                rangeX.expandRange(0.0);
                rangeX.expandRange(this.Length);
                rangeY.expandRange(this.RangeZ);
            }
            if (supplementalData == 1000) {
                rangeX.expandRange(0.0);
                rangeX.expandRange(this.Length);
                rangeY.expandRange(this.V);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            int z;
            int n;
            if (supplementalData == 2000) {
                for (n = 0; n < this.NumX; ++n) {
                    for (z = 0; z < this.NumZ; ++z) {
                        rangeC.expandRange(this.Time[n][z]);
                    }
                }
            }
            if (supplementalData == 2001) {
                for (n = 0; n < this.NumX; ++n) {
                    for (z = 0; z < this.NumZ; ++z) {
                        rangeC.expandRange(this.Velocity[n][z]);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

