/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosLibrary.Windows.Java2D.ColorWidgets.Java2D_VerticalColorCompositeWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_ScrollBar;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Java2D_XAxisWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_YAxisWidget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_AxisLines;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseoverInfo;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Rectangle;
import java.awt.Color;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Java2D_VerticalStackWidget
extends JPanel
implements ComponentListener,
Java2D_Widget.Listener,
GenericObjectListener.Listener,
Messenger.Listener,
Java2D_ScrollBar.Listener,
Java2D_VerticalColorCompositeWidget.Listener {
    protected ArrayList<Wrapper> m_list = new ArrayList();
    protected boolean m_labelVisible = false;
    protected Range_Double m_rangeX = new Range_Double();
    protected int m_numVisible = 1;
    protected Java2D_XAxisWidget m_axisX = new Java2D_XAxisWidget();
    protected boolean m_axisXVisible = true;
    protected Java2D_ScrollBar m_scrollBarHorz;

    public int numWidgets() {
        return this.m_list.size();
    }

    public Java2D_VerticalStackWidget(int numDisplays) {
        try {
            this.setLayout(null);
            numDisplays = Math.max(numDisplays, 1);
            this.m_numVisible = numDisplays = Math.min(numDisplays, 20);
            for (int n = 0; n < this.m_numVisible; ++n) {
                Wrapper wrapper = new Wrapper();
                wrapper.ColorWidget = new Java2D_VerticalColorCompositeWidget(this);
                wrapper.Main = new Java2D_Widget(wrapper.ColorWidget.getColorArrayWrapper());
                wrapper.Main.addListener(this);
                wrapper.Transform = wrapper.Main.transform();
                wrapper.ScrollBar = new Java2D_ScrollBar(1, this);
                wrapper.Zoomer.addListener(this);
                wrapper.TimeLines.DrawHorizontalLines = true;
                wrapper.TimeLines.DrawVerticalLines = false;
                this.add(wrapper.Main);
                this.add(wrapper.AxisVert);
                this.add(wrapper.Label);
                this.add(wrapper.ScrollBar);
                this.add(wrapper.ColorWidget);
                Tools_FontChanger.changeSizeOfFont(wrapper.Label, 4);
                wrapper.Label.setForeground(Color.blue);
                this.m_list.add(wrapper);
            }
            this.m_scrollBarHorz = new Java2D_ScrollBar(0, this);
            this.add(this.m_axisX);
            this.add(this.m_scrollBarHorz);
            this.addComponentListener(this);
            Messenger.singleton().addListener(this);
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setZeroColor(Color c) {
        try {
            for (Wrapper w : this.m_list) {
                Java2D_ColorArrayWrapper ca = w.ColorWidget.getColorArrayWrapper();
                ca.setColor(0, c);
                ca.interpolateColors(0, ca.colorCount() / 5);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clear() {
        try {
            for (Wrapper w : this.m_list) {
                w.Main.clearPaintableList();
            }
            this.unzoom();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setTransform(Java2D_Transform.Technique t) {
        try {
            for (Wrapper w : this.m_list) {
                w.Transform.setTechnique(t);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Java2D_Widget mainWidget(int index) {
        try {
            return this.m_list.get((int)index).Main;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public Java2D_VerticalColorCompositeWidget colorWidget(int index) {
        try {
            return this.m_list.get((int)index).ColorWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void setSectionWeight(int index, double w) {
        try {
            this.m_list.get((int)index).SizeWeight = Math.max(1.0, w);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setAxisLockedY(int index, boolean locked, double min, double max) {
        try {
            this.m_list.get((int)index).Transform.setAxisLockedY(locked, min, max);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void setColorLabel(int index, String lbl) {
        try {
            this.m_list.get((int)index).ColorWidget.setLabel(lbl);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setColorVisible(boolean vis) {
        try {
            for (Wrapper w : this.m_list) {
                w.ColorVisible = vis;
            }
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setLabel(int index, String lbl) {
        try {
            JLabel label = this.m_list.get((int)index).Label;
            label.setText(lbl);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setColorVisible(int index, boolean vis) {
        try {
            this.m_list.get((int)index).ColorVisible = vis;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setLabelVisible(boolean labelVisible) {
        try {
            this.m_labelVisible = labelVisible;
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void initializeMouseoverPanel(Java2D_PaintableInterface paintable, Java2D_UserEventConsumer_MouseoverInfo.ModelType modelType) {
        try {
            for (int n = 0; n < this.m_list.size(); ++n) {
                Wrapper wrapper;
                if (modelType == Java2D_UserEventConsumer_MouseoverInfo.ModelType.TomoVNS || modelType == Java2D_UserEventConsumer_MouseoverInfo.ModelType.Tomo3D) {
                    wrapper = this.m_list.get(n);
                    if (n == 0) {
                        wrapper.MouseUEC = new Java2D_UserEventConsumer_MouseoverInfo(paintable, modelType, Java2D_UserEventConsumer_MouseoverInfo.DisplayType.Velocity);
                    } else if (n == 1) {
                        wrapper.MouseUEC = new Java2D_UserEventConsumer_MouseoverInfo(paintable, modelType, Java2D_UserEventConsumer_MouseoverInfo.DisplayType.Count);
                    }
                    wrapper.Main.addEventConsumer(wrapper.MouseUEC);
                    wrapper.MouseUEC.addListener(this);
                    continue;
                }
                if (modelType == Java2D_UserEventConsumer_MouseoverInfo.ModelType.DelayTime) {
                    wrapper = this.m_list.get(n);
                    wrapper.MouseUEC = new Java2D_UserEventConsumer_MouseoverInfo(paintable, modelType, Java2D_UserEventConsumer_MouseoverInfo.DisplayType.Velocity);
                    wrapper.Main.addEventConsumer(wrapper.MouseUEC);
                    wrapper.MouseUEC.addListener(this);
                    continue;
                }
                wrapper = this.m_list.get(n);
                wrapper.MouseUEC = new Java2D_UserEventConsumer_MouseoverInfo(paintable, modelType, Java2D_UserEventConsumer_MouseoverInfo.DisplayType.Velocity);
                wrapper.Main.addEventConsumer(wrapper.MouseUEC);
                wrapper.MouseUEC.addListener(this);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleScrollBar(Java2D_ScrollBar sender, int orientation, double min, double max) {
    }

    @Override
    public void verticalColorMapCompositeChanged(Object sender) {
        try {
            for (int n = 0; n < this.m_numVisible; ++n) {
                Wrapper w = this.m_list.get(n);
                if (w.ColorWidget != sender || !w.ColorVisible) continue;
                w.Main.forceImageRepaint();
                w.Main.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void unzoom() {
        try {
            Wrapper w;
            int n;
            boolean unzoomScrollBars = true;
            unzoomScrollBars = true;
            this.m_rangeX.clearRange();
            for (n = 0; n < this.m_numVisible; ++n) {
                w = this.m_list.get(n);
                w.Main.recomputeAllRanges();
                this.m_rangeX.expandRange(w.Main.rangeX());
                w.Main.rangeY().addPercentBuffer(2.0);
            }
            if (!this.m_rangeX.rangeValid()) {
                for (n = 0; n < this.m_numVisible; ++n) {
                    this.m_list.get((int)n).Main.repaint();
                }
                return;
            }
            this.m_rangeX.addPercentBuffer(2.0);
            for (n = 0; n < this.m_numVisible; ++n) {
                w = this.m_list.get(n);
                if (w.Main.rangeY().rangeValid()) {
                    w.Transform.setDesiredWorldX(this.m_rangeX.rangeMin(), this.m_rangeX.rangeMax());
                    w.Transform.setDesiredWorldY(w.Main.rangeY().rangeMin(), w.Main.rangeY().rangeMax());
                    w.Transform.computeTransform();
                }
                w.Main.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setNumVisible(int num) {
        try {
            this.m_numVisible = num;
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void placeWidgets() {
        try {
            int width = this.getSize().width;
            int height = this.getSize().height;
            this.m_numVisible = Math.max(1, this.m_numVisible);
            this.m_numVisible = Math.min(this.m_numVisible, this.m_list.size());
            for (int n = 0; n < this.m_list.size(); ++n) {
                this.m_list.get(n).setVisible(n < this.m_numVisible, this.m_labelVisible);
            }
            boolean anyColorShown = false;
            double sumWeight = 0.0;
            for (int n = 0; n < this.m_numVisible; ++n) {
                Wrapper w = this.m_list.get(n);
                w.SizeWeight = Math.max(w.SizeWeight, 1.0);
                w.SizeWeight = Math.min(w.SizeWeight, 10.0);
                sumWeight += w.SizeWeight;
                anyColorShown = anyColorShown || w.ColorVisible;
            }
            int buffer = 10;
            int vertColorWidth = 100;
            if (!anyColorShown) {
                vertColorWidth = 0;
            }
            int labelHeight = 20;
            int axisHeight = 30;
            int scrollSize = 15;
            int axisWidth = 54;
            int mainWidth = width - axisWidth - scrollSize - vertColorWidth;
            this.m_axisX.setVisible(true);
            this.m_scrollBarHorz.setVisible(true);
            int numVertBuffer = this.m_numVisible - 1;
            int pixForBuffer = numVertBuffer * buffer;
            int pixForPlots = height - pixForBuffer - axisHeight - scrollSize;
            if (pixForPlots < 20 || mainWidth < 10) {
                this.m_axisX.setVisible(false);
                this.m_scrollBarHorz.setVisible(false);
                for (int n = 0; n < this.m_list.size(); ++n) {
                    this.m_list.get(n).setVisible(false, this.m_labelVisible);
                }
                return;
            }
            int top = 0;
            this.m_axisX.setBounds(axisWidth, top, mainWidth, axisHeight);
            top += axisHeight;
            for (int n = 0; n < this.m_numVisible; ++n) {
                if (n >= 1) {
                    top += buffer;
                }
                Wrapper w = this.m_list.get(n);
                int sectionHeight = (int)((double)pixForPlots * w.SizeWeight / sumWeight);
                if (this.m_labelVisible) {
                    w.Label.setBounds(axisWidth, top, mainWidth, labelHeight);
                    w.Label.setVisible(true);
                    top += labelHeight;
                    sectionHeight -= labelHeight;
                }
                w.Main.setBounds(axisWidth, top, mainWidth, sectionHeight);
                w.AxisVert.setBounds(0, top, axisWidth, sectionHeight);
                w.ScrollBar.setBounds(width - scrollSize - vertColorWidth, top, scrollSize, sectionHeight);
                if (w.ColorVisible) {
                    w.ColorWidget.setBounds(width - vertColorWidth, top, vertColorWidth, sectionHeight);
                }
                w.ScrollBar.invalidate();
                w.ScrollBar.repaint();
                w.ColorWidget.setVisible(w.ColorVisible);
                top += sectionHeight;
            }
            this.m_scrollBarHorz.setBounds(axisWidth, top, mainWidth, scrollSize);
            this.m_scrollBarHorz.setVisible(true);
            this.m_scrollBarHorz.repaint();
            this.m_scrollBarHorz.invalidate();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleJava2DWidgetPaintEvent(Java2D_Widget widget, boolean imagePainted) {
        try {
            if (this.m_list.get((int)0).Main == widget) {
                Wrapper w = this.m_list.get(0);
                double left = w.Transform.actualLeft();
                double right = w.Transform.actualRight();
                this.m_axisX.setRange(left, right);
                this.m_axisX.repaint();
                this.m_axisX.invalidate();
                this.m_scrollBarHorz.Technique = w.Main.transform().technique();
                if (w.Main.rangeX().rangeValid()) {
                    this.m_scrollBarHorz.setValues(w.Main.rangeX().rangeMin(), w.Main.rangeX().rangeMax(), w.Main.transform().actualLeft(), w.Main.transform().actualRight());
                }
            }
            for (int n = 0; n < this.m_numVisible; ++n) {
                Wrapper w = this.m_list.get(n);
                if (w.Main != widget) continue;
                double top = w.Transform.actualTop();
                double bottom = w.Transform.actualBottom();
                w.AxisVert.setRange(top, bottom);
                if (!w.ColorVisible) continue;
                w.ColorWidget.repaintScale();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            for (Wrapper wrapper : this.m_list) {
                if (sender != wrapper.MouseUEC) continue;
                wrapper.Main.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        try {
            this.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    public class Wrapper {
        public Java2D_Widget Main;
        public Java2D_YAxisWidget AxisVert = new Java2D_YAxisWidget();
        public Java2D_ScrollBar ScrollBar;
        public Java2D_Transform Transform;
        public JLabel Label = new JLabel("Ensemble description", 0);
        public Java2D_VerticalColorCompositeWidget ColorWidget;
        public Java2D_UserEventConsumer_MouseoverInfo MouseUEC = null;
        public Java2D_UserEventConsumer_Rectangle Zoomer = new Java2D_UserEventConsumer_Rectangle();
        public int Top = 0;
        public int Bottom = 0;
        public int Height = 0;
        public double SizeWeight = 1.0;
        public boolean ColorVisible = true;
        public Java2D_Paintable_AxisLines TimeLines = new Java2D_Paintable_AxisLines();

        public void setVisible(boolean visible, boolean labelVisible) {
            this.Main.setVisible(visible);
            this.Label.setVisible(visible && labelVisible);
            this.ScrollBar.setVisible(visible);
            this.AxisVert.setVisible(visible);
            this.ColorWidget.setVisible(visible && this.ColorVisible);
        }
    }
}

