/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D;

import com.PecosCore.Shared.ExceptionMonitor;
import java.awt.Color;
import java.awt.Graphics2D;

public class Java2D_EnsembleColorArray {
    protected Color[] m_arrayPos;
    protected Color[] m_arrayNeg;
    protected int m_indexMax;
    protected float m_max = 1.0f;
    protected float m_scalar;
    protected static Java2D_EnsembleColorArray m_singleton = null;
    protected static Java2D_EnsembleColorArray m_singletonGrayScale = null;

    public static Java2D_EnsembleColorArray singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new Java2D_EnsembleColorArray();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Java2D_EnsembleColorArray singletonGrayScale() {
        try {
            if (m_singletonGrayScale == null) {
                m_singletonGrayScale = new Java2D_EnsembleColorArray();
                m_singletonGrayScale.setGrayScale();
            }
            return m_singletonGrayScale;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Java2D_EnsembleColorArray() {
        try {
            int num = 52;
            this.m_arrayPos = new Color[num];
            this.m_arrayNeg = new Color[num];
            for (int n = 0; n < num; ++n) {
                int a = 255 - 5 * n;
                this.m_arrayPos[n] = new Color(a, a, 255);
                this.m_arrayNeg[n] = new Color(255, a, a);
            }
            this.m_indexMax = this.m_arrayPos.length - 1;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setGrayScale() {
        try {
            int num = 127;
            this.m_arrayPos = new Color[num];
            this.m_arrayNeg = new Color[num];
            for (int n = 0; n < num; ++n) {
                int a = 127 - n;
                this.m_arrayPos[n] = new Color(a, a, a);
                this.m_arrayNeg[n] = new Color(255 - a, 255 - a, 255 - a);
            }
            this.m_indexMax = this.m_arrayPos.length - 1;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setScaleMax(float max) {
        try {
            this.m_max = Math.max(max, 1.0E-20f);
            this.m_scalar = (float)this.m_arrayNeg.length / this.m_max;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setColor(Graphics2D g2d, float v) {
        try {
            if (v >= 0.0f) {
                int index = (int)(v * this.m_scalar);
                index = Math.min(index, this.m_indexMax);
                index = Math.max(index, 0);
                g2d.setColor(this.m_arrayPos[index]);
            } else {
                v = -v;
                int index = (int)(v * this.m_scalar);
                index = Math.min(index, this.m_indexMax);
                index = Math.max(index, 0);
                g2d.setColor(this.m_arrayNeg[index]);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

