/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Ensemble;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_Strings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class Java2D_EnsembleHeaderDisplayWidget
extends JPanel
implements MouseListener,
ActionListener {
    protected PlotType m_plotType = PlotType.Text;
    protected static final Font m_labelFont = new Font("SansSerif", 0, 9);
    protected static final Font m_valueFont = new Font("SansSerif", 0, 12);
    protected static final Color m_oddRowTextColor = new Color(0, 0, 0);
    protected static final Color m_evenRowTextColor = new Color(0, 0, 0);
    protected static final Color m_validHeaderTextColor = new Color(0, 0, 255);
    protected static final Color m_invalidHeaderTextColor = new Color(255, 0, 0);
    protected static final Color m_backgroundColor = new Color(240, 240, 255);
    protected static final Color m_dividingLineColor = new Color(200, 200, 200);
    protected static final Color m_selectedColor = new Color(44, 255, 44);
    public int StartX = 0;
    public int PixPerRow = 24;
    protected int m_numberOfRowsVisible = 2;
    protected Range_Double m_range = new Range_Double();
    protected EnsembleHeaderDictionary m_dictionary = null;
    protected Ensemble m_ensemble = null;
    protected String[] m_tableName = new String[12];
    protected String[] m_columnName = new String[12];
    protected ParameterTree m_paramTree;
    protected OverlapManager m_overlapManager = new OverlapManager();
    protected JPopupMenu m_popupMenu = null;
    protected int m_popopRow = 0;

    public Java2D_EnsembleHeaderDisplayWidget() {
        try {
            this.addMouseListener(this);
            for (int n = 0; n < this.m_tableName.length; ++n) {
                this.m_tableName[n] = "Trace";
                this.m_columnName[n] = "Offset";
            }
            this.m_tableName[1] = "Shot";
            this.m_columnName[1] = "Easting";
            this.m_tableName[2] = "Shot";
            this.m_columnName[2] = "Northing";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setParameterTree(ParameterTree pt) {
        try {
            this.m_paramTree = pt;
            for (int n = 0; n < this.m_tableName.length; ++n) {
                this.m_tableName[n] = this.m_paramTree.string_get(Pecos.getHeaderLabel_Table(n), "Trace");
                this.m_columnName[n] = this.m_paramTree.string_get(Pecos.getHeaderLabel_Column(n), "Offset");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setTableColumn(int index, String table, String column) {
        try {
            this.m_tableName[index] = table;
            this.m_columnName[index] = column;
            if (this.m_paramTree != null) {
                this.m_paramTree.string_put(Pecos.getHeaderLabel_Table(index), table);
                this.m_paramTree.string_put(Pecos.getHeaderLabel_Column(index), column);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int totalHeight() {
        return this.m_numberOfRowsVisible * this.PixPerRow;
    }

    public int rowCount() {
        return this.m_numberOfRowsVisible;
    }

    public void setNumRows(int numRows) {
        try {
            this.m_numberOfRowsVisible = Math.max(numRows, 0);
            this.m_numberOfRowsVisible = Math.min(this.m_numberOfRowsVisible, this.m_tableName.length);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block5: {
            try {
                if (!(e.getSource() instanceof MenuItem)) break block5;
                MenuItem mi = (MenuItem)e.getSource();
                this.m_tableName[this.m_popopRow] = mi.Table;
                this.m_columnName[this.m_popopRow] = mi.Column;
                if (this.m_paramTree != null) {
                    try {
                        this.m_paramTree.string_put(Pecos.getHeaderLabel_Table(this.m_popopRow), mi.Table);
                        this.m_paramTree.string_put(Pecos.getHeaderLabel_Column(this.m_popopRow), mi.Column);
                    }
                    catch (Exception error) {
                        error.printStackTrace();
                    }
                }
                this.repaint();
                return;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }

    public void setEnsemble(Ensemble ensemble) {
        try {
            this.m_ensemble = ensemble;
            if (this.m_ensemble != null) {
                if (this.m_dictionary == null) {
                    this.m_dictionary = this.m_ensemble.dictionary().createExactCopy();
                    this.m_popupMenu = null;
                }
                if (!ensemble.dictionary().compare(this.m_dictionary)) {
                    this.m_dictionary = this.m_ensemble.dictionary().createExactCopy();
                    this.m_popupMenu = null;
                }
            }
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            Graphics2D g2d = (Graphics2D)g;
            Dimension size = this.getSize();
            g2d.setColor(m_backgroundColor);
            g2d.fillRect(0, 0, size.width, size.height);
            g2d.setColor(m_dividingLineColor);
            g2d.drawLine(this.StartX, 0, this.StartX, size.height);
            if (this.m_ensemble == null) {
                return;
            }
            if (!this.m_ensemble.dictionary().compare(this.m_dictionary)) {
                this.m_dictionary = this.m_ensemble.dictionary().createExactCopy();
                this.m_popupMenu = null;
            }
            if (this.m_ensemble.dictionary().containsEntry("Trace", "ShotID") && this.m_ensemble.dictionary().containsEntry("Trace", "ReceiverID")) {
                int indexShotID = this.m_ensemble.dictionary().getEntryIndex("Trace", "ShotID");
                int indexRecID = this.m_ensemble.dictionary().getEntryIndex("Trace", "ReceiverID");
                for (int k = 0; k < this.m_ensemble.traceCount(); ++k) {
                    boolean selected;
                    EnsembleTrace t = this.m_ensemble.trace(k);
                    int recID = t.header().getInt(indexRecID);
                    int shotID = t.header().getInt(indexShotID);
                    int pixel = t.PlotData.PixelX + this.StartX;
                    boolean bl = selected = recID == Messenger.receiverID() && shotID == Messenger.shotID();
                    if (!selected || !t.PlotData.Visible || pixel < 0 || pixel >= size.width) continue;
                    g2d.setColor(m_selectedColor);
                    g2d.fillRect(pixel - 4, 0, 9, size.height);
                }
            }
            this.m_numberOfRowsVisible = size.height / this.PixPerRow;
            this.m_numberOfRowsVisible = Math.min(this.m_numberOfRowsVisible, this.m_tableName.length);
            for (int n = 0; n < this.m_numberOfRowsVisible; ++n) {
                int top = n * this.PixPerRow;
                int bottom = top + this.PixPerRow;
                if (n % 2 == 0) {
                    g2d.setColor(m_evenRowTextColor);
                } else {
                    g2d.setColor(m_oddRowTextColor);
                }
                this.m_overlapManager.clear();
                this.m_overlapManager.add(-99999, this.StartX);
                int pixy = bottom - 2;
                boolean headerOK = false;
                if (this.m_dictionary.containsEntry(this.m_tableName[n], this.m_columnName[n])) {
                    headerOK = true;
                    double range = 100.0;
                    if (Tools_Ensemble.computeTraceHeaderRange(this.m_range, this.m_ensemble, this.m_tableName[n], this.m_columnName[n])) {
                        this.m_range.addPercentBuffer(5.0);
                        range = this.m_range.range();
                        range = Math.max(range, 1.1);
                    }
                    g2d.setFont(m_valueFont);
                    int index = this.m_dictionary.getEntryIndex(this.m_tableName[n], this.m_columnName[n]);
                    for (int k = 0; k < this.m_ensemble.traceCount(); ++k) {
                        int right;
                        EnsembleTrace t = this.m_ensemble.trace(k);
                        int pixel = t.PlotData.PixelX + this.StartX;
                        if (!t.PlotData.Visible || pixel < 0 || pixel >= size.width) continue;
                        double headerValue = t.header().getDouble(index);
                        String s = Tools_Strings.doubleToString(headerValue, range, true);
                        int width = g2d.getFontMetrics().stringWidth(s);
                        int left = pixel - width / 2;
                        if (this.m_overlapManager.overlaps(left - 10, (right = left + width) + 10)) continue;
                        g2d.drawString(s, left, pixy);
                    }
                }
                if (headerOK) {
                    g2d.setColor(m_validHeaderTextColor);
                } else {
                    g2d.setColor(m_invalidHeaderTextColor);
                }
                g2d.setFont(m_labelFont);
                g2d.drawString(this.m_tableName[n], 2, pixy - 10);
                g2d.drawString(this.m_columnName[n], 2, pixy);
                g2d.setColor(m_dividingLineColor);
                g2d.drawLine(0, bottom, size.width, bottom);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    protected void showPopupMenu(MouseEvent event) {
        try {
            if (this.m_ensemble == null) {
                return;
            }
            if (this.m_dictionary == null) {
                return;
            }
            if (this.m_popupMenu == null) {
                this.m_popupMenu = new JPopupMenu();
                ArrayList<String> tables = this.m_dictionary.getListOfTableNames();
                for (String table : tables) {
                    JMenu menu = new JMenu(table);
                    this.m_popupMenu.add(menu);
                    JMenu menuDT = new JMenu("Delay time data");
                    menu.add(menuDT);
                    JMenu menuStatics = new JMenu("Statics");
                    menu.add(menuStatics);
                    ArrayList<String> columns = this.m_dictionary.getListOfColumnNames(table);
                    for (String column : columns) {
                        MenuItem item = new MenuItem(table, column);
                        item.setText(column);
                        item.addActionListener(this);
                        if (column.startsWith("DTA_")) {
                            menuDT.add(item);
                            continue;
                        }
                        if (column.startsWith("STATICS_")) {
                            menuStatics.add(item);
                            continue;
                        }
                        menu.add(item);
                    }
                }
            }
            this.m_popopRow = event.getY() / this.PixPerRow;
            this.m_popupMenu.show(event.getComponent(), event.getX(), event.getY());
            this.m_popupMenu.setVisible(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            this.showPopupMenu(event);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    public static enum PlotType {
        Text,
        Plot;

    }

    protected class OverlapManager {
        protected int[] m_pixelLeft = new int[120];
        protected int[] m_pixelRight = new int[120];
        protected int m_count = 0;

        protected OverlapManager() {
        }

        public void clear() {
            this.m_count = 0;
        }

        public void add(int left, int right) {
            if (this.m_count >= this.m_pixelLeft.length) {
                return;
            }
            this.m_pixelLeft[this.m_count] = left;
            this.m_pixelRight[this.m_count] = right;
            ++this.m_count;
        }

        public boolean overlaps(int left, int right) {
            try {
                for (int n = 0; n < this.m_count; ++n) {
                    if (left > this.m_pixelRight[n] || right < this.m_pixelLeft[n]) continue;
                    return true;
                }
                this.add(left, right);
                return false;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return true;
            }
        }
    }

    protected static class MenuItem
    extends JMenuItem {
        public String Table = "";
        public String Column = "";

        public MenuItem(String tbl, String col) {
            this.Table = tbl;
            this.Column = col;
        }
    }
}

