/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Ensemble;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Ensemble_Wiggles;
import com.PecosLibrary.Windows.Shared.ParameterTreeWidgetManager;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Java2D_EnsembleDisplayOptionsWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener {
    protected JCheckBox m_fillPosCheck = new JCheckBox("Fill positive");
    protected JButton m_posColorButton;
    protected Color m_posColor = Color.BLACK;
    protected JCheckBox m_fillNegCheck = new JCheckBox("Fill negative");
    protected JButton m_negColorButton;
    protected Color m_negColor = Color.RED;
    protected JCheckBox m_individualScalingCheck = new JCheckBox("Individual trace amplitude scaling");
    protected JCheckBox m_clippingCheck = new JCheckBox("Apply");
    protected JTextField m_overlapText = new JTextField("2");
    protected JTextField m_clipText = new JTextField("2");
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected JCheckBox m_showAllCheck = new JCheckBox("Display all traces, including killed");
    protected JRadioButton m_radShowAllTraces = new JRadioButton("Show all traces");
    protected JRadioButton m_radNoOverlap = new JRadioButton("Do not display overlapping traces");
    protected ButtonGroup m_buttonGroup = new ButtonGroup();
    protected JTextField m_textOverlapLimit = new JTextField("3");
    protected ParameterTreeWidgetManager m_paramManager = new ParameterTreeWidgetManager();

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public void setOverlapAndClip(double overlap, double clip) {
        try {
            this.m_overlapText.setText(Double.toString(overlap));
            this.m_clipText.setText(Double.toString(clip));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Java2D_EnsembleDisplayOptionsWidget(String label) {
        super(LinearLayoutWidget.Direction.Vertical, 0, "Wiggle display options");
        try {
            LinearLayoutWidget sub = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            sub.addComponent(this.m_fillPosCheck, 0);
            this.m_fillPosCheck.setSelected(true);
            this.m_fillPosCheck.addActionListener(this);
            this.m_posColorButton = Tools_Bitmap.makeButton(sub, BitmapEnum.Color, "Select positive color", (ActionListener)this);
            sub.addStretch(10);
            sub.addComponent(this.m_fillNegCheck, 0);
            this.m_fillNegCheck.setSelected(false);
            this.m_fillNegCheck.addActionListener(this);
            this.m_negColorButton = Tools_Bitmap.makeButton(sub, BitmapEnum.Color, "Select negative color", (ActionListener)this);
            sub = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            sub.addComponent(new JLabel("Overlap"), 0);
            sub.addComponent(this.m_overlapText, 10);
            sub.addComponent(new JLabel("clip limit"), 0);
            sub.addComponent(this.m_clipText, 10);
            sub.addComponent(this.m_clippingCheck, 0);
            this.m_clipText.addActionListener(this);
            this.m_overlapText.addActionListener(this);
            this.m_clippingCheck.addActionListener(this);
            this.m_clippingCheck.setSelected(true);
            this.addComponent(this.m_individualScalingCheck, 0);
            this.m_individualScalingCheck.addActionListener(this);
            this.m_individualScalingCheck.setSelected(true);
            this.addComponent(this.m_showAllCheck, 0);
            this.m_showAllCheck.addActionListener(this);
            this.m_showAllCheck.setSelected(false);
            LinearLayoutWidget vis = this.createVertical(0, "Select visible traces", 0);
            vis.addComponent(this.m_radShowAllTraces, 0);
            vis.addComponent(this.m_radNoOverlap, 0);
            this.m_radShowAllTraces.addActionListener(this);
            this.m_buttonGroup.add(this.m_radShowAllTraces);
            this.m_radNoOverlap.addActionListener(this);
            this.m_buttonGroup.add(this.m_radNoOverlap);
            this.m_radShowAllTraces.setSelected(true);
            vis.addHorzPair(new JLabel("Overlap limit, pixels"), 0, this.m_textOverlapLimit, 10);
            this.m_textOverlapLimit.addActionListener(this);
            this.m_textOverlapLimit.setEnabled(this.m_radNoOverlap.isSelected());
            if (label == null) {
                this.addStretch(10);
            }
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            this.m_paramManager.addCheckBoxConnector("IndividualScaling", this.m_individualScalingCheck, true);
            this.m_paramManager.addCheckBoxConnector("FillNeg", this.m_fillNegCheck, false);
            this.m_paramManager.addCheckBoxConnector("FillPos", this.m_fillPosCheck, true);
            this.m_paramManager.addCheckBoxConnector("ApplyClip", this.m_clippingCheck, true);
            this.m_paramManager.addCheckBoxConnector("ShowAll", this.m_showAllCheck, false);
            this.m_paramManager.addTextFieldConnector("PixelLimit", this.m_textOverlapLimit, "5");
            this.m_paramManager.addTextFieldConnector("Overlap", this.m_overlapText, "2.0");
            this.m_paramManager.addTextFieldConnector("Clip", this.m_clipText, "2.0");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    public void setIndividualScaling(boolean individ) {
        try {
            this.m_individualScalingCheck.setSelected(individ);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setParentParameterTree(ParameterTree parentTree) {
        try {
            this.m_paramManager.setTree(parentTree.ParameterTree_get("WiggleOptions"));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void saveParameters() {
        try {
            this.m_paramManager.saveParameters();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setNoOverlap() {
        try {
            this.m_radNoOverlap.setSelected(true);
            this.m_textOverlapLimit.setEnabled(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setFill(boolean fillNeg, boolean fillPos) {
        this.m_fillNegCheck.setSelected(fillNeg);
        this.m_fillPosCheck.setSelected(fillPos);
    }

    public void setClippingState(boolean on) {
        try {
            this.m_clippingCheck.setSelected(on);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void prepPainter(Java2D_Paintable_Ensemble_Wiggles po) {
        try {
            po.ApplyClipping = this.m_clippingCheck.isSelected();
            po.WiggleClipping = (float)Tools_Widget.extractDouble(this.m_clipText, 1.2, 1.0, 20.0);
            po.WiggleOverlap = (float)Tools_Widget.extractDouble(this.m_overlapText, 1.2, 0.5, 20.0);
            po.IndividualTraceAmplitudeScaling = this.m_individualScalingCheck.isSelected();
            po.FillPositiveWiggle = this.m_fillPosCheck.isSelected();
            po.PositiveColor = this.m_posColor;
            po.FillNegativeWiggle = this.m_fillNegCheck.isSelected();
            po.NegativeColor = this.m_negColor;
            po.DrawKilledTraces = this.m_showAllCheck.isSelected();
            po.DrawOverlappingTraces = this.m_radShowAllTraces.isSelected();
            po.PixelOverlapLimit = Tools_Widget.extractInteger(this.m_textOverlapLimit, 5, 2, 20);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setFillColors(Color pos, Color neg) {
        try {
            this.m_negColor = neg;
            this.m_posColor = pos;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Color c;
            if (e.getSource() == this.m_negColorButton) {
                c = JColorChooser.showDialog(this, "Select negative color", this.m_negColor);
                if (c == null) {
                    return;
                }
                this.m_negColor = c;
            }
            if (e.getSource() == this.m_posColorButton) {
                c = JColorChooser.showDialog(this, "Select positive color", this.m_posColor);
                if (c == null) {
                    return;
                }
                this.m_posColor = c;
            }
            this.m_textOverlapLimit.setEnabled(this.m_radNoOverlap.isSelected());
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

