/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Geometry.TableParserConflict;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.DatabaseEnum;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.JDBC.DuplicateEntryWidget;
import com.PecosLibrary.Windows.JDBC.ElementTableBaseWidget;
import com.PecosLibrary.Windows.JDBC.SimpleTablePlotterWidget;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class TableWrapperWidget
extends JTabbedPane {
    public String m_tableName;
    protected DatabaseEnum m_whichDatabase;
    protected boolean m_shotOrRecTable = false;
    protected ElementTableBaseWidget m_tableWidget;
    protected SimpleTablePlotterWidget m_plotWidget;
    protected IDatabaseConnection m_db;
    protected DuplicateEntryWidget m_duplicate;

    public TableWrapperWidget(IDatabaseConnection db, String tableName, DatabaseEnum whichDatabase) {
        try {
            this.m_db = db;
            this.m_tableName = tableName;
            this.m_shotOrRecTable = tableName.equalsIgnoreCase("Shot") || tableName.equalsIgnoreCase("Receiver");
            this.m_tableWidget = new ElementTableBaseWidget(this.m_db, this.m_tableName, whichDatabase);
            this.m_plotWidget = new SimpleTablePlotterWidget(this.m_db, this.m_tableName, whichDatabase);
            this.m_duplicate = new DuplicateEntryWidget(this.m_db, this.m_tableName, whichDatabase);
            this.addTab("Table", this.m_tableWidget);
            if (this.m_shotOrRecTable && DatabaseEnum.Geometry == whichDatabase) {
                this.addTab("Import conflicts", this.createConflict(tableName));
            }
            this.addTab("Crossplots", this.m_plotWidget);
            this.addTab("Duplicate entries", this.m_duplicate);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public TableWrapperWidget(IDatabaseConnection db, DatabaseEnum whichDatabase) {
        try {
            this.m_db = db;
            this.m_tableName = " ";
            this.m_tableWidget = new ElementTableBaseWidget(this.m_db, this.m_tableName, whichDatabase);
            this.m_plotWidget = new SimpleTablePlotterWidget(this.m_db, this.m_tableName, whichDatabase);
            this.m_duplicate = new DuplicateEntryWidget(this.m_db, this.m_tableName, whichDatabase);
            this.addTab("Table", this.m_tableWidget);
            this.addTab("Crossplots", this.m_plotWidget);
            this.addTab("Duplicate entries", this.m_duplicate);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected TableWrapperWidget() {
        try {
            this.m_db = null;
            this.m_tableName = " ";
            this.m_shotOrRecTable = false;
            this.m_tableWidget = null;
            this.m_plotWidget = null;
            this.m_duplicate = null;
            this.addTab("Table", this.m_tableWidget);
            this.addTab("Crossplots", this.m_plotWidget);
            this.addTab("Duplicate entries", this.m_duplicate);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static TableWrapperWidget createEmptyWidget(DatabaseEnum whichDatabase) {
        try {
            TableWrapperWidget widget = new TableWrapperWidget();
            return widget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void replaceElementTableWidget(DatabaseEnum whichDatabase) {
        try {
            this.m_tableWidget = new ElementTableBaseWidget(this.m_db, this.m_tableName, whichDatabase);
            this.setComponentAt(0, this.m_tableWidget);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createConflict(String tableName) {
        try {
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            HashMap_Integers<TableParserConflict> conflict = null;
            conflict = tableName.equalsIgnoreCase("Shot") ? RefractionStaticsProject.singleton().shotConflicts() : RefractionStaticsProject.singleton().receiverConflicts();
            int num = conflict.size();
            if (num < 1) {
                w.addComponent(new JLabel("There were no import geometry conflicts"), 0);
            } else {
                w.addComponent(new JLabel(String.format("There were %d import geometry conflicts", num)), 0);
            }
            JTree tree = new JTree();
            w.addComponent(new JScrollPane(tree), 10);
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
            DefaultTreeModel model = new DefaultTreeModel(root);
            if (num < 1) {
                tree.setModel(model);
                return w;
            }
            ArrayList<TableParserConflict> vals = conflict.getValues();
            tree.setRootVisible(false);
            for (TableParserConflict con : vals) {
                String s = String.format("ID: %d Line: %d Point: %d Index: %d ", con.ID, con.Line, con.Point, con.Index);
                DefaultMutableTreeNode entryNode = new DefaultMutableTreeNode(s);
                root.add(entryNode);
                ArrayList<TableParserConflict.ConflictColumn> cols = con.Columns;
                for (TableParserConflict.ConflictColumn column : cols) {
                    s = String.format("%s, first value = %f", column.Name, Float.valueOf((float)column.InitialValue));
                    DefaultMutableTreeNode columnNode = new DefaultMutableTreeNode(s);
                    entryNode.add(columnNode);
                }
            }
            tree.setModel(model);
            return w;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return new JLabel();
        }
    }
}

