/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.ApplicationFrames.INumberedWidget;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class OutlierMeasurementWidget
extends JSplitPane
implements INumberedWidget,
ActionListener,
GenericObjectListener.Listener,
Messenger.Listener,
ItemListener,
ISaveableFrame {
    protected Table_Abstract m_shotTable = null;
    protected Java2D_Paintable_Table m_shotPaintable = null;
    protected Table_Abstract m_receiverTable = null;
    protected Java2D_Paintable_Table m_receiverPaintable = null;
    protected Grid3D m_grid3D;
    protected JButton m_reloadVersionsButton;
    protected ComboStringListWrapper m_comboCol1 = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboVer1 = new ComboStringListWrapper();
    protected JButton m_reloadColumnsButton1;
    protected JTextField m_textRadius = new JTextField("500");
    protected JCheckBox m_chkUseShots = new JCheckBox("Use shots to compute smoothed grid");
    protected JCheckBox m_chkUseRecs = new JCheckBox("Use receivers to compute smoothed grid");
    protected JTextField m_textMinValid = new JTextField("0");
    protected JButton m_reloadPlotButton;
    protected JCheckBox m_chkShowSrc = new JCheckBox("Display source outliers");
    protected JCheckBox m_chkShowRec = new JCheckBox("Display receiver outliers");
    protected JCheckBox m_chkExport = new JCheckBox("Save outliers in database");
    protected JTextField m_textExportName = new JTextField("");
    protected Java2D_SimpleComposite m_plotWidget = new Java2D_SimpleComposite(true);
    protected JLabel m_plotLabel = new JLabel(" ", 0);
    protected JComboBox<String> m_mouseCombo = new JComboBox();
    protected MouseMode m_mouseMode = MouseMode.Shot;
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC;
    protected int m_widgetNumber = 1;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.JDBC.OutlierMeasurementWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Outliers";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Outliers";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return false;
    }

    public OutlierMeasurementWidget() {
        super(1);
        try {
            this.setRightComponent(this.centralWidget());
            this.setLeftComponent(this.createMainWidget());
            this.m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
            this.m_leftClickUEC.addListener(this);
            this.m_comboVer1.setPreferredSelected(RefractionStaticsProject.singleton().versionName());
            this.reloadVersions();
            this.reloadColumns1();
            Messenger.singleton().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public int getWidgetNumber() {
        return this.m_widgetNumber;
    }

    @Override
    public void setWidgetNumber(int number) {
        this.m_widgetNumber = number;
    }

    protected JComponent centralWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            Tools_FontChanger.changeSizeOfFont(this.m_plotLabel, 4);
            this.m_plotLabel.setForeground(Color.blue);
            main.addComponent(this.m_plotLabel, 0);
            main.addComponent(this.m_plotWidget, 10);
            this.m_plotWidget.setThreeColors(Color.red, new Color(250, 250, 250), Color.blue);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createMainWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_reloadVersionsButton = main.createButton("Reload list of versions", this, 0);
            main.createGapLabel(20);
            this.m_reloadColumnsButton1 = new JButton("Reload list of columns");
            this.m_reloadColumnsButton1.addActionListener(this);
            this.m_comboCol1.listener().addListener(this);
            this.m_comboVer1.listener().addListener(this);
            GridLayoutWidget grid = main.createGridLayoutWidget(3, null, 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Version:"), this.m_comboVer1);
            grid.addSimple(row++, new JLabel("Name:"), this.m_comboCol1);
            grid.addSimple(row++, new JLabel(" "), this.m_reloadColumnsButton1);
            grid.addSimple(row++, new JLabel("Smooth radius"), this.m_textRadius);
            grid.addSimple(row++, new JLabel("Minimum valid value"), this.m_textMinValid);
            grid.addComponent(this.m_chkUseShots, row++, 0, 0.0, 1.0, 1, 2);
            grid.addComponent(this.m_chkUseRecs, row++, 0, 0.0, 1.0, 1, 2);
            this.m_chkUseShots.setSelected(true);
            this.m_chkUseRecs.setSelected(true);
            main.createGapLabel(20);
            LinearLayoutWidget sub = main.createVertical(3, "Analysis", 0);
            this.m_reloadPlotButton = sub.createButton("Perform analysis", this, 0);
            sub.addComponent(this.m_chkExport, 0);
            sub.addComponent(new JLabel("Name of database column:"), 0);
            sub.addComponent(this.m_textExportName, 0);
            this.m_chkExport.setSelected(false);
            this.m_textExportName.setEnabled(false);
            this.m_chkExport.addActionListener(this);
            main.createGapLabel(20);
            this.m_chkShowSrc.setSelected(true);
            this.m_chkShowRec.setSelected(true);
            main.addComponent(this.m_chkShowSrc, 0);
            main.addComponent(this.m_chkShowRec, 0);
            LinearLayoutWidget mouse = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "Mouse mode", 0);
            for (MouseMode m : MouseMode.values()) {
                this.m_mouseCombo.addItem(m.Description);
            }
            this.m_mouseCombo.addItemListener(this);
            this.m_mouseCombo.setSelectedIndex(0);
            mouse.addComponent(this.m_mouseCombo, 0);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    protected void reloadVersions() {
        try {
            ArrayList<String> versionList = RefractionStaticsProject.singleton().versionList();
            this.m_comboVer1.setStringArray(versionList);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadMouse() {
        try {
            Java2D_Widget w = this.m_plotWidget.mainWidget();
            w.clearEventConsumerList();
            w.addZoomer();
            w.addEventConsumer(this.m_leftClickUEC);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void addTableToGrid(Table_Abstract table, Grid3D grid, String colName1) {
        try {
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_indexOfColumn(colName1);
            for (int r = 0; r < table.row_count(); ++r) {
                double x = table.getDouble(r, indexX);
                double y = table.getDouble(r, indexY);
                double v = table.getDouble(r, indexV);
                grid.interp_Add(x, y, (float)v, 1.0f);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void subtractGrid(Table_Abstract table, Grid3D grid, String colName1) {
        try {
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_indexOfColumn(colName1);
            for (int r = 0; r < table.row_count(); ++r) {
                double x = table.getDouble(r, indexX);
                double y = table.getDouble(r, indexY);
                double v = table.getDouble(r, indexV);
                double gridValue = grid.getNearestValue(x, y);
                double outlier = v - gridValue;
                table.putDouble(r, indexV, outlier);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadPlot() {
        try {
            boolean okay;
            Java2D_Widget w = this.m_plotWidget.mainWidget();
            w.clearPaintableList();
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            boolean bl = okay = this.m_chkUseShots.isSelected() || this.m_chkUseRecs.isSelected();
            if (!okay) {
                w.mooz();
                return;
            }
            boolean export = this.m_chkExport.isSelected();
            String exportName = this.m_textExportName.getText();
            if (export) {
                export = false;
                if ((exportName = Tools_RefractionStaticsProject.getValidColumnName(exportName, true, true)).length() >= 1) {
                    this.m_textExportName.setText(exportName);
                    export = true;
                }
            }
            double minValid = Tools_Widget.extractDouble(this.m_textMinValid, 0.0, -9.9999999E7, 1.0E8);
            String colName1 = this.m_comboCol1.getSelectedString();
            String versionName1 = this.m_comboVer1.getSelectedString();
            IDatabaseConnection database = RefractionStaticsProject.singleton().getVersionDatabase(versionName1);
            this.m_shotTable = this.loadTable(database, "Shot", colName1, minValid);
            this.m_receiverTable = this.loadTable(database, "Receiver", colName1, minValid);
            double smoothRadius = Tools_Widget.extractDouble(this.m_textRadius, 500.0, 20.0, 10000.0);
            double smoothGridSize = smoothRadius / 5.0;
            smoothGridSize = RefractionStaticsProject.singleton().units_feet() ? Math.max(25.0, smoothGridSize) : Math.max(5.0, smoothGridSize);
            Grid3D_Conversion grid = new Grid3D_Conversion();
            grid.setBinSize(smoothGridSize, smoothGridSize);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            double bestAngle = Tools_RefractionStaticsProject.findMinimumSurveyAreaAngle(project.shotTable(), project.receiverTable());
            grid.setInlineAngle(bestAngle);
            Tools_RefractionStaticsProject.gridRange3D(grid, 2.0 * smoothGridSize);
            Grid3D smoothGrid = new Grid3D(grid);
            smoothGrid.interp_Prep(0);
            if (this.m_chkUseShots.isSelected()) {
                this.addTableToGrid(this.m_shotTable, smoothGrid, colName1);
            }
            if (this.m_chkUseRecs.isSelected()) {
                this.addTableToGrid(this.m_receiverTable, smoothGrid, colName1);
            }
            smoothGrid.interp_Finish(1, false);
            smoothGrid.smooth(3);
            this.subtractGrid(this.m_shotTable, smoothGrid, colName1);
            this.subtractGrid(this.m_receiverTable, smoothGrid, colName1);
            if (export) {
                this.exportColumn(database, colName1, exportName);
            }
            this.m_shotPaintable = this.getPainter(this.m_shotTable, colName1);
            this.m_receiverPaintable = this.getPainter(this.m_receiverTable, colName1);
            if (this.m_chkShowSrc.isSelected()) {
                w.addPaintable(this.m_shotPaintable, -9999);
            }
            if (this.m_chkShowRec.isSelected()) {
                w.addPaintable(this.m_receiverPaintable, -9999);
            }
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            this.reloadMouse();
            database = null;
            System.gc();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void exportColumn(IDatabaseConnection database, String inputColumn, String exportName) {
        try {
            RefractionStaticsProject.singleton().shotTable().column_append(exportName, DataType.Double);
            this.m_shotTable.column_append(exportName, DataType.Double);
            database.addColumn("Shot", exportName, DataType.Double);
            RefractionStaticsProject.singleton().receiverTable().column_append(exportName, DataType.Double);
            this.m_receiverTable.column_append(exportName, DataType.Double);
            database.addColumn("Receiver", exportName, DataType.Double);
            String sql = String.format("UPDATE SHOT SET %s = -9999999", exportName);
            database.executeUpdateStatement(sql);
            sql = String.format("UPDATE RECEIVER SET %s = -9999999", exportName);
            database.executeUpdateStatement(sql);
            this.m_receiverTable.column_copy_double(inputColumn, exportName);
            this.m_shotTable.column_copy_double(inputColumn, exportName);
            database.writeColumnContentsToDatabase(this.m_shotTable, exportName);
            database.writeColumnContentsToDatabase(this.m_receiverTable, exportName);
            Messenger.broadcast(Messenger.Message.ColumnsModified, null, null);
            RefractionStaticsProject.singleton().reloadAllData();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Table_Abstract loadTable(IDatabaseConnection database, String tableName, String columnName, double minValid) {
        try {
            String colID = tableName + "ID";
            String query = String.format("SELECT Easting, Northing, %s, %s FROM %s WHERE KILLED = FALSE AND %s > %s", columnName, colID, tableName, columnName, Double.toString(minValid));
            return database.extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected Java2D_Paintable_Table getPainter(Table_Abstract table, String colName) {
        try {
            Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
            painter.ForceSymmetricalRange = true;
            painter.FixedColor = Color.LIGHT_GRAY;
            painter.Size_Pixel = 5;
            painter.Symbol = Java2D_PointSymbol.FilledSquare;
            painter.setTable(table);
            painter.setAxisX("Easting");
            painter.setAxisY("Northing");
            painter.setAxisC(colName);
            painter.UseColorScale = true;
            return painter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadColumns1() {
        try {
            this.m_comboCol1.removeAllItems();
            String versionName = this.m_comboVer1.getSelectedString();
            IDatabaseConnection database = RefractionStaticsProject.singleton().getVersionDatabase(versionName);
            ArrayList<String> recColList = database.listOfColumnNames("Receiver");
            ArrayList<String> shotColList = database.listOfColumnNames("Shot");
            database = null;
            System.gc();
            ArrayList<String> intersection = new ArrayList<String>();
            for (String rec : recColList) {
                boolean ok = false;
                for (String shot : shotColList) {
                    if (!rec.equalsIgnoreCase(shot)) continue;
                    ok = true;
                }
                if (!ok) continue;
                intersection.add(rec);
            }
            Collections.sort(intersection);
            this.m_comboCol1.setStringArray(intersection);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.m_mouseMode = this.m_mouseCombo.getSelectedIndex() == 0 ? MouseMode.Shot : MouseMode.Receiver;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_chkExport) {
                this.m_textExportName.setEnabled(this.m_chkExport.isSelected());
                return;
            }
            if (e.getSource() == this.m_reloadVersionsButton) {
                this.reloadVersions();
                this.reloadColumns1();
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_reloadColumnsButton1) {
                this.reloadColumns1();
                return;
            }
            if (e.getSource() == this.m_reloadPlotButton) {
                this.reloadPlot();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_leftClickUEC) {
                double x = this.m_leftClickUEC.WorldX;
                double y = this.m_leftClickUEC.WorldY;
                if (this.m_receiverTable != null && this.m_mouseMode == MouseMode.Receiver && this.m_receiverTable.selectNearestSpatialPoint(x, y)) {
                    Messenger.broadcastReceiverSelected(this, this.m_receiverTable.SelectedID);
                }
                if (this.m_shotTable != null && this.m_mouseMode == MouseMode.Shot && this.m_shotTable.selectNearestSpatialPoint(x, y)) {
                    Messenger.broadcastShotSelected(this, this.m_shotTable.SelectedID);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected static enum MouseMode {
        Shot("Select shot "),
        Receiver("Select receiver");

        public final String Description;

        private MouseMode(String desc) {
            this.Description = desc;
        }
    }
}

