/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ImportOtherProjectDialog
extends JDialog
implements GenericObjectListener.Listener,
ActionListener,
ItemListener {
    protected JButton m_btnCancel = new JButton("Close");
    protected JButton m_btnInterpolate = new JButton("Import");
    protected ComboStringListWrapper m_cmbOtherProject = new ComboStringListWrapper();
    protected ComboStringListWrapper m_cmbOtherVersion = new ComboStringListWrapper();
    protected ComboStringListWrapper m_cmbOtherColumn = new ComboStringListWrapper();
    protected JCheckBox m_chkUseOtherSource = new JCheckBox("Use the sources");
    protected JCheckBox m_chkUseOtherReceiver = new JCheckBox("Use the receivers");
    protected ComboStringListWrapper m_cmbColumn = new ComboStringListWrapper();
    protected JCheckBox m_chkModifySource = new JCheckBox("Modify the sources");
    protected JCheckBox m_chkModifyReceiver = new JCheckBox("Modify the receivers");
    protected ButtonGroup m_group = new ButtonGroup();
    protected JRadioButton m_radUseNearest = new JRadioButton("Use the value of the nearest shot or receiver");
    protected JRadioButton m_radInverseSquare = new JRadioButton("Use inverse-square interpolation");
    protected JRadioButton m_radInverseFourth = new JRadioButton("Use inverse-fourth interpolation");
    protected JTextField m_txtRadius = new JTextField("1000");
    protected JProgressBar m_progress = new JProgressBar();
    protected int m_count = 0;
    protected HashMap_Integers<ArrayList<Entry>> m_hash = new HashMap_Integers();
    protected Range_Double m_rangeX = new Range_Double();
    protected Range_Double m_rangeY = new Range_Double();

    public ImportOtherProjectDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            GridLayoutWidget otherGrid = main.createGridLayoutWidget(0, "Select other project, version, and column", 0);
            int row = 0;
            otherGrid.addSimple(row++, new JLabel("Select other project"), this.m_cmbOtherProject);
            otherGrid.addSimple(row++, new JLabel("Select version"), this.m_cmbOtherVersion);
            otherGrid.addSimple(row++, new JLabel("Select column"), this.m_cmbOtherColumn);
            otherGrid.addSimple(row++, new JLabel(" "), this.m_chkUseOtherReceiver);
            otherGrid.addSimple(row++, new JLabel(" "), this.m_chkUseOtherSource);
            this.m_cmbOtherProject.listener().addListener(this);
            this.m_cmbOtherVersion.listener().addListener(this);
            this.m_cmbOtherColumn.listener().addListener(this);
            this.m_chkUseOtherSource.addActionListener(this);
            this.m_chkUseOtherReceiver.addActionListener(this);
            this.m_chkUseOtherReceiver.setSelected(true);
            this.m_chkUseOtherSource.setSelected(true);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Select column within current project", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Modify this column"), this.m_cmbColumn);
            grid.addSimple(row++, new JLabel(" "), this.m_chkModifyReceiver);
            grid.addSimple(row++, new JLabel(" "), this.m_chkModifySource);
            this.m_chkModifySource.addActionListener(this);
            this.m_chkModifyReceiver.addActionListener(this);
            this.m_chkModifySource.setSelected(true);
            this.m_chkModifyReceiver.setSelected(true);
            LinearLayoutWidget sub = main.createVertical(row, "Interpolation method", 0);
            sub.addComponent(this.m_radUseNearest, 0);
            sub.addComponent(this.m_radInverseSquare, 0);
            sub.addComponent(this.m_radInverseFourth, 0);
            sub.addHorzPair(new JLabel("Smoothing radius (ft/m)"), 0, this.m_txtRadius, 5);
            this.m_group.add(this.m_radUseNearest);
            this.m_group.add(this.m_radInverseSquare);
            this.m_group.add(this.m_radInverseFourth);
            this.m_radUseNearest.addActionListener(this);
            this.m_radInverseSquare.addActionListener(this);
            this.m_radInverseFourth.addActionListener(this);
            this.m_radUseNearest.setSelected(true);
            this.m_txtRadius.setEnabled(!this.m_radUseNearest.isSelected());
            main.addComponent(this.m_progress, 0);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnInterpolate, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnInterpolate.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getSize().width + 200, this.getSize().height);
            this.setTitle("Import data from another project");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection getDB() {
        try {
            String projectsPath = SharedApplicationData.staticsProjectPath();
            String selectedProject = this.m_cmbOtherProject.getSelectedString();
            String fullProjectPath = projectsPath + "/" + selectedProject;
            String versionContainerPath = fullProjectPath + "/Versions";
            String selectedVersion = this.m_cmbOtherVersion.getSelectedString();
            String versionPath = versionContainerPath + "/" + selectedVersion;
            String fileNameDB = versionPath + "/geometry.db";
            IDatabaseConnection db = Tools_JDBC.getConnection(false, fileNameDB);
            return db;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void interpolate() {
        try {
            Table_Abstract table;
            String sql;
            this.m_rangeX.clearRange();
            this.m_rangeY.clearRange();
            IDatabaseConnection db1 = this.database();
            IDatabaseConnection db2 = this.getDB();
            String otherColumn = this.m_cmbOtherColumn.getSelectedString();
            String column = this.m_cmbColumn.getSelectedString();
            Table_Abstract shotTableOther = null;
            Table_Abstract recTableOther = null;
            int numOther = 0;
            if (this.m_chkUseOtherReceiver.isSelected()) {
                sql = String.format("SELECT Easting, Northing, Killed, %s FROM Receiver", otherColumn);
                recTableOther = db2.extractTableDataUsingQuery("Receiver", sql, 10000000);
                this.expandRange(recTableOther);
                numOther += recTableOther.row_count();
            }
            if (this.m_chkUseOtherSource.isSelected()) {
                sql = String.format("SELECT Easting, Northing, Killed, %s FROM Shot", otherColumn);
                shotTableOther = db2.extractTableDataUsingQuery("Shot", sql, 10000000);
                this.expandRange(shotTableOther);
                numOther += recTableOther.row_count();
            }
            int num = 0;
            if (this.m_chkModifySource.isSelected()) {
                table = RefractionStaticsProject.singleton().shotTable();
                num += table.row_count();
            }
            if (this.m_chkModifyReceiver.isSelected()) {
                table = RefractionStaticsProject.singleton().receiverTable();
                num += table.row_count();
            }
            boolean BFS = num + numOther > 500;
            this.m_rangeX.addPercentBuffer(5.0);
            this.m_rangeY.addPercentBuffer(5.0);
            double rx = this.m_rangeX.range();
            double ry = this.m_rangeY.range();
            double radius = Math.sqrt(rx * ry / 400.0);
            this.m_hash.clear();
            if (BFS && recTableOther != null) {
                this.populateHash(recTableOther, this.m_hash, radius);
            }
            if (BFS && shotTableOther != null) {
                this.populateHash(shotTableOther, this.m_hash, radius);
            }
            this.m_progress.setMaximum(num);
            this.m_progress.setMinimum(num);
            this.m_count = 0;
            if (!BFS) {
                Table_Abstract table2;
                if (this.m_chkModifySource.isSelected()) {
                    table2 = RefractionStaticsProject.singleton().shotTable();
                    this.interpolateTable(table2, shotTableOther, recTableOther);
                }
                if (this.m_chkModifyReceiver.isSelected()) {
                    table2 = RefractionStaticsProject.singleton().receiverTable();
                    this.interpolateTable(table2, shotTableOther, recTableOther);
                }
            } else {
                Table_Abstract table3;
                if (this.m_chkModifySource.isSelected()) {
                    table3 = RefractionStaticsProject.singleton().shotTable();
                    this.interpolateTableBFS(table3, radius);
                }
                if (this.m_chkModifyReceiver.isSelected()) {
                    table3 = RefractionStaticsProject.singleton().receiverTable();
                    this.interpolateTableBFS(table3, radius);
                }
            }
            this.m_progress.setValue(0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void populateHash(Table_Abstract table, HashMap_Integers<ArrayList<Entry>> hash, double radius) {
        try {
            String otherColumn = this.m_cmbOtherColumn.getSelectedString();
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_indexOfColumn(otherColumn);
            int indexKilled = table.column_indexOfColumn("Killed");
            for (int r = 0; r < table.row_count(); ++r) {
                if (table.getBool(r, indexKilled)) continue;
                double x = table.getDouble(r, indexX);
                double y = table.getDouble(r, indexY);
                double v = table.getDouble(r, indexV);
                int ix = (int)(x / radius);
                int iy = (int)(y / radius);
                if (!hash.containsKey(ix, iy)) {
                    hash.put(new ArrayList(), ix, iy);
                }
                ArrayList<Entry> list = hash.get(ix, iy);
                list.add(new Entry(x, y, v));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void expandRange(Table_Abstract table) {
        try {
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexKilled = table.column_indexOfColumn("Killed");
            for (int r = 0; r < table.row_count(); ++r) {
                if (table.getBool(r, indexKilled)) continue;
                this.m_rangeX.expandRange(table.getDouble(r, indexX));
                this.m_rangeY.expandRange(table.getDouble(r, indexY));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void interpolateTableBFS(Table_Abstract table, double radius) {
        try {
            String column = this.m_cmbColumn.getSelectedString();
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_indexOfColumn(column);
            boolean useNearest = this.m_radUseNearest.isSelected();
            boolean square = this.m_radInverseSquare.isSelected();
            boolean fourth = this.m_radInverseFourth.isSelected();
            double rad = Tools_Widget.extractDouble(this.m_txtRadius, 1000.0, 10.0, 100000.0);
            double rad2 = rad * rad;
            double rad4 = rad2 * rad2;
            for (int r = 0; r < table.row_count(); ++r) {
                if (this.m_count % 10 == 0) {
                    this.m_progress.setValue(this.m_count);
                    this.m_progress.paintImmediately(0, 0, 600, 44);
                }
                ++this.m_count;
                double bestValue = 0.0;
                double sum1 = 0.0;
                double sum2 = 1.0E-60;
                double x = table.getDouble(r, indexX);
                double y = table.getDouble(r, indexY);
                int ix = (int)(x / radius);
                int iy = (int)(y / radius);
                boolean keepGoing = true;
                int d = 2;
                while (keepGoing) {
                    keepGoing = false;
                    int num = 0;
                    double minDist = Double.MAX_VALUE;
                    bestValue = 0.0;
                    sum1 = 0.0;
                    sum2 = 1.0E-60;
                    for (int ix1 = ix - d; ix1 <= ix + d; ++ix1) {
                        for (int iy1 = iy - d; iy1 <= iy + d; ++iy1) {
                            if (!this.m_hash.containsKey(ix1, iy1)) continue;
                            ArrayList<Entry> list = this.m_hash.get(ix1, iy1);
                            for (Entry e : list) {
                                ++num;
                                double dx = x - e.X;
                                double dy = y - e.Y;
                                double dist = dx * dx + dy * dy;
                                double v = e.V;
                                if (dist < minDist) {
                                    minDist = dist;
                                    bestValue = v;
                                }
                                double w = 1.0;
                                if (square) {
                                    w = rad2 / (rad2 + dist);
                                }
                                if (fourth) {
                                    w = rad4 / (rad4 + dist * dist);
                                }
                                sum1 += w * v;
                                sum2 += w;
                                ++num;
                            }
                        }
                    }
                    keepGoing = num < 500;
                    ++d;
                }
                if (square) {
                    bestValue = sum1 / sum2;
                }
                if (fourth) {
                    bestValue = sum1 / sum2;
                }
                table.putDouble(r, indexV, bestValue);
            }
            this.database().writeColumnContentsToDatabase(table, column);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void interpolateTable(Table_Abstract table, Table_Abstract shotTableOther, Table_Abstract recTableOther) {
        try {
            String otherColumn = this.m_cmbOtherColumn.getSelectedString();
            String column = this.m_cmbColumn.getSelectedString();
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_indexOfColumn(column);
            boolean useNearest = this.m_radUseNearest.isSelected();
            boolean square = this.m_radInverseSquare.isSelected();
            boolean fourth = this.m_radInverseFourth.isSelected();
            double rad = Tools_Widget.extractDouble(this.m_txtRadius, 1000.0, 10.0, 100000.0);
            double rad2 = rad * rad;
            double rad4 = rad2 * rad2;
            for (int r = 0; r < table.row_count(); ++r) {
                double w;
                double v;
                double dist;
                double dy;
                double dx;
                int row;
                int indexKilled;
                int indexV2;
                int indexY2;
                int indexX2;
                if (this.m_count % 10 == 0) {
                    this.m_progress.setValue(this.m_count);
                    this.m_progress.paintImmediately(0, 0, 600, 44);
                }
                ++this.m_count;
                double minDist = Double.MAX_VALUE;
                double bestValue = 0.0;
                double sum1 = 0.0;
                double sum2 = 1.0E-60;
                double x = table.getDouble(r, indexX);
                double y = table.getDouble(r, indexY);
                if (recTableOther != null) {
                    indexX2 = recTableOther.column_indexOfColumn("Easting");
                    indexY2 = recTableOther.column_indexOfColumn("Northing");
                    indexV2 = recTableOther.column_indexOfColumn(otherColumn);
                    indexKilled = recTableOther.column_indexOfColumn("Killed");
                    for (row = 0; row < recTableOther.row_count(); ++row) {
                        if (recTableOther.getBool(row, indexKilled)) continue;
                        dx = x - recTableOther.getDouble(row, indexX2);
                        dy = y - recTableOther.getDouble(row, indexY2);
                        dist = dx * dx + dy * dy;
                        v = recTableOther.getDouble(row, indexV2);
                        if (dist < minDist) {
                            minDist = dist;
                            bestValue = v;
                        }
                        w = 1.0;
                        if (square) {
                            w = rad2 / (rad2 + dist);
                        }
                        if (fourth) {
                            w = rad4 / (rad4 + dist * dist);
                        }
                        sum1 += w * v;
                        sum2 += w;
                    }
                }
                if (shotTableOther != null) {
                    indexX2 = shotTableOther.column_indexOfColumn("Easting");
                    indexY2 = shotTableOther.column_indexOfColumn("Northing");
                    indexV2 = shotTableOther.column_indexOfColumn(otherColumn);
                    indexKilled = shotTableOther.column_indexOfColumn("Killed");
                    for (row = 0; row < shotTableOther.row_count(); ++row) {
                        if (shotTableOther.getBool(row, indexKilled)) continue;
                        dx = x - shotTableOther.getDouble(row, indexX2);
                        dy = y - shotTableOther.getDouble(row, indexY2);
                        dist = dx * dx + dy * dy;
                        v = shotTableOther.getDouble(row, indexV2);
                        if (dist < minDist) {
                            minDist = dist;
                            bestValue = v;
                        }
                        w = 1.0;
                        if (square) {
                            w = rad2 / (rad2 + dist);
                        }
                        if (fourth) {
                            w = rad4 / (rad4 + dist * dist);
                        }
                        sum1 += w * v;
                        sum2 += w;
                    }
                }
                if (square) {
                    bestValue = sum1 / sum2;
                }
                if (fourth) {
                    bestValue = sum1 / sum2;
                }
                table.putDouble(r, indexV, bestValue);
            }
            this.database().writeColumnContentsToDatabase(table, column);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadColumns() {
        try {
            IDatabaseConnection db = this.database();
            ArrayList<Object> list = new ArrayList();
            if (this.m_chkModifyReceiver.isSelected() && this.m_chkModifySource.isSelected()) {
                list = db.listOfColumnNames("Shot", "Receiver");
            }
            if (this.m_chkModifyReceiver.isSelected() && !this.m_chkModifySource.isSelected()) {
                list = db.listOfColumnNames("Receiver");
            }
            if (!this.m_chkModifyReceiver.isSelected() && this.m_chkModifySource.isSelected()) {
                list = db.listOfColumnNames("Shot");
            }
            this.m_cmbColumn.setStringArray(list);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadOtherColumns() {
        try {
            IDatabaseConnection db = this.getDB();
            ArrayList<Object> list = new ArrayList();
            if (this.m_chkUseOtherReceiver.isSelected() && this.m_chkUseOtherSource.isSelected()) {
                list = db.listOfColumnNames("Shot", "Receiver");
            }
            if (this.m_chkUseOtherReceiver.isSelected() && !this.m_chkUseOtherSource.isSelected()) {
                list = db.listOfColumnNames("Receiver");
            }
            if (!this.m_chkUseOtherReceiver.isSelected() && this.m_chkUseOtherSource.isSelected()) {
                list = db.listOfColumnNames("Shot");
            }
            this.m_cmbOtherColumn.setStringArray(list);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadVersions() {
        try {
            String projectsPath = SharedApplicationData.staticsProjectPath();
            String selected = this.m_cmbOtherProject.getSelectedString();
            String fullProjectPath = projectsPath + "/" + selected;
            String versionContainerPath = fullProjectPath + "/Versions";
            ArrayList<String> versions = Tools_FileSystem.subdirectories(versionContainerPath, false);
            this.m_cmbOtherVersion.setStringArray(versions);
            this.reloadOtherColumns();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadProjects() {
        try {
            String currentProject = RefractionStaticsProject.singleton().name();
            String projectsPath = SharedApplicationData.staticsProjectPath();
            ArrayList<String> projects = new ArrayList<String>();
            ArrayList<String> subdirs = Tools_FileSystem.subdirectories(projectsPath, false);
            for (String subdir : subdirs) {
                boolean sameProject = subdir.equalsIgnoreCase(currentProject);
                String fullProjectPath = projectsPath + "/" + subdir;
                String descFileName = fullProjectPath + "/ProjectDescription.xml";
                if (sameProject || !Tools_FileSystem.exists_file(descFileName)) continue;
                projects.add(subdir);
            }
            this.m_cmbOtherProject.setStringArray(projects);
            this.reloadVersions();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            try {
                this.reloadProjects();
                this.reloadColumns();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_cmbOtherProject) {
                this.reloadVersions();
                return;
            }
            if (sender == this.m_cmbOtherVersion) {
                this.reloadOtherColumns();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            boolean ok1 = this.m_chkModifyReceiver.isSelected() || this.m_chkModifySource.isSelected();
            boolean ok2 = this.m_chkUseOtherReceiver.isSelected() || this.m_chkUseOtherSource.isSelected();
            this.m_btnInterpolate.setEnabled(ok2 && ok1);
            this.m_txtRadius.setEnabled(!this.m_radUseNearest.isSelected());
            if (e.getSource() == this.m_chkModifyReceiver || e.getSource() == this.m_chkModifySource) {
                this.reloadColumns();
                return;
            }
            if (e.getSource() == this.m_chkUseOtherReceiver || e.getSource() == this.m_chkUseOtherSource) {
                this.reloadOtherColumns();
                return;
            }
            if (e.getSource() == this.m_btnInterpolate) {
                this.interpolate();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class Entry {
        public double X;
        public double Y;
        public double V;

        public Entry(double x, double y, double v) {
            this.X = x;
            this.Y = y;
            this.V = v;
        }
    }
}

