/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import com.PecosLibrary.Tools.Tools_Plot;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HistogramWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener {
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected HistogramData m_data = new HistogramData();
    protected JTextField m_txtMin = new JTextField("-100");
    protected JTextField m_txtMax = new JTextField("100");
    protected JTextField m_txtCount = new JTextField("201");
    protected RadioPanel m_rad;
    protected HistPaintWidget m_widget;

    public HistogramWidget(GenericObjectListener.Listener listener) {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            if (listener != null) {
                this.m_listener.addListener(listener);
            }
            LinearLayoutWidget top = this.createHorizontal(0, null, 0);
            top.addComponent(new JLabel("Minimum value"), 0);
            top.addComponent(this.m_txtMin, 1);
            top.addComponent(new JLabel("Maximum value"), 0);
            top.addComponent(this.m_txtMax, 1);
            top.addComponent(new JLabel("Bucket count"), 0);
            top.addComponent(this.m_txtCount, 1);
            this.m_txtMin.addActionListener(this);
            this.m_txtMax.addActionListener(this);
            this.m_txtCount.addActionListener(this);
            this.m_rad = new RadioPanel(LinearLayoutWidget.Direction.Horizontal, null, "Log scale", "Linear scale");
            this.m_rad.listener().addListener(this);
            top.addComponent(this.m_rad, 1);
            top.addStretch(4);
            this.m_widget = new HistPaintWidget(this.m_data);
            this.addComponent(this.m_widget, 10);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void finish() {
        try {
            this.m_data.finish();
            this.m_widget.LinearScale = this.m_rad.getSelectedIndex() == 1;
            this.m_widget.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void prepare() {
        try {
            double min = Tools_Widget.extractDouble(this.m_txtMin, -100.0, -1.0E20, 1.0E20);
            double max = Tools_Widget.extractDouble(this.m_txtMax, 100.0, -1.0E20, 1.0E20);
            int num = Tools_Widget.extractInteger(this.m_txtCount, 201, 21, 401);
            this.m_data.prepare(min, max, num);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void add(double v) {
        this.m_data.add(v);
    }

    protected class HistogramData {
        public double Min = -100.0;
        public double Max = 100.0;
        public int[] Count = new int[201];
        public int MaxCount = 0;

        protected HistogramData() {
        }

        public void prepare(double min, double max, int num) {
            try {
                if (num != this.Count.length) {
                    num = Math.max(num, 30);
                    num = Math.min(num, 500);
                    this.Count = new int[num];
                }
                this.Min = min;
                this.Max = Math.max(max, this.Min + 0.001);
                for (int n = 0; n < this.Count.length; ++n) {
                    this.Count[n] = 0;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void add(double v) {
            try {
                if (v < this.Min || v > this.Max) {
                    return;
                }
                int index = (int)((double)this.Count.length * (v - this.Min) / (this.Max - this.Min));
                index = Math.max(0, index);
                int n = index = Math.min(index, this.Count.length - 1);
                this.Count[n] = this.Count[n] + 1;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void finish() {
            try {
                this.MaxCount = 0;
                for (int n = 0; n < this.Count.length; ++n) {
                    this.MaxCount = Math.max(this.MaxCount, this.Count[n]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected class HistPaintWidget
    extends JPanel {
        protected HistogramData m_data;
        public boolean LinearScale;

        public HistPaintWidget(HistogramData data) {
            this.m_data = new HistogramData();
            this.LinearScale = true;
            this.m_data = data;
        }

        protected void paintLog(Graphics g) {
            try {
                Dimension size = this.getSize();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(Color.WHITE);
                g2d.fillRect(0, 0, size.width, size.height);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            try {
                Dimension size = this.getSize();
                Graphics2D g2d = (Graphics2D)g;
                if (!this.LinearScale) {
                    this.paintLog(g);
                    return;
                }
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.fillRect(0, 0, size.width, size.height);
                if (this.m_data.MaxCount <= 0) {
                    return;
                }
                int rightPix = size.width - 30;
                int leftPix = 100;
                int w = rightPix - leftPix;
                if (w < 20) {
                    return;
                }
                int bottom = size.height - 50;
                int top = 20;
                int h = bottom - top;
                if (h < 20) {
                    return;
                }
                double pixPerBucket = (double)w / (double)this.m_data.Count.length;
                double alphaY = (double)h / (double)this.m_data.MaxCount;
                g2d.setColor(Color.BLUE);
                for (int n = 0; n < this.m_data.Count.length; ++n) {
                    if (this.m_data.Count[n] <= 0) continue;
                    int x = leftPix + (int)((double)n * pixPerBucket);
                    int bh = (int)((double)this.m_data.Count[n] * alphaY);
                    g2d.fillRect(x, bottom - bh, (int)(1.0 + pixPerBucket), bh);
                }
                double range = this.m_data.Max - this.m_data.Min;
                if (range < 1.0E-4) {
                    return;
                }
                double scale = (double)(w - 1) / range;
                double shift = 0.0 - scale * this.m_data.Min;
                double tick = Tools_Plot.tickMarkInterval(range, 10);
                int temp = (int)(this.m_data.Min / tick);
                g2d.setFont(Tools_FontLibrary.AxisFont);
                int stringHeight = g2d.getFontMetrics().getHeight();
                int stickTop = bottom;
                int stickBottom = stickTop + 6;
                g2d.setColor(Color.BLACK);
                g2d.drawLine(leftPix, bottom, rightPix, bottom);
                int priorRight = -99999;
                for (double v = (double)temp * tick; v < this.m_data.Max; v += tick) {
                    String s = Tools_Strings.doubleToString(v, range, true);
                    int ix = leftPix + (int)(v * scale + shift);
                    g2d.drawLine(ix, stickTop, ix, stickBottom);
                    int stringWidth = g2d.getFontMetrics().stringWidth(s);
                    int strLeft = ix - stringWidth / 2;
                    if (strLeft <= priorRight + 12) continue;
                    priorRight = ix + stringWidth / 2;
                    g2d.drawString(s, strLeft, stickBottom + stringHeight);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

