/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Geometry;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Geometry.GeometryProject_SPS;
import com.PecosLibrary.Geometry.GeometryReceiverTableWrapper;
import com.PecosLibrary.Geometry.GeometryShotTableWrapper;
import com.PecosLibrary.Windows.ASCII.AsciiImportData;
import com.PecosLibrary.Windows.Shared.MultipleFileSelectionWidget;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class SpsSegyOutputWidget
extends JSplitPane
implements GenericObjectListener.Listener,
ActionListener {
    protected GeometryProject_SPS m_project;
    protected MultipleFileSelectionWidget m_filesWidget_Segy;
    protected MultipleFileSelectionWidget m_filesWidget_Sht;
    protected MultipleFileSelectionWidget m_filesWidget_Rec;
    protected MultipleFileSelectionWidget m_filesWidget_Rel;
    protected ScrollTable m_scrollTableShot;
    protected ScrollTable m_scrollTableRec;
    protected ScrollTable m_scrollTableRel;
    protected ScrollTable m_scrollTableDupShot;
    protected ScrollTable m_scrollTableDupRec;
    protected ScrollTable m_scrollTableError;
    protected LinearLayoutWidget m_leftWidget;
    protected LinearLayoutWidget m_rightWidget;
    protected JTextField m_txtFileName = new JTextField("");
    protected JButton m_btnSingleOut;
    protected JProgressBar m_progSingle = new JProgressBar();
    protected JButton m_btnSingleStart = new JButton("Start");
    protected JLabel m_lblSingleStatus = new JLabel("  ");
    protected JLabel m_lblComments = new JLabel("  ");
    public String FailureReason = "";
    protected Table_Abstract m_shotTable;
    protected Table_Abstract m_recTable;
    protected Table_Abstract m_relationTable;
    protected GeometryShotTableWrapper m_geometryShotTableWrapper;
    protected GeometryReceiverTableWrapper m_geometryReceiverTableWrapper;
    protected HashMap_Integers<String> m_shotFileHash = new HashMap_Integers();
    protected HashMap_Integers<String> m_recFileHash = new HashMap_Integers();
    protected HashMap_Integers<String> m_relFileHash = new HashMap_Integers();
    protected double m_coordScalar = 1.0;
    protected short m_coordHeader = 0;
    protected int m_coordScalarOffset = 70;
    protected double m_elevScalar = 1.0;
    protected short m_elevHeader = 0;
    protected int m_elevScalarOffset = 68;
    protected AsciiImportData m_shotAID = null;
    protected AsciiImportData m_recAID = null;
    protected Table_Abstract m_errorTable;
    protected int m_errorIndexFileName;
    protected int m_errorIndexIndex;
    protected int m_errorIndexFFID;
    protected int m_errorIndexChan;
    protected String m_currentSegyFileName = "";
    protected int m_currentIndexInSegy = 0;
    protected int m_numBadHeaders = 0;
    protected int m_numBadFFID = 0;
    protected int m_numBadChan = 0;

    public SpsSegyOutputWidget(GeometryProject_SPS project) {
        super(1);
        try {
            this.m_project = project;
            this.m_leftWidget = LinearLayoutWidget.vert(3, null);
            this.m_rightWidget = LinearLayoutWidget.vert(3, null);
            this.createLeft();
            this.createRight();
            this.setLeftComponent(this.m_leftWidget);
            this.setRightComponent(this.m_rightWidget);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createRight() {
        try {
            LinearLayoutWidget single = this.m_rightWidget.createVertical(3, "Single file output", 0);
            single.createLabel("All input SEG-Y files combined into one output file", 2, 0);
            LinearLayoutWidget sub = single.createHorizontal(0, null, 0);
            sub.addComponent(new JLabel("Output:"), 0);
            sub.addComponent(this.m_txtFileName, 10);
            this.m_btnSingleOut = sub.createButton("Select", this, 0);
            String out = this.m_project.parameterTree().string_get("OutputFile", "");
            this.m_txtFileName.setText(out);
            GridLayoutWidget grid = single.createGridLayoutWidget(0, 0);
            grid.addSimple(0, this.m_btnSingleStart, this.m_progSingle);
            grid.addSimple(1, new JLabel(" "), this.m_lblSingleStatus);
            grid.addSimple(2, new JLabel(" "), this.m_lblComments);
            this.m_btnSingleStart.addActionListener(this);
            JTabbedPane tabs = new JTabbedPane();
            this.m_scrollTableShot = new ScrollTable();
            this.m_scrollTableRec = new ScrollTable();
            this.m_scrollTableRel = new ScrollTable();
            this.m_scrollTableDupShot = new ScrollTable();
            this.m_scrollTableDupRec = new ScrollTable();
            this.m_scrollTableError = new ScrollTable();
            tabs.addTab("Shot", this.m_scrollTableShot);
            tabs.addTab("Receiver", this.m_scrollTableRec);
            tabs.addTab("Relation", this.m_scrollTableRel);
            tabs.addTab("Duplicate shots", this.m_scrollTableDupShot);
            tabs.addTab("Duplicate receivers", this.m_scrollTableDupRec);
            tabs.addTab("Errors", this.m_scrollTableError);
            this.m_rightWidget.addComponent(tabs, 11);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createLeft() {
        try {
            JTabbedPane tabs = new JTabbedPane();
            this.m_filesWidget_Segy = new MultipleFileSelectionWidget("SEG-Y files");
            this.m_filesWidget_Segy.getListenerController().addListener(this);
            this.m_filesWidget_Segy.RequireSegy = true;
            this.m_filesWidget_Segy.ShowSegyWarning = false;
            ArrayList<String> files = this.m_project.parameterTree().stringList_get("InputFiles_Segy");
            this.m_filesWidget_Segy.setFileList(files, false);
            tabs.addTab("SEG-Y", this.m_filesWidget_Segy);
            this.m_filesWidget_Sht = new MultipleFileSelectionWidget("Shot SPS files");
            this.m_filesWidget_Sht.getListenerController().addListener(this);
            this.m_filesWidget_Sht.RequireSegy = false;
            this.m_filesWidget_Sht.ShowSegyWarning = false;
            files = this.m_project.parameterTree().stringList_get("InputFiles_Shot");
            this.m_filesWidget_Sht.setFileList(files, false);
            tabs.addTab("Shot", this.m_filesWidget_Sht);
            this.m_filesWidget_Rec = new MultipleFileSelectionWidget("Receiver SPS files");
            this.m_filesWidget_Rec.getListenerController().addListener(this);
            this.m_filesWidget_Rec.RequireSegy = false;
            this.m_filesWidget_Rec.ShowSegyWarning = false;
            files = this.m_project.parameterTree().stringList_get("InputFiles_Receiver");
            this.m_filesWidget_Rec.setFileList(files, false);
            tabs.addTab("Receiver", this.m_filesWidget_Rec);
            this.m_filesWidget_Rel = new MultipleFileSelectionWidget("Relation SPS files");
            this.m_filesWidget_Rel.getListenerController().addListener(this);
            this.m_filesWidget_Rel.RequireSegy = false;
            this.m_filesWidget_Rel.ShowSegyWarning = false;
            files = this.m_project.parameterTree().stringList_get("InputFiles_Relation");
            this.m_filesWidget_Rel.setFileList(files, false);
            tabs.addTab("Relation", this.m_filesWidget_Rel);
            this.m_leftWidget.addComponent(tabs, 10);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.m_project.parameterTree().stringList_put("InputFiles_Segy", this.m_filesWidget_Segy.fileList());
            this.m_project.parameterTree().stringList_put("InputFiles_Shot", this.m_filesWidget_Sht.fileList());
            this.m_project.parameterTree().stringList_put("InputFiles_Receiver", this.m_filesWidget_Rec.fileList());
            this.m_project.parameterTree().stringList_put("InputFiles_Relation", this.m_filesWidget_Rel.fileList());
            this.m_project.saveParameters();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String file;
            if (e.getSource() == this.m_btnSingleOut && (file = Tools_Chooser.getSaveFileName("sgy")) != null) {
                this.m_txtFileName.setText(file);
            }
            if (e.getSource() == this.m_btnSingleStart) {
                this.singleOut();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected Table_Abstract prepTable(String key, String fileListKey, String prefix, HashMap_Integers<String> fileNameHash) {
        try {
            Table_Memory table = new Table_Memory();
            ((Table_Abstract)table).setName(key);
            AsciiImportData aid = this.m_project.asciiImportData(key);
            aid.prepTable(table);
            int colFileID = ((Table_Abstract)table).column_append("FileID", DataType.Int);
            int colLineNumber = ((Table_Abstract)table).column_append("LineNumberInFile", DataType.Int);
            ArrayList<String> fileNames = this.m_project.parameterTree().stringList_get(fileListKey);
            int fileID = 1;
            for (String fileName : fileNames) {
                if (!Tools_FileSystem.exists_file(fileName)) continue;
                fileNameHash.put(fileName, fileID);
                File file = new File(fileName);
                BufferedReader br = new BufferedReader(new FileReader(fileName));
                int lineNumber = 1;
                String line = br.readLine();
                while (line != null) {
                    if (line.startsWith(prefix)) {
                        aid.addRow(table, line, 0);
                        int rc = ((Table_Abstract)table).row_count();
                        ((Table_Abstract)table).putInt(rc - 1, colFileID, fileID);
                        ((Table_Abstract)table).putInt(rc - 1, colLineNumber, lineNumber);
                    }
                    line = br.readLine();
                    ++lineNumber;
                }
                br.close();
                ++fileID;
            }
            System.out.println(String.format("Entries for %s = %d", key, ((Table_Abstract)table).row_count()));
            return table;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void prepScalars() {
        try {
            int coordScalarIndex = this.m_project.parameterTree().int_get("CoordScalar", 0);
            int elevScalarIndex = this.m_project.parameterTree().int_get("ElevScalar", 0);
            this.m_elevScalar = 1.0;
            this.m_elevHeader = 0;
            if (elevScalarIndex == 1) {
                this.m_elevScalar = 10.0;
                this.m_elevHeader = (short)-10;
            }
            if (elevScalarIndex == 2) {
                this.m_elevScalar = 100.0;
                this.m_elevHeader = (short)-100;
            }
            if (elevScalarIndex == 3) {
                this.m_elevScalar = 1000.0;
                this.m_elevHeader = (short)-1000;
            }
            this.m_coordScalar = 1.0;
            this.m_coordHeader = 0;
            if (coordScalarIndex == 1) {
                this.m_coordScalar = 10.0;
                this.m_coordHeader = (short)-10;
            }
            if (coordScalarIndex == 2) {
                this.m_coordScalar = 100.0;
                this.m_coordHeader = (short)-100;
            }
            if (coordScalarIndex == 3) {
                this.m_coordScalar = 1000.0;
                this.m_coordHeader = (short)-1000;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void singleOut() {
        try {
            this.m_lblSingleStatus.setText(" ");
            this.m_lblComments.setText(" ");
            this.m_scrollTableShot.table().setModel(new DefaultTableModel());
            this.m_scrollTableRec.table().setModel(new DefaultTableModel());
            this.m_scrollTableRel.table().setModel(new DefaultTableModel());
            this.m_scrollTableDupShot.table().setModel(new DefaultTableModel());
            this.m_scrollTableDupRec.table().setModel(new DefaultTableModel());
            this.m_scrollTableError.table().setModel(new DefaultTableModel());
            String outName = this.m_txtFileName.getText();
            this.m_project.parameterTree().string_put("OutputFile", outName);
            this.m_project.saveParameters();
            this.m_shotTable = this.prepTable(GeometryProject_SPS.Shot, "InputFiles_Shot", "S", this.m_shotFileHash);
            this.m_recTable = this.prepTable(GeometryProject_SPS.Receiver, "InputFiles_Receiver", "R", this.m_recFileHash);
            this.m_relationTable = this.prepTable(GeometryProject_SPS.Relation, "InputFiles_Relation", "X", this.m_relFileHash);
            this.m_scrollTableShot.table().setModel(new Table_SimpleModel(this.m_shotTable));
            this.m_scrollTableRec.table().setModel(new Table_SimpleModel(this.m_recTable));
            this.m_scrollTableRel.table().setModel(new Table_SimpleModel(this.m_relationTable));
            this.m_geometryShotTableWrapper = new GeometryShotTableWrapper(this.m_shotTable, this.m_relationTable, this.m_shotFileHash);
            this.m_scrollTableDupShot.table().setModel(new Table_SimpleModel(this.m_geometryShotTableWrapper.duplicateTable()));
            if (!this.m_geometryShotTableWrapper.valid()) {
                this.m_lblSingleStatus.setText("Export failed: " + this.m_geometryShotTableWrapper.failureReason());
                this.m_lblSingleStatus.setForeground(Color.red);
                return;
            }
            this.m_geometryReceiverTableWrapper = new GeometryReceiverTableWrapper(this.m_recTable, this.m_relationTable, this.m_recFileHash);
            this.m_scrollTableDupRec.table().setModel(new Table_SimpleModel(this.m_geometryReceiverTableWrapper.duplicateTable()));
            if (!this.m_geometryReceiverTableWrapper.valid()) {
                this.m_lblSingleStatus.setText("Export failed: " + this.m_geometryReceiverTableWrapper.failureReason());
                this.m_lblSingleStatus.setForeground(Color.red);
                return;
            }
            this.m_errorTable = new Table_Memory();
            this.m_errorTable.setName("Errors");
            this.m_errorIndexFFID = this.m_errorTable.column_append("FFID", DataType.Int);
            this.m_errorIndexChan = this.m_errorTable.column_append("CHAN", DataType.Int);
            this.m_errorIndexFileName = this.m_errorTable.column_append("Segy file name", DataType.Text);
            this.m_errorIndexIndex = this.m_errorTable.column_append("Index in file", DataType.Int);
            this.prepScalars();
            this.m_shotAID = this.m_project.asciiImportData("Shot");
            this.m_recAID = this.m_project.asciiImportData("Receiver");
            this.m_shotAID.prepColumnIndices(this.m_shotTable);
            this.m_recAID.prepColumnIndices(this.m_recTable);
            ArrayList<String> fileNames = this.m_project.parameterTree().stringList_get("InputFiles_Segy");
            ArrayList<Segy> segys = new ArrayList<Segy>();
            int totalTraces = 0;
            for (String file : fileNames) {
                Segy segy = new Segy();
                segy.setFileName(file);
                if (!segy.isFileOK()) continue;
                segys.add(segy);
                totalTraces = (int)((long)totalTraces + segy.traceCount());
            }
            RandomAccessFile out = new RandomAccessFile(outName, "rw");
            if (out == null) {
                return;
            }
            int samplesPerTrace = 0;
            int bytePerTrace = 0;
            ByteBuffer inputBuffer = ByteBuffer_Shared.buffer(0, 111);
            ByteBuffer outputBuffer = null;
            int tracesPerChunk = 2000;
            byte[] inputArray = null;
            byte[] outputArray = null;
            boolean first = true;
            int totalTracesRead = 0;
            this.m_progSingle.setMaximum(totalTraces);
            this.m_progSingle.setMinimum(0);
            this.m_progSingle.setValue(0);
            this.m_progSingle.paintImmediately(0, 0, 400, 30);
            this.m_numBadFFID = 0;
            this.m_numBadHeaders = 0;
            this.m_numBadChan = 0;
            int numTracesRead = 0;
            int numTracesOutput = 0;
            for (Segy segy : segys) {
                boolean ok = true;
                if (first) {
                    byte[] ebcdic = segy.ebcdicBytes();
                    byte[] header = segy.headerBytes();
                    out.write(ebcdic, 0, 3200);
                    out.write(header, 0, 400);
                    samplesPerTrace = segy.samplesPerTrace();
                    bytePerTrace = segy.bytesPerTrace();
                    int bytesPerChunk = bytePerTrace * tracesPerChunk;
                    inputBuffer = ByteBuffer_Shared.buffer(0, bytesPerChunk);
                    inputBuffer.order(segy.binaryHeader().FileByteOrder);
                    inputArray = inputBuffer.array();
                    outputBuffer = ByteBuffer.allocate(bytesPerChunk);
                    outputBuffer.order(segy.binaryHeader().FileByteOrder);
                    outputArray = outputBuffer.array();
                } else if (segy.bytesPerTrace() != bytePerTrace) {
                    ok = false;
                }
                if (ok) {
                    this.m_currentSegyFileName = segy.fileName();
                    RandomAccessFile input = new RandomAccessFile(segy.fileName(), "rw");
                    input.read(inputBuffer.array(), 0, 3600);
                    int startIndex = 0;
                    while ((long)startIndex < segy.traceCount()) {
                        int lastIndex = startIndex + tracesPerChunk - 1;
                        lastIndex = Math.min(lastIndex, (int)segy.traceCount() - 1);
                        int numInChunk = lastIndex - startIndex + 1;
                        totalTracesRead += numInChunk;
                        int numBytes = numInChunk * bytePerTrace;
                        input.read(inputBuffer.array(), 0, numBytes);
                        int numInOutputBuffer = 0;
                        for (int n = 0; n < numInChunk; ++n) {
                            int chan;
                            ++numTracesRead;
                            this.m_currentIndexInSegy = n + startIndex;
                            int offset = n * bytePerTrace;
                            int ffid = inputBuffer.getInt(offset + 8);
                            if (!this.populateHeader(ffid, chan = inputBuffer.getInt(offset + 12), inputBuffer, offset)) continue;
                            int outputOffset = numInOutputBuffer * bytePerTrace;
                            for (int b = 0; b < bytePerTrace; ++b) {
                                outputArray[b + outputOffset] = inputArray[b + offset];
                            }
                            ++numTracesOutput;
                            ++numInOutputBuffer;
                        }
                        this.m_progSingle.setValue(totalTracesRead);
                        this.m_progSingle.paintImmediately(0, 0, 400, 30);
                        startIndex += tracesPerChunk;
                        if (numInOutputBuffer <= 0) continue;
                        out.write(outputBuffer.array(), 0, numInOutputBuffer * bytePerTrace);
                    }
                }
                first = false;
            }
            this.m_progSingle.setValue(0);
            this.m_progSingle.paintImmediately(0, 0, 400, 30);
            this.m_scrollTableError.table().setModel(new Table_SimpleModel(this.m_errorTable));
            String res = String.format("%d traces scanned, %d traces written", numTracesRead, numTracesOutput);
            String com = "";
            this.m_lblComments.setForeground(Color.blue);
            if (this.m_numBadHeaders >= 1) {
                com = String.format("  Errors: %d unrecognized FFID, %d unrecognized CHAN", this.m_numBadFFID, this.m_numBadChan);
                this.m_lblComments.setForeground(Color.red);
            }
            this.m_lblComments.setText(res + com);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected boolean pop(AsciiImportData aid, Table_Abstract table, int row, ByteBuffer buffer, int offset) {
        try {
            for (AsciiImportData.Column col : aid.columns()) {
                if (col.ColumnIndex < 0) continue;
                if (col.ExportType == DataType.Short) {
                    short v = (short)table.getInt(row, col.ColumnIndex);
                    if (col.ApplyCoordScalar) {
                        v = (short)(this.m_coordScalar * table.getDouble(row, col.ColumnIndex));
                    }
                    if (col.ApplyElevScalar) {
                        v = (short)(this.m_elevScalar * table.getDouble(row, col.ColumnIndex));
                    }
                    buffer.putShort(offset + col.Offset - 1, v);
                }
                if (col.ExportType == DataType.Float) {
                    float v = table.getFloat(row, col.ColumnIndex);
                    if (col.ApplyCoordScalar) {
                        v = (float)(this.m_coordScalar * table.getDouble(row, col.ColumnIndex));
                    }
                    if (col.ApplyElevScalar) {
                        v = (float)(this.m_elevScalar * table.getDouble(row, col.ColumnIndex));
                    }
                    buffer.putFloat(offset + col.Offset - 1, v);
                }
                if (col.ExportType != DataType.Int) continue;
                int v = table.getInt(row, col.ColumnIndex);
                if (col.ApplyCoordScalar) {
                    v = (int)(this.m_coordScalar * table.getDouble(row, col.ColumnIndex));
                }
                if (col.ApplyElevScalar) {
                    v = (int)(this.m_elevScalar * table.getDouble(row, col.ColumnIndex));
                }
                buffer.putInt(offset + col.Offset - 1, v);
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected boolean populateHeader(int ffid, int chan, ByteBuffer buffer, int offset) {
        try {
            if (!this.m_geometryShotTableWrapper.ffidHash().containsKey(ffid)) {
                ++this.m_numBadHeaders;
                ++this.m_numBadFFID;
                if (this.m_errorTable.row_count() < 10000) {
                    int errorRow = this.m_errorTable.row_increment();
                    this.m_errorTable.putString(errorRow, this.m_errorIndexFileName, this.m_currentSegyFileName);
                    this.m_errorTable.putInt(errorRow, this.m_errorIndexIndex, this.m_currentIndexInSegy + 1);
                    this.m_errorTable.putInt(errorRow, this.m_errorIndexFFID, ffid);
                    this.m_errorTable.putInt(errorRow, this.m_errorIndexChan, chan);
                }
                return false;
            }
            GeometryShotTableWrapper.FFIDENTRY entry = this.m_geometryShotTableWrapper.ffidHash().get(ffid);
            int receiverRow = this.m_geometryReceiverTableWrapper.findReceiverRowFromChan(entry.RelationRow, chan);
            if (receiverRow < 0) {
                ++this.m_numBadHeaders;
                ++this.m_numBadChan;
                if (this.m_errorTable.row_count() < 10000) {
                    int errorRow = this.m_errorTable.row_increment();
                    this.m_errorTable.putString(errorRow, this.m_errorIndexFileName, this.m_currentSegyFileName);
                    this.m_errorTable.putInt(errorRow, this.m_errorIndexIndex, this.m_currentIndexInSegy + 1);
                    this.m_errorTable.putInt(errorRow, this.m_errorIndexFFID, ffid);
                    this.m_errorTable.putInt(errorRow, this.m_errorIndexChan, chan);
                }
                return false;
            }
            this.pop(this.m_shotAID, this.m_shotTable, entry.ShotRow, buffer, offset);
            this.pop(this.m_recAID, this.m_recTable, receiverRow, buffer, offset);
            buffer.putShort(offset + this.m_coordScalarOffset, this.m_coordHeader);
            buffer.putShort(offset + this.m_elevScalarOffset, this.m_elevHeader);
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }
}

