/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Geometry;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Geometry.GeometryProject_SPS;
import com.PecosLibrary.Windows.ASCII.AsciiImportData;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;

public class SPSHeaderCheckWidget
extends JSplitPane
implements GenericObjectListener.Listener,
ActionListener {
    protected GeometryProject_SPS m_project;
    protected JButton m_btnRecheck;
    protected LinearLayoutWidget m_leftWidget;
    protected LinearLayoutWidget m_rightWidget;
    protected RadioPanel m_shotRadio;
    protected RadioPanel m_receiverRadio;
    protected Color m_colorOK = new Color(200, 255, 200);
    protected Color m_colorBad = new Color(255, 200, 200);
    protected Color m_colorIgnore = Color.LIGHT_GRAY;
    protected ArrayList<Entry> m_entryList = new ArrayList();

    public SPSHeaderCheckWidget(GeometryProject_SPS project) {
        super(1);
        try {
            this.m_project = project;
            this.m_leftWidget = LinearLayoutWidget.vert(3, null);
            this.m_rightWidget = LinearLayoutWidget.vert(3, null);
            this.createLeft();
            this.setLeftComponent(this.m_leftWidget);
            this.setRightComponent(this.m_rightWidget);
            this.checkShot();
            this.checkRec();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createReceiverOptions(LinearLayoutWidget parent) {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected Entry getEntry(String table, String column) {
        try {
            for (Entry e : this.m_entryList) {
                if (!e.Table.equalsIgnoreCase(table) || !e.Column.equalsIgnoreCase(column)) continue;
                return e;
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void createShotOptions() {
        try {
            this.m_shotRadio = new RadioPanel(LinearLayoutWidget.Direction.Vertical, "Shot definition columns", "LineNumber, PointNumber, and PointIndex", "LineNumber and PointNumber", "PointNumber");
            this.m_shotRadio.listener().addListener(this);
            this.m_leftWidget.addComponent(this.m_shotRadio, 0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createReceiverOptions() {
        try {
            this.m_receiverRadio = new RadioPanel(LinearLayoutWidget.Direction.Vertical, "Receiver definition columns", "LineNumber, PointNumber, and PointIndex", "LineNumber and PointNumber", "PointNumber");
            this.m_receiverRadio.listener().addListener(this);
            this.m_leftWidget.addComponent(this.m_receiverRadio, 0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createRelationOptions() {
        try {
            AsciiImportData aidrel = this.m_project.asciiImportData(GeometryProject_SPS.Relation);
            AsciiImportData aidsht = this.m_project.asciiImportData(GeometryProject_SPS.Shot);
            AsciiImportData aidrec = this.m_project.asciiImportData(GeometryProject_SPS.Receiver);
            GridLayoutWidget grid = this.m_leftWidget.createGridLayoutWidget(0, "Shot definition requirements", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel(" "), new JLabel("Required ? ", 0), new JLabel("Status:", 0));
            Entry e = new Entry(aidsht, "Shot", "LineNumber", grid, row++, this.m_entryList);
            e = new Entry(aidsht, "Shot", "PointNumber", grid, row++, this.m_entryList);
            e = new Entry(aidsht, "Shot", "PointIndex", grid, row++, this.m_entryList);
            grid = this.m_leftWidget.createGridLayoutWidget(0, "Receiver definition requirements", 0);
            row = 0;
            grid.addSimple(row++, new JLabel(" "), new JLabel("Required ? ", 0), new JLabel("Status:", 0));
            e = new Entry(aidrec, "Receiver", "LineNumber", grid, row++, this.m_entryList);
            e = new Entry(aidrec, "Receiver", "PointNumber", grid, row++, this.m_entryList);
            e = new Entry(aidrec, "Receiver", "PointIndex", grid, row++, this.m_entryList);
            grid = this.m_leftWidget.createGridLayoutWidget(0, "Relation definition requirements", 0);
            row = 0;
            grid.addSimple(row++, new JLabel(" "), new JLabel("Required ? ", 0), new JLabel("Status:", 0));
            e = new Entry(aidrel, "Relation", "FFID", grid, row++, this.m_entryList);
            e = new Entry(aidrel, "Relation", "ShotLineNumber", grid, row++, this.m_entryList);
            e = new Entry(aidrel, "Relation", "ShotPointNumber", grid, row++, this.m_entryList);
            e = new Entry(aidrel, "Relation", "ShotPointIndex", grid, row++, this.m_entryList);
            e = new Entry(aidrel, "Relation", "ReceiverLineNumber", grid, row++, this.m_entryList);
            e = new Entry(aidrel, "Relation", "FromReceiverPointNumber", grid, row++, this.m_entryList);
            e = new Entry(aidrel, "Relation", "ToReceiverPointNumber", grid, row++, this.m_entryList);
            e = new Entry(aidrel, "Relation", "ReceiverPointIndex", grid, row++, this.m_entryList);
            e = new Entry(aidrel, "Relation", "FromChannel", grid, row++, this.m_entryList);
            e = new Entry(aidrel, "Relation", "ToChannel", grid, row++, this.m_entryList);
            e = new Entry(aidrel, "Relation", "ChannelIncrement", grid, row++, this.m_entryList);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected boolean checkRec() {
        try {
            boolean reqLine;
            int numBad = 0;
            boolean reqIndex = this.m_receiverRadio.getSelectedIndex() == 0;
            boolean bl = reqLine = this.m_receiverRadio.getSelectedIndex() == 0 || this.m_receiverRadio.getSelectedIndex() == 1;
            if (!this.getEntry("Receiver", "PointNumber").setRequired(true)) {
                ++numBad;
            }
            if (!this.getEntry("Receiver", "LineNumber").setRequired(reqLine)) {
                ++numBad;
            }
            if (!this.getEntry("Receiver", "PointIndex").setRequired(reqIndex)) {
                ++numBad;
            }
            if (!this.getEntry("Relation", "ReceiverLineNumber").setRequired(reqLine)) {
                ++numBad;
            }
            if (!this.getEntry("Relation", "ReceiverPointIndex").setRequired(reqIndex)) {
                ++numBad;
            }
            if (!this.getEntry("Relation", "FromReceiverPointNumber").setRequired(true)) {
                ++numBad;
            }
            if (!this.getEntry("Relation", "ToReceiverPointNumber").setRequired(true)) {
                ++numBad;
            }
            if (!this.getEntry("Relation", "FromChannel").setRequired(true)) {
                ++numBad;
            }
            if (!this.getEntry("Relation", "ToChannel").setRequired(true)) {
                ++numBad;
            }
            if (!this.getEntry("Relation", "ChannelIncrement").setRequired(true)) {
                ++numBad;
            }
            return numBad == 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected boolean checkShot() {
        try {
            boolean reqLine;
            int numBad = 0;
            boolean reqIndex = this.m_shotRadio.getSelectedIndex() == 0;
            boolean bl = reqLine = this.m_shotRadio.getSelectedIndex() == 0 || this.m_shotRadio.getSelectedIndex() == 1;
            if (!this.getEntry("Shot", "PointNumber").setRequired(true)) {
                ++numBad;
            }
            if (!this.getEntry("Shot", "LineNumber").setRequired(reqLine)) {
                ++numBad;
            }
            if (!this.getEntry("Shot", "PointIndex").setRequired(reqIndex)) {
                ++numBad;
            }
            if (!this.getEntry("Relation", "ShotPointNumber").setRequired(true)) {
                ++numBad;
            }
            if (!this.getEntry("Relation", "FFID").setRequired(true)) {
                ++numBad;
            }
            if (!this.getEntry("Relation", "ShotLineNumber").setRequired(reqLine)) {
                ++numBad;
            }
            if (!this.getEntry("Relation", "ShotPointIndex").setRequired(reqIndex)) {
                ++numBad;
            }
            return numBad == 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected void createLeft() {
        try {
            this.m_btnRecheck = this.m_leftWidget.createButton("Recheck entries", this, 0);
            this.createShotOptions();
            this.createReceiverOptions();
            this.createRelationOptions();
            this.m_leftWidget.addStretch(11);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createRight() {
        try {
            JSplitPane splitter = new JSplitPane(0);
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.checkShot();
            this.checkRec();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.checkShot();
            this.checkRec();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class Entry {
        public AsciiImportData AID;
        public JLabel Label_Required;
        public JLabel Label_Status;
        public String Table;
        public String Column;

        public Entry(AsciiImportData aid, String table, String column, GridLayoutWidget grid, int row, ArrayList<Entry> list) {
            this.AID = aid;
            this.Table = table;
            this.Column = column;
            this.Label_Required = new JLabel("", 0);
            this.Label_Status = new JLabel("", 0);
            this.Label_Status.setOpaque(true);
            JLabel lbl = new JLabel(this.Column, 4);
            grid.addSimple(row, lbl, this.Label_Required, this.Label_Status);
            list.add(this);
        }

        public boolean setRequired(boolean required) {
            try {
                if (required) {
                    this.Label_Required.setText("Yes");
                    if (this.AID.hasColumn(this.Column)) {
                        this.Label_Status.setText("Ok");
                        this.Label_Status.setBackground(SPSHeaderCheckWidget.this.m_colorOK);
                        return true;
                    }
                    this.Label_Status.setText("Undefined");
                    this.Label_Status.setBackground(SPSHeaderCheckWidget.this.m_colorBad);
                    return false;
                }
                this.Label_Required.setText("No");
                this.Label_Status.setText("");
                this.Label_Status.setBackground(SPSHeaderCheckWidget.this.m_colorIgnore);
                return true;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                return false;
            }
        }
    }
}

