/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Geometry;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleGroupManager;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import java.awt.Color;
import javax.swing.JLabel;

public class PatternParser {
    protected Ensemble m_ensemble;
    protected EnsembleGroupManager m_groupManager = new EnsembleGroupManager();
    protected int m_selectedLineIndex;
    protected boolean m_groupingValid = false;
    protected Table_Abstract m_shotInfoTable;
    protected int m_shotInfoIndex_Line;
    protected int m_shotInfoIndex_MinPoint;
    protected int m_shotInfoIndex_MaxPoint;
    protected Table_Abstract m_lineInfoTable;
    protected int m_lineInfoIndex_Point;
    protected int m_lineInfoIndex_Index;
    protected int m_lineInfoIndex_Easting;
    protected int m_lineInfoIndex_Northing;
    protected int m_lineInfoIndex_FileID;
    protected int m_lineInfoIndex_FileIndex;
    protected int m_lineInfoIndex_TraceTableIndex;
    protected int m_lineCount = 0;
    protected int[] m_arrayPointNumber = new int[1000];
    protected int[] m_arrayPointIndex = new int[1000];

    public PatternParser(Ensemble ensemble) {
        try {
            this.m_ensemble = ensemble;
            this.m_lineInfoTable = new Table_Memory();
            this.m_lineInfoTable.setName("LineNumber");
            this.m_lineInfoIndex_Point = this.m_lineInfoTable.column_append("PointNumber", DataType.Int);
            this.m_lineInfoIndex_Index = this.m_lineInfoTable.column_append("PointIndex", DataType.Int);
            this.m_lineInfoIndex_Easting = this.m_lineInfoTable.column_append("Easting", DataType.Int);
            this.m_lineInfoIndex_Northing = this.m_lineInfoTable.column_append("Northing", DataType.Int);
            this.m_lineInfoIndex_FileID = this.m_lineInfoTable.column_append("FileID", DataType.Int);
            this.m_lineInfoIndex_FileIndex = this.m_lineInfoTable.column_append("IndexInFile", DataType.Long);
            this.m_lineInfoIndex_TraceTableIndex = this.m_lineInfoTable.column_append("TraceTableIndex", DataType.Int);
            this.m_shotInfoTable = new Table_Memory();
            this.m_shotInfoTable.setName("Shot");
            this.m_shotInfoIndex_Line = this.m_shotInfoTable.column_append("LineNumber", DataType.Int);
            this.m_shotInfoIndex_MinPoint = this.m_shotInfoTable.column_append("Min PointNumber", DataType.Int);
            this.m_shotInfoIndex_MaxPoint = this.m_shotInfoTable.column_append("Max PointNumber", DataType.Int);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Table_Abstract lineInfoTable() {
        return this.m_lineInfoTable;
    }

    public Table_Abstract shotInfoTable() {
        return this.m_shotInfoTable;
    }

    public int selectedLineIndex() {
        return this.m_selectedLineIndex;
    }

    public void setSelectedLineIndex(int selectedLineIndex) {
        this.m_selectedLineIndex = selectedLineIndex;
        this.prepareLineInformation();
    }

    public boolean groupingValid() {
        return this.m_groupingValid;
    }

    public void getLineDescription(JLabel lbl) {
        try {
            if (!this.m_groupingValid) {
                lbl.setText("No valid shot");
                lbl.setForeground(Color.red);
                return;
            }
            this.confirmSelectedIndex();
            EnsembleGroupManager.GroupInfo group = this.m_groupManager.GroupList.get(this.m_selectedLineIndex);
            lbl.setForeground(Color.blue);
            lbl.setText(String.format("Line number %d selected", group.GroupValue));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void confirmSelectedIndex() {
        try {
            if (!this.m_groupingValid) {
                return;
            }
            this.m_selectedLineIndex = Math.max(this.m_selectedLineIndex, 0);
            this.m_selectedLineIndex = Math.min(this.m_selectedLineIndex, this.m_groupManager.GroupList.size() - 1);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void parseEnsemble() {
        try {
            this.m_selectedLineIndex = 0;
            this.m_groupManager.setParentEnsemble(this.m_ensemble);
            this.m_groupManager.prepareGroupsBasedOnInteger("Receiver", "LineNumber");
            boolean bl = this.m_groupingValid = this.m_groupManager.GroupList.size() > 0;
            if (!this.m_groupingValid) {
                return;
            }
            this.prepareShotInfoTable();
            this.prepareLineInformation();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void prepareShotInfoTable() {
        try {
            this.m_shotInfoTable.row_clear(false);
            if (!this.m_groupingValid) {
                return;
            }
            for (int n = 0; n < this.m_groupManager.GroupList.size(); ++n) {
                EnsembleGroupManager.GroupInfo group = this.m_groupManager.GroupList.get(n);
                int line = group.GroupValue;
                Ensemble lineEnsemble = group.GroupEnsemble;
                int indexPoint = lineEnsemble.dictionary().getEntryIndex("Receiver", "PointNumber");
                int min = Integer.MAX_VALUE;
                int max = Integer.MIN_VALUE;
                for (int k = 0; k < lineEnsemble.traceCount(); ++k) {
                    EnsembleTrace trace = lineEnsemble.trace(k);
                    int point = trace.header().getInt(indexPoint);
                    min = Math.min(min, point);
                    max = Math.max(max, point);
                }
                int row = this.m_shotInfoTable.row_increment();
                this.m_shotInfoTable.putInt(row, this.m_shotInfoIndex_Line, line);
                this.m_shotInfoTable.putInt(row, this.m_shotInfoIndex_MinPoint, min);
                this.m_shotInfoTable.putInt(row, this.m_shotInfoIndex_MaxPoint, max);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void prepareLineInformation() {
        try {
            this.m_lineInfoTable.row_clear(false);
            if (!this.m_groupingValid) {
                return;
            }
            this.confirmSelectedIndex();
            EnsembleGroupManager.GroupInfo group = this.m_groupManager.GroupList.get(this.m_selectedLineIndex);
            Ensemble lineEnsemble = group.GroupEnsemble;
            lineEnsemble.sortInt(0, "Receiver", "PointNumber", "Receiver", "PointIndex");
            this.m_lineCount = lineEnsemble.traceCount();
            if (this.m_lineCount > this.m_arrayPointNumber.length) {
                this.m_arrayPointNumber = new int[this.m_lineCount + 200];
                this.m_arrayPointIndex = new int[this.m_lineCount + 200];
            }
            int indexPointNumber = lineEnsemble.dictionary().getEntryIndex("Receiver", "PointNumber");
            int indexPointIndex = lineEnsemble.dictionary().getEntryIndex("Receiver", "PointIndex");
            int indexEasting = lineEnsemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexNorthing = lineEnsemble.dictionary().getEntryIndex("Receiver", "Northing");
            int indexFileID = lineEnsemble.dictionary().getEntryIndex("Trace", "FileID");
            int indexIndexInFile = lineEnsemble.dictionary().getEntryIndex("Trace", "IndexInFile");
            int indexTraceIndex = lineEnsemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            for (int n = 0; n < this.m_lineCount; ++n) {
                int row = this.m_lineInfoTable.row_increment();
                Column_Abstract header = lineEnsemble.trace(n).header();
                int point = header.getInt(indexPointNumber);
                int index = header.getInt(indexPointIndex);
                this.m_arrayPointNumber[n] = point;
                this.m_arrayPointIndex[n] = index;
                this.m_lineInfoTable.putInt(row, this.m_lineInfoIndex_Point, header.getInt(indexPointNumber));
                this.m_lineInfoTable.putInt(row, this.m_lineInfoIndex_Index, header.getInt(indexPointIndex));
                this.m_lineInfoTable.putInt(row, this.m_lineInfoIndex_Easting, header.getInt(indexEasting));
                this.m_lineInfoTable.putInt(row, this.m_lineInfoIndex_Northing, header.getInt(indexNorthing));
                this.m_lineInfoTable.putInt(row, this.m_lineInfoIndex_FileID, header.getInt(indexFileID));
                this.m_lineInfoTable.putLong(row, this.m_lineInfoIndex_FileIndex, header.getLong(indexIndexInFile));
                this.m_lineInfoTable.putLong(row, this.m_lineInfoIndex_TraceTableIndex, header.getLong(indexTraceIndex));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

