/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Geometry;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Geometry.GeometryProject_Pattern;
import com.PecosLibrary.Windows.Shared.HtmlBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class PatternBinningWidget
extends JSplitPane
implements ActionListener {
    protected GeometryProject_Pattern m_project;
    protected JEditorPane m_editorPane;
    protected JButton m_btnScan;

    public PatternBinningWidget(GeometryProject_Pattern project) {
        super(1);
        try {
            this.m_project = project;
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected JComponent createRight() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            return main;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            this.m_btnScan = main.createButton("Rescan shot/receiver data", this, 0);
            this.m_editorPane = new JEditorPane();
            this.m_editorPane.setContentType("text/html");
            this.m_editorPane.setEditable(false);
            main.addComponent(new JScrollPane(this.m_editorPane), 5);
            main.addStretch(5);
            return main;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    protected boolean checkColumn(Table_Abstract t, String tableName, String col, HtmlBuilder html) {
        try {
            if (t.column_exists(col)) {
                return true;
            }
            String s = String.format("%s table must have column %s", tableName, col);
            html.add(s, "red");
            return false;
        }
        catch (Exception error) {
            error.printStackTrace();
            return false;
        }
    }

    protected boolean checkShot(HtmlBuilder html) {
        try {
            if (!this.m_project.TableHash.containsKey("Shot")) {
                html.add("Shot table does not exist", "red");
                return false;
            }
            Table_Abstract tbl = (Table_Abstract)this.m_project.TableHash.get("Shot");
            boolean ok = true;
            ok = ok && this.checkColumn(tbl, "Shot", "FFID", html);
            ok = ok && this.checkColumn(tbl, "Shot", "ShotPeg", html);
            ok = ok && this.checkColumn(tbl, "Shot", "SkidI", html);
            ok = ok && this.checkColumn(tbl, "Shot", "SkidC", html);
            ok = ok && this.checkColumn(tbl, "Shot", "Depth", html);
            ok = ok && this.checkColumn(tbl, "Shot", "Ch1", html);
            ok = ok && this.checkColumn(tbl, "Shot", "Ch2", html);
            ok = ok && this.checkColumn(tbl, "Shot", "Ch3", html);
            ok = ok && this.checkColumn(tbl, "Shot", "Ch4", html);
            ok = ok && this.checkColumn(tbl, "Shot", "Peg1", html);
            ok = ok && this.checkColumn(tbl, "Shot", "Peg2", html);
            ok = ok && this.checkColumn(tbl, "Shot", "Peg3", html);
            boolean bl = ok = ok && this.checkColumn(tbl, "Shot", "Peg4", html);
            return ok;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected boolean checkRec(HtmlBuilder html) {
        try {
            if (!this.m_project.TableHash.containsKey("Receiver")) {
                html.add("Receiver table does not exist", "red");
                return false;
            }
            Table_Abstract tbl = (Table_Abstract)this.m_project.TableHash.get("Receiver");
            boolean ok = true;
            ok = ok && this.checkColumn(tbl, "Receiver", "Peg", html);
            ok = ok && this.checkColumn(tbl, "Receiver", "Distance", html);
            ok = ok && this.checkColumn(tbl, "Receiver", "Elevation", html);
            ok = ok && this.checkColumn(tbl, "Receiver", "Easting", html);
            ok = ok && this.checkColumn(tbl, "Receiver", "Northing", html);
            boolean bl = ok = ok && this.checkColumn(tbl, "Receiver", "Increment", html);
            return ok;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected void scan() {
        try {
            this.m_project.clearAll();
            HtmlBuilder html = new HtmlBuilder();
            if (!this.checkShot(html)) {
                this.m_editorPane.setText(html.finish());
                return;
            }
            if (!this.checkRec(html)) {
                this.m_editorPane.setText(html.finish());
                return;
            }
            this.m_project.createReceivers((Table_Abstract)this.m_project.TableHash.get("Receiver"));
            this.m_project.createShots((Table_Abstract)this.m_project.TableHash.get("Shot"));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnScan) {
                this.scan();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

