/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Geometry;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Geometry.PatternParser;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Refraction.Picking.NavigationWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickerBasemapWidget;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PatternAnalysisWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
ItemListener,
PickerBasemapWidget.Listener,
Messenger.Listener,
PopupMenuButton.Listener,
ListSelectionListener,
ISaveableFrame {
    protected int m_shotID;
    protected Ensemble m_ensemble = new Ensemble();
    protected Ensemble m_lineEnsembleClone = null;
    protected PatternParser m_parser;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected Java2D_AxisLocker m_axisLockerTime;
    protected Java2D_VertStackedEnsembleDisplayWidget m_widget;
    protected PickerBasemapWidget m_basemapWidget;
    protected NavigationWidget m_shotNavigationWidget;
    protected JTextField m_txtShotID = new JTextField("");
    protected JButton m_btnNextShot;
    protected JButton m_btnPrevShot;
    protected JTextField m_txtShotLine = new JTextField("");
    protected JButton m_btnNextShotLine;
    protected JButton m_btnPrevShotLine;
    protected JTextField m_txtShotPoint = new JTextField("");
    protected JButton m_btnNextShotPoint;
    protected JButton m_btnPrevShotPoint;
    protected BitmapCardWidget m_bitmapCardWidget = new BitmapCardWidget();
    protected Sequence_MainWidget m_workerWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected boolean m_ignoreShotTableSelection = false;
    protected ScrollTable m_shotInfoTable;
    protected Table_SimpleModel m_shotInfoTableModel;
    protected ScrollTable m_lineInfoTable;
    protected Table_SimpleModel m_lineInfoTableModel;
    protected JLabel m_lblSelectedLine = new JLabel("No line selected", 0);

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Geometry.PatternAnalysisWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Patterns";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Pattern analysis";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public PatternAnalysisWidget() {
        super(1);
        try {
            this.m_parser = new PatternParser(this.m_ensemble);
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRightCenter());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeft() {
        try {
            this.m_workerWidget = new Sequence_MainWidget("Pattern", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_sequence = this.m_workerWidget.sequence();
            this.m_sequence.addListener(this);
            this.m_basemapWidget = new PickerBasemapWidget(this);
            this.m_shotNavigationWidget = new NavigationWidget("Shot");
            this.m_shotNavigationWidget.listener().addListener(this);
            LinearLayoutWidget options = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget("Trace display options");
            this.m_wiggleOptionsWidget.listener().addListener(this);
            this.m_axisLockerTime = new Java2D_AxisLocker("Time lock", "Lock axis ");
            this.m_axisLockerTime.listener().addListener(this);
            this.m_axisLockerTime.setRange(-400.0, 500.0);
            options.addComponent(this.m_wiggleOptionsWidget, 0);
            options.addComponent(this.m_axisLockerTime, 0);
            options.addStretch(10);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Basemap, this.m_basemapWidget, "Basemap");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Sequence, this.m_workerWidget, "Ensemble processing sequence");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Navigation, this.m_shotNavigationWidget, "Ensemble navigation");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Wiggle, options, "Display options, axis lock");
            return this.m_bitmapCardWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightCenter() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            LinearLayoutWidget top = main.createHorizontal(3, null, 0);
            LinearLayoutWidget sub = top.createVertical(0, "Shot ID ", 0);
            sub.addComponent(this.m_txtShotID, 0);
            this.m_txtShotID.addActionListener(this);
            this.m_btnPrevShot = sub.createButton("Prior ID", this, 0);
            this.m_btnNextShot = sub.createButton("Next ID", this, 0);
            sub = top.createVertical(0, "Shot LineNumber", 0);
            sub.addComponent(this.m_txtShotLine, 0);
            this.m_txtShotLine.addActionListener(this);
            this.m_btnPrevShotLine = sub.createButton("Prior LineNumber", this, 0);
            this.m_btnNextShotLine = sub.createButton("Next LineNumber", this, 0);
            sub = top.createVertical(0, "Shot PointNumber", 0);
            sub.addComponent(this.m_txtShotPoint, 0);
            this.m_txtShotPoint.addActionListener(this);
            this.m_btnPrevShotPoint = sub.createButton("Prior PointNumber", this, 0);
            this.m_btnNextShotPoint = sub.createButton("Next PointNumber", this, 0);
            top.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(top, -2, null, true);
            JSplitPane splitter = new JSplitPane(0);
            splitter.setTopComponent(this.createCenterSplitterTopComponent());
            splitter.setBottomComponent(this.createCenterSplitterBottomComponent());
            main.addComponent(splitter, 10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createCenterSplitterBottomComponent() {
        try {
            this.m_widget = new Java2D_VertStackedEnsembleDisplayWidget(1);
            this.m_widget.setHeaderPlotVisibleCount(0, 1);
            this.m_widget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            this.m_widget.setAxisTableColumn("Receiver", "PointNumber");
            this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
            return this.m_widget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createCenterSplitterTopComponent() {
        try {
            JSplitPane splitter = new JSplitPane(1);
            this.m_shotInfoTable = new ScrollTable();
            this.m_shotInfoTableModel = new Table_SimpleModel(this.m_parser.shotInfoTable());
            this.m_shotInfoTable.table().setModel(this.m_shotInfoTableModel);
            this.m_shotInfoTable.table().getSelectionModel().setSelectionMode(0);
            this.m_shotInfoTable.table().getSelectionModel().addListSelectionListener(this);
            this.m_lineInfoTable = new ScrollTable();
            this.m_lineInfoTableModel = new Table_SimpleModel(this.m_parser.lineInfoTable());
            this.m_lineInfoTable.table().setModel(this.m_lineInfoTableModel);
            this.m_lineInfoTable.table().getSelectionModel().setSelectionMode(0);
            this.m_lineInfoTable.table().getSelectionModel().addListSelectionListener(this);
            LinearLayoutWidget right = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            right.addComponent(this.m_lblSelectedLine, 0);
            JTabbedPane tabs = new JTabbedPane();
            right.addComponent(tabs, 10);
            tabs.addTab("Line table", this.m_lineInfoTable);
            splitter.setLeftComponent(this.m_shotInfoTable);
            splitter.setRightComponent(right);
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            boolean polarityFlipped;
            boolean bl = polarityFlipped = message == Messenger.Message.ReceiverPolarityFlipped || message == Messenger.Message.ShotPolarityFlipped;
            if (polarityFlipped) {
                return;
            }
            if (message == Messenger.Message.PicksChanged) {
                return;
            }
            boolean reloadData = false;
            int reloadID = -9999;
            boolean reloadBasemap = false;
            if (message == Messenger.Message.ReceiverGeometryChanged) {
                // empty if block
            }
            if (message == Messenger.Message.ShotGeometryChanged) {
                reloadID = (Integer)data;
                reloadData = reloadData || Tools_Ensemble.hasShotID(this.m_ensemble, reloadID);
                reloadBasemap = true;
            }
            if (message == Messenger.Message.ProjectVersionChanged) {
                reloadData = true;
            }
            if (reloadData) {
                this.m_shotNavigationWidget.setSelected(reloadID);
                this.loadShot();
                return;
            }
            if (message == Messenger.Message.ShotSelected) {
                if (this.m_shotID != Messenger.shotID()) {
                    this.m_shotNavigationWidget.setSelected(Messenger.shotID());
                    this.loadShot();
                }
                return;
            }
            if (message == Messenger.Message.TraceSelected) {
                if (this.m_shotID != Messenger.shotID()) {
                    this.m_shotNavigationWidget.setSelected(Messenger.shotID());
                    this.loadShot();
                }
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void scrollToSelected() {
        try {
            this.m_ignoreShotTableSelection = true;
            int selRow = this.m_parser.selectedLineIndex();
            this.m_shotInfoTable.table().scrollRectToVisible(new Rectangle(this.m_shotInfoTable.table().getCellRect(selRow, 0, true)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_ignoreShotTableSelection = false;
    }

    protected void loadShot() {
        try {
            this.m_ensemble.clearTraces(false);
            this.m_shotID = this.m_shotNavigationWidget.selected();
            RefractionStaticsProject.singleton().ensemble_Shot(this.m_ensemble, this.m_shotID, true);
            this.m_txtShotID.setText(Integer.toString(this.m_shotID));
            this.m_ensemble.sortInt(0, "Receiver", "LineNumber", "Receiver", "PointNumber");
            this.m_parser.parseEnsemble();
            this.m_shotInfoTableModel.fireTableDataChanged();
            this.m_lineInfoTableModel.fireTableDataChanged();
            this.scrollToSelected();
            this.getShotLineAndPoint();
            this.m_parser.getLineDescription(this.m_lblSelectedLine);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void getShotLineAndPoint() {
        try {
            this.m_txtShotLine.setText("INVALID");
            this.m_txtShotPoint.setText("INVALID");
            if (!RefractionStaticsProject.singleton().shotMap().containsKey(this.m_shotID)) {
                return;
            }
            int row = RefractionStaticsProject.singleton().shotMap().get(this.m_shotID);
            Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
            int colLine = shotTable.column_indexOfColumn("LineNumber");
            int colPoint = shotTable.column_indexOfColumn("PointNumber");
            int line = shotTable.getInt(row, colLine);
            int point = shotTable.getInt(row, colPoint);
            this.m_txtShotLine.setText(Integer.toString(line));
            this.m_txtShotPoint.setText(Integer.toString(point));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadLinePoint() {
        try {
            this.m_shotID = -9999;
            this.m_ensemble.clearTraces(false);
            Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
            int line = Tools_Widget.extractInteger(this.m_txtShotLine, -9999, -999999999, 99999999);
            int point = Tools_Widget.extractInteger(this.m_txtShotPoint, -9999, -999999999, 99999999);
            this.m_shotID = Tools_RefractionStaticsProject.getIDUsingLinePoint(shotTable, line, point);
            if (this.m_shotID > 0) {
                this.m_shotNavigationWidget.setSelected(this.m_shotID);
            }
            this.loadShot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadLinePoint_NeighborLine(boolean positive) {
        try {
            this.m_shotID = -9999;
            this.m_ensemble.clearTraces(false);
            Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
            int line = Tools_Widget.extractInteger(this.m_txtShotLine, -9999, -999999999, 99999999);
            int point = Tools_Widget.extractInteger(this.m_txtShotPoint, -9999, -999999999, 99999999);
            this.m_shotID = Tools_RefractionStaticsProject.getIDUsingLinePoint_NeighborLine(shotTable, positive, line, point);
            if (this.m_shotID > 0) {
                this.m_shotNavigationWidget.setSelected(this.m_shotID);
            }
            this.loadShot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadLinePoint_NeighborPoint(boolean positive) {
        try {
            this.m_shotID = -9999;
            this.m_ensemble.clearTraces(false);
            Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
            int line = Tools_Widget.extractInteger(this.m_txtShotLine, -9999, -999999999, 99999999);
            int point = Tools_Widget.extractInteger(this.m_txtShotPoint, -9999, -999999999, 99999999);
            this.m_shotID = Tools_RefractionStaticsProject.getIDUsingLinePoint_NeighborPoint(shotTable, positive, line, point);
            if (this.m_shotID > 0) {
                this.m_shotNavigationWidget.setSelected(this.m_shotID);
            }
            this.loadShot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            if (e.getValueIsAdjusting() || this.m_ignoreShotTableSelection) {
                return;
            }
            int row = this.m_shotInfoTable.table().getSelectedRow();
            this.m_parser.setSelectedLineIndex(row);
            this.m_lineInfoTableModel.fireTableDataChanged();
            this.scrollToSelected();
            this.m_parser.getLineDescription(this.m_lblSelectedLine);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (this.m_shotNavigationWidget == sender) {
                this.loadShot();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_txtShotID) {
                int id = Tools_Widget.extractInteger(this.m_txtShotID, 1000, -999999, 9999999);
                this.m_shotNavigationWidget.setSelected(id);
                this.loadShot();
                return;
            }
            if (e.getSource() == this.m_btnPrevShot) {
                this.m_shotNavigationWidget.goToPrevious();
                this.loadShot();
                return;
            }
            if (e.getSource() == this.m_btnNextShot) {
                this.m_shotNavigationWidget.goToNext();
                this.loadShot();
                return;
            }
            if (e.getSource() == this.m_btnNextShotPoint) {
                this.loadLinePoint_NeighborPoint(true);
                return;
            }
            if (e.getSource() == this.m_btnPrevShotPoint) {
                this.loadLinePoint_NeighborPoint(false);
                return;
            }
            if (e.getSource() == this.m_btnNextShotLine) {
                this.loadLinePoint_NeighborLine(true);
                return;
            }
            if (e.getSource() == this.m_btnPrevShotLine) {
                this.loadLinePoint_NeighborLine(false);
                return;
            }
            if (e.getSource() == this.m_txtShotLine || e.getSource() == this.m_txtShotPoint) {
                this.loadLinePoint();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
    }

    @Override
    public void handleBasemap_SparseCMPSelected(Ensemble ensemble) {
    }

    @Override
    public void handleBasemap_Bin2DSelected(int bin) {
    }

    @Override
    public void handleBasemap_Bin3DSelected(int inline, int crossline) {
    }

    @Override
    public void handleBasemap_ReceiverDrag(double x, double y) {
    }

    @Override
    public void handleBasemap_ReceiverDragFinish(double x, double y) {
    }

    @Override
    public void handleBasemap_ShotDrag(double x, double y) {
    }

    @Override
    public void handleBasemap_ShotDragFinish(double x, double y) {
    }

    @Override
    public void handleBasemap_ShotSelected(int id, int plotIndex) {
    }

    @Override
    public void handleBasemap_ShotSelected(int id) {
        try {
            this.m_shotNavigationWidget.setSelected(id);
            this.loadShot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleBasemap_ReceiverSelected(int id) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }
}

