/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Geometry;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Windows.Geometry.NewPatternProjectDialog;
import com.PecosLibrary.Windows.Geometry.NewSPSProjectDialog;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GeometryProjectManagerWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener,
ListSelectionListener {
    protected GenericObjectListener m_listenerManager = new GenericObjectListener();
    protected JButton m_btnReloadProject;
    protected JButton m_btnNewSPSProject;
    protected JButton m_btnNewPatternProject;
    protected ScrollTable m_scrollTable;
    protected Table_Abstract m_projectTable = new Table_Memory();
    protected Table_SimpleModel m_tableModel;
    protected int m_indexName;
    protected int m_indexOrigin;
    protected int m_indexDate;
    protected NewSPSProjectDialog m_spsDialog;
    public String ProjectName = "";
    public String ProjectOrigin = "";
    protected NewPatternProjectDialog m_patDlg = null;

    public GeometryProjectManagerWidget(GenericObjectListener.Listener listener) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_listenerManager.addListener(listener);
            LinearLayoutWidget top = this.createVertical(3, null, 0);
            this.m_btnReloadProject = top.createButton("Reload list of geometry schemas", this, 0);
            this.m_btnNewSPSProject = top.createButton("Create new SPS schema", this, 0);
            this.m_btnNewPatternProject = top.createButton("Create new pattern-based schema", this, 0);
            top.addStretch(11);
            this.m_scrollTable = new ScrollTable();
            this.addComponent(this.m_scrollTable, 10);
            this.m_projectTable.setName("Projects");
            this.m_indexName = this.m_projectTable.column_append("Name", DataType.Text);
            this.m_indexOrigin = this.m_projectTable.column_append("Origin", DataType.Text);
            this.m_indexDate = this.m_projectTable.column_append("Date", DataType.Text);
            this.m_tableModel = new Table_SimpleModel(this.m_projectTable);
            this.m_scrollTable.table().setModel(this.m_tableModel);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexName).setMinWidth(130);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexOrigin).setMinWidth(60);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexDate).setMinWidth(210);
            this.m_scrollTable.table().getSelectionModel().addListSelectionListener(this);
            this.reloadTable();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadTable() {
        try {
            this.m_projectTable.row_clear(true);
            String parentPath = SharedApplicationData.geometryProjectPath();
            ArrayList<String> subdirs = Tools_FileSystem.subdirectories(parentPath, false);
            for (String subdir : subdirs) {
                String fullProjectPath = parentPath + "/" + subdir;
                String descFileName = fullProjectPath + "/ProjectDescription.xml";
                if (!Tools_FileSystem.exists_file(descFileName)) continue;
                ParameterTree pt = new ParameterTree();
                pt.read(descFileName);
                int row = this.m_projectTable.row_increment();
                this.m_projectTable.putString(row, this.m_indexName, subdir);
                this.m_projectTable.putString(row, this.m_indexDate, pt.string_get("DateCreated", "Error"));
                this.m_projectTable.putString(row, this.m_indexOrigin, pt.string_get("Origin", "Error"));
            }
            this.m_tableModel.fireTableDataChanged();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void newSPS() {
        try {
            if (this.m_spsDialog == null) {
                this.m_spsDialog = new NewSPSProjectDialog(null);
            }
            this.m_spsDialog.showDialog();
            if (this.m_spsDialog.OK) {
                String name;
                this.ProjectName = name = this.m_spsDialog.ProjectName;
                this.ProjectOrigin = Pecos.SPS;
                this.reloadTable();
                this.m_listenerManager.broadcast(this, null);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void newPattern() {
        try {
            if (this.m_patDlg == null) {
                this.m_patDlg = new NewPatternProjectDialog(null);
            }
            this.m_patDlg.showDialog();
            if (this.m_patDlg.OK) {
                String name;
                this.ProjectName = name = this.m_patDlg.ProjectName;
                this.ProjectOrigin = Pecos.Pattern;
                this.reloadTable();
                this.m_listenerManager.broadcast(this, null);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            if (e.getSource() == this.m_scrollTable.table().getSelectionModel()) {
                int row = this.m_scrollTable.table().getSelectedRow();
                this.ProjectName = this.m_projectTable.getString(row, this.m_indexName);
                this.ProjectOrigin = this.m_projectTable.getString(row, this.m_indexOrigin);
                this.m_listenerManager.broadcast(this, null);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnNewPatternProject) {
                this.newPattern();
                return;
            }
            if (e.getSource() == this.m_btnReloadProject) {
                this.reloadTable();
                return;
            }
            if (e.getSource() == this.m_btnNewSPSProject) {
                this.newSPS();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }
}

