/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Ensemble.Sequence;

import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Ensemble.Worker.Tools_EnsembleWorker;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_SplitterWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Sequence_MainWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener {
    protected EnsembleWorker_Sequence m_sequence = null;
    protected boolean m_saveOkay = true;
    protected JTextField m_fileNameTextField = new JTextField();
    protected JButton m_openButton;
    protected JButton m_saveButton;
    protected JButton m_saveAsButton;
    protected JButton m_newButton;
    protected Sequence_SplitterWidget m_splitter;
    protected Timer m_timer = new Timer(2000, this);

    public Sequence_MainWidget(String sequenceName, EnsembleWorker_Sequence.SequenceType type) {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this.m_sequence = new EnsembleWorker_Sequence(type);
            this.createFileWidget();
            this.m_splitter = new Sequence_SplitterWidget(this.m_sequence);
            this.addComponent(this.m_splitter, 10);
            if (sequenceName == null) {
                sequenceName = "Default";
            }
            if (sequenceName.length() < 1) {
                sequenceName = "Default";
            }
            String path = SharedApplicationData.singleton().homeSubDirectory("Sequences");
            String name = path + "/" + sequenceName + ".SequenceXML";
            this.setFileName(name);
            this.m_timer.start();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void toggle_active_process() {
        try {
            this.m_splitter.toggle_active_process();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void toggle_unlocked_processes() {
        try {
            this.m_splitter.toggle_unlocked_processes();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public String getFileName() {
        try {
            return this.m_fileNameTextField.getText();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    public void setFileName(String fileName) {
        try {
            this.m_fileNameTextField.setText(fileName);
            Tools_EnsembleWorker.read(this.m_sequence, fileName);
            this.m_sequence.setRefractionStaticsProject(RefractionStaticsProject.singleton());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void createModWidget() {
        try {
            LinearLayoutWidget linearLayoutWidget = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, "Sequence modification", 0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected JComponent createFileWidget() {
        try {
            LinearLayoutWidget top = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "", 0);
            this.m_fileNameTextField = top.createTextField("", null, 0);
            this.m_fileNameTextField.setEditable(false);
            Tools_FontChanger.changeSizeOfFont(this.m_fileNameTextField, -2);
            LinearLayoutWidget w = top.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            this.m_openButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileOpen, "Open existing sequence", (ActionListener)this);
            this.m_saveButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileSave, "Save sequence", (ActionListener)this);
            this.m_saveAsButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileSaveAs, "Save to new file", (ActionListener)this);
            this.m_newButton = Tools_Bitmap.makeButton(w, BitmapEnum.FileNew, "New sequence", (ActionListener)this);
            w.addStretch(10);
            return top;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public EnsembleWorker_Sequence sequence() {
        try {
            this.save();
            return this.m_sequence;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender instanceof EnsembleWorker_Base && data != null && data instanceof String) {
                String string = (String)data;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void save() {
        try {
            if (!this.m_saveOkay) {
                return;
            }
            this.m_sequence.setRefractionStaticsProject(RefractionStaticsProject.singleton());
            this.m_sequence.getParametersFromWidgets();
            Tools_EnsembleWorker.save(this.m_sequence, this.m_fileNameTextField.getText());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_timer) {
                if (this.m_sequence.isDirty()) {
                    this.save();
                }
                return;
            }
            if (e.getSource() == this.m_saveButton) {
                this.save();
                return;
            }
            if (e.getSource() == this.m_saveAsButton) {
                String fileName = Tools_Chooser.getSaveFileName("SequenceXML");
                if (fileName == null) {
                    return;
                }
                fileName = Tools_Strings.confirmSuffix(fileName, "SequenceXML");
                this.m_fileNameTextField.setText(fileName);
                this.save();
                return;
            }
            if (e.getSource() == this.m_newButton) {
                String fileName = Tools_Chooser.getSaveFileName("SequenceXML");
                if (fileName == null) {
                    return;
                }
                fileName = Tools_Strings.confirmSuffix(fileName, "SequenceXML");
                this.m_sequence.clear();
                this.m_fileNameTextField.setText(fileName);
                this.save();
                return;
            }
            if (e.getSource() == this.m_openButton) {
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Sequence", "SequenceXML");
                String fileName = Tools_Chooser.getFileName("Select sequence", filter);
                if (fileName == null) {
                    return;
                }
                this.m_fileNameTextField.setText(fileName);
                Tools_EnsembleWorker.read(this.m_sequence, fileName);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

