/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.ApplicationFrames;

import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.ApplicationFrames.INumberedWidget;
import com.PecosLibrary.Windows.ApplicationFrames.Menu_Window;
import com.PecosLibrary.Windows.MDI.MDIDesktopPane;
import com.PecosLibrary.Windows.MDI.MDIInternalFrame;
import com.PecosLibrary.Windows.MDI.MDIViewMenu;
import com.PecosLibrary.Windows.Refraction.Picking.BasicPickWidget_V2;
import com.PecosLibrary.Windows.Shared.ButtonTabComponent;
import com.PecosLibrary.Windows.Shared.MultiButtonTextDialog;
import com.PecosLibrary.Windows.Shared.StatusPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ToolTipManager;

public abstract class ComponentManagerFrame
extends JFrame
implements IComponentManager,
Messenger.Listener,
WindowListener {
    protected JMenuBar m_menuBar = new JMenuBar();
    protected int m_windowLayout;
    protected Menu_Window m_windowMenu;
    protected JSplitPane m_splitMain;
    protected StatusPane m_statusPane;
    protected JTabbedPane m_leftTabs = null;
    protected JTabbedPane m_rightTabs = null;
    protected JTabbedPane m_tabs = null;
    protected MDIViewMenu m_mdiMenu;
    protected JScrollPane m_mdiScrollPane;
    protected MDIDesktopPane m_mdiDesktop;
    protected int m_tabIndexBeforeLock;
    protected ArrayList<JTabbedPane> m_tabList = new ArrayList();
    protected JTabbedPane m_jobTabs = null;
    protected boolean m_specialCase;
    public boolean AskWhichTab = true;
    protected MultiButtonTextDialog m_whichDialog = null;

    public JTabbedPane leftTabs() {
        return this.m_leftTabs;
    }

    public JTabbedPane rightTabs() {
        return this.m_rightTabs;
    }

    public JTabbedPane tabs() {
        return this.m_tabs;
    }

    public ComponentManagerFrame() {
        try {
            SharedApplicationData.singleton().setComponentManager(this);
            this.getContentPane().setLayout(new BorderLayout());
            this.m_windowLayout = SharedApplicationData.singleton().windowLayout();
            if (this.m_windowLayout == SharedApplicationData.SplitTabs) {
                this.m_splitMain = new JSplitPane();
                this.m_leftTabs = new JTabbedPane();
                this.m_rightTabs = new JTabbedPane();
                this.m_splitMain.setLeftComponent(this.m_leftTabs);
                this.m_splitMain.setRightComponent(this.m_rightTabs);
                this.getContentPane().add((Component)this.m_splitMain, "Center");
                this.m_tabList.add(this.m_leftTabs);
                this.m_tabList.add(this.m_rightTabs);
                this.m_jobTabs = this.m_leftTabs;
            }
            if (this.m_windowLayout == SharedApplicationData.Tabs) {
                this.m_tabs = new JTabbedPane();
                this.getContentPane().add((Component)this.m_tabs, "Center");
                this.m_tabList.add(this.m_tabs);
                this.m_jobTabs = this.m_tabs;
            }
            if (this.m_windowLayout == SharedApplicationData.MDI) {
                this.m_mdiDesktop = new MDIDesktopPane();
                this.m_mdiScrollPane = new JScrollPane();
                this.m_mdiScrollPane.getViewport().add(this.m_mdiDesktop);
                this.getContentPane().add((Component)this.m_mdiScrollPane, "Center");
                this.m_mdiMenu = new MDIViewMenu(this.m_mdiDesktop);
            }
            this.m_statusPane = new StatusPane(4);
            this.getContentPane().add((Component)this.m_statusPane, "South");
            ToolTipManager.sharedInstance().setInitialDelay(10);
            Messenger.singleton().addListener(this);
            this.addWindowListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            this.handleMessage(message, sender, data);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public abstract void handleMessage(Messenger.Message var1, Object var2, Object var3);

    protected void createMenus() {
    }

    @Override
    public void closeSelectedComponent() {
        try {
            int sel;
            if (this.m_tabs != null && (sel = this.m_tabs.getSelectedIndex()) >= 0) {
                this.m_tabs.remove(sel);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void closeLeftSelectedComponent() {
        try {
            int sel;
            if (this.m_leftTabs != null && (sel = this.m_leftTabs.getSelectedIndex()) >= 0) {
                this.m_leftTabs.remove(sel);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void closeRightSelectedComponent() {
        try {
            int sel;
            if (this.m_rightTabs != null && (sel = this.m_rightTabs.getSelectedIndex()) >= 0) {
                this.m_rightTabs.remove(sel);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void closeAllLeftComponents() {
        try {
            if (this.m_leftTabs != null) {
                this.m_leftTabs.removeAll();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void closeAllRightComponents() {
        try {
            if (this.m_rightTabs != null) {
                this.m_rightTabs.removeAll();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void closeAllComponents() {
        try {
            for (JTabbedPane tabs : this.m_tabList) {
                tabs.removeAll();
            }
            Messenger.singleton().clearListeners();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            Messenger.singleton().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void setMenuEnabled(boolean enabled) {
        try {
            int numMenus = this.m_menuBar.getMenuCount();
            for (int n = 0; n < numMenus; ++n) {
                this.m_menuBar.getMenu(n).setEnabled(enabled);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void unlockAllComponents() {
        try {
            this.setMenuEnabled(true);
            for (JTabbedPane tabs : this.m_tabList) {
                for (int n = 0; n < tabs.getTabCount(); ++n) {
                    tabs.setEnabledAt(n, true);
                }
            }
            if (this.m_tabIndexBeforeLock >= 0 && this.m_tabIndexBeforeLock < this.m_jobTabs.getTabCount()) {
                this.m_jobTabs.setSelectedIndex(this.m_tabIndexBeforeLock);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public JComponent showAndLockComponent(String componentClassName, String tabLabel, String mdiLabel) {
        try {
            if (this.m_jobTabs != null) {
                this.m_tabIndexBeforeLock = this.m_jobTabs.getSelectedIndex();
                this.setMenuEnabled(false);
                this.AskWhichTab = false;
                this.showComponent(componentClassName, tabLabel, mdiLabel, true);
                this.AskWhichTab = true;
                int index = this.m_jobTabs.getSelectedIndex();
                for (JTabbedPane tabs : this.m_tabList) {
                    for (int n = 0; n < tabs.getTabCount(); ++n) {
                        tabs.setEnabledAt(n, false);
                    }
                }
                this.m_jobTabs.setEnabledAt(index, true);
                return (JComponent)this.m_jobTabs.getSelectedComponent();
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void showComponent(String componentClassName, String tabLabel, String mdiLabel, boolean unique) {
        try {
            this.m_specialCase = componentClassName.equalsIgnoreCase(BasicPickWidget_V2.class.getName());
            if (this.m_tabs != null) {
                this.addComponentToTab(componentClassName, tabLabel, mdiLabel, unique);
            }
            if (this.m_splitMain != null) {
                this.addComponentToSplitTabs(componentClassName, tabLabel, mdiLabel, unique);
            }
            if (this.m_mdiDesktop != null) {
                this.addComponent_MDI(componentClassName, unique, tabLabel, mdiLabel);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void showComponent(JComponent c, String tabLabel, String mdiLabel) {
        try {
            if (this.m_tabs != null) {
                this.m_tabs.addTab(tabLabel, null, c, mdiLabel);
                this.m_tabs.setSelectedIndex(this.m_tabs.getTabCount() - 1);
            }
            if (this.m_leftTabs != null) {
                this.m_leftTabs.addTab(tabLabel, null, c, mdiLabel);
                this.m_leftTabs.setSelectedIndex(this.m_leftTabs.getTabCount() - 1);
            }
            if (this.m_mdiDesktop != null) {
                MDIInternalFrame frame = new MDIInternalFrame(c, mdiLabel);
                this.m_mdiDesktop.add(frame);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected boolean checkUniqueTabs(String componentClassName) {
        try {
            for (JTabbedPane tabs : this.m_tabList) {
                for (int n = 0; n < tabs.getTabCount(); ++n) {
                    String name = tabs.getComponentAt(n).getClass().getName();
                    if (!name.equalsIgnoreCase(componentClassName)) continue;
                    tabs.setSelectedIndex(n);
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected void addComponentToSelectedTab(JTabbedPane tabPane, String componentClassName, String tabLabel, String mdiLabel, boolean unique) {
        try {
            boolean killButton = true;
            try {
                Preferences prefs = Preferences.userRoot();
                killButton = prefs.getBoolean("KillButton", true);
            }
            catch (Exception prefs) {
                // empty catch block
            }
            if (unique && this.checkUniqueTabs(componentClassName)) {
                return;
            }
            ClassLoader loader = this.getClass().getClassLoader();
            Class<?> tempClass = loader.loadClass(componentClassName);
            if (tempClass == null) {
                return;
            }
            Object obj = tempClass.newInstance();
            if (!(obj instanceof JComponent)) {
                return;
            }
            JComponent c = (JComponent)obj;
            int newIndex = tabPane.getTabCount();
            if (unique) {
                tabPane.addTab((String)tabLabel, null, c, mdiLabel);
                tabPane.setSelectedIndex(newIndex);
                if (killButton) {
                    tabPane.setTabComponentAt(newIndex, new ButtonTabComponent(tabPane));
                }
                SharedApplicationData.singleton().LaunchData = null;
                return;
            }
            boolean isPicker = c instanceof BasicPickWidget_V2;
            if (isPicker) {
                BasicPickWidget_V2 picker = (BasicPickWidget_V2)c;
                BasicPickWidget_V2.LayoutMethod layout = picker.layoutMethod();
                HashMap_Integer map = new HashMap_Integer();
                for (JTabbedPane tabs : this.m_tabList) {
                    for (int n = 0; n < tabs.getTabCount(); ++n) {
                        BasicPickWidget_V2 p;
                        if (!(tabs.getComponentAt(n) instanceof BasicPickWidget_V2) || (p = (BasicPickWidget_V2)tabs.getComponentAt(n)).layoutMethod() != layout) continue;
                        map.put(p.getWidgetNumber(), n);
                    }
                }
                int number = 1;
                while (map.containsKey(number)) {
                    ++number;
                }
                picker.setWidgetNumber(number);
                tabLabel = (String)tabLabel + " #" + Integer.toString(number);
            }
            if (c instanceof INumberedWidget && !isPicker) {
                INumberedWidget nw = (INumberedWidget)((Object)c);
                HashMap_Integer map = new HashMap_Integer();
                for (JTabbedPane tabs : this.m_tabList) {
                    for (int n = 0; n < tabs.getTabCount(); ++n) {
                        String name = tabs.getComponentAt(n).getClass().getName();
                        if (!name.equalsIgnoreCase(componentClassName) || !(tabs.getComponentAt(n) instanceof INumberedWidget)) continue;
                        INumberedWidget numw = (INumberedWidget)((Object)tabs.getComponentAt(n));
                        map.put(numw.getWidgetNumber(), n);
                    }
                }
                int number = 1;
                while (map.containsKey(number)) {
                    ++number;
                }
                nw.setWidgetNumber(number);
                tabLabel = (String)tabLabel + " #" + Integer.toString(number);
            }
            tabPane.addTab((String)tabLabel, null, c, mdiLabel);
            tabPane.setSelectedIndex(newIndex);
            if (killButton) {
                tabPane.setTabComponentAt(newIndex, new ButtonTabComponent(tabPane));
            }
            SharedApplicationData.singleton().LaunchData = null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void addComponentToSplitTabs(String componentClassName, String tabLabel, String mdiLabel, boolean unique) {
        try {
            JTabbedPane tabs = this.m_jobTabs;
            if (this.AskWhichTab) {
                if (this.m_whichDialog == null) {
                    this.m_whichDialog = new MultiButtonTextDialog(LinearLayoutWidget.Direction.Horizontal, null, "", "Add to left tabs", "Add to right tabs");
                }
                this.m_whichDialog.showDialog();
                if (this.m_whichDialog.SelectedButtonIndex == 0) {
                    tabs = this.m_leftTabs;
                }
                if (this.m_whichDialog.SelectedButtonIndex == 1) {
                    tabs = this.m_rightTabs;
                }
            }
            this.addComponentToSelectedTab(tabs, componentClassName, tabLabel, mdiLabel, unique);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void addComponentToTab(String componentClassName, String tabLabel, String mdiLabel, boolean unique) {
        try {
            this.addComponentToSelectedTab(this.m_tabs, componentClassName, tabLabel, mdiLabel, unique);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void addComponent_MDI(String componentClassName, boolean single, String shortLabel, String longLabel) {
        try {
            ClassLoader loader;
            Class<?> tempClass;
            INumberedWidget nw;
            HashMap_Integer map = new HashMap_Integer();
            JInternalFrame[] frames = this.m_mdiDesktop.getAllFrames();
            if (frames != null) {
                for (int n = 0; n < frames.length; ++n) {
                    MDIInternalFrame frame;
                    JComponent comp;
                    String name;
                    if (!(frames[n] instanceof MDIInternalFrame) || !(name = (comp = (frame = (MDIInternalFrame)frames[n]).getComponent()).getClass().getName()).equalsIgnoreCase(componentClassName)) continue;
                    if (single) {
                        frames[n].moveToFront();
                        return;
                    }
                    if (!(comp instanceof INumberedWidget)) continue;
                    nw = (INumberedWidget)((Object)comp);
                    map.put(nw.getWidgetNumber(), n);
                }
            }
            if ((tempClass = (loader = this.getClass().getClassLoader()).loadClass(componentClassName)) == null) {
                return;
            }
            Object obj = tempClass.newInstance();
            if (!(obj instanceof JComponent)) {
                return;
            }
            JComponent comp = (JComponent)obj;
            if (comp == null) {
                return;
            }
            if (comp instanceof INumberedWidget) {
                nw = (INumberedWidget)((Object)comp);
                int number = 1;
                while (map.containsKey(number)) {
                    ++number;
                }
                nw.setWidgetNumber(number);
                longLabel = (String)longLabel + " #" + Integer.toString(number);
            }
            MDIInternalFrame frame = new MDIInternalFrame(comp, (String)longLabel);
            this.m_mdiDesktop.add(frame);
            SharedApplicationData.singleton().LaunchData = null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

