/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Action;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Action_Messenger;
import com.PecosLibrary.Action.Action_Thread;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ActionSequence_Widget
extends LinearLayoutWidget
implements ActionListener {
    protected ScrollTable m_table = new ScrollTable();
    protected JProgressBar m_progressBar = new JProgressBar();
    protected JLabel m_actionDescriptionLabel = new JLabel("", 0);
    protected JLabel m_mainStatusLabel = new JLabel("", 0);
    protected JLabel m_subStatusLabel = new JLabel("", 0);
    protected JLabel m_timeLabel = new JLabel("", 0);
    protected JLabel m_etaLabel = new JLabel("", 0);
    protected JButton m_stopCurrentActionButton = new JButton("Stop current action");
    protected JButton m_kilAllButton = new JButton("Stop all actions");
    protected boolean m_firstFinishedUpdate = false;
    protected Action_Thread m_thread;

    public ActionSequence_Widget(Action_Thread thread) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_thread = thread;
            this.addComponent(this.m_table, 10);
            this.m_table.table().setModel(thread.tableModel());
            this.m_table.table().setAutoResizeMode(0);
            this.m_table.table().getColumnModel().getColumn(thread.m_colIndex_Description).setMinWidth(180);
            this.m_table.table().getColumnModel().getColumn(thread.m_colIndex_Message).setMinWidth(180);
            this.m_table.table().getColumnModel().getColumn(thread.m_colIndex_RunTime).setMinWidth(130);
            this.m_table.table().getColumnModel().getColumn(thread.m_colIndex_Status).setMinWidth(80);
            this.m_actionDescriptionLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            this.m_actionDescriptionLabel.setForeground(Color.blue);
            this.m_progressBar.setMinimum(0);
            this.m_progressBar.setMaximum(1000);
            this.m_progressBar.setStringPainted(true);
            GridLayoutWidget gb = this.createGridLayoutWidget(3, null, 0);
            int row = 0;
            gb.createLabel("Current action:", row, 0, 3, 4);
            gb.addComponent(this.m_actionDescriptionLabel, row, 1, 1.0, 10.0);
            gb.createLabel("Status:", ++row, 0, 3, 4);
            gb.addComponent(this.m_mainStatusLabel, row, 1, 1.0, 10.0);
            gb.createLabel("Status:", ++row, 0, 3, 4);
            gb.addComponent(this.m_subStatusLabel, row, 1, 1.0, 10.0);
            gb.createLabel("Time, memory:", ++row, 0, 3, 4);
            gb.addComponent(this.m_timeLabel, row, 1, 1.0, 10.0);
            gb.createLabel("Estimated time left:", ++row, 0, 3, 4);
            gb.addComponent(this.m_etaLabel, row, 1, 1.0, 10.0);
            gb.createLabel("Progress:", ++row, 0, 3, 4);
            gb.addComponent(this.m_progressBar, row, 1, 1.0, 10.0);
            ++row;
            Tools_FontChanger.changeSizeOfFont(gb, 2, null, true);
            this.m_stopCurrentActionButton.addActionListener(this);
            this.m_kilAllButton.addActionListener(this);
            LinearLayoutWidget w = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            w.addComponent(this.m_stopCurrentActionButton, 0);
            w.addComponent(this.m_kilAllButton, 0);
            w.addStretch(10);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_stopCurrentActionButton) {
                this.m_thread.stopCurrentAction();
                return;
            }
            if (e.getSource() == this.m_kilAllButton) {
                this.m_thread.stopAllActions();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void updateGUI() {
        try {
            Action_Messenger messageServer = this.m_thread.messenger();
            this.m_stopCurrentActionButton.setEnabled(this.m_thread.isAlive());
            this.m_kilAllButton.setEnabled(this.m_thread.isAlive());
            if (messageServer.tableModified()) {
                this.m_thread.tableModel().fireTableDataChanged();
                messageServer.setTableModified(false);
            }
            if (this.m_thread.isAlive()) {
                if (messageServer.messageModified(0)) {
                    this.m_actionDescriptionLabel.setText(messageServer.message(0));
                }
                if (messageServer.messageModified(2)) {
                    this.m_mainStatusLabel.setText(messageServer.message(2));
                }
                if (messageServer.messageModified(3)) {
                    this.m_subStatusLabel.setText(messageServer.message(3));
                }
                this.m_timeLabel.setText(messageServer.getTimeMem());
                this.m_etaLabel.setText(messageServer.getTimeLeft());
                if (messageServer.percentModified()) {
                    int v = (int)(10.0 * messageServer.percentDone());
                    v = Math.max(v, 0);
                    v = Math.min(v, 1000);
                    this.m_progressBar.setValue(v);
                    this.m_progressBar.setString(Double.toString((double)v / 10.0) + "%");
                }
                return;
            }
            if (this.m_thread.finished() && !this.m_firstFinishedUpdate) {
                this.m_firstFinishedUpdate = true;
                Thread.State state = this.m_thread.getState();
                System.out.println("m_thread.finishedRunning(), state = " + state.name());
                this.m_progressBar.setValue(0);
                this.m_mainStatusLabel.setText("");
                this.m_subStatusLabel.setText("");
                this.m_timeLabel.setText("");
                this.m_actionDescriptionLabel.setText(" Finished ");
                this.m_thread.tableModel().fireTableDataChanged();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

