/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Action;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Action_Messenger;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Action.Action_Thread;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Volume.VolumeProject;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;

public class ActionSequence_InternalWidget
extends JSplitPane
implements ActionListener {
    protected Timer m_timer = new Timer(500, this);
    protected boolean m_bStartedThread = false;
    protected int m_timerCount = 0;
    protected Action_Thread m_thread;
    public UseWhichProject WhichProject = UseWhichProject.Refraction;
    protected ScrollTable m_table = new ScrollTable();
    protected JProgressBar m_progressBar = new JProgressBar();
    protected JProgressBar m_subtaskprogressBar = new JProgressBar();
    protected JLabel m_actionDescriptionLabel = new JLabel("", 0);
    protected JLabel m_mainStatusLabel = new JLabel("", 0);
    protected JLabel m_subStatusLabel = new JLabel("", 0);
    protected JLabel m_timeLabel = new JLabel("", 0);
    protected JLabel m_etaLabel = new JLabel("", 0);
    protected JButton m_stopCurrentActionButton = new JButton("Stop current action");
    protected JButton m_kilAllButton = new JButton("Stop all actions");
    protected boolean m_firstUpdate = false;
    protected boolean m_bThreadFinishedCalled = false;
    protected int m_numBadPrint = 0;
    protected int m_numPrintThreadFinished = 0;

    public ActionSequence_InternalWidget() {
        super(1);
        try {
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeft() {
        try {
            JSplitPane splitter = new JSplitPane(0);
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, null);
            main.addComponent(this.m_table, 10);
            this.m_table.table().setModel(new DefaultTableModel());
            this.m_actionDescriptionLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            this.m_actionDescriptionLabel.setForeground(Color.blue);
            this.m_progressBar.setMinimum(0);
            this.m_progressBar.setMaximum(1000);
            this.m_progressBar.setStringPainted(true);
            this.m_subtaskprogressBar.setMinimum(0);
            this.m_subtaskprogressBar.setMaximum(1000);
            this.m_subtaskprogressBar.setStringPainted(true);
            GridLayoutWidget gb = main.createGridLayoutWidget(3, null, 0);
            int row = 0;
            gb.createLabel("Current action:", row, 0, 3, 4);
            gb.addComponent(this.m_actionDescriptionLabel, row, 1, 1.0, 10.0);
            gb.createLabel("Status:", ++row, 0, 3, 4);
            gb.addComponent(this.m_mainStatusLabel, row, 1, 1.0, 10.0);
            gb.createLabel("Status:", ++row, 0, 3, 4);
            gb.addComponent(this.m_subStatusLabel, row, 1, 1.0, 10.0);
            gb.createLabel("Time, memory:", ++row, 0, 3, 4);
            gb.addComponent(this.m_timeLabel, row, 1, 1.0, 10.0);
            gb.createLabel("Estimated time left:", ++row, 0, 3, 4);
            gb.addComponent(this.m_etaLabel, row, 1, 1.0, 10.0);
            gb.createLabel("Progress:", ++row, 0, 3, 4);
            gb.addComponent(this.m_progressBar, row, 1, 1.0, 10.0);
            gb.createLabel("Subtask Progress:", ++row, 0, 3, 4);
            gb.addComponent(this.m_subtaskprogressBar, row, 1, 1.0, 10.0);
            ++row;
            this.m_stopCurrentActionButton.addActionListener(this);
            this.m_kilAllButton.addActionListener(this);
            LinearLayoutWidget w = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            w.addComponent(this.m_stopCurrentActionButton, 0);
            w.addComponent(this.m_kilAllButton, 0);
            w.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            LinearLayoutWidget bottom = LinearLayoutWidget.vert(3, null);
            splitter.setTopComponent(main);
            splitter.setBottomComponent(bottom);
            splitter.setDividerLocation(0.5);
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, null);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void startJob(Action_Sequence actionSequence) {
        try {
            Action_Sequence sequence = null;
            if (actionSequence == null) {
                if (this.WhichProject == UseWhichProject.Refraction) {
                    sequence = RefractionStaticsProject.singleton().actionSequence();
                }
                if (this.WhichProject == UseWhichProject.Volume) {
                    sequence = VolumeProject.singleton().actionSequence();
                }
            } else {
                sequence = actionSequence;
            }
            this.m_bStartedThread = false;
            this.m_firstUpdate = true;
            this.m_thread = new Action_Thread();
            this.m_thread.setSequence(sequence);
            this.m_timer.start();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void updateGUI() {
        try {
            int v;
            boolean running = false;
            if (this.m_thread != null) {
                running = this.m_thread.isAlive();
            }
            this.m_stopCurrentActionButton.setEnabled(running);
            this.m_kilAllButton.setEnabled(running);
            if (!running) {
                this.m_table.table().setModel(new DefaultTableModel());
                this.m_progressBar.setValue(0);
                this.m_subtaskprogressBar.setValue(0);
                this.m_mainStatusLabel.setText("");
                this.m_subStatusLabel.setText("");
                this.m_timeLabel.setText("");
                this.m_actionDescriptionLabel.setText(" Finished ");
                return;
            }
            Action_Messenger messageServer = this.m_thread.messenger();
            if (this.m_firstUpdate) {
                this.m_table.table().setModel(this.m_thread.tableModel());
                this.m_table.table().setAutoResizeMode(0);
                this.m_table.table().getColumnModel().getColumn(this.m_thread.m_colIndex_Description).setMinWidth(160);
                this.m_table.table().getColumnModel().getColumn(this.m_thread.m_colIndex_Message).setMinWidth(160);
                this.m_table.table().getColumnModel().getColumn(this.m_thread.m_colIndex_RunTime).setMinWidth(110);
                this.m_table.table().getColumnModel().getColumn(this.m_thread.m_colIndex_Status).setMinWidth(80);
            }
            if (messageServer.tableModified()) {
                this.m_thread.tableModel().fireTableDataChanged();
                messageServer.setTableModified(false);
            }
            this.m_firstUpdate = false;
            if (messageServer.messageModified(0)) {
                this.m_actionDescriptionLabel.setText(messageServer.message(0));
            }
            if (messageServer.messageModified(2)) {
                this.m_mainStatusLabel.setText(messageServer.message(2));
            }
            if (messageServer.messageModified(3)) {
                this.m_subStatusLabel.setText(messageServer.message(3));
            }
            this.m_timeLabel.setText(messageServer.getTimeMem());
            this.m_etaLabel.setText(messageServer.getTimeLeft());
            if (messageServer.percentModified()) {
                v = (int)(10.0 * messageServer.percentDone());
                v = Math.max(v, 0);
                v = Math.min(v, 1000);
                this.m_progressBar.setValue(v);
                this.m_progressBar.setString(Double.toString((double)v / 10.0) + "%");
            }
            if (messageServer.subtaskpercentModified()) {
                v = (int)(10.0 * messageServer.subtaskpercentDone());
                v = Math.max(v, 0);
                v = Math.min(v, 1000);
                this.m_subtaskprogressBar.setValue(v);
                this.m_subtaskprogressBar.setString(Double.toString((double)v / 10.0) + "%");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_stopCurrentActionButton) {
                if (this.m_thread != null) {
                    this.m_thread.stopCurrentAction();
                }
                return;
            }
            if (e.getSource() == this.m_kilAllButton) {
                if (this.m_thread != null) {
                    this.m_thread.stopAllActions();
                }
                return;
            }
            if (e.getSource() == this.m_timer) {
                if (this.m_thread == null) {
                    SharedApplicationData.JobRunning = false;
                    this.m_timer.stop();
                    return;
                }
                if (this.m_thread != null && !this.m_bStartedThread) {
                    this.m_bStartedThread = true;
                    SharedApplicationData.JobRunning = true;
                    this.m_thread.startThread();
                    this.updateGUI();
                    System.out.println("ActionSequence_InternalWidget: just started thread");
                    return;
                }
                if (this.m_thread.isAlive()) {
                    SharedApplicationData.JobRunning = true;
                    this.updateGUI();
                    return;
                }
                if (this.m_thread.finished()) {
                    if (this.m_numPrintThreadFinished < 10) {
                        ++this.m_numPrintThreadFinished;
                        System.out.println("m_timer event, m_thread.finished() called");
                    }
                    if (this.m_bThreadFinishedCalled && this.m_numBadPrint < 10) {
                        System.out.println("m_timer event, m_thread.finished() function, m_bThreadFinishedCalled alrady true???");
                        ++this.m_numBadPrint;
                    }
                    this.m_bThreadFinishedCalled = true;
                    SharedApplicationData.JobRunning = false;
                    this.m_timer.stop();
                    Action_Sequence sequence = this.m_thread.sequence();
                    this.m_thread = null;
                    this.updateGUI();
                    if (SharedApplicationData.singleton().getComponentManager() != null) {
                        SharedApplicationData.singleton().getComponentManager().unlockAllComponents();
                    }
                    sequence.sendSequenceFinished();
                    sequence.clearListeners();
                    System.out.println("ActionSequence_InternalWidget: Messenger.broadcastReloadAllGathers(null)");
                    Messenger.broadcastReloadAllGathers(null);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static enum UseWhichProject {
        Refraction,
        Volume;

    }
}

