/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.WaveEquation;

import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.VNS.Tomo_VNS;
import com.PecosLibrary.WaveEquation.Model3D;
import com.PecosLibrary.WaveEquation.Propagator_Chelsea;
import com.PecosLibrary.WaveEquation.Propagator_Darrell;
import com.PecosLibrary.WaveEquation.Propagator_Igor;

public class WaveEquationTest {
    protected Ensemble m_emptyEnsemble = new Ensemble();
    protected Ensemble m_ensembleApplied = new Ensemble();
    protected Ensemble m_ensembleWEC = new Ensemble();
    protected Model3D m_model = new Model3D();
    public Propagator_Igor Igor = new Propagator_Igor();
    public Propagator_Chelsea Chelsea = new Propagator_Chelsea();
    public Propagator_Darrell Darrell = new Propagator_Darrell();
    public double MaxOff = 1000.0;
    public double MaxTime = 300.0;
    public double BinSize = 50.0;
    public double TimeStep = 0.25;
    public int NodeBufferCount = 10;
    public int PropagationMethod = 0;

    public Ensemble emptyEnsemble() {
        return this.m_emptyEnsemble;
    }

    public Ensemble ensembleApplied() {
        return this.m_ensembleApplied;
    }

    public Ensemble ensembleWEC() {
        return this.m_ensembleWEC;
    }

    public Model3D model() {
        return this.m_model;
    }

    public void recomputeWEQC() {
        try {
            String table = "Trace";
            String column = "Axis";
            this.m_ensembleWEC.sortDouble(0, "Trace", "Offset");
            this.m_ensembleApplied.clearTraces(false);
            int indexAxis = this.m_ensembleApplied.dictionary().addEntry(table, column, DataType.Double);
            int indexOffset_Input = this.m_ensembleWEC.dictionary().addEntry("Trace", "Offset", DataType.Double);
            int indexOffset = this.m_ensembleApplied.dictionary().addEntry("Trace", "Offset", DataType.Double);
            int indexSrcX_Input = this.m_ensembleWEC.dictionary().addEntry("Shot", "Easting", DataType.Double);
            int indexSrcX = this.m_ensembleApplied.dictionary().addEntry("Shot", "Easting", DataType.Double);
            int indexSrcY_Input = this.m_ensembleWEC.dictionary().addEntry("Shot", "Northing", DataType.Double);
            int indexSrcY = this.m_ensembleApplied.dictionary().addEntry("Shot", "Northing", DataType.Double);
            int indexSrcZ_Input = this.m_ensembleWEC.dictionary().addEntry("Shot", "Elevation", DataType.Double);
            int indexSrcZ = this.m_ensembleApplied.dictionary().addEntry("Shot", "Elevation", DataType.Double);
            int indexRecX_Input = this.m_ensembleWEC.dictionary().addEntry("Receiver", "Easting", DataType.Double);
            int indexRecX = this.m_ensembleApplied.dictionary().addEntry("Receiver", "Easting", DataType.Double);
            int indexRecY_Input = this.m_ensembleWEC.dictionary().addEntry("Receiver", "Northing", DataType.Double);
            int indexRecY = this.m_ensembleApplied.dictionary().addEntry("Receiver", "Northing", DataType.Double);
            int indexRecZ_Input = this.m_ensembleWEC.dictionary().addEntry("Receiver", "Elevation", DataType.Double);
            int indexRecZ = this.m_ensembleApplied.dictionary().addEntry("Receiver", "Elevation", DataType.Double);
            double axis = 0.0;
            float[] outputArray = new float[2];
            float[] inputArray = new float[2];
            double minElevation = Double.MAX_VALUE;
            double maxElevation = Double.MIN_VALUE;
            double shotX = 0.0;
            double shotY = 0.0;
            double shotZ = 0.0;
            float digi = 4.0f;
            int numOutputSamples = 20;
            for (int n = 0; n < this.m_ensembleWEC.traceCount(); ++n) {
                int s;
                EnsembleTrace t = this.m_ensembleWEC.trace(n);
                if (inputArray.length != t.data().length()) {
                    inputArray = new float[t.data().length()];
                }
                t.data().copyToArray(inputArray);
                digi = t.data().getSampleInterval();
                numOutputSamples = (int)(0.5 + this.MaxTime / (double)digi);
                if (outputArray.length != numOutputSamples) {
                    outputArray = new float[numOutputSamples];
                }
                for (s = 0; s < outputArray.length; ++s) {
                    outputArray[s] = 0.0f;
                }
                for (s = 0; s < Math.min(numOutputSamples, inputArray.length); ++s) {
                    outputArray[s] = inputArray[s];
                }
                double offset = t.header().getDouble(indexOffset_Input);
                if (!(offset < this.MaxOff)) continue;
                for (int m = 0; m <= 1; ++m) {
                    axis = (double)n - 0.15;
                    if (m == 1) {
                        axis = (double)n + 0.15;
                    }
                    EnsembleTrace t1 = this.m_ensembleApplied.addTrace();
                    t1.data().setSampleInterval(digi);
                    t1.data().insertArray(outputArray, numOutputSamples);
                    shotX = t.header().getDouble(indexSrcX_Input);
                    shotY = t.header().getDouble(indexSrcY_Input);
                    shotZ = t.header().getDouble(indexSrcZ_Input);
                    minElevation = Math.min(minElevation, t.header().getDouble(indexSrcZ_Input));
                    minElevation = Math.min(minElevation, t.header().getDouble(indexRecZ_Input));
                    maxElevation = Math.max(maxElevation, t.header().getDouble(indexSrcZ_Input));
                    maxElevation = Math.max(maxElevation, t.header().getDouble(indexRecZ_Input));
                    t1.header().putDouble(indexAxis, axis);
                    t1.header().putDouble(indexSrcX, t.header().getDouble(indexSrcX_Input));
                    t1.header().putDouble(indexSrcY, t.header().getDouble(indexSrcY_Input));
                    t1.header().putDouble(indexSrcZ, t.header().getDouble(indexSrcZ_Input));
                    t1.header().putDouble(indexRecX, t.header().getDouble(indexRecX_Input));
                    t1.header().putDouble(indexRecY, t.header().getDouble(indexRecY_Input));
                    t1.header().putDouble(indexRecZ, t.header().getDouble(indexRecZ_Input));
                    t1.header().putDouble(indexOffset, t.header().getDouble(indexOffset_Input));
                }
            }
            int radius = this.NodeBufferCount + (int)(this.MaxOff / this.BinSize);
            int numNodesHorz = 1 + 2 * radius;
            Tomo_VNS vns = RefractionStaticsProject.singleton().getTomo_VNS();
            float[] node = vns.nodeDepth();
            float maxDepth = node[node.length - 1];
            double minZ = minElevation - (double)maxDepth;
            int numNodesVert = this.NodeBufferCount + (int)((maxElevation - (minZ -= (double)this.NodeBufferCount * this.BinSize)) / this.BinSize);
            System.out.format("minElev: %f  maxElev: %f  minZ: %f  maxDepth: %f  numNodesVert: %d\n", minElevation, maxElevation, minZ, Float.valueOf(maxDepth), numNodesVert);
            double minX = shotX - (double)(radius * numNodesHorz);
            double minY = shotY - (double)(radius * numNodesHorz);
            this.m_model.setNodeCounts(numNodesHorz, numNodesHorz, numNodesVert);
            this.m_model.setAngle(0.0);
            this.m_model.setNodeSpacing(this.BinSize);
            this.m_model.setOrigin(minX, minY, minZ);
            float[][][] vel = this.m_model.array_get("Velocity");
            for (int ix = 0; ix < numNodesHorz; ++ix) {
                for (int iy = 0; iy < numNodesHorz; ++iy) {
                    for (int iz = 0; iz < numNodesVert; ++iz) {
                        double x = minX + (double)ix * this.BinSize;
                        double y = minY + (double)iy * this.BinSize;
                        double z = minZ + (double)iz * this.BinSize;
                        vns.setWorldLocation(x, y, z, true, true);
                        double s = vns.SlownessAtWorld;
                        vel[ix][iy][iz] = (float)(1000.0 / s);
                    }
                }
            }
            if (this.TimeStep >= (double)digi) {
                this.TimeStep = digi;
            } else {
                int fac = (int)(0.5 + (double)digi / this.TimeStep);
                this.TimeStep = digi / (float)fac;
            }
            if (this.PropagationMethod == 0) {
                this.Igor.prepareForPropagation(this.m_model, shotX, shotY, shotZ, this.TimeStep);
                this.Igor.prepareSponge(this.m_model, this.NodeBufferCount, 0.5);
            }
            if (this.PropagationMethod == 1) {
                this.Chelsea.prepareForPropagation(this.m_model, shotX, shotY, shotZ, this.TimeStep);
                this.Chelsea.prepareSponge(this.m_model, this.NodeBufferCount, 0.5);
            }
            if (this.PropagationMethod == 2) {
                this.Darrell.prepareForPropagation(this.m_model, shotX, shotY, shotZ, this.TimeStep);
                this.Darrell.prepareSponge(this.m_model, this.NodeBufferCount, 0.006);
            }
            if (this.PropagationMethod == 3) {
                this.Darrell.prepareForPropagation(this.m_model, shotX, shotY, shotZ, this.TimeStep);
                this.Darrell.prepareSponge(this.m_model, this.NodeBufferCount, 0.006);
            }
            for (int s = 0; s < numOutputSamples; ++s) {
                System.out.println(String.format("%3d  of  %3d samples digi: %f  TimeStep: %f", s, numOutputSamples, Float.valueOf(digi), this.TimeStep));
                for (int n = 1; n < this.m_ensembleApplied.traceCount(); n += 2) {
                    EnsembleTrace t = this.m_ensembleApplied.trace(n);
                    double rx = t.header().getDouble(indexRecX);
                    double ry = t.header().getDouble(indexRecY);
                    double rz = t.header().getDouble(indexRecZ);
                    this.m_model.setWorldCoordinates(rx, ry, rz, true);
                    t.data().copyToArray(outputArray);
                    outputArray[s] = this.m_model.getInterpolatedValue("pfield_time");
                    t.data().insertArray(outputArray, outputArray.length);
                }
                if (this.PropagationMethod == 0) {
                    this.Igor.propagate(this.m_model, digi);
                }
                if (this.PropagationMethod == 1) {
                    this.Chelsea.propagate(this.m_model, digi);
                }
                if (this.PropagationMethod == 2) {
                    this.Darrell.propagate(this.m_model, digi, 0);
                }
                if (this.PropagationMethod != 3) continue;
                this.Darrell.propagate(this.m_model, digi, 1);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

