/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.WaveEquation;

import com.PecosCore.Data.Model.Model3D_CoordinateConversion;
import com.PecosCore.Data.Model.Model3D_Index;
import com.PecosCore.Data.Model.Model3D_Profile_VariableZ;
import com.PecosLibrary.WaveEquation.Model3D;
import java.util.HashMap;
import java.util.Set;

public class Model3D_VariableZ
extends Model3D_CoordinateConversion {
    public static final String Slowness = "Slowness";
    protected double[] m_nodeZ;
    protected static int m_numLookup = 7777;
    protected double m_lookupNodeSpacing = 1.0;
    protected double m_lookupInverseNodeSpacing;
    protected int[] m_lookup_LowerIndex = new int[m_numLookup];
    protected int[] m_lookup_UpperIndex = new int[m_numLookup];
    protected float[] m_lookup_LowerWeight = new float[m_numLookup];
    protected float[] m_lookup_UpperWeight = new float[m_numLookup];
    protected int m_nodeCountX = 3;
    protected int m_nodeCountY = 3;
    protected int m_nodeCountZ = 3;
    protected double m_nodeSpacingX = 25.0;
    protected double m_nodeSpacingY = 25.0;
    protected double m_maximumGridX = 1.0;
    protected double m_maximumGridY = 1.0;
    protected double m_maximumGridZ = 1.0;
    protected double m_inverseNodeSpacingX = 0.04;
    protected double m_inverseNodeSpacingY = 0.04;
    protected HashMap<String, Float> m_hashInterpolated = new HashMap();
    protected HashMap<String, float[][][]> m_hash = new HashMap();
    public Model3D_Index IndexX = new Model3D_Index();
    public Model3D_Index IndexY = new Model3D_Index();
    public Model3D_Index IndexZ = new Model3D_Index();

    public Model3D createModel3D(double nodeSpacing) throws Exception {
        try {
            Model3D model = new Model3D();
            Set<String> keys = this.array_getNames();
            model.setOrigin(this.originX(), this.originY(), this.originZ());
            model.setAngle(this.m_angle);
            model.setNodeSpacing(nodeSpacing);
            int nx = (int)(0.8 + this.maximumGridX() / nodeSpacing);
            int ny = (int)(0.8 + this.maximumGridY() / nodeSpacing);
            int nz = (int)(0.8 + this.maximumGridZ() / nodeSpacing);
            model.setNodeCounts(nx, ny, nz);
            model.interpolateFromModel3D_VariableZ(this);
            return model;
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public double[] nodeZ() {
        return this.m_nodeZ;
    }

    public void createNodeZ(int nodeCount, double nodeSpacing, double originZ) {
        try {
            this.m_nodeCountZ = Math.max(nodeCount, 10);
            this.m_nodeZ = new double[this.m_nodeCountZ];
            for (int n = 0; n < this.m_nodeCountZ; ++n) {
                this.m_nodeZ[n] = originZ + (double)n * nodeSpacing;
            }
            this.computeLookup();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void insertNodeZ(double[] nodeZ) {
        try {
            this.m_nodeCountZ = nodeZ.length;
            this.m_nodeZ = nodeZ;
            this.computeLookup();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void computeLookup() {
        try {
            this.m_maximumGridZ = this.m_nodeZ[this.m_nodeCountZ - 1];
            this.m_originZ = this.m_nodeZ[0];
            this.m_lookupNodeSpacing = (this.m_maximumGridZ - this.m_originZ) / (double)(m_numLookup - 1);
            this.m_lookupInverseNodeSpacing = 1.0 / this.m_lookupNodeSpacing;
            for (int n = 0; n < m_numLookup; ++n) {
                double z = this.m_originZ + (double)n * this.m_lookupNodeSpacing;
                for (int m = 1; m < this.m_nodeCountZ; ++m) {
                    double minZ = this.m_nodeZ[m - 1] - 1.0E-5;
                    double maxZ = this.m_nodeZ[m] + 1.0E-5;
                    if (!(z >= minZ) || !(z <= maxZ)) continue;
                    this.m_lookup_UpperIndex[n] = m;
                    this.m_lookup_LowerIndex[n] = m - 1;
                    this.m_lookup_LowerWeight[n] = (float)((this.m_nodeZ[m] - z) / (this.m_nodeZ[m] - this.m_nodeZ[m - 1]));
                    this.m_lookup_UpperWeight[n] = 1.0f - this.m_lookup_LowerWeight[n];
                    m = 10000000;
                }
                if (n >= 300) continue;
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public double maximumGridX() {
        return this.m_maximumGridX;
    }

    public double maximumGridY() {
        return this.m_maximumGridY;
    }

    public double maximumGridZ() {
        return this.m_maximumGridZ;
    }

    public void profile_Prepare(Model3D_Profile_VariableZ profile, double x1, double y1, double x2, double y2) {
        try {
            int n;
            int nodeCountZ = 2 + (int)((this.m_maximumGridZ - this.m_originZ) / profile.preferredNodeSpacingZ());
            double nodeSpacingZ = (this.m_maximumGridZ - this.m_originZ) / (double)(nodeCountZ - 1);
            double dx = x2 - x1;
            double dy = y2 - y1;
            double offset = Math.sqrt(dx * dx + dy * dy);
            double azimuth = Math.atan2(dy, dx);
            if (profile.forceSameNodeSpacing()) {
                nodeCountH = 3 + (int)(offset / nodeSpacingZ);
                profile.setNodeSpacing(nodeSpacingZ, nodeSpacingZ);
            } else {
                nodeCountH = 2 + (int)(offset / profile.preferredNodeSpacingH());
                double nodeSpacingH = offset / (double)(nodeCountH - 1);
                profile.setNodeSpacing(nodeSpacingH, nodeSpacingZ);
            }
            profile.setNodeCountZ(nodeCountZ);
            profile.setEndPointCoords(x1, y1, x2, y2);
            for (n = 0; n < profile.NumNodesH; ++n) {
                this.setWorldCoordinates(profile.X[n], profile.Y[n], this.m_originZ);
                profile.LowerIndexX[n] = this.IndexX.LowerIndex;
                profile.UpperIndexX[n] = this.IndexX.UpperIndex;
                profile.LowerWeightX[n] = this.IndexX.LowerWeight;
                profile.UpperWeightX[n] = this.IndexX.UpperWeight;
                profile.LowerIndexY[n] = this.IndexY.LowerIndex;
                profile.UpperIndexY[n] = this.IndexY.UpperIndex;
                profile.LowerWeightY[n] = this.IndexY.LowerWeight;
                profile.UpperWeightY[n] = this.IndexY.UpperWeight;
            }
            for (n = 0; n < nodeCountZ; ++n) {
                double gridZ = (double)n * nodeSpacingZ;
                int index = (int)(gridZ * this.m_lookupInverseNodeSpacing);
                index = Math.max(index, 0);
                index = Math.min(index, m_numLookup - 1);
                profile.LowerIndexZ[n] = this.m_lookup_LowerIndex[index];
                profile.LowerWeightZ[n] = this.m_lookup_LowerWeight[index];
                profile.UpperIndexZ[n] = this.m_lookup_UpperIndex[index];
                profile.UpperWeightZ[n] = this.m_lookup_UpperWeight[index];
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void profile_CopyDataToProfile(Model3D_Profile_VariableZ profile, String key) throws Exception {
        try {
            if (!this.m_hash.containsKey(key)) {
                throw new Exception(key + " does not exist");
            }
            float[][][] modelData = this.array_get(key);
            float[][] profileData = profile.getDataArray(key);
            for (int n = 0; n < profile.NumNodesH; ++n) {
                int ix1 = profile.LowerIndexX[n];
                int ix2 = profile.UpperIndexX[n];
                float wx1 = profile.LowerWeightX[n];
                float wx2 = profile.UpperWeightX[n];
                int iy1 = profile.LowerIndexY[n];
                int iy2 = profile.UpperIndexY[n];
                float wy1 = profile.LowerWeightY[n];
                float wy2 = profile.UpperWeightY[n];
                for (int m = 0; m < profile.nodeCountZ(); ++m) {
                    int iz1 = profile.LowerIndexZ[m];
                    int iz2 = profile.UpperIndexZ[m];
                    float wz1 = profile.LowerWeightZ[m];
                    float wz2 = profile.UpperWeightZ[m];
                    float v111 = wx1 * wy1 * wz1 * modelData[ix1][iy1][iz1];
                    float v112 = wx1 * wy1 * wz2 * modelData[ix1][iy1][iz2];
                    float v121 = wx1 * wy2 * wz1 * modelData[ix1][iy2][iz1];
                    float v122 = wx1 * wy2 * wz2 * modelData[ix1][iy2][iz2];
                    float v211 = wx2 * wy1 * wz1 * modelData[ix2][iy1][iz1];
                    float v212 = wx2 * wy1 * wz2 * modelData[ix2][iy1][iz2];
                    float v221 = wx2 * wy2 * wz1 * modelData[ix2][iy2][iz1];
                    float v222 = wx2 * wy2 * wz2 * modelData[ix2][iy2][iz2];
                    profileData[n][m] = v111 + v112 + v121 + v122 + v211 + v212 + v221 + v222;
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public void setNodeSpacing(double nodeSpacingX, double nodeSpacingY) {
        this.m_nodeSpacingX = Math.max(0.01, nodeSpacingX);
        this.m_nodeSpacingY = Math.max(0.01, nodeSpacingY);
        this.computeInternals(true);
        this.m_inverseNodeSpacingX = 1.0 / this.m_nodeSpacingX;
        this.m_inverseNodeSpacingY = 1.0 / this.m_nodeSpacingY;
        this.computeGridRange();
    }

    public double nodeSpacingY() {
        return this.m_nodeSpacingY;
    }

    public double nodeSpacingX() {
        return this.m_nodeSpacingX;
    }

    public void setNodeCounts(int nx, int ny) {
        this.m_nodeCountX = Math.max(3, nx);
        this.m_nodeCountY = Math.max(3, ny);
        this.m_hash.clear();
        this.computeGridRange();
    }

    public int nodeCountX() {
        return this.m_nodeCountX;
    }

    public int nodeCountY() {
        return this.m_nodeCountY;
    }

    public int nodeCountZ() {
        return this.m_nodeCountZ;
    }

    protected void computeGridRange() {
        this.m_maximumGridX = this.m_nodeSpacingX * (double)(this.m_nodeCountX - 1);
        this.m_maximumGridY = this.m_nodeSpacingY * (double)(this.m_nodeCountY - 1);
    }

    public float getInterpolatedValue(String key) throws Exception {
        try {
            return this.m_hashInterpolated.get(key).floatValue();
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public float[][][] array_get(String key) throws Exception {
        try {
            if (!this.m_hash.containsKey(key)) {
                this.m_hash.put(key, new float[this.m_nodeCountX][this.m_nodeCountY][this.m_nodeCountZ]);
            }
            return this.m_hash.get(key);
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public void array_remove(String key) {
        try {
            if (this.m_hash.containsKey(key)) {
                this.m_hash.remove(key);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public Set<String> array_getNames() {
        return this.m_hash.keySet();
    }

    public void array_setValue(String key, float v) {
        try {
            float[][][] array = this.array_get(key);
            for (int x = 0; x < this.m_nodeCountX; ++x) {
                for (int y = 0; y < this.m_nodeCountY; ++y) {
                    for (int z = 0; z < this.m_nodeCountZ; ++z) {
                        array[x][y][z] = v;
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void setWorldCoordinates(double x, double y, double z) throws Exception {
        try {
            this.setWorldCoordinates(x, y, z, false);
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public void setWorldCoordinates(double x, double y, double z, boolean interpolate) throws Exception {
        try {
            this.convertWorldCoordinatesToModelCoordinates(x, y, z);
            this.IndexX.set(this.GridX, this.m_maximumGridX, this.m_inverseNodeSpacingX, this.m_nodeCountX);
            this.IndexY.set(this.GridY, this.m_maximumGridY, this.m_inverseNodeSpacingY, this.m_nodeCountY);
            int index = (int)(this.GridZ * this.m_lookupInverseNodeSpacing);
            index = Math.max(index, 0);
            index = Math.min(index, m_numLookup - 1);
            this.IndexZ.LowerIndex = this.m_lookup_LowerIndex[index];
            this.IndexZ.LowerWeight = this.m_lookup_LowerWeight[index];
            this.IndexZ.UpperIndex = this.m_lookup_UpperIndex[index];
            this.IndexZ.UpperWeight = this.m_lookup_UpperWeight[index];
            this.m_hashInterpolated.clear();
            if (!interpolate) {
                return;
            }
            for (String key : this.m_hash.keySet()) {
                float[][][] v = this.m_hash.get(key);
                float LLL = v[this.IndexX.LowerIndex][this.IndexY.LowerIndex][this.IndexZ.LowerIndex] * this.IndexX.LowerWeight * this.IndexY.LowerWeight * this.IndexZ.LowerWeight;
                float ULL = v[this.IndexX.UpperIndex][this.IndexY.LowerIndex][this.IndexZ.LowerIndex] * this.IndexX.UpperWeight * this.IndexY.LowerWeight * this.IndexZ.LowerWeight;
                float LUL = v[this.IndexX.LowerIndex][this.IndexY.UpperIndex][this.IndexZ.LowerIndex] * this.IndexX.LowerWeight * this.IndexY.UpperWeight * this.IndexZ.LowerWeight;
                float UUL = v[this.IndexX.UpperIndex][this.IndexY.UpperIndex][this.IndexZ.LowerIndex] * this.IndexX.UpperWeight * this.IndexY.UpperWeight * this.IndexZ.LowerWeight;
                float LLU = v[this.IndexX.LowerIndex][this.IndexY.LowerIndex][this.IndexZ.UpperIndex] * this.IndexX.LowerWeight * this.IndexY.LowerWeight * this.IndexZ.UpperWeight;
                float ULU = v[this.IndexX.UpperIndex][this.IndexY.LowerIndex][this.IndexZ.UpperIndex] * this.IndexX.UpperWeight * this.IndexY.LowerWeight * this.IndexZ.UpperWeight;
                float LUU = v[this.IndexX.LowerIndex][this.IndexY.UpperIndex][this.IndexZ.UpperIndex] * this.IndexX.LowerWeight * this.IndexY.UpperWeight * this.IndexZ.UpperWeight;
                float UUU = v[this.IndexX.UpperIndex][this.IndexY.UpperIndex][this.IndexZ.UpperIndex] * this.IndexX.UpperWeight * this.IndexY.UpperWeight * this.IndexZ.UpperWeight;
                float interp = LLL + ULL + LUL + UUL + LLU + ULU + LUU + UUU;
                this.m_hashInterpolated.put(key, Float.valueOf(interp));
            }
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }
}

