/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Tools;

import com.PecosCore.Shared.ExceptionMonitor;

public class Tools_Math {
    public double AX1;
    public double AY1;
    public double AX2;
    public double AY2;
    public double BX1;
    public double BY1;
    public double BX2;
    public double BY2;
    public double R;
    public double S;
    public double X;
    public double Y;
    protected static Tools_Math m_singleton = null;
    protected double[] m_tempDouble = new double[100];

    public static void apply_constraint(float[][][] start_array, float[][][] current_array, float[][][] blend) {
        try {
            int nx = start_array.length;
            int ny = start_array[0].length;
            int nz = start_array[0][0].length;
            for (int x = 0; x < nx; ++x) {
                for (int y = 0; y < ny; ++y) {
                    for (int z = 0; z < nz; ++z) {
                        float b = blend[x][y][z];
                        current_array[x][y][z] = b * start_array[x][y][z] + (1.0f - b) * current_array[x][y][z];
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static float[][][] clone(float[][][] array) {
        try {
            int nx = array.length;
            int ny = array[0].length;
            int nz = array[0][0].length;
            float[][][] temp = new float[nx][ny][nz];
            for (int x = 0; x < nx; ++x) {
                for (int y = 0; y < ny; ++y) {
                    for (int z = 0; z < nz; ++z) {
                        temp[x][y][z] = array[x][y][z];
                    }
                }
            }
            return temp;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static void smooth_3d(float[][][] array, int radh, int radz) {
        try {
            int z;
            int y;
            int x;
            int nx = array.length;
            int ny = array[0].length;
            int nz = array[0][0].length;
            float[][][] temp = new float[nx][ny][nz];
            for (x = 0; x < nx; ++x) {
                for (y = 0; y < ny; ++y) {
                    for (z = 0; z < nz; ++z) {
                        temp[x][y][z] = array[x][y][z];
                    }
                }
            }
            for (x = 0; x < nx; ++x) {
                for (y = 0; y < ny; ++y) {
                    for (z = 0; z < nz; ++z) {
                        int minx = Math.max(x - radh, 0);
                        int maxx = Math.min(x + radh, nx - 1);
                        int miny = Math.max(y - radh, 0);
                        int maxy = Math.min(y + radh, ny - 1);
                        int minz = Math.max(z - radz, 0);
                        int maxz = Math.min(z + radz, nz - 1);
                        double s1 = 0.0;
                        double s2 = 0.0;
                        for (int ix = minx; ix <= maxx; ++ix) {
                            for (int iy = miny; iy <= maxy; ++iy) {
                                for (int iz = minz; iz <= maxz; ++iz) {
                                    double dx = 1.5 + (double)Math.abs(x - ix);
                                    double dy = 1.5 + (double)Math.abs(y - iy);
                                    double dz = 1.5 + (double)Math.abs(z - iz);
                                    double w = 1.0 / (dx + dy + dz);
                                    s1 += w * (double)temp[ix][iy][iz];
                                    s2 += w;
                                }
                            }
                        }
                        array[x][y][z] = (float)(s1 / s2);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean computeIntersection() {
        try {
            double numerator = (this.BX1 - this.AX1) * (this.AY2 - this.AY1) - (this.BY1 - this.AY1) * (this.AX2 - this.AX1);
            double denominator = (this.BY2 - this.BY1) * (this.AX2 - this.AX1) - (this.BX2 - this.BX1) * (this.AY2 - this.AY1);
            if (Math.abs(denominator) < 1.0E-12) {
                return false;
            }
            this.R = numerator / denominator;
            this.X = this.BX1 + this.R * (this.BX2 - this.BX1);
            this.Y = this.BY1 + this.R * (this.BY2 - this.BY1);
            this.S = Math.abs(this.AY2 - this.AY1) > 1.0 ? (this.Y - this.AY1) / (this.AY2 - this.AY1) : (this.X - this.AX1) / (this.AX2 - this.AX1);
            return this.S >= 0.0 && this.S < 1.0 && this.R >= 0.0 && this.R < 1.0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public static Tools_Math singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new Tools_Math();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public boolean interpolateArray(double[] array, double min, double max) {
        try {
            int n;
            if (array == null) {
                return false;
            }
            if (array.length < 1) {
                return false;
            }
            if (this.m_tempDouble.length < array.length) {
                this.m_tempDouble = new double[array.length];
            }
            int minIndex = Integer.MAX_VALUE;
            int maxIndex = Integer.MIN_VALUE;
            for (n = 0; n < array.length; ++n) {
                this.m_tempDouble[n] = array[n];
                if (!(array[n] >= min) || !(array[n] <= max)) continue;
                minIndex = Math.min(n, minIndex);
                maxIndex = Math.max(n, maxIndex);
            }
            if (maxIndex < minIndex) {
                return false;
            }
            for (n = 0; n < minIndex; ++n) {
                array[n] = array[minIndex];
            }
            for (n = maxIndex + 1; n < array.length; ++n) {
                array[n] = array[maxIndex];
            }
            for (n = minIndex + 1; n < maxIndex; ++n) {
                if (!(array[n] < min) && !(array[n] >= max)) continue;
                int imin = n - 1;
                while (this.m_tempDouble[imin] <= min || this.m_tempDouble[imin] >= max) {
                    --imin;
                }
                int imax = n + 1;
                while (this.m_tempDouble[imax] < min || this.m_tempDouble[imax] > max) {
                    ++imax;
                }
                double ta = (double)(n - imin) / (double)(imax - imin);
                double tb = (double)(imax - n) / (double)(imax - imin);
                array[n] = ta * this.m_tempDouble[imax] + tb * this.m_tempDouble[imin];
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }
}

