/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Stack;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Stack.VelocityLocationCollection;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class VelocityManager {
    protected String m_versionPath;
    protected HashMap<String, VelocityLocationCollection> m_hash = new HashMap();
    protected ArrayList<WeakReference<Listener>> m_listeners = new ArrayList();

    public VelocityManager(RefractionStaticsProject project) {
        try {
            this.m_versionPath = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), "VelocityVersions");
            ArrayList<String> files = Tools_FileSystem.files(this.m_versionPath, false, false);
            if (files.size() < 1) {
                String name = this.m_versionPath + "/Default.xml";
                VelocityLocationCollection coll = new VelocityLocationCollection();
                coll.save(name);
                files = Tools_FileSystem.files(this.m_versionPath, false, false);
            }
            for (String name : files) {
                String path;
                if (name.startsWith(".") || !name.endsWith(".xml") || !Tools_FileSystem.exists_file(path = this.m_versionPath + "/" + name)) continue;
                VelocityLocationCollection coll = new VelocityLocationCollection();
                coll.read(path);
                this.m_hash.put(name, coll);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addListener(Listener listener) {
        try {
            if (listener == null) {
                return;
            }
            this.m_listeners.add(new WeakReference<Listener>(listener));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void broadcast(String name, Message msg) {
        try {
            for (int n = this.m_listeners.size() - 1; n >= 0; --n) {
                WeakReference<Listener> listener = this.m_listeners.get(n);
                if (listener.get() != null) continue;
                this.m_listeners.remove(n);
            }
            for (WeakReference<Listener> listener : this.m_listeners) {
                Listener l = (Listener)listener.get();
                if (l == null) continue;
                l.handleVelocityManager(name, msg);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void versionModified(String name) {
        try {
            this.saveVersion(name);
            this.broadcast(name, Message.VersionModified);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void saveVersion(String name) {
        try {
            String path = this.m_versionPath + "/" + name;
            if (this.m_hash.containsKey(name)) {
                this.m_hash.get(name).save(path);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ArrayList<String> getVersionList() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (String s : this.m_hash.keySet()) {
                list.add(s);
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public String addVersion(String name) throws Exception {
        try {
            if (name == null) {
                throw new Exception("name == null");
            }
            if (name.length() < 1) {
                throw new Exception("name.length() < 1");
            }
            if (!Tools_Strings.isAlphaNumeric(name, true, true)) {
                throw new Exception("Invalid name");
            }
            if (this.m_hash.containsKey(name = Tools_Strings.confirmSuffix(name, "xml"))) {
                return name;
            }
            String path = this.m_versionPath + "/" + name;
            VelocityLocationCollection coll = new VelocityLocationCollection();
            coll.save(path);
            this.m_hash.put(name, coll);
            this.broadcast(name, Message.VersionAdded);
            return name;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public VelocityLocationCollection getVelocityLocationCollection(String name) throws Exception {
        try {
            return this.m_hash.get(name);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public VelocityLocationCollection getVelocityLocationCollection() throws Exception {
        try {
            Iterator<VelocityLocationCollection> iterator = this.m_hash.values().iterator();
            if (iterator.hasNext()) {
                VelocityLocationCollection vlc = iterator.next();
                return vlc;
            }
            return null;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static interface Listener {
        public void handleVelocityManager(String var1, Message var2);
    }

    public static enum Message {
        VersionAdded,
        VersionModified;

    }
}

