/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Stack;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.Seismic.CubicTraceInterpolator;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Stack.VelocityLocationCollection;
import java.util.ArrayList;

public class StackGizmo {
    protected ArrayList<Trace> m_list = new ArrayList();
    protected int m_numValidTraces = 0;
    protected float[] m_tempData = new float[10];

    public int getNumValidTraces() {
        return this.m_numValidTraces;
    }

    public float[] stack(Ensemble ensemble, float[] velocity, float t0, float digi, double mute, double minOff, double maxOff) {
        try {
            int k;
            this.applyMoveout(ensemble, velocity, t0, digi, mute);
            float[] sum = new float[velocity.length];
            float[] count = new float[velocity.length];
            float[] outputData = new float[velocity.length];
            for (int k2 = 0; k2 < velocity.length; ++k2) {
                sum[k2] = 0.0f;
                count[k2] = 1.0E-40f;
            }
            if (ensemble.traceCount() < 1) {
                return sum;
            }
            EnsembleHeaderDictionary dict = ensemble.dictionary();
            int indexOff = dict.getEntryIndex("Trace", "Offset");
            int indexMute = dict.getEntryIndex("Trace", "MuteTime");
            int indexMaxTime = dict.getEntryIndex("Trace", "MaxTime");
            float maxCount = 1.0E-40f;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                Column_Abstract header = trace.header();
                double offset = header.getFloat(indexOff);
                float muteTime = header.getFloat(indexMute);
                float maxTime = header.getFloat(indexMaxTime);
                if (!(offset >= minOff) || !(offset <= maxOff)) continue;
                trace.data().copyToArray(outputData);
                float time = t0;
                for (int k3 = 0; k3 < velocity.length; ++k3) {
                    if (time > muteTime && time < maxTime) {
                        sum[k3] = sum[k3] + outputData[k3];
                        count[k3] = count[k3] + 1.0f;
                    }
                    time += digi;
                }
            }
            for (k = 0; k < velocity.length; ++k) {
                outputData[k] = 0.0f;
                for (int s = k - 5; s <= k + 5; ++s) {
                    if (s < 0 || s >= count.length) continue;
                    outputData[k] = count[s];
                }
            }
            for (k = 0; k < velocity.length; ++k) {
                sum[k] = sum[k] * outputData[k];
            }
            return sum;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void applyMoveout(Ensemble ensemble, float[] velocity, float t0, float digi, double mute) {
        try {
            if (ensemble.traceCount() < 1) {
                return;
            }
            EnsembleHeaderDictionary dict = ensemble.dictionary();
            int indexOffset = dict.getEntryIndex("Trace", "Offset");
            int indexMute = dict.addEntry("Trace", "MuteTime", DataType.Double);
            int indexMaxTime = dict.addEntry("Trace", "MaxTime", DataType.Double);
            Trace gizmoTrace = this.getTrace(0);
            mute = Math.max(mute, 1.0);
            double s = 1.0 + 0.01 * mute;
            double fac = Math.sqrt(s * s - 1.0);
            float[] outputData = new float[velocity.length];
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                Column_Abstract header = trace.header();
                double offset = header.getDouble(indexOffset);
                FloatArrayWrapper data = trace.data();
                if (this.m_tempData.length != data.length()) {
                    this.m_tempData = new float[data.length()];
                }
                data.copyToArray(this.m_tempData);
                gizmoTrace.setInputTrace(this.m_tempData, data.getFirstSampleCoord_WithShifts(), data.getSampleInterval());
                gizmoTrace.setOffset(offset);
                float muteStart = -9999.0f;
                boolean muteSet = false;
                boolean maxSet = false;
                float maxTime = t0 + digi * (float)(velocity.length - 1);
                for (int k = 0; k < velocity.length; ++k) {
                    float time0 = t0 + digi * (float)k;
                    float v = velocity[k];
                    double muteTime = 1000.0 * offset / ((double)v * fac);
                    if ((double)time0 > muteTime) {
                        float temp1;
                        float tnmo;
                        if (!muteSet) {
                            muteSet = true;
                            muteStart = time0;
                        }
                        if ((double)(tnmo = (float)Math.sqrt(time0 * time0 + (temp1 = 1000.0f * (float)offset / v) * temp1)) >= gizmoTrace.MaxInputTraceTime && !maxSet) {
                            maxSet = true;
                            maxTime = time0;
                        }
                        outputData[k] = gizmoTrace.getValueAtTime(tnmo);
                        continue;
                    }
                    outputData[k] = 0.0f;
                }
                header.putFloat(indexMute, muteStart);
                header.putFloat(indexMaxTime, maxTime);
                data.setFirstSampleCoord(0.0f);
                data.setSampleInterval(digi);
                data.insertArray(outputData, outputData.length);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void applyMoveout(Ensemble ensemble, VelocityLocationCollection velField, float t0, double mute) {
        try {
            if (ensemble.traceCount() < 1) {
                return;
            }
            int numSamp = ensemble.trace(0).data().length();
            float digi = ensemble.trace(0).data().getSampleInterval();
            velField.setRequestedInterp(0.0f, digi, numSamp);
            EnsembleHeaderDictionary dict = ensemble.dictionary();
            int indexX = dict.getEntryIndex("Trace", "CdpX");
            int indexY = dict.getEntryIndex("Trace", "CdpX");
            int indexOffset = dict.getEntryIndex("Trace", "Offset");
            int indexMute = dict.addEntry("Trace", "MuteTime", DataType.Double);
            int indexMaxTime = dict.addEntry("Trace", "MaxTime", DataType.Double);
            Trace gizmoTrace = this.getTrace(0);
            mute = Math.max(mute, 1.0);
            double s = 1.0 + 0.01 * mute;
            double fac = Math.sqrt(s * s - 1.0);
            float[] outputData = new float[numSamp];
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                Column_Abstract header = trace.header();
                double offset = header.getDouble(indexOffset);
                double x = header.getDouble(indexX);
                double y = header.getDouble(indexY);
                float[] velocity = velField.getVelocity(x, y);
                FloatArrayWrapper data = trace.data();
                if (this.m_tempData.length != data.length()) {
                    this.m_tempData = new float[data.length()];
                }
                data.copyToArray(this.m_tempData);
                gizmoTrace.setInputTrace(this.m_tempData, data.getFirstSampleCoord_WithShifts(), data.getSampleInterval());
                gizmoTrace.setOffset(offset);
                float muteStart = -9999.0f;
                boolean muteSet = false;
                boolean maxSet = false;
                float maxTime = t0 + digi * (float)(velocity.length - 1);
                for (int k = 0; k < velocity.length; ++k) {
                    float time0 = t0 + digi * (float)k;
                    float v = velocity[k];
                    double muteTime = 1000.0 * offset / ((double)v * fac);
                    if ((double)time0 > muteTime) {
                        float temp1;
                        float tnmo;
                        if (!muteSet) {
                            muteSet = true;
                            muteStart = time0;
                        }
                        if ((double)(tnmo = (float)Math.sqrt(time0 * time0 + (temp1 = 1000.0f * (float)offset / v) * temp1)) >= gizmoTrace.MaxInputTraceTime && !maxSet) {
                            maxSet = true;
                            maxTime = time0;
                        }
                        outputData[k] = gizmoTrace.getValueAtTime(tnmo);
                        continue;
                    }
                    outputData[k] = 0.0f;
                }
                header.putFloat(indexMute, muteStart);
                header.putFloat(indexMaxTime, maxTime);
                data.setFirstSampleCoord(0.0f);
                data.setSampleInterval(digi);
                data.insertArray(outputData, outputData.length);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int insertEnsemble(Ensemble ensemble, boolean ignoreKilled) throws Exception {
        try {
            EnsembleHeaderDictionary dict = ensemble.dictionary();
            int indexShotKilled = -999;
            int indexRecKilled = -999;
            int indexTraceKilled = -999;
            int indexOffset = dict.getEntryIndex_ReturnInvalid("Trace", "Offset");
            if (!ignoreKilled) {
                indexShotKilled = dict.getEntryIndex_ReturnInvalid("Shot", "Killed");
                indexRecKilled = dict.getEntryIndex_ReturnInvalid("Receiver", "Killed");
                indexTraceKilled = dict.getEntryIndex_ReturnInvalid("Trace", "Killed");
            }
            this.m_numValidTraces = 0;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                Column_Abstract header = trace.header();
                boolean ok = true;
                if (indexShotKilled >= 0) {
                    boolean bl = ok = ok && !header.getBool(indexShotKilled);
                }
                if (indexRecKilled >= 0) {
                    boolean bl = ok = ok && !header.getBool(indexRecKilled);
                }
                if (indexTraceKilled >= 0) {
                    ok = ok && !header.getBool(indexTraceKilled);
                }
                boolean bl = ok = ok && trace.hasData();
                if (!ok) continue;
                FloatArrayWrapper data = trace.data();
                if (this.m_tempData.length != data.length()) {
                    this.m_tempData = new float[data.length()];
                }
                data.copyToArray(this.m_tempData);
                Trace gizmoTrace = this.getTrace(this.m_numValidTraces);
                gizmoTrace.setInputTrace(this.m_tempData, data.getFirstSampleCoord_WithShifts(), data.getSampleInterval());
                gizmoTrace.setOffset(header.getDouble(indexOffset));
                ++this.m_numValidTraces;
            }
            return this.m_numValidTraces;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void clear() {
        try {
            this.m_list.clear();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Trace getTrace(int index) throws Exception {
        try {
            while (this.m_list.size() <= index) {
                this.m_list.add(new Trace());
            }
            return this.m_list.get(index);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static class Trace {
        protected CubicTraceInterpolator m_cubicTraceInterpolator = new CubicTraceInterpolator();
        protected float m_time0 = 0.0f;
        protected float m_inputDigi = 4.0f;
        protected double m_offset = 0.0;
        public boolean InUse = false;
        public double MaxInputTraceTime;
        public double MaxZeroOffsetTime;
        public float[] MoveoutTime;
        public float[] MoveoutValue;
        public double StretchMuteTime0;
        public double StretchMuteMoveoutTime;

        public void computeStretchMuteTime0_ConstantVel(double vel, double mutePercent) throws Exception {
            try {
                double s = 1.0 + 0.01 * mutePercent;
                double fac = Math.sqrt(s * s - 1.0);
                this.StretchMuteTime0 = 1000.0 * this.m_offset / (vel * fac);
                double temp = 1000000.0 * (this.m_offset * this.m_offset) / (vel * vel);
                this.StretchMuteMoveoutTime = Math.sqrt(this.StretchMuteTime0 * this.StretchMuteTime0 + temp);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }

        public void prepMoveoutArrays(int numTimes) throws Exception {
            try {
                if (this.MoveoutTime == null) {
                    this.MoveoutTime = new float[numTimes];
                }
                if (this.MoveoutTime.length != numTimes) {
                    this.MoveoutTime = new float[numTimes];
                }
                if (this.MoveoutValue == null) {
                    this.MoveoutValue = new float[numTimes];
                }
                if (this.MoveoutValue.length != numTimes) {
                    this.MoveoutValue = new float[numTimes];
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }

        public void prepMoveout_ConstantVel(double time0, double digi, double vel) throws Exception {
            try {
                double fac = 1000000.0 * (this.m_offset * this.m_offset) / (vel * vel);
                for (int n = 0; n < this.MoveoutTime.length; ++n) {
                    double t0 = time0 + digi * (double)n;
                    double moveoutTime = Math.sqrt(t0 * t0 + fac);
                    this.MoveoutValue[n] = this.getValueAtTime((float)moveoutTime);
                    this.MoveoutTime[n] = (float)moveoutTime;
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }

        public double offset() {
            return this.m_offset;
        }

        public void setOffset(double offset) {
            this.m_offset = offset;
        }

        public float getValueAtTime(float time) throws Exception {
            try {
                if ((double)time >= this.MaxInputTraceTime) {
                    return 0.0f;
                }
                return this.m_cubicTraceInterpolator.interpolate(time);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }

        public void setInputTrace(float[] data, float t0, float digi) throws Exception {
            try {
                this.m_time0 = t0;
                this.m_inputDigi = Math.max(digi, 0.1f);
                this.MaxInputTraceTime = t0 + digi * (float)(data.length - 1);
                this.m_cubicTraceInterpolator.prepareInput(data, this.m_time0, this.m_inputDigi);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }
    }
}

