/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Stack;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosLibrary.Math.Grid3D;
import java.awt.Color;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class StackFileController {
    protected boolean m_valid = false;
    protected String m_path;
    protected Grid3D m_countGrid;
    protected Grid3D m_weightGrid;
    protected ParameterTree m_parameters = new ParameterTree();
    protected int m_inlineCount;
    protected int m_inlineMin;
    protected int m_inlineMax;
    protected int m_crosslineCount;
    protected int m_crosslineMin;
    protected int m_crosslineMax;
    protected int m_samplesPerTrace;
    protected int m_headerCount;
    protected int m_headerByteCount;
    protected int m_dataByteCount;
    protected float m_digi;
    protected float m_time0;
    protected ByteBuffer m_dataBuffer;
    protected ByteBuffer m_headerBuffer;
    protected String m_hdrFileName;
    protected String m_dataFileName;
    protected boolean m_tempValid = false;
    protected float[] m_tempData;
    protected float[] m_tempHeader;

    public float[] tempData() {
        return this.m_tempData;
    }

    public int samplesPerTrace() {
        return this.m_samplesPerTrace;
    }

    public float time0() {
        return this.m_time0;
    }

    public float digi() {
        return this.m_digi;
    }

    public boolean valid() {
        return this.m_valid;
    }

    public void setPath(String path) {
        try {
            this.m_valid = false;
            this.m_path = path;
            String countGridName = path + "/count.grid3d";
            this.m_countGrid = new Grid3D(countGridName);
            String weightGridName = path + "/weight.grid3d";
            this.m_weightGrid = new Grid3D(weightGridName);
            String paramFileName = path + "/params.xml";
            this.m_parameters.read(paramFileName);
            this.m_time0 = (float)this.m_parameters.double_get("MinTime");
            this.m_digi = (float)this.m_parameters.double_get("Digi");
            this.m_inlineCount = this.m_parameters.int_get("InlineCount");
            this.m_crosslineCount = this.m_parameters.int_get("CrosslineCount");
            this.m_inlineMin = this.m_countGrid.inlineMin();
            this.m_inlineMax = this.m_countGrid.inlineMax();
            this.m_crosslineMin = this.m_countGrid.crosslineMin();
            this.m_crosslineMax = this.m_countGrid.crosslineMax();
            this.m_samplesPerTrace = this.m_parameters.int_get("SamplesPerTrace");
            this.m_headerCount = this.m_parameters.int_get("HeaderCount");
            this.m_tempHeader = new float[this.m_headerCount];
            this.m_tempData = new float[this.m_samplesPerTrace];
            this.m_dataFileName = this.m_path + "/stack.data";
            this.m_hdrFileName = this.m_path + "/stack.hdr";
            this.m_dataByteCount = 2 * this.m_inlineCount * this.m_crosslineCount * this.m_samplesPerTrace;
            this.m_dataBuffer = ByteBuffer.allocate(this.m_dataByteCount);
            this.m_headerByteCount = 4 * this.m_inlineCount * this.m_crosslineCount * this.m_headerCount;
            this.m_headerBuffer = ByteBuffer.allocate(this.m_headerByteCount);
            RandomAccessFile file = new RandomAccessFile(this.m_dataFileName, "rw");
            file.read(this.m_dataBuffer.array(), 0, this.m_dataByteCount);
            file.close();
            file = new RandomAccessFile(this.m_hdrFileName, "rw");
            file.read(this.m_headerBuffer.array(), 0, this.m_headerByteCount);
            file.close();
            this.m_valid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public float getHorizon(int inline, int crossline, int horizonIndex) throws Exception {
        try {
            if (!this.m_valid) {
                return -9999.0f;
            }
            int i = inline - this.m_inlineMin;
            int c = crossline - this.m_crosslineMin;
            if (i < 0 || i >= this.m_inlineCount || c < 0 || c >= this.m_crosslineCount) {
                return -9999.0f;
            }
            int offset = 4 * this.m_headerCount * (c + i * this.m_crosslineCount);
            return this.m_headerBuffer.getFloat(offset += 4 * (2 + horizonIndex));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void getData(int inline, int crossline) throws Exception {
        try {
            int n;
            this.m_tempValid = false;
            if (!this.m_valid) {
                return;
            }
            for (n = 0; n < this.m_samplesPerTrace; ++n) {
                this.m_tempData[n] = 0.0f;
            }
            for (n = 0; n < this.m_headerCount; ++n) {
                this.m_tempHeader[n] = 0.0f;
            }
            int i = inline - this.m_inlineMin;
            int c = crossline - this.m_crosslineMin;
            if (i < 0 || i >= this.m_inlineCount || c < 0 || c >= this.m_crosslineCount) {
                return;
            }
            int offset = 4 * this.m_headerCount * (c + i * this.m_crosslineCount);
            for (int n2 = 0; n2 < this.m_headerCount; ++n2) {
                this.m_tempHeader[n2] = this.m_headerBuffer.getFloat(offset + 4 * n2);
            }
            float scalar = 1.0f / (this.m_tempHeader[1] + 1.0E-40f);
            offset = 2 * this.m_samplesPerTrace * (c + i * this.m_crosslineCount);
            for (int n3 = 0; n3 < this.m_samplesPerTrace; ++n3) {
                this.m_tempData[n3] = scalar * (float)this.m_dataBuffer.getShort(offset + 2 * n3);
            }
            this.m_tempValid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public float stackAmplitude(float[] stack) {
        try {
            float sum = 0.0f;
            for (int n = 0; n < stack.length; ++n) {
                sum += Math.abs(stack[n]);
            }
            return sum / (float)stack.length;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0f;
        }
    }

    public void killPicks(int horizonIndex) {
    }

    public Grid3D getHorizonGrid(int h) {
        try {
            if (!this.m_valid) {
                return null;
            }
            if (h < 0 || h >= 3) {
                return null;
            }
            Grid3D grid = new Grid3D(this.m_weightGrid);
            grid.interp_Prep();
            int numOkay = 0;
            for (int i = 0; i < this.m_inlineCount; ++i) {
                for (int c = 0; c < this.m_crosslineCount; ++c) {
                    int offset = 4 * this.m_headerCount * (c + i * this.m_crosslineCount);
                    float v = this.m_headerBuffer.getFloat(offset += 4 * (2 + h));
                    if (!(v >= 0.0f)) continue;
                    double x = this.m_weightGrid.getWorldX(i + this.m_inlineMin, c + this.m_crosslineMin);
                    double y = this.m_weightGrid.getWorldY(i + this.m_inlineMin, c + this.m_crosslineMin);
                    grid.interp_Add(x, y, v, 1.0f);
                    ++numOkay;
                }
            }
            if (numOkay < 1) {
                grid.interp_Free();
                return grid;
            }
            grid.interp_Finish(4);
            grid.interp_Free();
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void killHorizon(int index) {
        try {
            if (!this.m_valid) {
                return;
            }
            if (index < 0 || index >= 3) {
                return;
            }
            for (int i = 0; i < this.m_inlineCount; ++i) {
                for (int c = 0; c < this.m_crosslineCount; ++c) {
                    int offset = 4 * this.m_headerCount * (c + i * this.m_crosslineCount);
                    this.m_headerBuffer.putFloat(offset += 4 * (2 + index), -9999.0f);
                }
            }
            RandomAccessFile file = new RandomAccessFile(this.m_hdrFileName, "rw");
            file.write(this.m_headerBuffer.array(), 0, this.m_headerByteCount);
            file.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void putEnsembleHeader(Ensemble ensemble) {
        try {
            if (!this.m_valid) {
                return;
            }
            int indexInline = ensemble.dictionary().addEntry("Trace", "Inline", DataType.Int);
            int indexCrossline = ensemble.dictionary().addEntry("Trace", "Crossline", DataType.Int);
            int totalHeaders = this.m_headerCount;
            int numHorizons = totalHeaders - 2;
            int[] indexHeader = new int[totalHeaders];
            indexHeader[0] = ensemble.dictionary().getEntryIndex("Trace", "Amplitude");
            indexHeader[1] = ensemble.dictionary().getEntryIndex("Trace", "Scalar");
            for (int h = 0; h < numHorizons; ++h) {
                String s = Pecos.getColNameHorizon(h + 1);
                indexHeader[h + 2] = ensemble.dictionary().getEntryIndex("Trace", s);
            }
            boolean dirty = false;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                int inline = trace.header().getInt(indexInline);
                int crossline = trace.header().getInt(indexCrossline);
                int i = inline - this.m_inlineMin;
                int c = crossline - this.m_crosslineMin;
                if (i < 0 || i >= this.m_inlineCount || c < 0 || c >= this.m_crosslineCount) continue;
                int offset = 4 * this.m_headerCount * (c + i * this.m_crosslineCount);
                for (int h = 0; h < numHorizons; ++h) {
                    float oldVal;
                    float newVal = trace.header().getFloat(indexHeader[h + 2]);
                    if (!(Math.abs(newVal - (oldVal = this.m_headerBuffer.getFloat(offset + 4 * (h + 2)))) > 0.001f)) continue;
                    dirty = true;
                    this.m_headerBuffer.putFloat(offset + 4 * (h + 2), newVal);
                }
            }
            if (!dirty) {
                return;
            }
            RandomAccessFile file = new RandomAccessFile(this.m_hdrFileName, "rw");
            file.write(this.m_headerBuffer.array(), 0, this.m_headerByteCount);
            file.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Ensemble getInlineEnsemble(int inline) {
        try {
            Ensemble ensemble = new Ensemble();
            if (!this.m_valid) {
                return ensemble;
            }
            int indexInline = ensemble.dictionary().addEntry("Trace", "Inline", DataType.Int);
            int indexCrossline = ensemble.dictionary().addEntry("Trace", "Crossline", DataType.Int);
            int indexX = ensemble.dictionary().addEntry("Trace", "CdpX", DataType.Double);
            int indexY = ensemble.dictionary().addEntry("Trace", "CdpY", DataType.Double);
            int totalHeaders = this.m_headerCount;
            int numHorizons = totalHeaders - 2;
            int[] indexHeader = new int[totalHeaders];
            indexHeader[0] = ensemble.dictionary().addEntry("Trace", "Amplitude", DataType.Double);
            indexHeader[1] = ensemble.dictionary().addEntry("Trace", "Scalar", DataType.Double);
            for (int h = 0; h < numHorizons; ++h) {
                String s = Pecos.getColNameHorizon(h + 1);
                indexHeader[h + 2] = ensemble.dictionary().addEntry("Trace", s, DataType.Double);
            }
            float minAmp = Float.MAX_VALUE;
            float maxAmp = Float.MIN_VALUE;
            for (int n = 0; n < this.m_crosslineCount; ++n) {
                this.getData(inline, n + this.m_crosslineMin);
                if (!this.m_tempValid) continue;
                EnsembleTrace trace = ensemble.addTrace();
                Column_Abstract header = trace.header();
                header.putInt(indexInline, inline);
                header.putInt(indexCrossline, n + this.crosslineMin());
                double x = this.m_weightGrid.getWorldX(inline, n + this.crosslineMin());
                double y = this.m_weightGrid.getWorldY(inline, n + this.crosslineMin());
                header.putDouble(indexX, x);
                header.putDouble(indexY, y);
                for (int h = 0; h < totalHeaders; ++h) {
                    header.putDouble(indexHeader[h], this.m_tempHeader[h]);
                }
                trace.data().insertArray(this.m_tempData, this.m_samplesPerTrace);
                trace.data().setFirstSampleCoord(this.m_time0);
                trace.data().setSampleInterval(this.m_digi);
            }
            ensemble.pickPlotData().add(Pecos.getColNameHorizon(1), Color.black, 5, Java2D_PointSymbol.FilledSquare);
            ensemble.pickPlotData().add(Pecos.getColNameHorizon(2), Color.magenta, 5, Java2D_PointSymbol.FilledSquare);
            ensemble.pickPlotData().add(Pecos.getColNameHorizon(3), Color.cyan, 5, Java2D_PointSymbol.FilledSquare);
            return ensemble;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public int crosslineMin() {
        return this.m_weightGrid.crosslineMin();
    }

    public int crosslineMax() {
        return this.m_weightGrid.crosslineMax();
    }

    public int inlineMin() {
        return this.m_weightGrid.inlineMin();
    }

    public int inlineMax() {
        return this.m_weightGrid.inlineMax();
    }

    public Grid3D weightGrid() {
        return this.m_weightGrid;
    }
}

